{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*                ***   INTERPRETOR  INITIALIZER   ***                   *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
     {***********    CPAS  Version   **************}



module LISP_INIT( Input, Output );      { input and output for user terminal }


%include 'LISPSRC:lisp_env';            { Get the Lisp Environment Definitions }



var
  last_symb: ident_ptr;




procedure SETOPE( in_var std: string; ope: obj_type );
var
  i: integer;
  p, p1: ident_ptr;

begin { SETOPE }
  NEW( p );
  with p^ do
  begin
    name := NEW_LISP_STRINGV( std );
    if ope >= atomety then     { Full atom standard operator }
    begin
      atom := ATOME_ALLOC;     { Create the associated atom }
      with atom.at^ do
      begin
        ats.typ := strty;      { Set the atom nature }
        ats.nam := name        { Set the atom name link }
      end;
      atom.flg := flg_def;
      if ope > atomety then    { Set the standard flag when required }
        atom.flg.k := std_funct;
      atom.typ := ope;         { Set the operator field }
    end
    else
    begin
      atom.typ := ope;         { Set the operator field }
      atom.nam := name         { Internal coded atom only }
    end;
    p1 := LEVEL_IDENT_SEARCH( name^.body, name^.length, true )
  end;
  IDENT_NEW_LINK( p );
  last_symb := p
end SETOPE;


procedure SET_SYSPARM;
var
  prm, p1, p2: obj_ref;

begin
  { Create the Atome with the parameter }
  SETOPE( 'SYS$_PARM',  atomety );
  prm := last_symb^.atom;               { Keep the atom pointer }
  with prm.at^ do
  begin
    plist.typ := intty;
    plist.int := argc;                  { Set the argument count as plist }
    p2  := obj_nil;
    for i := 0 to argc - 1 do
    begin
      p1 := DOUBLET_ALLOC;              { Allocate a doublet }
      { Build the list link }
      if p2.typ = nullty then val := p1
                         else p2.db^.cdr := p1;
      p2 := p1;
      p1.db^.car     := obj_nuls;       { Set the parameter string value }
      p1.db^.car.nam := NEW_LISP_STRINGV( argv[i]^ )
    end
  end
end SET_SYSPARM;


procedure SET_STANDARD;
var
  ch: char;
  ob: obj_ref;

begin { SET_STANDARD }
  macro_idlst := nil;                   { No defined macro lex }
  curr_lex := -1;                       { Initialize the lex system }
  curr_lexd := nil;
  reserved_lexd := nil;                 { Initialize the reserved lex }
  ob := NEW_LEX( obj_nil );             { Create the standard lex }
  gbl_lexd := curr_lexd;                { Set the global lex level }
  last_lexd := gbl_lexd;                { Set the tree for identificator link }
  bas_lexd := curr_lexd;                { Set the basis lex level }
  basreserved_lexd := curr_lexd;        { Set the basis reserved lex level }
  lisp_base_lexd   := curr_lexd;        { Preserve any lex change for usr error }

  { Initialize the Doublet and Atoms Free Lists }
  atm_free := obj_nil;
  dbl_free := obj_nil;

  { Initialize the Lex Table }
  for ch := CHR(0) to CHR (255) do
    pro_lex_tab[ch] := obj_nil;

  { Initialize the macro character tables }
  for ch := '!' to '~' do
  begin
    mac_tab[ch] := obj_nil;
    alt_mtb[ch] := obj_nil
  end;

  mac_tab['('].typ  := list_fnc;        { Enable begin of input list management }
  mac_tab[')'].typ  := last_fnc;        { Enable end of input list management }
  mac_tab['!'].typ  := charty;          { Enable the character management }
  mac_tab['|'].typ  := charty;          { Enable the character management }
  mac_tab['"'].typ  := strty;           { Enable the input string manager }


  { Define all Standard Atoms }

  %INCLUDE 'LISPSRC:lisp_setope.pas';



	{**** Special Standard Functions ****}


  SETOPE(    'LAMBDA',   lambda_fnc );
  lambda_atm  := last_symb^.atom;
  lambda_atm.at^.fncref.flg.k  := de__funct;

  SETOPE(   'FLAMBDA',  flambda_fnc );
  flambda_atm := last_symb^.atom;
  flambda_atm.at^.fncref.flg.k := df__funct;

  SETOPE(   'MLAMBDA',  mlambda_fnc );
  mlambda_atm := last_symb^.atom;
  mlambda_atm.at^.fncref.flg.k := dm__funct;

  SETOPE(     'QUOTE',     quot_fnc );
  quote_atm   := last_symb^.atom;
  mac_tab[''''] := quote_atm;

  mac_tab['\']  := obj_refer;           { Set formal by reference flag for DP function }


        {**** Set Predefined Constants ****}

  SETOPE(         'T',      truety  ); obj_true.nam := last_symb^.name;

  SETOPE(      'NILP',     areatyp  );  { Define null pointer }
  last_symb^.atom := obj_nilp;

  SETOPE(       'NIL',      nullty  );
  last_symb^.atom.nam := nil;  { Force no nil name pointer (never used). }

  SETOPE( 'SYS$_EOLN',   eoln_seen  ); obj_eoln.nam := last_symb^.name;

  SETOPE(  'SYS$_EOF',    eof_seen  ); obj_eof.nam := last_symb^.name;

  SETOPE(      'SELF',      atomety );  { Create the self identifier ... }
  self_let := last_symb^.atom;          { ... and the related link . }



        {**** Set Some Standard Atoms ****}

  SETOPE(  'SYS$_STR',      atomety );  { Create the print string flag ... }
  prin_str := last_symb^.atom;          { ... and the related link . }

  SETOPE( 'SYS$_CHAR',      atomety );  { Create the print char flag ... }
  prin_cha := last_symb^.atom;          { ... and the related link . }

  SETOPE( 'SYS$_NUMBER_KIND', atomety );{ Create the print int. kind flag ... }
  prin_int := last_symb^.atom;          { ... and the related link . }

  SETOPE('SYS$_READ_EOF',   atomety );  { Create the eof seens identifier ... }
  sys_eof  := last_symb^.atom;          { ... and the related link . }

  SETOPE('SYS$_READ_EOLN',  atomety );  { Create the eoln seens identifier ... }
  sys_eoln := last_symb^.atom;          { ... and the related link . }

  SETOPE('SYS$_INCL_DEEP',  atomety );  { Create the include lex level identifier ... }
  sys_read_deep := last_symb^.atom;     { ... and the related link . }

  SETOPE('SYS$_UNDEF',      atomety );  { Create the undef. atom identifier ... }
  und_atom := last_symb^.atom;          { ... and the related link . }

  SETOPE('SYS$_LEX_OWNER',  atomety );  { Create the lex_owner atom ... }
  lex_own_atm := last_symb^.atom;       { ... and the related link . }

  SETOPE('SYS$_ALG_KIND',  atomety );   { Create the alg_comm. class atom ... }
  alg_katom := last_symb^.atom;         { ... and the related link . }

  SETOPE('SYS$_ALG_TYPE',  atomety );   { Create the alg_comm. type atom ... }
  alg_tatom := last_symb^.atom;         { ... and the related link . }

  SETOPE('SYS$_ALG_SPC',   atomety );   { Create the alg_comm. specification atom ... }
  alg_satom := last_symb^.atom;         { ... and the related link . }

  SETOPE('SYS$_ALG_SPC2',  atomety );   { Create the alg_comm. specification atom ... }
  alg_spcex := last_symb^.atom;         { ... and the related link . }

  SETOPE('SYS$_READK',      atomety );  { Create the read kind atom ... }
  read_kind := last_symb^.atom;         { ... and the related link . }

  SETOPE('SYS$_LAST_READ',  atomety );  { Create the last read object atom }
  sys_read_obj := last_symb^.atom;      { ... and the related link . }

  SETOPE('SYS$_BUILD_LIST', atomety );  { Create the building list atom }
  sys_build_list := last_symb^.atom;    { ... and the related link . }

  SETOPE('SYS$_ERROR',      atomety );  { Create the error code atom ... }
  exception_status := last_symb^.atom;  { ... and the related link . }

  SETOPE('SYS$_ERROR_POINT',atomety );  { Create the error LISP code atom ... }
  exception_point := last_symb^.atom;   { ... and the related link . }

  SETOPE('SYS$_LISPLIB',atomety );      { Create the LISP Library Path atom ... }
  with last_symb^.atom.at^ do
  begin
    val := obj_nuls;                    { Force the string type }
    val.nam := NEW_LISP_STRINGV( lisp_lisplib ); { ... and its related value . }
  end;

  SETOPE('SYS$DRAW_STATUS',atomety );   { Create the LISP Library Path atom ... }
  ldrw_Link := last_symb^.atom;         { Draw Server Mode and status Atom }

  SETOPE(      'M_CH',       charty );  { Create the unsigned byte flafgatom }
  last_symb^.atom.ch  := CHR( 0 );

  SETOPE(      'M_UB',        intub );  { Create the unsigned byte flafgatom }
  last_symb^.atom.int := 0;

  SETOPE(      'M_SB',        intsb );  { Create the signed byte flag atom }
  last_symb^.atom.int := 0;

  SETOPE(      'M_UW',        intuw );  { Create the unsigned word flag atom }
  last_symb^.atom.int := 0;

  SETOPE(      'M_SW',        intsw );  { Create the signed word flag atom }
  last_symb^.atom.int := 0;

  SETOPE(      'M_PT',       mrecty );  { Create the memory address flag atom }
  last_symb^.atom.rec := nil;

  SETOPE(      'M_AD',      areatyp );  { Create the memory address flag atom }
  last_symb^.atom.mem := nil;

  SETOPE(      'M_OB',     doublety );  { Create the LISP list flag }
  last_symb^.atom := DOUBLET_ALLOC;

  SETOPE(      'M_AT',      atomety );  { Create the LISP atom flag }

  SETOPE(      'M_LI',        intty );  { Create the integer flag atom }
  last_symb^.atom.int := 0;

  SETOPE(      'M_FL',        sflty );  { Create the single floatting flag atom }
  last_symb^.atom.flt := 0.0;

  SETOPE(      'M_DB',         flty );  { Create the long floatting flag atom }
  last_symb^.atom.flt := 0.0;

  SET_SYSPARM; {**** Set Standard System Parameters ****}

  log_val[false] := obj_nil;            { Inittialize the logical LISP ...}
  log_val[true]  := obj_true;           { ... correspondance of pascal boolean }

     {**** Set the User Lex ****}


  reserved_lexd := curr_lexd;           { Set Standard Lex as Reserved }
  ob := NEW_LEX( obj_nil );             { Create the User Lex Level }
  gbl_lexd := curr_lexd;                { Set as the Global Lex Level ... }
  all_lexd := curr_lexd;                { ... and the unique allocation Lex }
  lisp_base_lexd   := curr_lexd         { Preserve any Lex change from User Error }
end SET_STANDARD;




            {****************************************}
            { ***    Initialization procedure    *** }
            {****************************************}



[global]
procedure SEARCH_FILE( in_var  path,                                    { Path to use can be string or array of char }
                              fname:                       string;      { Name of file to search }
                                acc:                      integer;      { Access reaquired }
                       var       re:                       string;      { Returned complete file specification if found (fnd = true) }
                       var      fnd:                      boolean );    { Returned flag (true when found, false otherwise) }
{ Routine to search a file from a short PATH list (Path in a string - not an array).
}

var
  ip, ie, nb:  integer;

begin
  fnd := FILE_ACCESS_CHECK( fname, acc );                       { Before search on the local directory }
  if fnd then re := fname
  else
  begin
    ip  :=     1; nb  :=     1;
    while (ip <= path.length) and not fnd do                    { Loop on all PATH entry }
    begin
      ie  := INDEX( path, ',', nb );
      if ie = 0 then ie := path.length + 1;
      re  := SUBSTR( path, ip, ie - ip )||fname;
      ip  := ie + 1; nb := nb + 1;
      fnd := FILE_ACCESS_CHECK( re, acc );
    end;
    if not fnd then re.length := 0
  end
end SEARCH_FILE;



[global]
procedure LISP_INIT;
var
  ierr: integer;
  fnd:  boolean;

begin
  { Initialize Listing Sub-System }
  LST_G_INIT( lisp_deflst, lisp_page_head, ierr);
  main_lst := lst_current;

  if ierr = 0 then
  begin
    { Look for standard initial file }
    { Look for the initial MXD Standard Environment file in the MXD Search Path }
    SEARCH_FILE( lisp_search_path, lisp_defstd, 4 { Read Access }, sy_string, fnd );
    if fnd then
           begin
             ierr := INDEX( sy_string, '/', -1 );
             if ierr > 0 then lisp_lisplib := SUBSTR( sy_string, 1, ierr )
                         else lisp_lisplib.length := 0
           end
           else
           begin
             WRITELN( ' *** E-Lisp Init Error : Standard Init Open Phase Error -- STOP. ***' );
             PASCAL_EXIT( 2 )
           end;

    { Initialize the Error Message Sub-System }
    ERR_INIT( lisp_lisplib||lisp_errfilespc );

    { Initialize Source Input Sub-System }
    SRC_INIT( lisp_prompt, sy_string );
    main_src := src_control;

    if src_control = nil then
    begin
      error_result := e_fatal; emergency_stop := true;
      WRITELN( ' LISP CANNOT OPEN THE "', lisp_defstd, '" INITIAL FILE.' )
    end
    else
    with src_control^ do
    begin
      emergency_stop := false;
      src_commentty := src_lispcomment;  { set LISP comment management }
      { Set LISP Source Input Mode without list }
      src_flags := src_flags - [src_blist] + [src_linemode,src_listbyline];

      { Built the Keyword Tree (Standard Atom) }
      SET_STANDARD;

      recurs_nb := 0;             { Init Recursive Count }


      { Init sy_ch for F_READ }
      sy_lstbreak := nil;
      sy_ch_break := false;
      sy_ch := eol;
      sym := obj_nil;

      eval_ninc := 0;             { Init exec trace level }

      { Disable the automatic interpretation of logical value as integer value }
      logint_mode   := false;
      opt_debug     := false;
      opt_exectrace := false;
      opt_calltrace := false;     { No trace by default }
      opt_result := false;        { Output result option for debug disable }
      nctobj_max := 100;          { Maximum number of object in one output }

      exception_step := false;    { no step to step mode }
      exception_man := obj_nil;   { no user exception handler defined }
      exception_debug := obj_nil; { no debug exception entry point }

      with sys_read_deep.at^.val do
      begin
        flg := flg_def; typ := intty; int := 1
      end;

      fnc_list_save := obj_nil;   { initialize the save value stack }
      stop_reg := obj_nil         { no exit status }
    end
  end
  else
  begin
    WRITELN( ' *** E-Lisp Init Error : Init Listing Phase Error -- STOP. ***' );
    PASCAL_EXIT( 2 )
  end
end { LISP_INIT };

end.
