{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*            ***  GLOBAL REFERENCES PASCAL FILE MODULE   ***            *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}



[external]
var

  obj_ref_size:   integer;

  lisp_lisplib:   string(255);  { Lisp Library Location }

  main_src:       src_ptr;      { Main Source }
  main_lst:       lst_ptr;      { Main Listing }

  pck_alloc:      pck_ptr;      { List of Allocated Block }

  mrd_alloc:      mrd_ptr;      { Allocated Record Descriptor List }

  strg_hde:       lisp_s_ptr;   { Pointer to the Alloc. LISP String List Head }
  vect_hde:       vect_ptr;     { Pointer to the Allocated Vector List Head }

  atm_free,                     { Pointer of Free Atomes }
  dbl_free:       obj_ref;      { Pointer of Free Doublets }

  macro_idlst:    ident_ptr;    { Macro Lex if Used }
  lisp_base_lexd,               { LISP Base Lex context Pointer }
  lisp_user_lexd,               { LISP User Lex context Pointer }
  cmp_base_lexd,                { Compiler base lex context pointer }
  all_lexd,                     { Selected lex for allocation }  
  gbl_lexd,                     { Global lex definition }
  last_lexd,                    { Last founded identifier lex level }
  top_lexd,                     { Top of defined lex levels }
  bas_lexd,                     { Base of active lex levels }
  basreserved_lexd,             { Base of reserved lex levels }
  reserved_lexd,                { Current top of reserved display pointer }
  curr_lexd:      lex_ptr;      { Current top of active lex display pointer }

  { Create a Dynamic and Static Lex Tables for Computed Language(s) }
  pro_lex_tab:    array[char] of obj_ref;
  run_lex:        char;         { Curr. running lex for local allocations }

  macro_dcl_flag,               { Macro Declare Flag }
  ident_dcl_flag: boolean;      { To Define the Create Ident Mode }
  cmp_base_lex:   integer;      { Compiler Base Lex }


  nctobj,                       { Current Object Count Output Value }
  nctobj_max,                   { Maximum Object Count Output Value }
  reserved_lex,                 { Top of Reserved Lex }
  curr_lex:       integer;      { Current Value of Lex Number }

  sy_lstbreak:    lst_ptr;      { Pointer to the break output listing }
  sy_ch_break:    boolean;      { Flag for last character enable }
  sy_cmaj,                      { Current lower character }
  sy_ch:          char;         { Current character for INSYMBOL }

  sym:            obj_ref;      { Qualifier of read symbol }

  sy_ival:        integer;      { Integer value of constante }
  sy_rval:        double;       { Real value of constante }
  sy_string:      string(255);  { Read string constante value }

  sy_found:       ident_ptr;    { Last found identifier }
  sy_found_test:  integer;      { Last identifier match value }


  flg_def,                      { Default flag/kind set }
  flg_emp:        obj_char;     { Empty flag/kind  set }

  obj_nilp,                     { Nil pointer Value Object reference }
  obj_nil,                      { Nil (or () ) Value Object reference }
  obj_true,                     { T Value Object reference }
  obj_zero,                     { Zero (or 0) integer Value Object reference }
  obj_one,                      { One (or 1) Integer Value Object reference }
  obj_eof,                      { End Of File Seen Value Object reference }
  obj_eoln,                     { End Of Line Seen Value Object reference }
  obj_empty,                    { Empty Value Object reference }
  obj_quot,                     { String Quote Character Object reference }
  obj_refer,                    { Refer Object reference }
  obj_nuls:       obj_ref;      { Define "empty string obj" }


  { Alternate and Standard Macro Character Pointer Tables }
  alt_mtb,
  mac_tab:        array['!'..'~'] of obj_ref;
  alt_mac_tab_flag: boolean;    { Flag to validate the Alternate Table }

  case_atm,                     { Pointer to the Case name atome }
  lambda_atm,                   { Pointer to the Lambda name atome }
  flambda_atm,                  { Pointer to the Flambda name atome }
  mlambda_atm,                  { Pointer to the Mlambda name atome }
  quote_atm:      obj_ref;      { Pointer of the quote name function }

  { Array Used to Convert Test in LISP symbol NIL or T }
  log_val:        array[boolean] of obj_ref;

  main_statement,               { Main LISP Statement pointer }
  fnc_list_save,                { Save formal atome stack head }
  currobj,                      { Current LISP object reference }
  sys_eof,                      { Ptr. to eof read state specified atom }
  sys_eoln,                     { Ptr to eoln read state specified atom }
  sys_read_deep,                { Ptr to include deep atom }
  sys_build_list,               { Ptr to the buiding list }
  sys_read_obj,                 { Ptr to the last read object }
  prin_str,                     { Ptr to sys$_str atom }
  prin_cha,                     { Ptr to sys$_char atom }
  prin_int,                     { Write kind of integer value 0 }
  und_atom,                     { Was undefined test atom }
  lex_own_atm,                  { Lex owner of atom, atom }
  read_kind,                    { Read object kind (in m code) }
  alg_tatom,                    { Communication type atom }
  alg_katom,                    { Communication kind atom }
  alg_satom,                    { Communication macro properties atom }
  alg_spcex,                    { Communication expr specification atom }

  ldrw_Link,                    { Draw Server Mode Atom }

  self_let:       obj_ref;      { Pointer to the "SELF" atom }

  sy_init_mod:    boolean;      { Flag for Init Mode }

  lfile_first,                  { List Head (and End) of Opened File Descr. }
  lfile_last:     lfile_ptr;


  { Record Data Access Table for SYS_CALL Use }

  rec_tbidx:      0..max_rectb;
  rec_tbacc:      array[1..max_rectb] of rfd_ptr;
  rec_tbind:      array[1..max_rectb] of integer;



      {*************************************}
      { *** LISP interpretor exceptions *** }
      {*************************************}

  exception_point,              { Exception point atome pointer }
  exception_status,             { Exception kind atom pointer }
  exception_debug,              { Pointer to debug exception entry point }
  exception_man:  obj_ref;      { Pointer to a lisp exception manager }

  fnc_result,                   { Forced function result (when stopped) }
  stop_reg:       obj_ref;      { Pointer for sequence (EXEC_LIST) exit }


  condition_sev:  error_sev;    { LISP error severity }
  condition_error:integer;      { LISP error code }





      {**********************************}
      { *** LISP interpretor options *** }
      {**********************************}

  logint_mode,                  { Flag for logical to integer mode }
  exception_step,               { Flag for step to step debug call }
  opt_debug,                    { Concentration of all debuging option }
  opt_calltrace,                { User function call trace }
  opt_exectrace,                { User exec trace }
  opt_result:     boolean;      { Output result option }

  eval_ninc,                    { Current trace level }
  recurs_nb:      integer;      { Recursive call count }

  curr_point,                   { Current Node to Execute }
  let_flist,                    { Current list of let parameter }
  interp:         obj_ref;      { Current head value pointer }






      {**************************************}
      { emergency flag to exit from compiler }
      {**************************************}


  emergency_stop: boolean;      { To set the Emergency Exit of Run }




     {**********************************************}
     { file specification for the source to compile }
     {**********************************************}


  lisp_src:       str_ptr;      { Current LISP Source File Pointer }


{  * * * *   End Of External Variable Definitions File   * * * *  }
