{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*           ***  GLOBAL DEFINITIONS PASCAL FILE MODULE   ***            *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}



{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}





[global]
var

  obj_ref_size:   integer := obj_ref"size;

  lisp_lisplib: string(255) := '';  { Lisp Library Location }

  main_src:    src_ptr := nil;  { Main Source }
  main_lst:    lst_ptr := nil;  { Main Listing }

  pck_alloc:   pck_ptr := nil;  { List of Allocated Block }
  mrd_alloc:   mrd_ptr := nil;  { Allocated Record Descriptor List }

  strg_hde: lisp_s_ptr := nil;  { Pointer to the Alloc. LISP String List Head }
  vect_hde: vect_ptr   := nil;  { Pointer to the Allocated Vector List Head }

  atm_free,                     { Pointer of Free Atomes }
  dbl_free:  obj_ref;           { Pointer of Free Doublets }

  macro_idlst: ident_ptr := nil;{ Macro Lex if used }

  lisp_base_lexd,               { LISP base lex context pointer }
  lisp_user_lexd,               { LISP user lex context pointer }
  cmp_base_lexd,                { Compiler base lex context pointer }
  all_lexd,                     { Selected lex for allocation }  
  gbl_lexd,                     { Global lex definition }
  last_lexd,                    { Last founded identifier lex level }
  top_lexd,                     { Top of defined lex levels }
  bas_lexd,                     { Base of active lex levels }
  basreserved_lexd,             { Base of reserved lex levels }
  reserved_lexd,                { Current top of reserved display pointer }
  curr_lexd:   lex_ptr := nil;  { Current top of active lex display pointer }

  { Create a Dynamic and Static Lex Tables for Computed Language }
  pro_lex_tab:    array[char] of obj_ref;
  run_lex:        char := CHR( 0 ); { Current Running Lex for Local Alloc. }

  macro_dcl_flag,                     { Macro Declare Flag }
  ident_dcl_flag: boolean := false;   { To Define the Create Ident Mode }
  cmp_base_lex:   integer;            { Compiler Base Lex }


  nctobj,                       { Current Object Count Output Value }
  nctobj_max,                   { Maximum Object Count Output Value }
  reserved_lex,                 { Top of Reserved Lex }
  curr_lex:       integer;      { Current Value of Lex Number }

  sy_lstbreak:    lst_ptr;      { Pointer to the break output listing }
  sy_ch_break:    boolean;      { Flag for last character enable }
  sy_cmaj,                      { Current lower character }
  sy_ch:          char;         { Current character for INSYMBOL }

  sym:            obj_ref;      { Qualifier of read symbol }

  sy_ival:        integer;      { Integer value of constante }
  sy_rval:        double;       { Real value of constante }
  sy_string:      string(255);  { Read string constante value }

  sy_found:       ident_ptr;    { Last found identifier }
  sy_found_test:  integer;      { Last identifier match value }


  flg_def:        obj_char := ( und_funct, []            );
  flg_emp:        obj_char := ( und_funct, [invalid_flg] );


  obj_nilp: obj_ref := ( ( und_funct, [] ),           areatyp, nil); { Define nil pointer }
  obj_nil:  obj_ref := ( ( und_funct, [] ),            nullty, nil); { Define () }
  obj_true: obj_ref := ( ( und_funct, [] ),            truety, nil); { Define "true" as 1 }
  obj_zero: obj_ref := ( ( und_funct, [] ),             intty,   0); { Define zero value }
  obj_one:  obj_ref := ( ( und_funct, [] ),             intty,   1); { Define one value }
  obj_eof:  obj_ref := ( ( und_funct, [] ),          eof_seen, nil); { Define "sys$_eof" }
  obj_eoln: obj_ref := ( ( und_funct, [] ),         eoln_seen, nil); { Define "sys$_eoln" }
  obj_empty:obj_ref := ( ( und_funct, [invalid_flg] ), nullty, nil); { Define "empty_cd" }
  obj_quot: obj_ref := ( ( und_funct, [] ),          quot_fnc, nil); { Define "quote obj" }
  obj_refer:obj_ref := ( ( und_funct, [dp_ref_flg]),   dp_fnc, nil); { Define "refer obj" }
  obj_nuls: obj_ref := ( ( und_funct, [] ),             strty, nil); { Define "empty string obj" }


  { Alternate and Standard Macro Character Pointer Tables }
  alt_mtb,
  mac_tab:        array['!'..'~'] of obj_ref;
  alt_mac_tab_flag: boolean := false; { Flag to Validate the Alternate Table }

  case_atm,                     { Pointer to the Case name atome }
  lambda_atm,                   { Pointer to the Lambda name atome }
  flambda_atm,                  { Pointer to the Flambda name atome }
  mlambda_atm,                  { Pointer to the Mlambda name atome }
  quote_atm:      obj_ref;      { Pointer of the quote name function }

  { array used to convert test in LISP symbol NIL or T }
  log_val:        array[boolean] of obj_ref;

  main_statement,               { Main LISP Statement pointer }
  fnc_list_save,                { Save formal atome stack head }
  currobj,                      { Current LISP object reference }
  sys_eof,                      { Pointer to eof read state specified atom }
  sys_eoln,                     { Pointer to eoln read state specified atom }
  sys_read_deep,                { Pointer to include deep atom }
  sys_build_list,               { Pointer to the buiding list }
  sys_read_obj,                 { Pointer to the last read object }
  prin_str,                     { Pointer to sys$_str atom }
  prin_cha,                     { Pointer to sys$_char atom }
  prin_int,                     { Write kind of integer value 0 }
  und_atom,                     { Was undefined test atom }
  lex_own_atm,                  { Lex owner of atom, atom }
  read_kind,                    { Read object kind (in m code) }
  alg_tatom,                    { Communication type atom }
  alg_katom,                    { Communication kind atom }
  alg_satom,                    { Communication macro properties atom }
  alg_spcex,                    { Communication expr specification atom }

  ldrw_Link,                    { Draw Server Mode Atom }

  self_let:       obj_ref;      { Pointer to the "SELF" atom }

  sy_init_mod:    boolean;      { Flag for init mode }

  lfile_first,                  { List Head (and end) of opened file descriptor }
  lfile_last:  lfile_ptr := nil;


  { Record Data Access Table for SYS_CALL Use }

  rec_tbidx:      0..max_rectb;
  rec_tbacc:      array[1..max_rectb] of rfd_ptr;
  rec_tbind:      array[1..max_rectb] of integer;



      {*************************************}
      { *** LISP interpretor exceptions *** }
      {*************************************}

  exception_point,              { Exception point atome pointer }
  exception_status,             { Exception kind atom pointer }
  exception_debug,              { Pointer to debug exception entry point }
  exception_man:  obj_ref;      { Pointer to a lisp exception manager }

  fnc_result,                   { Forced function result (when stopped) }
  stop_reg:       obj_ref;      { Pointer for sequence (EXEC_LIST) exit }


  condition_sev:  error_sev;    { LISP error severity }
  condition_error:integer := 0; { LISP error code }





      {**********************************}
      { *** LISP interpretor options *** }
      {**********************************}

  logint_mode,                  { Flag for logical to integer mode }
  exception_step,               { Flag for step to step debug call }
  opt_debug,                    { Concentration of all debuging option }
  opt_calltrace,                { User function call trace }
  opt_exectrace,                { User exec trace }
  opt_result:     boolean;      { Output result option }

  eval_ninc,                    { Current trace level }
  recurs_nb:     integer;       { Recursive call count }

  curr_point,                   { Current node to execute }
  let_flist,                    { Current list of let parameter }
  interp:        obj_ref;       { Current head value pointer }






      {**************************************}
      { emergency flag to exit from compiler }
      {**************************************}


  emergency_stop: boolean;      { To Set the Emergency Exit of Run }




     {**********************************************}
     { file specification for the source to compile }
     {**********************************************}

  lisp_src:      str_ptr;       { Current LISP Source File Pointer }


{  * * * *   End Of Global Variable Definitions File   * * * *  }
