{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*         ---  Proc./Func. DEFINITIONS PASCAL FILE MODULE   ---         *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}




     {*****************************************************}
     { **** Lisp Error managment procedures/functions **** }
     {*****************************************************}



{ CPAS Error Handler }
function CONDITION_HANDLER( ierr: cc__int ): cc__int; external;


procedure EXEC_ERROR( md: error_mdnam; nb: integer; sev: error_sev );
external;

function F_EXEC_ERROR( md: error_mdnam; nb: integer; sev: error_sev ): obj_ref;
external;

function ELISP_DEBUG( obj: obj_ref ): boolean;
external;

function ELISP_ERROR( md: error_mdnam; nb: integer; sev: error_sev ): integer;
external;

function F_ON_EVENT( parm_lst: obj_ref ): obj_ref;
external;




     {**************************************}
     { ****  Init procedure/functions  **** }
     {**************************************}


procedure SEARCH_FILE( in_var  path,            { Path to use can be string or array of char }
                              fname:  string;   { Name of file to search }
                                acc: integer;   { Access reaquired }
                       var       re:  string;   { Returned complete file specification if found (fnd = true) }
                       var      fnd: boolean ); { Returned flag (true when found, false otherwise) }
external;

procedure LISP_INIT;
external;






     {***************************************************}
     { ****  Garbage collector procedure/functions  **** }
     {***************************************************}


procedure PACKET_ALLOC( atmflg: boolean );
external;

function DOUBLET_ALLOC: obj_ref;
external;

function ATOME_ALLOC: obj_ref;
external;

function LISP_STRING_ALLOC( len: integer ): lisp_s_ptr;
external;

function NEW_LISP_STRINGV( in_var str: packed array[cap: integer] of char;
                                  len: integer := 0 ): lisp_s_ptr;
external;

function VECTOR_ALLOC( len: integer; nil_ini: boolean ): obj_ref;
external;

function LEVEL_IDENT_SEARCH( in_var nam:     packed array[cap:integer] of char;
                                    len:     integer := 0;
                                    bcreate: boolean := false ): ident_ptr;
external;

function IDENT_SEARCH( in_var nam:  packed array[cap:integer] of char;
                                    len:     integer := 0;
                                    bcreate: boolean := false ): ident_ptr;
external;

procedure IDENT_NEW_LINK( p: ident_ptr );
external;

function ATOM_SEARCH( in_var str: packed array[cap: integer] of char;
                             len: integer := 0 ): obj_ref;
external;

function NEW_LEX( ow: obj_ref ): obj_ref;
external;

procedure FREE_LEX;
external;

procedure ACTIVATE_LEX( list: obj_ref );
external;

procedure DEACTIVATE_LEX;
external;

procedure F_SET_LEX( ll: obj_ref );
external;

procedure GARBAGE_COLLECTOR;
external;

procedure EXPORT_IDENTIFIER( ll: obj_ref );
external;

function CREATE_NEW_IDENT( ll: obj_ref ): obj_ref;
external;


procedure FREE_MACRO_SYMBOL( ll: obj_ref );
external;


function F_OBLIST( parml: obj_ref ): obj_ref;
external;




     {************************************************}
     { ****  Dump / Restore procedure/functions  **** }
     {************************************************}



function  OID_REFERENCE( id: integer; obj: obj_ref; iflg: integer ): obj_ref;
external;

function  F_ID_DEFINE( parml: obj_ref ): obj_ref;
external;

function  F_ID_REFER( parml: obj_ref ): obj_ref;
external;

function  F_ID_PURGE( parml: obj_ref ): obj_ref;
external;


function  F_READ_AREA( parmlst: obj_ref ): obj_ref;
external;


procedure F_WRITE_AREA( parmlst: obj_ref );
external;





     {**********************************************}
     { ****  Source input procedure/functions  **** }
     {**********************************************}


function LISP_KIND( obj: obj_ref ): obj_ref;
external;

function F_ZAPLINE: obj_ref;
external;

procedure NEXT_CH;
external;

function F_READCH( binch: boolean ): obj_ref;
external;

procedure SKIP_SPACE;
external;

procedure SKIP_EOLN_AND_SPACE;
external;

function IN_ATOM( lim, defbase: integer; signed_flg: boolean ): obj_ref;
external;

function F_READ: obj_ref;
external;


procedure GET_LISP_STR_REF( var r:   $wild_pointer;
                            var len: integer;
                            var ref: string;
                                obj: obj_ref;
                                bref: boolean := false );
external;


function GET_LISP_STR_LEN( obj: obj_ref ): integer;
external;


procedure LST_PUT_LISP_STR( pst: lisp_s_ptr; l: integer := 0 );
external;


procedure GET_STRING( var res: string; obj: obj_ref; in_var sdef: string );
external;


function GET_LISP_STR( obj: obj_ref; in_var sdef: string ): obj_ref;
external;


{ To use on none Standard Filespc the standard STRING_LOCATE_SEP procedure }
procedure STRING_LOOK_SEPAR(        st: body_s_ptr; l: integer;
                             in_var sp: packed array[n:integer] of char;
                                var tp: array[nsp:integer] of byte;
                                var ie: integer
                           );
external 'PAS__STR_LSEP';


{ To use on none Standard Strings the standard INDEX procedure }
function LIB_REF_INDEX( s1: body_s_ptr; l1: integer;
                        s2: body_s_ptr; l2: integer;
                        nb: integer :=  0;
                        ip: integer := -1;
                        nc: boolean := false
                      ): integer;
external 'PAS__NINDEX_STR';


function STRING_INDEX( ob1, ob2: obj_ref;
                        nb: integer :=  0;
                        ip: integer := -1;
                        nc: boolean := false
                     ): integer;
external;


procedure STRING_SUBSTR( var res: obj_ref; obj: obj_ref; i, j: integer );
external;


procedure STRING_CONCAT( var res: obj_ref; ll: obj_ref );
external;


procedure STRING_CV_IS( var ob:    obj_ref;
                            iv:    integer;
                             f, b: integer := 0 );
external;


procedure STRING_CV_RS( var ob:        obj_ref;
                            rv:        lisp_real;
                             f, d, sg: integer := 0 );
external;

function CHECK_FILE_SPC_TYPE( fnam: obj_ref ): boolean;
external;

function PARSE_FILE_SPC( fspc, lre: obj_ref ): obj_ref;
external;

function F_PRAGMA( parm: obj_ref; src: src_ptr ): obj_ref;
external;

function F_LISTING( ll: obj_ref ): obj_ref;
external;

function F_INCLUDE( ll: obj_ref; bincl, berr: boolean ): obj_ref;
external;


     {***********************************************}
     { ****  Source output procedure/functions  **** }
     {***********************************************}


function GET_CHAR( obj: obj_ref): char;
external;

function F_PRINTCH( cha: obj_ref; nrep: integer ): obj_ref;
external;

function F_TERPRI( ll: obj_ref ): obj_ref;
external;

procedure OUT_ATOM( obj: obj_ref );
external;

procedure OUT_OBJECT( obj: obj_ref );
external;

procedure F_TRACE_EXEC( obj: obj_ref );
external;

procedure F_TRACE_EXEC1( obj: obj_ref );
external;

procedure F_TRACE_CALL( fn, expr: obj_ref; fend: boolean );
external;

function F_PRINT( li: obj_ref; out_flg: boolean ): obj_ref;
external;

function F_STRING_INP( pl: obj_ref): obj_ref;
external;

function F_INP_FORMAT( pl: obj_ref): obj_ref;
external;

function F_OUT_FORMAT( pl: obj_ref): obj_ref;
external;


function F_GET_BIN( lpar: obj_ref ): obj_ref;
external;

function F_PUT_BIN( lpar: obj_ref ): obj_ref;
external;



     {***********************************************}
     { *****  general input/output functions   ***** }
     {***********************************************}

function F_OPEN( lpar: obj_ref ): obj_ref;
external;

function F_CLOSE( lfile: obj_ref ): obj_ref;
external;

function F_EOF( fil: obj_ref ): obj_ref;
external;

function F_EOLN( fil: obj_ref ): obj_ref;
external;

procedure F_CLOSE_ALL;
external;

function F_INPUT( lpar: obj_ref ): obj_ref;
external;


function F_OUTPUT( lpar: obj_ref ): obj_ref;
external;


function F_SET_OUT_HEAD( lpar: obj_ref ): obj_ref;
external;


function F_DEF_LIS_ARRAY( pl: obj_ref ): obj_ref;
external;


function F_SET_LIS_ARRAY( pl: obj_ref ): obj_ref;
external;




      {********************************************}
      { *****  General interface functions   ***** }
      {********************************************}


function F_SYS_CALL( parm_lst: obj_ref ): obj_ref;
external;


procedure REC_ACC_SET( var el: obj_ref; ipm: integer );
external;


procedure REC_GET_ACC( id: integer; var off: integer; var ty: obj_type );
external;





    {************************************************}
    { *****  Algebrical management functions   ***** }
    {************************************************}


function ALG_INIT( obl: obj_ref ): obj_ref;
external;

function ALG_INP_SETUP( ll: obj_ref ): obj_ref;
external;

function ALG_READ: obj_ref;
external;

function ALG_TO_LISP( li: obj_ref ): obj_ref;
external;



     {***************************************}
     { *****  Mathematical functions   ***** }
     {***************************************}


procedure CREATE_FLT_ARRAY( fa: obj_ref; sz: integer );
external;


procedure GET_REC_ARRAY( var lp: obj_ref;    rty: obj_type;
                         var bl: rec_ptr; var sz: integer   );
external;

function MTH_L_BESSELJ( lp: obj_ref ): obj_ref;
external;

function MTH_L_GAMMA( lp: obj_ref ): obj_ref;
external;

function MTH_L_INTERPOL( lp: obj_ref ): obj_ref;
external;

function MTH_L_GAUSS_INTEGR( lp: obj_ref ): obj_ref;
external;

function MTH_L_GAUSS_INTEGR_BLDTAB( lp: obj_ref ): obj_ref;
external;





     {**********************************************}
     { *****  General interpretor functions   ***** }
     {**********************************************}


function F_EVAL( obj: obj_ref ):obj_ref;
external;

function F_LET( obj: obj_ref; namflg: boolean ):obj_ref;
external;

function LOCATE_PROP( ll, indic: obj_ref ): obj_ref;
external;

procedure NEW_PROP( atm, indic, value: obj_ref );
external;

procedure REM_PROP( atm, indic: obj_ref );
external;

function IMPLODCH( lch: obj_ref ): obj_ref;
external;

function TEST_EQUAL( l1, l2: obj_ref ): boolean;
external;

function TEST_EQ( ob1, ob2: obj_ref ): boolean;
external;




{*********************************************************}
{**** Small LISP routines to handle the LISP elements ****}
{*********************************************************}


function NXT_PAR( var list: obj_ref ): obj_ref; external;


function NXD_PAR( var list: obj_ref ): obj_ref; external;


function F_CONS( ob1, ob2: obj_ref ): obj_ref; external;


function F_DBL_FREE( var stk: obj_ref ): obj_ref; external;


function F_CONS_INT( v: integer; lnk: obj_ref ): obj_ref; external;


function F_CONS_STR( v: lisp_s_ptr; lnk: obj_ref ): obj_ref; external;


function F_CONS_FLT( v: lisp_real; lnk: obj_ref ): obj_ref; external;


function F_CONS_SFLT( v: single; lnk: obj_ref ): obj_ref; external;


function F_CONS_MEM( v: mem_ptr; lnk: obj_ref ): obj_ref; external;


function INTVAL( obj: obj_ref ): integer; external;


function INTVREC( r: rec_ptr; ad: integer; ty: obj_type ): integer; external;


function FLTVAL( obj: obj_ref ): lisp_real; external;


function FLTVREC( r: rec_ptr; ad: integer; ty: obj_type ): lisp_real; external;


function SFLTVREC( r: rec_ptr; ad: integer; ty: obj_type ): single; external;


procedure LIST_BLK_EVL( var ll, ob: obj_ref ); external;


procedure LIST_BLK_NEXT( var obj, cur: obj_ref; var idx: integer ); external;


procedure MEM_CHECK( obj: obj_ref; bt1: boolean ); external;


procedure MEM_SET_TYPREF( var adr, obt: obj_ref; obp: obj_ref ); external;


function NUMEVL( var obj: obj_ref ): obj_ref; external;


function INTEVL( var ll: obj_ref ): integer; external;


function FLTEVL( var ll: obj_ref ): lisp_real; external;


function FFUNCT( id, exp: obj_ref; x: lisp_real ): lisp_real; external;


function INTEVLDEF( var ll: obj_ref; vdef: integer ): integer; external;


function FLTEVLDEF( var ll: obj_ref; vdef: lisp_real ): lisp_real; external;


function SFLTEVL( var obj: obj_ref ): single; external;


function SFLTEVLDEF( var obj: obj_ref; r: lisp_real ): single; external;


function RECEVL( var ll: obj_ref ): rec_ptr; external;


function GET_ATOM( obj: obj_ref; absflg : boolean ): obj_ref; external;


procedure REC_EVL( var el: obj_ref; var bl: rec_ptr; var sz: integer ); external;


function GET_LIST( var obj: obj_ref; flg: boolean ): obj_ref; external;


function INSTALL_LISP_FUNC( var ll: obj_ref ): obj_ref; external;


function SET_RESULT_LIST( o: obj_ref; dim: integer ): obj_ref; external;


procedure SET_PARM_OBJ( o: obj_ref ); external;


procedure SET_PARM_STR( s: lisp_s_ptr ); external;


procedure SET_PARM_INT( v: integer ); external;


procedure SET_PARM_BOOL( b: boolean ); external;


procedure SET_PARM_FLT( v: lisp_real ); external;


procedure SET_PARM_SFLT( v: single ); external;


function GET_VALFLAG( ob: obj_ref ): boolean; external;


function GET_EVLFLAG( var ll: obj_ref ): boolean; external;


function GET_FLAG( var ll: obj_ref ): boolean; external;


function GET_CHA( var ll: obj_ref; def: char := ' ' ): char; external;


function GET_INT( var ll: obj_ref; def: integer := 0 ): integer; external;


function GET_REC( var ll: obj_ref ): obj_ref; external;


function GET_FLT( var ll: obj_ref; def: lisp_real := 0.0 ): lisp_real; external;


function GET_SFLT( var ll: obj_ref; def: single := 0.0 ): single; external;


function GET_STRVAL( s: obj_ref ): obj_ref; external;


procedure GET_STR( var  s:   string;
                   var  ll:  obj_ref;
                   var  def: [READONLY] string );
external;


function STRING_MATCH( s1, s2: obj_ref ): integer; external;


function FLOAT_MATCH_VAL( ob1, ob2: obj_ref ): integer; external;

{  * * * *  End of external/inline procedure/function def. file  * * * *  }
