{
******************************************************************
*                                                                *
*                                                                *
*                                                                *
*                                                                *
*      * * *    L I S P    I n t e r p r e t e r    * * *        *
*                                                                *
*                                                                *
*      * * *   ALGEBRIC EXPRESSION MANAGER MODULE   * * *        *
*                                                                *
*	by :                                                     *
*                                                                *
*	    P. Wolfers                                           *
*		c.n.r.s.                                         *
*		Laboratoire de Cristallographie                  *
*		B.P.  166 X   38042  Grenoble Cedex              *
*					FRANCE.                  *
*                                                                *
******************************************************************
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}


{
        *** modification(s) from major version ***


			----

		       nothing

			----


}
module LISP__ALGEBRICAL;


{ Expression item representation in LISP :

  Each item is designed by an atome or a LISP constante. The LISP constantes are
used directly as Numerical or character or string constantes.
  Each atom can be used to denotes a separator, an operator, a macro symbol,
a function, a special LISP handled parameter. The kind or atome is specified by
using of the PLIST of the atoms. Some atomes must be use by a particular method
as the parenthesys to be managed as normal expression parenthesys.
  When an atom has not a PLIST, the atom value is used as a LISP constante.


Representation methods :
------------------------
  The ALG_TO_LISP LISP function use the NIL and T properties
  of atoms to define the atoms particularities.
  The NIL, or (), property is used for the normal input symbols,
  the T property is used for the macro management.

  NIL property values :
  ---------------------

  Separator Property NIL syntaxe :: (0 <separator_character>  [<macro_sequence> ] )

  Separators examples: 
      For "(" and ")" :
            (SETQ *lpar* (IMPLODECH |(| )
                  *rpar* (IMPLODECH |)| ))
            (PUTPROP *lpar*          () '(0 |(|))
            (PUTPROP *rpar*          () '(0 |)|))
      For "," and ";" :
            (PUTPROP (IMPLODECH |;|) () '(0 |;|))
            (PUTPROP ,               () '(0 |,|))
      For "." :
            (PUTPROP (IMPLODECH |.|) () '(0 |.| 1 (field_access 1)))
             ; => Execute the field_access DF function where the parameter if the previous item,
             ; field_access can modify SYS$_ALG_TYPE and SYS$_ALG_KIND et also set SYS$_ALG_SPC.
             ; The result must be the resulting reference.
         The normal application should be  for record field reference .
         When we read rec.res the parameter is res, field_access read with ALG_READ "res".


  Operator Property syntaxe :: for unary only     (1 <unary_operator_def> )
                               for binary only    (2 <binary_operator_def> )
                               for mixt operator  (3 (<unary_operator_def> ) <binary_operator_def> )

                            Where <unary_operator_def> and <binary_operator_def> are a sequence :
                                <priority> <left/rigth_eval_flag> <function_spc>

  Operators examples: 
            (PUTPROP 'NOT () '(1 8 T NULL))      ; for Not logical unary operator of priority 8,
                                                 ; Use the right to left evaluation,
                                                 ; Use the NULL LISP function.
            (PUTPROP '*   () '(2 5 () * ))       ; For * : prior = 8, left to right, Use LISP * function.
            (PUTPROP '-   () '(3 (8 T NEG) 4 () -))
                                                 ; For unary - : prior = 8, right to left, Use NEG function,
                                                 ; For substract : prior = 4, left to right, Use - function,
            (PUTPROP '.   () '(2 9 () field_acc))
                                                 ; For . : prior = 9, left to right,

  Function Property syntaxe :: (4 [T <lex_spc_fnc>] <function_spc> )
                        <function_spc>           ; The function specification.
     The optionnel <lex_spc_fnc> call list must have the following form ::
                     <npos> (<fnc_atm> <i/o_flag> <formal_place>)
                              <fnc_atm>          ; is the function atom,
                               <i/o_flag is the T in first call
                                            and NIL in second call.
                               <npos> must be 2 (or more) or -1 (if not used)



  A function specification can use three formats :

  The direct mode with two variants:

    With using a test type function :
    <nf> <funct> [<type_match_probe>] [ <nsupparm> ] [ <nctef> ] [ <npurgef> ]

    Without test type function :
    <nf> <funct> () [ <ftype> ] [ <nsupparm> ] [ <nctef> ] [ <npurgef> ]

    Where :   <nf>                       ; (default 0) the number of formal:
                                         ; if nf >= 0 it must be satisfied,
                                         ; if nf <  0 it is a maximum,
                                         ; <nf> must be omitted for the unary/binary/mixed operators.
              <funct>                    ; the Lisp function to use,
              <type_match_prob>          ; Type match probe function using only nf parameter types,
                                                 ; it is a list call model that is set by ALG_TO_LISP,
                  Form: (fnc f t1 ... tn ) ;
                                                 ;   f is the Lisp function atom <func> (set by ALG_TO_LISP),
                                                 ;   t1 to tn are the types of each parameters or () when
                                                 ;   the parameter is not present,
                                                 ; The results must be the resulting type.
                                                 ;   Setting of SYS$_ALG_KIND to change the class.
                                                 ;   () = > Error to generate,
                                                 ;   other, the LISP function to use for call generation,
                                                 ; When the type match prob is not specified,
                                                 ;   function is directly used as the LISP function to use.
              <ftype>                    ; The default type (defaulted to () ),
              <supparm>                  ; Suplemental first parameter (Default () ),
              <nctef>                    ; Three value flag to set the macro/expr/cte protocol.
                  -1                             ; It is to set the expression protocol,
                                                 ; in this protocol, the result is an expression and
                                                 ; no ALG_TO_LISP evaluation occures.
                   0/NIL                         ; ( default ) in this protocol, the evaluation occures
                                                 ; when all parameters have the constant class.
                   1                             ; The macro protocol, the evaluation occures always
                                                 ; when all actual are constant (default () ).
              <npurgef>                  ; If T the call list is not free (def () ).



  The Generic mode: In this mode, function_spc denotes a list of generic entries as this :

    ( (<fp1> <fp2> ... <fpn>) <funct> [ <ftype> ] [ <nsupparm> ] [ <nctef> ] [ <npurgef> ] )

              <fp1> ... <fpn>            ; are the formal parameters descriptor for this generic entry,
              <funct>                    ; is the LISP function to use when this entry is selected,
              <ftype>                    ; is the related returned type.
              ...                        ; the other parameter have same same functionality that for
                                         ; the direct mode.

    The format of a formal parameter descriptor is :

    ( <ptype> [ <defval> ] [ . <pclass> ] )

    with :
              <ptype>                    ; the required type of the parameter.
              <defval>                   ; the default value for this parameter, (for ommitted effective),
              <pclass>                   ; the required class of the parameter.

    When <pclass> is not defined, any class can match to the generic entry for this parameter.

    The <ptype> can be a list or an atom.
    If the type is an atom, when its value is a list, this list must be a list of acceptable type.
    The type match is defined as this :

      The type_match between the effective <et> and the formal type <et> is set when :
        1/ (EQ <et> <ft>) = T,           ; The types are the sames.
        2/ if <et> is a list when the TYPE_MATCH is set for (CAR <et>) <ft>) ; parent type same that <ft>.
        3/ if <ft> is an atom, and if the value of atom is a list of types,
             one memeber of this list is matching with the <et> type.




  Functions examples:
            (PUTPROP 'SIN    () '(4 1 SIN))      ; Use the function SIN with one actual parameter.
            (PUTPROP 'SELECT () '(4 -32 SELECT)) ; Use the function SELECT with a maximum of
                                                 ; 32 actual parameters.

   For macro function and parameter the SYS$_ALG_KIND atom is used to
   specify a kind of object as follow :
       -1 => Unknown object,
        0 => No object,
        1 => Constant object,
        2 => Variable object,
        3 => Expression object,
        4 => Function object.


  Special parameter Property syntaxe :: (5 [ <npos> <manager_call_model> <fexp> ] )

                        <npos>                   ; position of the object to set.
                                                 ; 0 = first element,
                                                 ; < 0 => no parameter to give (def.)
                        <manager_call_model>     ; the LISP expression to execute to generate the correct
                                                 ; reference, the <npos>'th. parameter of LISP function
                                                 ; when present, is replaced by the symbol.
                        <fexp>                   ; this flag specify when the
                                                 ; resulted value is an expression.

          when the parameters are not given, the reference is the atom.

  Special Parameter examples:
            (SETQ GEN_ACCESS '(5 1 (GEN_ACCESS 1)))

            (PUTPROP 'COEF () 'GEN_ACCESS)       ; COEF => (COEF).

            (DF GEN_ACCESS (V) (CONS V ()))      ;

            (SETQ HH '(12 . M_LI)                ; Declaration of record.
                  KK '(16 . M_LI)
                  LL '(20 . M_LI)
                  F2 '(24)
                  ; Define its access function.
                  FIELD_ACCESS '(5 2 (FIELD_ACCESS data_list T ))
            )
            (PUTPROP 'HH () FIELD_ACCESS)
            (PUTPROP 'KK () FIELD_ACCESS)
            (PUTPROP 'LL () FIELD_ACCESS)
            (PUTPROP 'F2 () FIELD_ACCESS)
                                                 ; generate call (FIELD_ACCESS 'data_list HH)
                                                 ; and the generated reference is (data_list 12 M_LI)
                                                 ; with :
            (DF FIELD_ACCESS (record field)
               (CONS record (EVAL field))
            )


  Macro properties values :
  -------------------------
  The macro property T is managed as this :

  Input Macro Property syntaxe :: ( [ <npos> <manager_call_model> ] )
  To handle directly from input (before algebrical operator handling).

  The macro option of any level can use SYS$_ALG_SPC atom value to specify
  a special symbol attribute that supershed the normal symbol attribute.

  Example :
           (SETQ period (IMPLODECH |.|))
           (PUTPROP 'rec   T   '( 1 (recfield 1)) ; define the macro property.
                         '*lex '(SYS_CALL 10 'point))
             (SETQ f_a (IMPLODECH( "fa" )
                   f_b (IMPLODECH( "fb" )
                   f_c (IMPLODECH( "fc" ))
           (SYS_CALL 12)
           (SETQ facc '(5 1 (field_acc 1)))
           (PUTPROP f_a '*off '(00 . M_UW)
                        ()    facc))
           (PUTPROP f_b '*off '(00 . M_SW)
                        ()    facc)
           (PUTPROP f_c '*off '(00 . "abcd")
                        ()    facc)

           (DF recfield (r)
             (LET ( (f (SYS_CALL 14 (GETPROP r '*lex)))
                  )
               (IF (NEQ (SETQ *symb (ALG_READ)) period)
               ; Full record reference.
               r
               ; Record field reference.
               (SETQ *symb ())
               (IF SYS$_UNDEF (SYS_CALL 0 "RFLD" 999 3))
                 (SET *symb r)
                 *symb
               )
             )
           )

           (DF field_acc (f)
             (CONS (EVAL f) (GETPROP f '*off))
           )

}


%include 'LISPSRC:lisp_env';   { Get the LISP Environment Definitions }



const
  alg_stk_max = 128;

type
  alg_stk_index = 0..alg_stk_max;

  alg_kindty = ( alg_empty,       { Not to push item }
                 alg_null,        { Null object }
                 alg_cte,         { Constant object }
                 alg_param,       { Active parameter to handle }
                 alg_expr,        { Expression }
                 alg_function,    { Function to call }
                 alg_separator,   { Separator }
                 alg_unaop,       { Unary Operator }
                 alg_binop,       { Binary Operator }
                 alg_mxtop,       { Mixte Operator }
                 alg_unknown);    { Unknown Code }


  { bit/integer equivalence for flag management }
  eqv = record case integer of
    0:( s: bits );
    1:( i: integer );
  end;


  alg_obj = record                { *** Algebrical object record definition *** }
    al_spcex: eqv;                { Special property flags }
    al_prior,                     { Object priority }
    al_npar: integer;             { Number of object parameter to take in object stack }
    al_kind: alg_kindty;          { Object kind }
    al_left: boolean;             { Flag for rigth to left evaluation }
    al_type,                      { Application type }
    al_lexman,                    { For lex manager specification }
    al_handler,                   { Object handler or obj_nil }
    al_object: obj_ref            { Dedicated object or function }
  end;



var
  alg_sv,                                   { Operand stack index }
  alg_sp: alg_stk_index;                    { Item stack index }
  alg_stv,                                  { Operand stack }
  alg_stk: array[alg_stk_index] of alg_obj; { Item stack }

  alg_null_item,           { Null item object }
  alg_primobj,             { Primary expression object }
  alg_gitm: alg_obj;       { Current algebrical object }

  alg_call_buffer,         { Buffer for call lisp }
  alg_openpar,             { Open parenthesys atom pointer }
  alg_closepar,            { Close parenthesys atom pointer }
  alg_last_atom,           { Last object atom pointer, set by ALG_SETUP, updated by ALG_TO_LISP and ALG_READ }
  alg_list_atom,           { Current pointer atom, set by ALG_SETUP, updated by ALG_TO_LISP and ALG_READ }
  alg_type_prop,           { Type of object propery definition }
  alg_read_object,         { Readden object for the read_flag mode }
  alg_ctx_list,            { List of context for the sub expression list }
  alg_expression,          { Algebrical expression pointer (a LISP list) }
  alg_curr: obj_ref;       { Current pointer in algebrical expression }

  alg_read_flag,           { Set for the read mod flag }
  alg_unary,               { Unary operator flag }
  alg_left,                { Left to right evaluation flag }
  alg_end,                 { End of expression list flag }
  alg_stp: boolean;        { Stop parsing flag }

  alg_operand_prior,       { The operand priority }

  alg_code,                { Current symbol identification code }
  alg_prior: integer;      { Current operator priority }
  alg_kind: alg_kindty;    { Current symbol kind }
  alg_separ: char;         { Current separator character }
  alg_prop,                { Current symbol properties list pointer }
  alg_symbol: obj_ref;     { Current expression element }

  alg_type_table: array[0..9] of obj_ref;

  { Table to translate alg_kind to integer }
  alg_code_tab: array[alg_kindty] of integer :=
    ( -1, 0, 1, 2, 3, 4, -1, -1, -1, -1, -1 );

  { Table to tranaslate integer code to alg_kind value }
  alg_kind_tab: array[-1..4] of alg_kindty := (alg_unknown,
                                               alg_null,
                                               alg_cte,
                                               alg_param,
                                               alg_expr,
                                               alg_function );


procedure INPUTSYMB;
var
  n: integer;
  ob0, ob1: obj_ref;

begin
  if alg_read_object.typ <> nullty then
  begin { Prioritary object was specified }
    alg_symbol      := alg_read_object;
    alg_read_object := obj_nil
  end
  else { Object to read from input file or input list }
    if alg_read_flag then
    begin { Input File }
      alg_symbol := F_READ;
      if alg_symbol.typ = eof_seen then alg_end := true
    end
    else
    begin { Input List }
      if alg_curr.typ <> doublety then { End of Sub list or End of expression List }
        if alg_ctx_list.typ = doublety then
        begin { End of sub list }
          ob0            := alg_ctx_list;
          ob1            := ob0;
          alg_curr       := ob1.db^.car;
          ob1.db^.car    := obj_nil;
          ob1            := ob1.db^.cdr;
          alg_expression := ob1.db^.car;
          ob1.db^.car    := obj_nil;
          alg_ctx_list   := ob1.db^.cdr;
          ob1.db^.cdr    := dbl_free;
          dbl_free       := ob0;
          alg_symbol     := alg_closepar
        end
        else alg_end := true
      else
      begin
        alg_separ  := '?';
        alg_symbol := NXT_PAR( alg_curr );
        if alg_symbol.typ = doublety then
        begin  { Sub List are managed as parenthesys }
          alg_ctx_list   := F_CONS( alg_expression, alg_ctx_list );
          alg_ctx_list   := F_CONS( alg_curr, alg_ctx_list );
          alg_expression := alg_symbol;
          alg_curr       := alg_symbol;
          alg_symbol     := alg_openpar
        end
      end;
      alg_list_atom.at^.val := alg_expression
    end;
  if alg_last_atom.typ >= atomety then alg_last_atom.at^.val := alg_symbol;

  { Macro symbol management }
  if alg_symbol.typ >= atomety then
  begin
    ob0 := LOCATE_PROP( alg_symbol, obj_true );
    if ob0.typ = doublety then
    begin { LISP insymbol macro }
      n := GET_INT( ob0, -1 ); { Get the input symbol position }
      ob0 := NXT_PAR( ob0 );   { Get the macro routine }
      ob1 := ob0;              { Locate the parameter position }
      while (n > 0) and (ob1.typ = doublety) do
      begin
        ob1 := ob1.db^.cdr;
        n := n - 1
      end;
      { When found set the Macro Parameter }
      if (n = 0) and (ob1.typ = doublety) then ob1.db^.car := alg_symbol;
      { Execute the Macro Function }
      ob1 := alg_symbol;
      alg_read_object := F_EVAL( ob0 );
      if alg_read_object.typ <> nullty then
        if (alg_read_object.typ >= atomety) and
           (alg_read_object.at = ob1.at) then
        begin { do not loop on the same symbol }
          alg_read_object := alg_symbol; { Keep for next read }
          alg_symbol      := ob0; { Set old object as readen }
        end
        else { When a Result is provided }
          INPUTSYMB   { Set it for algebrical handling }
    end
  end
end INPUTSYMB;


procedure INSYMBOL;
{ Routine to Get an Expression Item from a Given List }
const
  mdnam = 'INSY';

begin { INSYMBOL }
  alg_prior  := 0;
  INPUTSYMB;
  if not alg_end then
  begin
    alg_prop := alg_satom.at^.val; { Try top get a forced property }
    alg_satom.at^.val := obj_nil;  { Erase any trailing property }
    if (alg_prop.typ <> doublety) and
       (alg_symbol.typ >= atomety) then
      alg_prop  := LOCATE_PROP( alg_symbol, obj_nil ); { Look for normal properties }

    if alg_prop.typ = doublety then
    begin { Normal Symbol }
      alg_code  := GET_INT( alg_prop, -1 );
      case alg_code of
        0: { Separator }
          begin
            alg_kind    := alg_separator;
            alg_separ   := GET_CHA( alg_prop, '?' )
          end;

        1: { Unary Operator }
          begin
            alg_kind    := alg_unaop;
            alg_prior   := GET_INT( alg_prop, 1 );
            alg_left    := GET_FLAG( alg_prop )
          end;

        2: { Binary Operator }
          begin
            alg_kind    := alg_binop;
            alg_prior   := GET_INT( alg_prop, 1 );
            alg_left    := GET_FLAG( alg_prop )
          end;

        3: { Unary or Binary Operator }
          alg_kind := alg_mxtop;

        4: { Function }
          begin
            alg_kind    := alg_function;
            alg_prior   := alg_operand_prior
          end;

        5: { LISP active parameter }
          begin
            alg_kind    := alg_param;
            alg_prior   := alg_operand_prior
          end;

      otherwise { Use the value as a cte }
        if alg_symbol.at^.val.typ = nullty then
        begin { Any atom with a NIL value is equivalent to an Unknown separator }
          alg_kind    := alg_separator;
          alg_separ   := '?'
        end
        else
        begin
          alg_kind   := alg_cte;
          alg_prior  := alg_operand_prior;
          alg_symbol := alg_symbol.at^.val
        end
      end { case alg_code of }
    end { normal symbol }
    else
    begin { Should be Cte }
      alg_kind   := alg_cte;
      if alg_symbol.typ >= atomety then
      case alg_symbol.at^.val.typ of
        intub, intsb, intuw, intsw, intty,
        sflty, flty, charty, strty: alg_symbol := alg_symbol.at^.val;

      otherwise
      end;

      alg_prior  := alg_operand_prior
    end
  end
end INSYMBOL;



procedure LOOKSEPAR( ch: char; ier: integer; bps: boolean );
const
  mdnam = 'LSEP';

begin
  if (alg_kind <> alg_separator) or
     (alg_separ <> ch) then
    EXEC_ERROR( mdnam, ier, e_severe )
  else
    if bps then INSYMBOL
end LOOKSEPAR;



function TESTSEPAR( ch: char ): boolean;
begin
  TESTSEPAR := (alg_kind = alg_separator) and (alg_separ = ch)
end TESTSEPAR;



procedure LOOKOPERATOR( ch: char; ier: integer; bps: boolean );
const
  mdnam = 'LOPE';

begin
  if (alg_kind <> alg_unaop) or
     (alg_kind <> alg_binop) or
     (alg_separ <> ch) then
    EXEC_ERROR( mdnam, ier, e_severe )
  else
    if bps then INSYMBOL
end LOOKOPERATOR;



procedure EXPRESSION; forward;



procedure ALG_PUSH( aobj: alg_obj );
const
  mdnam = 'APUV';

begin
  if alg_sv = alg_stk_max then EXEC_ERROR( mdnam, 201, e_severe )
                          else alg_sv := alg_sv + 1;
  alg_stv[alg_sv] := aobj
end ALG_PUSH;


procedure ALG_POP( var aobj: alg_obj );
const
  mdnam = 'APOV';

begin
  aobj := alg_stv[alg_sv];
  if alg_sv = 0 then EXEC_ERROR( mdnam, 202, e_severe )
                else alg_sv := alg_sv - 1
end ALG_POP;


function GETITMTYPE( ob: obj_ref ): obj_ref;
var
  res: obj_ref;

begin
  res := obj_nil;
  if (alg_type_prop.typ <> nullty) and (alg_symbol.typ >= atomety) then
    res := LOCATE_PROP( alg_symbol, alg_type_prop )
  else
  begin
    res := LISP_KIND( ob );
    if (res.int >= 0) and (res.int <= 9) then res := alg_type_table[ res.int ]
                                         else res := obj_nil;
  end;
  GETITMTYPE := res
end GETITMTYPE;


procedure GETITEM;
const
  mdnam = 'GITM';

var
  noinsymbol: boolean;
  n, ncp: integer;
  fspc, obj, ob1, ob2: obj_ref;

begin
  repeat
    noinsymbol := false;
    alg_gitm := alg_null_item;
    if alg_end then alg_stp := true;
    if not alg_stp then
    begin
      case alg_kind of
        alg_separator:
          if alg_separ = '(' then
            if alg_unary then
            begin
              INSYMBOL; { Gobble up "(" }
              EXPRESSION;
              LOOKSEPAR( ')', 211, false );
              alg_stp           := false; { Force read continue }
              alg_unary         := false;
              alg_gitm.al_prior := alg_operand_prior;
              alg_gitm.al_kind  := alg_empty
            end
            else alg_stp := true
          else
            if (alg_prop.typ = doublety) and not alg_unary then
            begin { Separator with post operator function }
              n        := GET_INT( alg_prop, -1 );
              alg_prop := NXT_PAR( alg_prop );
              fspc     := alg_prop;
              while (n > 0) and (alg_prop.typ = doublety) do
              begin
                alg_prop := alg_prop.db^.cdr;
                n := n - 1
              end;
              { Get the last object in stack }
              alg_gitm := alg_stk[alg_sp];
              if alg_sp < 1 then EXEC_ERROR( mdnam, 203, e_severe )
                            else alg_sp := alg_sp - 1;
              alg_katom.at^.val.typ := intty;
              alg_katom.at^.val.int := alg_code_tab[ alg_gitm.al_kind ]; { Get class of previous object }
              alg_tatom.at^.val   := alg_gitm.al_type;     { Get the related type ... }
              if (n = 0) and (alg_prop.typ = doublety) then
                alg_prop.db^.car  := alg_gitm.al_object;
              alg_read_object     := F_EVAL( fspc ); { Set the resulting ... }
              alg_unary           := true;     { To force read continue }
              alg_gitm.al_kind    := alg_empty { ... object as next read obj. }
            end
            else alg_stp := true;

        alg_cte:
          if alg_unary then
          begin
            alg_gitm.al_prior   := alg_prior;
            alg_gitm.al_kind    := alg_cte;
            alg_gitm.al_object  := alg_symbol;
            alg_gitm.al_type    := GETITMTYPE( alg_symbol );
            alg_unary           := false
          end
          else alg_stp := true;

        alg_param:
          if alg_unary then
          begin
            alg_gitm.al_prior   := alg_operand_prior;
            alg_gitm.al_kind    := alg_param;
            alg_gitm.al_handler := alg_prop;
            alg_gitm.al_object  := alg_symbol;
            alg_gitm.al_type    := GETITMTYPE( alg_symbol );
            alg_unary           := false
          end
          else alg_stp := true;

        alg_unaop,
        alg_binop,
        alg_mxtop:
          begin
            if alg_kind = alg_mxtop then
            begin
              if alg_unary then
              begin
                alg_prop  := NXT_PAR( alg_prop );
                alg_kind  := alg_unaop
              end
              else
              begin
                fspc := NXT_PAR( alg_prop );
                alg_kind  := alg_binop
              end;
              alg_prior   := GET_INT( alg_prop, 1 );
              alg_left    := GET_FLAG( alg_prop )
            end
            else
              if alg_unary then
              begin
                if alg_kind = alg_binop then EXEC_ERROR( mdnam, 205, e_severe )
              end
              else
                if alg_kind = alg_unaop then
                  EXEC_ERROR( mdnam, 206, e_severe );
            alg_gitm.al_prior  := alg_prior;
            if alg_kind = alg_unaop then alg_gitm.al_npar := 1
                                    else alg_gitm.al_npar := 2;
            alg_gitm.al_kind    := alg_kind;
            alg_gitm.al_type    := obj_nil;
            alg_gitm.al_object  := NXT_PAR( alg_prop );
            alg_gitm.al_left    := alg_left;
            alg_gitm.al_handler := alg_prop;
            alg_unary           := true
          end;

        alg_function:
          if alg_unary then
          begin
            obj  := alg_prop;                { Save the function reference }
            fspc := NXT_PAR( obj );          { Get the function reference }
            if fspc.typ = truety then        { If a lex manager is specified }
            begin                            { ... then ... }
              ob1  := NXT_PAR( obj );        { save the special lexman spc }
              fspc := NXT_PAR( obj );        { Get the true function reference }
              ncp  := 0;                     { Set action count to 0 }
              if ob1.typ = doublety then
                ob2 := ob1.db^.cdr           { Get the parameter pointer }
              else
                ob2 := obj_nil               { or disable the parm. setting }
            end
            else                             { else disable lexman handling }
            begin
              ncp := -1;
              ob1 := obj_nil;
              ob2 := obj_nil
            end;
            n    := 0;
            INSYMBOL;                        { Gobble up the function identifier }
            if TESTSEPAR( '(' ) then
            begin
              repeat
                if n = ncp then              { If the lex manager ... }
                begin                        { must be called then ... }
                  if ob2.typ = doublety then { when the parm handling is ... }
                  with ob2.db^ do            { enable set it. }
                  begin
                    car := obj_zero;
                    car.int := n
                  end;
                  ncp := INTVAL( F_EVAL( ob1 ) ); { Activate the lexman routine }
                  { ... and get the resulting syntax unit }
                  if alg_last_atom.typ >= atomety then
                    alg_read_object := alg_last_atom.at^.val
                end;
                INSYMBOL;                    { Get the syntax unit. }
                EXPRESSION;
                n := n + 1
              until not TESTSEPAR( ',' );
              LOOKSEPAR( ')', 211, false )
            end
            else noinsymbol := true;         { When no parameter, do notread next now }
            if ob1.typ = doublety then
            begin
              if ob2.typ = doublety then     { When the parm handling is ... }
                ob2.db^.car := obj_nil;      { enable the end parm list mode }
              ob2 := F_EVAL( ob1 )           { Activate the lexman routine }
            end;
            alg_gitm.al_npar    := n;
            alg_gitm.al_prior   := alg_operand_prior;
            alg_gitm.al_kind    := alg_function;
            alg_gitm.al_object  := fspc;
            alg_gitm.al_type    := obj_nil;
            alg_gitm.al_handler := obj;
            alg_stp             := false;    { Force read continue }
            alg_unary           := false
          end
          else alg_stp := true;

      otherwise
        alg_stp := true  { Unknown condition }
      end
    end;
    if not (alg_stp or alg_end or noinsymbol) then INSYMBOL
  until alg_gitm.al_kind <> alg_empty
end GETITEM;


{ *** Generic Managment Procedures *** }

function TYPE_MATCH( et, ft: obj_ref ): boolean;
{ Generic type match test :
  et is the effective parameter type and ft is the formal parameter type.
  a type is a list where the first parameter is the parent type list.
  The formal type can be also an atom (wild types), in this case the
  value must be a list of allowed types.
  The Matching is set when :
    1/ The two types are sames,
    2/ An parent of effective type is the formal type,
    3/ Itself or a parent type of effective type is a member of the
       list of the wild formal type list.
}
var
  r: boolean;

begin
  if TEST_EQ( et, ft ) then r := true
  else
  begin
    r := false;
    if et.typ = doublety then r := TYPE_MATCH( et.db^.car, ft );
    if not r and (ft.typ >= atomety) then
    begin
      ft := ft.at^.val;
      while not r and (ft.typ = doublety) do
        r := TYPE_MATCH( et, NXT_PAR( ft ) )
    end
  end;
  TYPE_MATCH := r
end TYPE_MATCH;


function ENTRY_MATCH( var nf: integer; var bct: boolean;   var spcr: eqv;
                           n: integer;    fepl: obj_ref ): boolean;
{ Test when the formal entry fp is compatible with the actual parameter lisp in the alg_stk stack.
  n is the actual number of effective parameters,
  The function entry fp has the following format :
    ( (fp1 fp2 ... fpm) <funct> <ftype> [ <nsupparm> ] [ <nctef> ] [ <npurgef> ] )
        fpi              is the formal description for the i-th formal,
       <funct>           is the Lisp function to select when match occure,
       <ftype>           is the returned type,
       <nsupparm>        is the supplemental parameter to insert,
       <ieval>           is an integer flag this the next following signicant value :
                           0   ALG_TO_LISP disable any Lisp evaluation.
                           T/1 ALG_TO_LISP set the macro mode (Lisp evaluation always),
                           ()  or any other value (default), A Lisp evaluation occures when
                               all effective parameters have the class set to constante.
       <npurgef>         is a flag to suppress the List purge after an Lisp evaluation.
}
const
  mdnam = 'ENTM';

var
  r, b:       boolean;
  i, j, fcl:  integer;
  dv, ft, ob: obj_ref;
  spc:        eqv;

begin
  b := true;                                 { Cte Mode Assumed until shown otherwise }
  spc.s   := [];                             { Assume no special flag }
  currobj := alg_call_buffer;                { Set the calling buffer setting }
  r   := true;                               { Assume ok. until showed otherwise }
  i   := alg_sv - n + 1;                     { Set the pointer in the stack list }
  j   := 0;                                  { Initialize the formal count }
  if i < 0 then EXEC_ERROR( mdnam, 777, e_fatal );
  while r and (fepl.typ = doublety) do       { Loop on all formal parameters }
  begin
    j  := j + 1;                             { Update the formal parameter count }
    ob := NXT_PAR( fepl );                   { Get one formal specification }
    ft := NXT_PAR( ob );                     { Get the required formal type }
    dv := NXT_PAR( ob );                     { Get the required formal default value }
    if ob.typ = intty then fcl := ob.int     { Get the formal class whene specified }
                      else fcl := -1;
    if i > alg_sv then                       { End of effective list ? }
      if dv.typ = nullty then                { No specified default effective value for the formal }
        r := false
      else SET_PARM_OBJ( dv )                { Yes set in the call buffer }
    else                                     { No }
    if alg_stv[i].al_kind <= alg_null then   { No effective parameter }
      if dv.typ = nullty then r := false     { No specified default effective value for the formal }
      else SET_PARM_OBJ( dv )                { Yes set in the call buffer }
    else                                     { An effective parameter is specified }
      if TYPE_MATCH( alg_stv[i].al_type, ft ) then
      begin
        if fcl >= 1 then                     { When a particular class is specified the class must match }
          if alg_stv[i].al_kind <> alg_kind_tab[fcl] then r := false;
        if r then                            { When ok. put the parameter in the call buffer }
          SET_PARM_OBJ( alg_stv[i].al_object );
        spc.s := spc.s + alg_stv[i].al_spcex.s;
        if alg_stv[i].al_kind > alg_cte then b := false
      end
      else r := false;
    i := i + 1
  end;
  if (i <= alg_sv) and (fepl.typ <> doublety) then r := false; { formal list shorter than effective list }
  { Here fe -> the return function entry }
  if r then
  begin
    nf   := j;
    spcr := spc;
    bct  := b
  end;
  ENTRY_MATCH := r
end ENTRY_MATCH;



{ *** Operator/Function Call/Reference Generator *** }

procedure PUTITEM( aobj: alg_obj );
const
  mdnam = 'PITM';

var
  bmac, bcte:                        boolean;
  i, j, itk, n, nf:                  integer;
  defv, func, fnty, obdf, obsp, res: obj_ref;
  spc:                               eqv;

begin
  alg_katom.at^.val := obj_zero;
  alg_primobj       := aobj;
  spc.s             := [];
  case alg_primobj.al_kind of
    alg_unaop,
    alg_binop,
    alg_function: { Function Call }
      if alg_primobj.al_object.typ <> nullty then
      begin
        func := alg_primobj.al_object;       { When Generic mode use, it is the generic list }
        n    := alg_primobj.al_npar;         { get the number of effective parameters }
        nf   := 0;                           { to init nf }
        res  := obj_nil;
        bcte := true;                        { until shown otherwise }
        if func.typ = doublety then
        begin { *** Generic mode *** }
          bmac := false;
          while (func.typ = doublety) and not bmac do
          begin
            { Loop on all generic entries }
            obsp := NXT_PAR( func );         { Get a generic entry }
            { Test for applicability of this entry }
            bmac := ENTRY_MATCH( nf, bcte, spc, n, NXT_PAR( obsp ) )
          end;                               { Loop until founded or end of generic list }
          if not bmac then                   { Not found generic entry }
            EXEC_ERROR( mdnam, 207, e_severe );
          func := NXT_PAR( obsp );           { Get the Lisp function from the selected entry }
          alg_sv := alg_sv - n;              { POP the parameters from the value stack }
          if alg_sv < 0 then EXEC_ERROR( mdnam, 202, e_severe );
          if func.typ <> nullty then
          begin { Set the generic specification }
            fnty := obj_nil;                 { Init the parameter list head }
            i    := 0;                       { Set the count of formal }
            obdf := alg_call_buffer;         { Set call buffer start addr. }          
            while i < nf do
            begin
              defv := DOUBLET_ALLOC;         { Create a parameter doublet }
              { Set the link of the parameter doublet }
              if res.typ = nullty then res := defv
                                  else fnty.db^.cdr := defv;
              fnty := defv;                  { Keep the last doublet pointer }
              defv.db^.car := NXT_PAR( obdf );
              i := i + 1
            end
          end;
          alg_tatom.at^.val := NXT_PAR( obsp )
        end
        else  { *** No generic mode *** }
        begin { we generate the appropriate count of effective parameter }
          obsp := alg_primobj.al_handler;    { Get the function handler list }
          if alg_primobj.al_kind = alg_binop then nf := 2
          else
            if alg_primobj.al_kind = alg_unaop then nf := 1
            else
            begin
              nf := INTVAL( func );          { Get the allowed number of formal }
              func := NXT_PAR( obsp )        { Get the Lisp function atom }
            end;
          fnty := NXT_PAR( obsp );           { Get the type probe specifier }
          if (nf <> n) and (nf > 0) then EXEC_ERROR( mdnam, 208, e_error );
          nf := ABS( nf );
          if nf < n then EXEC_ERROR( mdnam, 209, e_error );
          i := alg_sv - n + 1;
          if i < 0 then EXEC_ERROR( mdnam, 202, e_fatal );
          if fnty.typ = doublety then
          begin { fnty is the test function atom }
            j := 0;
            currobj := fnty;
            SET_PARM_OBJ( fnty );            { Set the test function atom }
            SET_PARM_OBJ( func );            { Set the applied function }
            while i <= alg_sv do
            begin
              SET_PARM_OBJ( alg_stv[i].al_type ); { Set the user effective type }
              j := j + 1;
              i := i + 1
            end;
            while j < nf do
            begin
              SET_PARM_OBJ( obj_nil );       { Set NIL typ for unspecified effective parameters }
              j := j + 1
            end;
            { Evaluate test function to get the resulting type }
            alg_tatom.at^.val := F_EVAL( alg_call_buffer )
          end
          else alg_tatom.at^.val := NXT_PAR( obsp );
          i     := nf;
          while i > n do
          begin
            res := F_CONS( obj_nil, res );
            i := i + 1
          end;
          while i > 0 do
          begin { Loop on all formal }
            if alg_stv[alg_sv].al_kind > alg_cte then bcte := false;
            res   := F_CONS( alg_stv[alg_sv].al_object, res );
            spc.s := spc.s + alg_stv[alg_sv].al_spcex.s;
            if alg_sv > 0 then alg_sv := alg_sv - 1;
            i := i - 1
          end
        end;

        { *** Common part of the function Managment *** }

        if func.typ < atomety then           { Unknown Function }
          EXEC_ERROR( mdnam, 210, e_severe );

        obdf := NXT_PAR( obsp );             { Get the Supplemental Parameter }
        { insert it when specified }
        if obdf.typ <> nullty then res := F_CONS( obdf, res );
        res := F_CONS( func, res );          { Forms the LISP call list }

        defv := NXT_PAR( obsp );
        bmac := false;
        case defv.typ of
          intty: if defv.int = 1 then
                 begin { macro mode }
                   bcte := true; bmac := true
                 end
                 else
                   if defv.int = -1 then bcte := false;

          truety: begin
                    bcte := true; bmac := true
                  end;
        otherwise
        end;

        if bcte then                         { Constante and Macro conditions }
        begin { Applied directly the function }
          alg_primobj.al_object := F_EVAL( res );
          { Set a kind of object to the result }
          if bmac then
          begin { Macro mode specific code to set a class }
            i := INTVAL( alg_katom.at^.val );{ Try to use SYS$_ALG_KIND }
            if (i >=-1) and (i <= 4) then
              alg_primobj.al_kind := alg_kind_tab[i]
            else
              case alg_primobj.al_object.typ of
                intub, intsb, intuw, intsw, intty,
                sflty, flty, charty, strty: { Constante }
                  alg_primobj.al_kind := alg_cte;

              otherwise
                { For all not constant object Set kind to unknown }
                alg_primobj.al_kind := alg_unknown
              end;
            spc.i := INTVAL( alg_spcex.at^.val );{ Try to use SYS$_ALG_SPC2 }

          end
          else
            alg_primobj.al_kind := alg_cte;  { For no macro case the class is set to cte }
          if not GET_FLAG( obsp ) then       { Purge the call list is required }
          begin
            defv := res;
            while defv.typ = doublety do
            begin
              defv.db^.car := obj_nil;
              obsp := defv;
              defv := defv.db^.cdr
            end;
            obsp.db^.cdr := dbl_free;
            dbl_free := res
          end
        end { if bcte then }
        else
        begin { Generate an Expression with class = alg_expr }
          alg_primobj.al_kind   := alg_expr;
          alg_primobj.al_object := res
        end;
        alg_primobj.al_type  := alg_tatom.at^.val; { Set the current type }
        alg_primobj.al_spcex := spc          { Set special flags }
      end;

    alg_param: { Special Parameter Load }
      begin
        func:= alg_primobj.al_handler;
        if func.typ = intty then spc.i := INTVAL( func );
        if func.typ = doublety then
        begin
          n    := GET_INT( func, -1 );
          defv := NXT_PAR( func );
          bcte := GET_FLAG( func );
          func := defv;
          { Locate the appropriate parameter as required }
          while (n > 0) and (defv.typ = doublety) do
          begin
            defv := defv.db^.cdr;
            n := n - 1
          end;
          if (n = 0) and (defv.typ = doublety) then
            defv.db^.car := alg_primobj.al_object;
          if n < 0 then { No modification except possible change of kind/spc/type }
            func := F_EVAL( func )
          else
            alg_primobj.al_object := F_EVAL( func ); { Execute the LISP generation }
          { Set a kind of object to the result }
          itk := INTVAL( alg_katom.at^.val ); { Try to use SYS$_ALG_KIND }
          if (itk >=-1) and (itk <= 4) then
          begin
            alg_primobj.al_kind := alg_kind_tab[ itk ];
            alg_primobj.al_type := alg_tatom.at^.val;
            spc.i := INTVAL( alg_spcex.at^.val )
          end
          else { We try to default it }
          case alg_primobj.al_object.typ of
            intub, intsb, intuw, intsw, intty,
            sflty, flty, charty, strty: { Constante }
              begin
                alg_primobj.al_kind := alg_cte;
                alg_primobj.al_type := GETITMTYPE( alg_primobj.al_object )
              end;

          otherwise
            { For all not constant object keep the alg_param kind for LISP expression }
            { We assume unchanged type }
            if bcte then alg_primobj.al_kind := alg_expr
                    else alg_primobj.al_kind := alg_param
          end
        end;
        alg_primobj.al_spcex := spc; { Set special flags }
      end;

  otherwise { Nothing to do }
  end;
  ALG_PUSH( alg_primobj ) { Push the resulted operand }
end PUTITEM;


procedure EXPRESSION;
const
  mdnam = 'AEXP';

var
  sav_gitm : alg_obj;
  svsp:      alg_stk_index;

begin { EXPRESSION }
  sav_gitm    := alg_gitm;
  alg_primobj := alg_null_item;
  alg_unary   := true;
  alg_stp     := false;
  svsp        := alg_sp;

  GETITEM;
  while ((alg_sp <> svsp) or not alg_stp) do
    if (alg_sp <> svsp) and ((alg_gitm.al_prior < alg_stk[alg_sp].al_prior) or
                            ((not alg_gitm.al_left) and (alg_gitm.al_prior = alg_stk[alg_sp].al_prior)))
    then
    begin
      PUTITEM( alg_stk[alg_sp] );
      if alg_sp < 1 then EXEC_ERROR( mdnam, 203, e_severe )
                    else alg_sp := alg_sp - 1
    end
    else
    begin
      if alg_sp = alg_stk_max then EXEC_ERROR( mdnam, 204, e_severe )
                              else alg_sp := alg_sp + 1;
      alg_stk[alg_sp] := alg_gitm;
      GETITEM
    end;
  alg_gitm := sav_gitm
end EXPRESSION;


[global]
function ALG_INP_SETUP( ll: obj_ref ): obj_ref;
{ call form :
  (ALG_INPUT [ T /<alg_list_atom> ] [ <alg_last_atom> ] )

   for first parameter ;
     T => The read flag mode is set.
     () => No change (same as unspecified).
     atome => pointer atom for input list.

}
var
 ob_at: obj_ref;

begin
  ob_at := F_EVAL( NXT_PAR( ll ) );
  if ob_at.typ <> nullty then
    if ob_at.typ = truety then
    begin { Set the read mode for ALG_READ }
      alg_read_flag := true;
      alg_list_atom := obj_nil
    end
    else
    begin { Set the list mode }
      alg_read_flag := false;
      alg_list_atom := GET_ATOM( ob_at, true )
    end;
  ob_at := F_EVAL( NXT_PAR( ll ) );
  if ob_at.typ <> nullty then alg_last_atom := GET_ATOM( ob_at, true );
  ALG_INP_SETUP := alg_list_atom
end ALG_INP_SETUP;



[global]
function ALG_READ: obj_ref;
begin
  if not alg_read_flag and (alg_list_atom.typ >= atomety) then
  begin
    alg_expression := alg_list_atom.at^.val;
    alg_curr       := alg_expression
  end;
  INPUTSYMB;
  ALG_READ := alg_symbol
end ALG_READ;



[global]
function ALG_TO_LISP( li: obj_ref ): obj_ref;
{ call form :
  (ALG_TO_LISP [ <prior_symbol> ] [ <expected_type> ] [ <conv_funct> ])
}
const
  mdnam = 'ALGL';

var
  subfl:        boolean;
  cvobj:        alg_obj;
  expty, cvlis: obj_ref;
  sv_sp, sv_sv: alg_stk_index;

begin { ALG_TO_LISP }
  alg_read_object := F_EVAL( NXT_PAR( li ) );
  expty := NXT_PAR( li );               { Get the expected type }
  cvlis := NXT_PAR( li );               { Get the conversion ope. list }
  subfl := GET_EVLFLAG( li );           { Get the subexpression flag }

  alg_tatom.at^.val := obj_nil;
  alg_katom.at^.val := obj_zero;
  alg_spcex.at^.val := obj_zero;
  alg_expression    := obj_nil;

  if not alg_read_flag and (alg_list_atom.typ >= atomety) then 
    alg_expression := alg_list_atom.at^.val;
  alg_curr       := alg_expression;
  alg_end        := false;

  sv_sp := alg_sp;
  sv_sv := alg_sv;

  INSYMBOL;
  EXPRESSION;

  alg_katom.at^.val.int    := alg_code_tab[ alg_primobj.al_kind ];
  alg_tatom.at^.val        := alg_primobj.al_type;
  alg_spcex.at^.val.int    := alg_primobj.al_spcex.i;

  if (alg_primobj.al_kind <> alg_null) and (expty.typ <> nullty) then
    if not TYPE_MATCH( alg_tatom.at^.val, F_EVAL( expty ) ) then
    { The expected type and the expression type do not match }
      if cvlis.typ <> nullty then
      begin
        cvlis := F_EVAL( cvlis );
        cvobj := alg_null_item;         { Init all field of the conv. object }
        with cvobj do
        begin
          al_prior   := alg_operand_prior;      { Set the conv. prior. (do not used )}
          al_npar    := 1;                      { Set the number of eff. parameter }
          al_kind    := alg_function;           { Set function kind }
          al_type    := obj_nil;                { Resulting type }
          al_object  := NXT_PAR( cvlis );       { Set conversion function entry }
          al_handler := cvlis
        end;
        PUTITEM( cvobj );
        { Set a kind of object to the result }
        alg_katom.at^.val.int := alg_code_tab[ alg_primobj.al_kind ];
        alg_spcex.at^.val.int := alg_primobj.al_spcex.i;
        alg_tatom.at^.val     := alg_primobj.al_type
      end
      else
        EXEC_ERROR( mdnam, 212, e_error );

  if alg_last_atom.typ >= atomety then alg_last_atom.at^.val := alg_symbol;

  if not subfl then
  begin
    alg_sp := sv_sp;
    alg_sv := sv_sv  { Remove the alg_primobj object from the stack }
  end;

  ALG_TO_LISP := alg_primobj.al_object
end ALG_TO_LISP;



[global]
function ALG_INIT( obl: obj_ref ): obj_ref;
var
  ch:                     char;
  i, cod, prior:          integer;
  ob, ob1, ob_obj, ob_at: obj_ref;

begin
  alg_read_object          := obj_nil;
  alg_null_item.al_spcex.i := 0;
  alg_null_item.al_prior   := 0;
  alg_null_item.al_npar    := 0;
  alg_null_item.al_kind    := alg_null;
  alg_null_item.al_left    := false;
  alg_null_item.al_type    := obj_nil;
  alg_null_item.al_lexman  := obj_nil;
  alg_null_item.al_handler := obj_nil;
  alg_null_item.al_object  := obj_nil;

  alg_list_atom     := obj_true;
  alg_last_atom     := obj_nil;
  alg_operand_prior := 0;

  alg_sp        := 0;
  alg_sv        := 0;
  alg_stk[0]    := alg_null_item;
  alg_stv[0]    := alg_null_item;

  alg_satom.at^.val := obj_nil;

  alg_ctx_list   := obj_nil;

  ob_obj := F_EVAL( NXT_PAR( obl ) );
  while ob_obj.typ = doublety do
  begin
    ob_at := NXT_PAR( ob_obj );
(*
WRITELN( ' ALG_INIT A "', ob_at.typ, '"' );
OUT_OBJECT( ob_at ); LST_EOLN;
*)
    if ob_at.typ < atomety then ob_at := IMPLODCH( ob_at );
(*
WRITELN( ' ALG_INIT B "', ob.typ, '"' );
*)
    ob := NXT_PAR( ob_obj );
    NEW_PROP( ob_at, obj_nil, ob );
    cod := GET_INT( ob, -1);
    case cod of
      0: { Separator }
        begin
          ch := GET_CHA( ob, '?' );
          if ch = '(' then alg_openpar := ob_at
                      else if ch = ')' then alg_closepar := ob_at
        end;

      1,2: { Unary or Binary Operator }
        begin
          prior := GET_INT( ob, 1 );
          if prior >= alg_operand_prior then alg_operand_prior := prior + 1
        end;

      3: { Mixte Operator }
        begin
          ob1 := NXT_PAR( ob );
          prior := GET_INT( ob1, 2 );
          if prior >= alg_operand_prior then alg_operand_prior := prior + 1;
          prior := GET_INT( ob, 1 );
          if prior >= alg_operand_prior then alg_operand_prior := prior + 1
        end;

    otherwise
    end
  end;

  ob_obj := F_EVAL( NXT_PAR( obl ) );
  for i := 0 to 9 do alg_type_table[i] := obj_nil;
  while ob_obj.typ = doublety do
  begin
    i := GET_INT( ob_obj, -1 );
    ob := NXT_PAR( ob_obj );
    if (i >= 0) and (i <= 9) then alg_type_table[i] := ob
  end;

  alg_type_prop    := F_EVAL( NXT_PAR( obl ) );

  i := INTEVLDEF( obl, 64 );
  if i < 16 then i := 64;
  alg_call_buffer := obj_nil;
  while i >= 0 do
  begin
    alg_call_buffer := F_CONS( obj_nil, alg_call_buffer );
    i := i - 1
  end;

  ALG_INIT := obj_nil
end ALG_INIT;


end.
