{
******************************************************************
*                                                                *
*                                                                *
*                                                                *
*                                                                *
*      * * *    L I S P    I n t e r p r e t e r    * * *        *
*                                                                *
*                                                                *
*            ***   EXECPTION  MANAGER MODULE   ***               *
*                                                                *
*	by :                                                     *
*                                                                *
*	    P. Wolfers                                           *
*		c.n.r.s.                                         *
*		Laboratoire de Cristallographie                  *
*		B.P.  166 X   38042  Grenoble Cedex              *
*					FRANCE.                  *
*                                                                *
******************************************************************
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}



{************************************************}
{**** Exception Manager for LISP Execution   ****}
{************************************************}

module LISP_ERROR( input, output );


%include 'lispsrc:lisp_env';    { Get the Lisp Environment Definitions }


var
  { To disable the error condition handler }
  err_nohandler: [global] boolean := false;

  error_ent:  error_entry;      { Execution Error Context }



procedure LISP_ERR_MSG( var f: text );
begin
  WRITE( f, ' **LISP** ' );
  with error_ent do
  begin
    case err_sv of
      e_success: ;
      e_warning: WRITE( f, ' Exec-Warning' );
      e_error:   WRITE( f, ' Exec-Error' );
      e_severe:  WRITE( f, ' Severe Exec-Error' );
      e_fatal:   WRITE( f, ' Fatal Exec-Error' )
    end;
    WRITELN( f, ' # ', err_code:3, ' detected by the ', err_mdn, ' module.' );
    if err_msg <> nil then
      WRITELN( f, '  *EXE* ', err_msg^ )
    else WRITELN( f )
  end
end LISP_ERR_MSG;


[global]
function ELISP_DEBUG( obj: obj_ref ): boolean;
var
  res: obj_ref;

begin
  exception_step := false;                 { Disable the step mode }
  exception_point.at^.val   := log_val[ exception_step ];
  exception_point.at^.plist := obj;        { Set the exception point }
  res := F_LET( exception_debug, false );
  ELISP_DEBUG := (res.typ <> nullty)       { Set the Step Mode for the next }
end ELISP_DEBUG;


[global]
function ELISP_ERROR( md: error_mdnam; nb: integer; sev: error_sev ): integer;
var
  std_lst: boolean;

begin
  std_lst := lstf_stdout in lst_current^.lst_flagsw;
  with error_ent do
  begin
    err_pos  :=   1;
    err_code :=  nb;
    err_sv   := sev;
    err_mdn  :=  md;
  end;
  ERR_GETMSG( error_ent );                               { Get possible defined message }
  error_cnt[sev] := SUCC( error_cnt[sev] );
  if error_result < sev then error_result := sev;

  if (src_blist in src_control^.src_flags) or std_lst then
    with lst_current^ do
    begin
      lst_lncnt := SUCC( lst_lncnt );                   { Skip to next page without page skip }
      LST_NEWLINE; lst_lncnt := SUCC( lst_lncnt );      { To allocate two lines }
      LISP_ERR_MSG( lst_current^.lst_file )
    end;

  if not std_lst then LISP_ERR_MSG( output );
  if exception_debug.typ = doublety then
  begin
    exception_step := ELISP_DEBUG( exception_point.at^.plist );
    ELISP_ERROR := 0
  end
  else
    if sev > e_warning then
    begin
      recurs_nb := 0;            { Reset trace flag }
      eval_ninc := 0;            { Reset exec trace level }
      ELISP_ERROR := nb          { Set error code }
    end
    else ELISP_ERROR := 0
end ELISP_ERROR;


[global]
function F_ON_EVENT( parm_lst: obj_ref ): obj_ref;
begin
  exception_man := parm_lst;
  F_ON_EVENT := obj_nil
end F_ON_EVENT;


[global]
function CONDITION_HANDLER( ierr: cc__int ): cc__int;

begin { CONDITION_HANDLER }
  if not err_nohandler then
  begin
    stop_reg.typ := truety; { Set the Condition Mode in the F_EVAL procedure }
    CONDITION_HANDLER := 1; { Try to Continue the Execution }
    condition_sev := e_severe;  { Assume the Error Severity }
    { Select the related LISP Error Code }
    case ierr of
      21: { interger overflow }
          condition_error := 21;
      22: { Integer ZeroDivide }
          condition_error := 22;      { set the lisp error code }
      24: { Floatting Overflow }
          condition_error := 23;      { Set the LISP Error Code ... }
      25: { Floatting Zerodivide }
          condition_error := 24;      { Set the LISP Error Code ... }
    otherwise
      CONDITION_HANDLER := 0          { Return Error to Previous Handler }
    end;

(*
      case sig_args[1] of
        ss$_intovf:
        ss$_intdiv:
        mth$_squrooneg:
          { Handle square root of a negative number }
          begin
            savmth_err := 31;
            savmth_sev := e_severe
          end;
        mth$_logzerneg:
          { Handle logaritme of a negative number }
          begin
            savmth_err := 32;
            savmth_sev := e_severe
          end;
        mth$_invargmat:
          { Handle invalide argument value, ex: ACOS( 2.0 ) }
          begin
            savmth_err := 33;
            savmth_sev := e_severe
          end;
        mth$_floovemat:
          { Handle floatting point overflow in math routine }
          begin
            savmth_err := 34;
            savmth_sev := e_severe
          end;
        mth$_floundmat:
          { Handle floatting underflow in mth conversion }
          begin
            savmth_err := 35;           { set the lisp error code }
            savmth_sev := e_severe      { and error severity }
          end
      otherwise
        stop_reg.typ := nullty;
        CONDITION_HANDLER := 0          { Return Error to Previous Handler }
      end
    end
*)

  end
  else
    CONDITION_HANDLER := 0              { Return Error to Previous Handler }
end CONDITION_HANDLER;


end.
{  * * * *  End of Lisp Exception Manager file  * * * *  }
