{
******************************************************************
*                                                                *
*                                                                *
*                                                                *
*                                                                *
*      * * *    L I S P    I n t e r p r e t e r    * * *        *
*                                                                *
*                                                                *
*            ***   LOAD and RESTORE MODULE   ***                 *
*                                                                *
*	by :                                                     *
*                                                                *
*	    P. Wolfers                                           *
*		c.n.r.s.                                         *
*		Laboratoire de Cristallographie                  *
*		B.P.  166 X   38042  Grenoble Cedex              *
*					FRANCE.                  *
*                                                                *
******************************************************************
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}


{
        *** modification(s) from major version ***


			----

		       nothing

			----

}
module LISP_DMP( Input, Output ); { input and output for user terminal }

{
	Module to save or restore a LISP environment.
}

%include 'LISPSRC:lisp_env';   { Get the LISP Environment Definitions }


type
  oid_ptr = ^oid_rec;

  oid_rec = record             { Object reference identifier record }
    oid_ide: integer;          { Identifier name (= integer) }
    oid_ref,                   { Unsolved identifier reference list head }
    oid_val: obj_ref;          { Identifier value }
    oid_prv,  oid_nxt,         { Links for undefined identifiers }
    oid_l, oid_r: oid_ptr
  end;



var

  oid_fundef,                  { First undefined identifier pointer }
  oid_lundef,                  { Last undefined identifier pointer }
  oid_hde: oid_ptr := nil;     { Identifier tree root (head) }




{  ****   Routines de manage the integer identifiers   ****  }


function OID_SEARCH( id: integer ): oid_ptr;
{ Search a specified integer identifier entry and create it if not found.
  Any new identifier is defined as not Lisp defined }
var
  p, q, r: oid_ptr;

begin { OID_SEARCH }
  p := nil;
  q := oid_hde;                { Start the search from the tree root }
  r := nil;
  while (q <> nil) and (p = nil) do
    with q^ do
      if oid_ide = id then     { If found }
        p := q
      else
      begin                    { else, follow the appropriate link }
        r := q;
        if id > oid_ide then q := oid_r
                        else q := oid_l
      end;

  { Now Create any new identifier }
  if p = nil then
  begin                        { Creates a new identifier }
    NEW( p );
    if oid_hde = nil then      { For the first one, init the id tree root }
      oid_hde := p
    else
      with r^ do
        if id > oid_ide then oid_r := p
                        else oid_l := p;
    with p^ do
    begin
      oid_ide := id;           { Set identifier number }
      oid_r   := nil;          { Set the right and left pointer }
      oid_l   := nil;
      oid_val := obj_empty;    { Set identifier in the undefined state }
      oid_ref := obj_nil;      { No reference }
      oid_prv := oid_lundef;   { Add the new identifier as the last in ... }
      oid_nxt := nil;          { The undefined identifier list }
      if oid_fundef = nil then oid_fundef := p;
      oid_lundef := p
    end
  end;
  OID_SEARCH := p
end OID_SEARCH;


[global]
function OID_REFERENCE( id: integer; obj: obj_ref; iflg: integer ): obj_ref;
const
  mdnam = 'IDEF';

var
  p:   oid_ptr;
  ob1: obj_ref;

begin
  if (iflg > 2) or (iflg < 0) then EXEC_ERROR( mdnam, 501, e_fatal );
  if (obj.typ <> doublety) and (obj.typ < atomety) then
    EXEC_ERROR( 'IDEF', 502, e_fatal );
  p := OID_SEARCH( id );
  with p^ do
    if invalid_flg in oid_val.flg.f then { Undefined symbol }
    begin { add this reference to the main reference }
      ob1 := oid_ref;          { Build the reference of user location }
      oid_ref := obj;
      case iflg of             { With the location attribute }
        0: oid_ref.flg.f := [];
        1: oid_ref.flg.f := [lrefpli_flg];
        2: oid_ref.flg.f := [lreffnc_flg];
      end
    end
    else
      ob1 := oid_val;
  OID_REFERENCE := ob1         { Return the reference or value for obj_ref }
end OID_REFERENCE;



procedure OID_DEFINITION( id: integer; val: obj_ref );
{ Set the integer identifier as Lisp defined }
var
  p:   oid_ptr;
  nob: obj_ref;

begin
  p := OID_SEARCH( id );
  with p^ do
  begin
    { Clear the invalid (undefined) flag and set the label value }
    oid_val := val;
    while oid_ref.typ <> nullty do
    begin
      with oid_ref do
      begin
        if typ = doublety then { Doublet use of reference }
          if lrefpli_flg in flg.f then
          begin { Cdr reference }
            nob := db^.cdr;
            db^.cdr := oid_val
          end
          else
          begin { Car reference }
            nob := db^.car;
            db^.car := oid_val
          end
        else
          if lreffnc_flg in flg.f then
          begin { FNCREF atom reference }
            nob := at^.fncref;
            at^.fncref := oid_val
          end
          else
          if lrefpli_flg in flg.f then
          begin { PLIST atom reference }
            nob := at^.plist;
            at^.plist := oid_val
          end
          else
          begin { VAL atom reference }
            nob := at^.val;
            at^.val := oid_val
          end
      end;
      oid_ref := nob
    end;
    { Take off the identifier from the undefined list }
    if oid_nxt <> nil then
      oid_nxt^.oid_prv := oid_prv;
    if oid_prv <> nil then
      oid_prv^.oid_nxt := oid_nxt;
    oid_val := val
  end
end OID_DEFINITION;


procedure OID_TREE_FREE( p: oid_ptr );
{ The OID_FREE( oid_hde ) call is used to free all oid_rec records }
begin
  if p <> nil then
  begin
    with p^ do
    begin
      OID_TREE_FREE( oid_l );
      OID_TREE_FREE( oid_r )
    end;
    DISPOSE( p )
  end
end OID_TREE_FREE;




[global]
function  F_ID_DEFINE( parml: obj_ref ): obj_ref;
{ Use : (ID_DEFINE <int_lab> <lisp_expr>) }
var
  id:   integer;
  valu: obj_ref;

begin
  id   := INTEVL( parml );
  valu := F_EVAL( NXT_PAR( parml ) );
  OID_DEFINITION( id, valu );
  F_ID_DEFINE := valu
end F_ID_DEFINE;



[global]
function  F_ID_REFER( parml: obj_ref ): obj_ref;
{ Use : (ID_REFER <int_lab> SYS$_BUILD_LIST (PLIST 'SYS$_BUILD_LIST)) -> the label value }
var
  id, iflg: integer;
  obj:      obj_ref;

begin
  id   := INTEVL( parml );
  obj  := F_EVAL( NXT_PAR( parml ) );
  iflg := INTEVLDEF( parml, 0 );
  if obj.typ <> doublety then EXEC_ERROR( 'IREF', 501, e_fatal );
  F_ID_REFER := OID_REFERENCE( id, obj, iflg )
end F_ID_REFER;



[global]
function F_ID_PURGE( parml: obj_ref ): obj_ref;
{ Purge all integer identifiers,
  counts (and lists when a list is given) the undefined labels,
  and then set to NIL all undefined locations. }

var
  lis, nob, res: obj_ref;

begin
  res := obj_zero;
  if oid_fundef <> nil then
  begin
    lis := GET_LIST( parml, false ); { NIL is allowed }
    while oid_fundef <> nil do
    with oid_fundef^ do
    begin
      if lis.typ = doublety then
      with lis.db^ do
      begin
        car.flg    := flg_def;
        car.typ    := intty;
        car.int    := oid_ide;
        lis := cdr
      end;
      while oid_ref.typ <> nullty do
      begin
        with oid_ref do
          if typ = doublety then { Doublet use of reference }
            if lrefpli_flg in flg.f then
            begin { Cdr reference }
              nob := db^.cdr;
              db^.cdr := obj_nil
            end
            else
            begin { Car reference }
              nob := db^.car;
              db^.car := obj_nil
            end
          else
            if lreffnc_flg in flg.f then
            begin { FNCREF atom reference }
              nob := at^.fncref;
              at^.fncref := obj_nil
            end
            else
            if lrefpli_flg in flg.f then
            begin { PLIST atom reference }
              nob := at^.plist;
              at^.plist := obj_nil
            end
            else
            begin { VAL atom reference }
              nob := at^.val;
              at^.val := obj_nil
            end;
        oid_ref := nob
      end;
      res.int := res.int + 1;
      oid_fundef := oid_nxt
    end
  end;
  OID_TREE_FREE( oid_hde );
  oid_hde := nil;
  oid_fundef := nil;
  oid_lundef := nil;
  F_ID_PURGE := res
end F_ID_PURGE;



[global]
procedure F_WRITE_AREA( parmlst: obj_ref );
var
  ch:     char;
  i, isz: integer;
  blk:    rec_ptr;
  obj:    obj_ref;

begin
  REC_EVL( parmlst, blk, isz ); { Get the memory address and block size }
  if parmlst.typ = nullty then
    ch := ' '
  else
    ch  := GET_CHAR( F_EVAL( NXT_PAR( parmlst ) ) ); { Get the macro character }
  if ch > ' ' then LST_PUT_CHAR( ch ); { Output specified macro character }
  LST_PUT_CHAR( ' ' );         { Output a space }
  LST_PUT_INT( isz, 0 );       { Output the size in byte }
  LST_EOLN;                    { Skip to next list }
  for i := 1 to isz do
  begin                        { Output each byte in hexadecimal form }
    LST_PUT_CHAR( ' ' );
    LST_PUT_INT( ORD( blk^.bf[i] ), 4, 16 ); { Write in Hexadecimal }
    if (i mod 16 = 0) or (i = isz) then LST_EOLN
  end
end F_WRITE_AREA;



[global]
function F_READ_AREA( parmlst: obj_ref ): obj_ref;
var
  i, isz:   integer;
  res, loc: obj_ref;

begin
  res := F_EVAL( NXT_PAR( parmlst ) ); { Get a specified area }
  if res.typ <> nullty then    { Area specified, get size }
  begin
    MEM_CHECK( res, false );   { Check for memory ref. }
    isz := INTEVL( parmlst );  { Get allocated size }
    SKIP_EOLN_AND_SPACE;
    i := INTVAL( IN_ATOM( 0, 10, true ) ); { Get the memory size in decimal }
    if isz > i then isz := i   { We read only isz byte(s) }
  end
  else
  begin
    SKIP_EOLN_AND_SPACE;
    isz := INTVAL( IN_ATOM( 0, 10, true ) ); { Get the read block size (in byte) }
    res := obj_nilp;
    res.mem := NEW_RECORD_ALLOC( 4 * ((isz + 3) div 4) )
  end;
  loc := res;
  i := 1;
  for i := 1 to isz do
  begin { Read each long word in hexadecimal form }
    SKIP_EOLN_AND_SPACE;
    loc.mem^.ub := INTVAL( IN_ATOM( 0, 16, true ) );
    loc.int := loc.int + 1
  end;
  F_READ_AREA := res
end F_READ_AREA;




end.
