{ Basic Environment for Memory Block Operations }
{
	P. Wolfers

	Laboratoire de Cristrallographie
	C.N.R.S. GRENOBLE
	B.P. 166 X  38042 GRENOBLE CEDEX
				FRANCE

}


const

  max_record = 2**16;           { Define the maximum size of a memory record }

  size_mptr = $wild_pointer"size;
  size_char = char"size;
  size_byte = byte"size;
  size_word = word_integer"size;
  size_inte = integer"size;
  size_sing = single"size;
  size_doub = double"size;

  algn_mptr = size_mptr;        { Must be correct for Cpas/CC environment }
  algn_char = size_char;
  algn_byte = size_byte;
  algn_word = size_word;
  algn_inte = size_inte;
  algn_sing = size_sing;
  algn_doub = size_doub;

  blk_max_io_buff  = 512;       { Size of a binary i/o buffer }

  max_mptr  = max_record div size_mptr;
  max_char  = max_record div size_char;
  max_byte  = max_record div size_byte;
  max_word  = max_record div size_word;
  max_inte  = max_record div size_inte;
  max_sing  = max_record div size_sing;
  max_doub  = max_record div size_doub;


type

  ubyte = [BYTE] 0..255;        { Unsigned byte integer }
  sbyte = [BYTE] -128..127;     { Signed byte integer   }
  uword = [WORD] 0..65535;      { Unsigned word integer }
  sword = [WORD] -32768..32767; { Signed word integer   }


  rec_ptr  = ^record_rec;       { Pointer of memory record }


  { Binary i/o buffer definition }
  blk_io_buff = packed array[1..blk_max_io_buff] of char;


  { Type of Block Objects Definitions }

  field_types = (
    blkt_pt,                    { Block pointer }
    blkt_ch,                    { Character }
    blkt_ub,                    { Unsigned byte integer }
    blkt_sb,                    { Signed byte integer }
    blkt_uw,                    { Unsigned word (16 bits) integer }
    blkt_sw,                    { Signed word (16 bits) integer }
    blkt_li,                    { Signed long word (32 bits) integer }
    blkt_fl,                    { Single floatting number (32 bits) }
    blkt_db,                    { Double floatting number (64 bits) }
    blkt_bf                     { Binary i/o buffer }
  );


  { Memory Record Definition }
  record_rec = record case field_types of
    blkt_pt:(at:         array[0..max_mptr-1] of rec_ptr);
    blkt_ch:(cht: packed array[0..max_char-1] of char);
    blkt_ub:(ubt: packed array[0..max_byte-1] of ubyte);
    blkt_sb:(sbt: packed array[0..max_byte-1] of sbyte);
    blkt_uw:(uwt: packed array[0..max_word-1] of uword);
    blkt_sw:(swt: packed array[0..max_word-1] of sword);
    blkt_li:(it:         array[0..max_inte-1] of integer);
    blkt_fl:(ft:         array[0..max_sing-1] of single);
    blkt_db:(gt:         array[0..max_doub-1] of double);
    blkt_bf:(bf:         blk_io_buff)
  end;




{************************************************************}
{ **********  RECORD Allocation and De-allocation ********** }
{************************************************************}


[ external 'PAS__NEW']
function NEW_RECORD_ALLOC( iv: integer ): $wild_pointer; external;

[ external 'PAS__DISPOSE']
procedure FREE_RECORD_ALLOC( var p: $wild_pointer ); external;





         {*******************************}
         { *** BASICDEF$BLK routines *** }
         {*******************************}



function BLK_PT( r: rec_ptr; ad: integer ): rec_ptr;
begin
  BLK_PT := r^.at[ad]
end BLK_PT;


function BLK_CH( r: rec_ptr; ad: integer ): char;
begin
  BLK_CH := r^.cht[ad]
end BLK_CH;


function BLK_UB( r: rec_ptr; ad: integer ): integer;
begin
  BLK_UB := r^.ubt[ad]
end BLK_UB;


function BLK_SB( r: rec_ptr; ad: integer ): integer;
begin
  BLK_SB := r^.sbt[ad]
end BLK_SB;


function BLK_UW( r: rec_ptr; ad: integer ): integer;
begin
  BLK_UW := r^.uwt[ad]
end BLK_UW;


function BLK_SW( r: rec_ptr; ad: integer ): integer;
begin
  BLK_SW := r^.swt[ad]
end BLK_SW;


function BLK_LI( r: rec_ptr; ad: integer ): integer;
begin
  BLK_LI := r^.it[ad]
end BLK_LI;


function BLK_FL( r: rec_ptr; ad: integer ): single;
begin
  BLK_FL := r^.ft[ad]
end BLK_FL;


function BLK_DB( r: rec_ptr; ad: integer ): double;
begin
  BLK_DB := r^.gt[ad]
end BLK_DB;


