{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*     * * *    L I S P    D r a w i n g   I n t e r f a c e   * * *     *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}



{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}




module LISP_ALFR( Input, Output );     { Input and Output for user terminal }


%include 'lispsrc:lisp_env';           { Get the LISP Environment Definitions }


const
  gbc_factor = 20;                     { Garbage Collector call factor }
                                       { must be modified with possible memory
                                         requirement }

var
  gbc_count: [static] integer := 0;    { count for garbage collector }

  oblist,
  oblast: obj_ref;                     { used to build the oblist }

  debug: boolean := false;



{ **** garbage collector procedures **** }



procedure IDENT_MARKER( id: ident_ptr ); forward;
{ Forward definition of the Identifier Marker Routine }


procedure OBJECT_MARKER( ob: obj_ref );
{ Local Recursive Procedure to Mark Object as Used }
var
  i:   integer;
  rf:  rfd_ptr;
  ob1: obj_ref;

begin
  ob1.flg   := flg_def;
  ob1.typ   := atomety;
  case ob.typ of
    doublety:
      with ob.db^ do
      if not (refered_flg in cdr.flg.f) then
      begin { stop scan on already exa. doublet }
        cdr.flg.f := cdr.flg.f + [refered_flg];  { set the used mark }
        OBJECT_MARKER( car );
        OBJECT_MARKER( cdr )
      end;

    strty: if ob.nam <> nil then
             ob.nam^.used := true;   { Set as a Used String }

    lextyp: if ob.lexd <> nil then
            with ob.lexd^ do
              if tree <> nil then IDENT_MARKER( tree );

    vectortyp:
      if ob.vect <> nil then
      with ob.vect^ do
        if not vect_used then          { Do not do twice }
        begin
          vect_used := true;           { Set the Used Mark }
          for i := 0 to vect_size-1 do
            OBJECT_MARKER( vect_tab[i] )
        end;

    mrdty: { Record Type Descriptor }
      if ob.mrd <> nil then
      with ob.mrd^ do
      begin
        ob1.at := mrd_atm;             { Set the type atom identifier }
        OBJECT_MARKER( ob1 );          { To preserve it }
        rf := mrd_rfdl;
        while rf <> nil do
        with rf^ do
        begin
          ob1.at := rfd_atm;           { set the field atom identifier }
          OBJECT_MARKER( ob1 );        { to preserve it from freeing }
          rf := rfd_nxt
        end
      end;


  otherwise

    if ob.typ >= atomety then
    if ob.at <> nil then
      with ob.at^ do
      if not (refered_flg in ats.flg.f) then { stop scan on already exa. atom }
      begin
        ats.flg.f := ats.flg.f + [refered_flg];  { set the used mark }
        if ats.nam <> nil then
          ats.nam^.used := true;     { Set name as used }
        OBJECT_MARKER( val );
        OBJECT_MARKER( plist );
        OBJECT_MARKER( fncref )
      end;

    { else nothing to do }

  end
end OBJECT_MARKER;



{ local recursive procedure to mark all used object in a tree }
procedure IDENT_MARKER { ( id: ident_ptr ) was forward };
begin
  with id^ do
  begin
    if left <> nil then  IDENT_MARKER( left );
    if right <> nil then IDENT_MARKER( right );
    if atom.typ >= atomety then        { for true atom only }
      OBJECT_MARKER( atom )
  end
end IDENT_MARKER;



procedure FREE_REC_DESCR;
var
  flg: boolean;
  mr0, mr1, mr2: mrd_ptr;
  rf0, rf1: rfd_ptr;

begin
  mr2 := nil;
  mr0 := mrd_alloc;             { Start from the Record type Head list }
  while mr0 <> nil do           { Loop on all record tyupe definitions }
  begin
    with mr0^ do
    begin
      mr1 := mrd_nxt;
      rf0 := mrd_rfdl;          { Get the related Field List Head }
      flg := (refered_flg in mrd_atm^.ats.flg.f) { Check for type Used }
    end;
    if flg then
      mr2 := mr1 { mr2 is set as the next valid descriptor pointer }
    else
    begin { Free this Record Type Descriptors }
      while rf0 <> nil do   
      begin { Free all Field Descriptors }
        with rf0^ do
        begin
          rf1 := rfd_nxt;
          with rfd_atm^ do
            if (val.typ = rfdty) and (val.rfd = rf0) then
              val := obj_nil;   { Destroy the field atom link }
        end;
        DISPOSE( rf0 );
        rf0 := rf1
      end;
      { Reset the correct link of Descriptors }
      if mr2 = nil then mrd_alloc := mr1
                   else mr2^.mrd_nxt := mr1;
      DISPOSE( mr0 );
    end;
    mr0 := mr1
  end
end FREE_REC_DESCR;



procedure FREE_UNUSED_VECTOR;
{ Free all Unreferenced Vectors }
var
  prev, pcur, pnxt: vect_ptr;

begin
  prev := nil;                  { At begining, No Previous Vector }
  pcur := vect_hde;             { Get the Allocated Vector List Head }
  while pcur <> nil do          { Loop one all Allocated Vector }
  begin
    pnxt := pcur^.vect_lnk;     { Get the next vector pointer }
    if pcur^.vect_used then     { For the Unused ... }
    begin
      pcur^.vect_used := false; { Reset for next Garbage Collector Call }
      prev := pcur              { This Used Vector becomes the previous }
    end
    else
    begin                       { ... Unused, we must Free it }
      { Put off the Unused Vector from the ALlocated Vector List }
      if prev = nil then vect_hde := pnxt
                    else prev^.vect_lnk := pnxt;
      DISPOSE( pcur )           { Free the Vector Allocation }
    end;
    pcur := pnxt                { Loop to Next String }
  end
end FREE_UNUSED_VECTOR;



procedure FREE_UNUSED_STRING;
{ Free all Unreferenced Strings }
var
  prev, pcur, pnxt: lisp_s_ptr;

begin
  prev := nil;                  { At begining, No Previous string }
  pcur := strg_hde;             { Get the Allocated String List Head }
  while pcur <> nil do          { Loop one all Allocated String }
  begin
    pnxt := pcur^.lnknxt;       { Get the next string pointer }
    if pcur^.used then
    begin                       { For the Used String ... }
      pcur^.used := false;      { For next Call of the Garbage Collector }
      prev := pcur              { This Used String becomes the previous one }
    end
    else
    begin                       { For the Unused string, we must Free it }
      { Put off the Unused string from the ALlocated String List }
      if prev = nil then strg_hde := pnxt
                    else prev^.lnknxt := pnxt;
      DISPOSE( pcur );          { Free the String allocation }
    end;
    pcur := pnxt                { Loop to Next String }
  end
end FREE_UNUSED_STRING;



[global]
procedure GARBAGE_COLLECTOR;
var
  ch: char;
  i: integer;
  plex: lex_ptr;
  ppck: pck_ptr;

begin { GARBAGE_COLLECTOR }
  { **** Save the Macro Objects **** }
  IDENT_MARKER( macro_idlst );   { Scan Macro Symbol }
  plex := top_lexd;              { Scan all current lex }
  while plex <> nil do
  with plex^ do
  begin
    if tree <> nil then IDENT_MARKER( tree );
    plex := prvlex
  end;
  { **** Save the Macro Character Specifications **** }
  for ch := '!' to '~' do
  begin
    OBJECT_MARKER( mac_tab[ch] );
    OBJECT_MARKER( alt_mtb[ch] )
  end;

  { **** Save Stack call Objects Definitions **** }
  OBJECT_MARKER( fnc_list_save );

  { **** Save The Main Statement Definitions **** }
  OBJECT_MARKER( main_statement );

  { **** freeing step **** }
  { Here :
     each used string has s_tmp true,
     each used atom has a refered_flg in ats.flg.f,
     and each used doublet has a refered_flg in cdr.flg.f . }

  dbl_free := obj_nil;  { do the free lists empty }
  atm_free := obj_nil;

  ppck := pck_alloc;    { Scan on all Allocated Packet }

  FREE_REC_DESCR;       { Scan Record Descriptor and Free All Unused Ones }

  { Loop on all Packet of Atoms or Doublets }
  while ppck <> nil do
  with ppck^ do
  begin
    if pck_atomflg then            { Packet of atom }
      for i := 1 to pckatm do
      with pck_atm[i] do
      if not (refered_flg in ats.flg.f) then { Free this atome }
      begin
        atm_free.flg := flg_def;   { Clear any trailing unused flag }
        val := atm_free;
        atm_free.typ := atomety;
        atm_free.at := pck_atm[i]"address
      end
      else
        ats.flg.f := ats.flg.f - [refered_flg] { clear the used flag }
    else                           { Packet of doublet }
      for i := 1 to pckdbl do
      with pck_dbl[i] do
      if not (refered_flg in cdr.flg.f) then { Free this doublet }
      begin
        dbl_free.flg := flg_def;
        cdr := dbl_free;
        dbl_free.typ := doublety;
        dbl_free.db := pck_dbl[i]"address
      end
      else
        cdr.flg.f := cdr.flg.f - [refered_flg]; { Clear the used flag }
    ppck := pck_nxt
  end;
  FREE_UNUSED_VECTOR;              { Free all Unreferenced Vectors }
  FREE_UNUSED_STRING;              { Free all Unreferenced Strings }
  gbc_count := 0                   { Reset Garbage Count }
end GARBAGE_COLLECTOR;




{ **** Allocation Deallocation of Memory Procedures **** }



[global]
procedure PACKET_ALLOC( atmflg: boolean );
var
  i: integer;
  p: pck_ptr;
  ob: obj_ref;

begin
  gbc_count := gbc_count + 1;
  NEW( p );
  with p^ do
  begin
    pck_nxt := pck_alloc;  { link to previously allocated block }
    pck_atomflg := atmflg; { set the nature of the block }
    { built the free list }
    if atmflg then
    begin
      ob := atm_free;
      for i := pckatm downto 1 do
      begin
        pck_atm[i].ats := obj_nil;
        pck_atm[i].val := ob;
        ob.typ := atomety; ob.flg := flg_def;
        ob.at := pck_atm[i]"address
      end;
      atm_free := ob
    end
    else
    begin
      ob := dbl_free;
      for i := pckdbl downto 1 do
      begin
        pck_dbl[i].cdr := ob;
        ob.typ := doublety; ob.flg := flg_def;
        ob.db := pck_dbl[i]"address
      end;
      dbl_free := ob
    end
  end;
  pck_alloc := p
end PACKET_ALLOC;


[global]
function DOUBLET_ALLOC: obj_ref;
var
  p: obj_ref;

begin
  if dbl_free.typ = nullty then
  begin
    { if gbc_count >= gbc_factor then GARBAGE_COLLECTOR; }
    { if not enough then }
    if dbl_free.typ = nullty then PACKET_ALLOC( false )
  end;
  p := dbl_free; dbl_free := p.db^.cdr;
  with p.db^ do
  begin
    cdr := obj_nil; car := obj_nil
  end;
  DOUBLET_ALLOC := p
end DOUBLET_ALLOC;


[global]
function ATOME_ALLOC: obj_ref;
var
  p: obj_ref;

begin
  if atm_free.typ = nullty then
  begin
    { if gbc_count >= gbc_factor then GARBAGE_COLLECTOR; }
    { if not enough then }
    if atm_free.typ = nullty then PACKET_ALLOC( true )
  end;
  p := atm_free; atm_free := p.at^.val;
  with p.at^ do
  begin
    ats := obj_nil;
    val := obj_nil;
    plist := obj_nil;
    fncref := obj_nil
  end;
  ATOME_ALLOC := p
end ATOME_ALLOC;


[global]
function LISP_STRING_ALLOC( len: integer ): lisp_s_ptr;
var
  r: lisp_s_ptr;

begin
  r := nil;
  if len > 0 then
  begin
    NEW( r, len );
    if r <> nil then
    with r^ do
    begin
      lnknxt   := strg_hde;    { Link the lisp_string to string all. list }
      strg_hde := r;
      used     := false;       { Prepare for Garbage collector }
      length   := 0            { Set as an Empty string }
    end
  end;
  LISP_STRING_ALLOC := r
end LISP_STRING_ALLOC;


[global]
function NEW_LISP_STRINGV( in_var str: packed array[cap: integer] of char;
                                  len: integer := 0 ): lisp_s_ptr;
var
  r: lisp_s_ptr;

begin
  if len <= 0 then len := cap;
  if len > 0 then
  begin
    r := LISP_STRING_ALLOC( len );
    if r <> nil then
    with r^ do
    begin
      length   := len;         { Set as an Empty string }
      for i := 1 to len do  body[i] := str[i]
    end
  end
  else r := nil;
  NEW_LISP_STRINGV := r
end NEW_LISP_STRINGV;



[global]
function VECTOR_ALLOC( len: integer; nil_ini: boolean ): obj_ref;
var
  r: obj_ref;

begin
  r.flg := flg_def;
  r.typ := vectortyp;
  NEW( r.vect, len );
  if r.vect <> nil then
  with r.vect^ do
  begin
    vect_used  := false;       { Prepare for Garbage collector }
    vect_lnk   := vect_hde;    { Link the Allocated Vector List }
    vect_hde   := r.vect;
    if nil_ini then
      for i := 0 to vect_size-1 do
        vect_tab[i] := obj_nil
  end;
  VECTOR_ALLOC := r
end VECTOR_ALLOC;


[global]
procedure OBJECT_FREE( obj: obj_ref );
begin
  obj.flg := flg_def;
  with obj do
  case typ of
    doublety:
      with obj.db^ do
      begin
        car := obj_nil;
        cdr := dbl_free;
        dbl_free := obj
      end;

    atomety:
      with obj.at^ do
      begin
        ats    := obj_nil;
        plist  := obj_nil;
        fncref := obj_nil;
        val    := atm_free;
        atm_free       := obj
      end;

  otherwise
    { no allocation to do }
  end
end OBJECT_FREE;



[global]
procedure FREE_LIST_TREE( lob: obj_ref );
begin
  if lob.typ = doublety then
  with lob.db^ do
  begin
    FREE_LIST_TREE( car );
    FREE_LIST_TREE( cdr );
    cdr := dbl_free;
    dbl_free := lob
  end
end FREE_LIST_TREE;



     {*******************************************}
     { IDENTIFIER group functions and procedures }
     {*******************************************}


function MACRO_IDENT_SEARCH( in_var nam:     packed array[cap:integer] of char;
                                    len:     integer := 0 ): ident_ptr;
var
  i: integer;
  p: ident_ptr;

begin
  if len <= 0 then len := cap;
  i := -1;
  p := macro_idlst;
  while (i <> 0) and (p <> nil) do
  with p^ do
  begin
    i := STR_MATCH( name^.body, name^.length, nam, len );
    if i <> 0 then p := p^.left
  end;
  MACRO_IDENT_SEARCH := p
end MACRO_IDENT_SEARCH;


[global]
function LEVEL_IDENT_SEARCH( in_var nam:     packed array[cap:integer] of char;
                                    len:     integer := 0;
                                bcreate: boolean := false ): ident_ptr;
{ Search the nam Identifier in the Allocation Identifier Display Tree.
  if bcreate is true, then the Location for Add the Unfounded identifier
  is Saved. }
var
  p:     ident_ptr;
  i:     integer;
  found: boolean;

begin { LEVEL_IDENT_SEARCH }
  if len <= 0 then len := cap;
  i := 0;
  if debug then
  begin
    WRITELN;
    WRITELN( ' Debug search in lex ', last_lexd^.lex:4, ' for ', nam:len )
  end;
  p := last_lexd^.tree;
  if bcreate then sy_found := nil;
  found := false;
  while not found and (p <> nil) do
  with p^ do
  begin
    if debug then
    begin
      WRITELN( ' Debug id compare ', name^.body:name^.length,
               ' with ', nam:len )
    end;
    if bcreate then sy_found := p;  { Set to link a new identifier }
    i := STR_MATCH( name^.body, name^.length, nam, len );
    if i = 0 then found := true
             else if i > 0 then p := p^.left
                           else p := p^.right
  end;
  if bcreate then sy_found_test := i;
  LEVEL_IDENT_SEARCH := p
end LEVEL_IDENT_SEARCH;
 

[global]
function IDENT_SEARCH( in_var nam:  packed array[cap:integer] of char;
                                    len:     integer := 0;
                                    bcreate: boolean := false ): ident_ptr;
{ Search the nam Identifier in the Complete Identifier Display Tree.
  if bcreate is true, then the Location for Add the Unfounded identifier
  is Saved. }
var
  id: ident_ptr;

begin { IDENT_SEARCH }
  if macro_dcl_flag then id := nil
                    else id := MACRO_IDENT_SEARCH( nam, len );
  if id = nil then
  begin
    if macro_dcl_flag then last_lexd := reserved_lexd
                      else last_lexd := top_lexd;
    while (last_lexd <> nil) and (id = nil) do
    begin
      id := LEVEL_IDENT_SEARCH( nam, len, bcreate and (all_lexd = last_lexd) );
      if id = nil then { if not found we can continue to search }
        if last_lexd = basreserved_lexd then last_lexd := nil
        else
          if last_lexd = bas_lexd then last_lexd := reserved_lexd
          else last_lexd := last_lexd^.prvlex
    end
  end;
  IDENT_SEARCH := id
end IDENT_SEARCH; 

 


[global]
procedure IDENT_NEW_LINK( p: ident_ptr );
{ To link the Specified Identifier the Current Display Level Tree. }
{ the values of sy_found and sy_found_test are used }
begin { IDENT_NEW_LINK }
  if debug then
  begin
    WRITELN( ' Debug include in lex the new id. ', all_lexd^.lex:4 );
  end;
  if macro_dcl_flag then
  with p^ do
  begin
    nxt   := macro_idlst;
    macro_idlst := p;
    left  := macro_idlst;
    right := nil;
  end
  else
  with all_lexd^ do
  begin
    if sy_found = nil then
      tree := p
    else
    begin
      if sy_found_test > 0 then
        sy_found^.left := p
      else
        sy_found^.right := p;
      lastid^.nxt := p
    end;
    lastid := p
  end;
  with p^ do
  begin
    left := nil; right := nil; nxt := nil;
    lex := all_lexd^.lex
  end;
  sy_found := p
end IDENT_NEW_LINK;



[global]
function ATOM_SEARCH( in_var str: packed array[cap: integer] of char;
                             len: integer := 0 ): obj_ref;
var
  id: ident_ptr;
  i: integer;
  sv_top, sv_bas: lex_ptr;

begin
  if len <= 0 then len := cap;
  sv_top := nil;
  sv_bas := nil;
  if ident_dcl_flag then
  begin { New identifier declaration mode: do not search in lower lex }
    sv_top := top_lexd; top_lexd := all_lexd;
    sv_bas := bas_lexd; bas_lexd := all_lexd
  end;
  id := IDENT_SEARCH( str, len, true );  { Search in the Known Symbol Tree }
  if ident_dcl_flag then
  begin
    top_lexd := sv_top; bas_lexd := sv_bas
  end;
  if id = nil then
  begin { New Atome }
    und_atom.at^.val := obj_true;
    NEW( id ); { Create the NEW Identifier Record }
    id^.name := NEW_LISP_STRINGV( str, len );
    IDENT_NEW_LINK( id );          { Attach new symbol to the tree }
    id^.atom := ATOME_ALLOC;
    with id^.atom.at^ do
    begin
      ats.typ := strty;            { set the atome name string type }
      ats.nam := id^.name          { set the atom name }
    end;
    with lex_own_atm.at^ do
    begin
      val.flg    := flg_def;
      val.typ    := lextyp;
      val.lexd   := all_lexd
    end;
  end
  else
  with lex_own_atm.at^ do
  begin
    val.flg    := flg_def;
    val.typ    := lextyp;
    val.lexd   := last_lexd;
    und_atom.at^.val := obj_nil
  end;
  { the object is now defined }
  ATOM_SEARCH := id^.atom { get the previous pointer definition }
end ATOM_SEARCH;



[global]
procedure ACTIVATE_LEX( list: obj_ref );
var
   flg1, flg2: boolean;
   ob:  obj_ref;

begin
  ob   := F_EVAL( NXT_PAR( list ) );
  flg1 := GET_EVLFLAG( list );
  flg2 := GET_EVLFLAG( list );
  if ob.typ = lextyp then
  begin
    curr_lex := curr_lex + 1;
    ob.lexd^.prvlex := curr_lexd;  { links with the previously activate lex }
    curr_lexd := ob.lexd;
    if not flg2 then all_lexd  := ob.lexd;
    top_lexd  := ob.lexd;
    if flg1 then bas_lexd := ob.lexd
  end
  else EXEC_ERROR( 'ALEX', 101, e_severe )
end ACTIVATE_LEX;



[global]
function NEW_LEX( ow: obj_ref ): obj_ref;
var
   p: lex_ptr;
   r: obj_ref;

begin
  curr_lex := curr_lex + 1;
  NEW( p );
  with p^ do
  begin
    prvlex := curr_lexd;
    lex    := curr_lex;
    lastid := nil;
    tree   := nil;
    owner  := ow
  end;
  curr_lexd := p;
  all_lexd  := p;
  top_lexd  := p;
  r.flg     := flg_def;
  r.typ     := lextyp;
  r.lexd    := p;
  NEW_LEX := r
end NEW_LEX;



{ local recursive procedure to perform a freeing of all a lex level }
procedure FREE_LEX_TREE( id: ident_ptr );
begin
  with id^ do
  begin
    if left <> nil then FREE_LEX_TREE( left );
    if right <> nil then FREE_LEX_TREE( right )
  end;
  DISPOSE( id )
end FREE_LEX_TREE;


[global]
procedure DEACTIVATE_LEX;
var p: lex_ptr;
begin
  if curr_lex > 1 then
  begin
    p := curr_lexd;
    curr_lexd := p^.prvlex;
    curr_lex  := curr_lexd^.lex;
    top_lexd  := curr_lexd;
    if bas_lexd = p then bas_lexd := curr_lexd;
    if all_lexd = p then all_lexd := curr_lexd;
    if reserved_lexd    = curr_lexd then
      reserved_lexd    := lisp_base_lexd;
    if basreserved_lexd = curr_lexd then
      basreserved_lexd := lisp_base_lexd;
    last_lexd := nil
  end
end DEACTIVATE_LEX;


[global]
procedure FREE_LEX;
var p: lex_ptr;
begin
  if curr_lex > 1 then
  begin
    p := curr_lexd;
    curr_lexd := p^.prvlex;
    curr_lex  := curr_lexd^.lex;
    top_lexd  := curr_lexd;
    if bas_lexd = p then bas_lexd := curr_lexd;
    if all_lexd = p then all_lexd := curr_lexd;
    if reserved_lexd    = bas_lexd then
      reserved_lexd    := bas_lexd^.prvlex;
    if basreserved_lexd = bas_lexd then
      basreserved_lexd := bas_lexd^.prvlex;
    last_lexd := nil;
    with p^ do
       if tree <> nil then
        FREE_LEX_TREE( tree );  { free all identifier in the tree }
    DISPOSE( p )
  end
end FREE_LEX;


[global]
procedure F_SET_LEX( ll: obj_ref );
var
  top, base, alloc, reserved, basreserved: integer;
  p: lex_ptr;

begin
  { defaulted to actual value }
  top          := INTEVLDEF( ll, top_lexd^.lex );
  base         := INTEVLDEF( ll, bas_lexd^.lex );
  alloc        := INTEVLDEF( ll, all_lexd^.lex );
  reserved     := INTEVLDEF( ll, reserved_lexd^.lex );
  basreserved  := INTEVLDEF( ll, basreserved_lexd^.lex );
  cmp_base_lex := INTEVLDEF( ll, basreserved_lexd^.lex );
  { verify and set into correct range each parameter }
  if top > curr_lex then top := curr_lex
  else if top < 1 then top := 1;
  if base > top then base := top
  else if base < 1 then base := 1;
  if alloc > top then alloc := top
  else if alloc < base then alloc := base;
  if reserved < 0 then reserved := 0
  else if reserved >= alloc then reserved := alloc - 1;
  if basreserved < 0 then basreserved := 0
  else if basreserved > reserved then basreserved := reserved;
  { look for top lex }
  p := curr_lexd;
  while p^.lex > top do  p := p^.prvlex;
  top_lexd := p;
  { look for alloc }
  while p^.lex > alloc do p := p^.prvlex;
  all_lexd := p;
  while p <> nil do
  with p^ do
  begin
    if lex = reserved then reserved_lexd := p;
    if lex = basreserved then basreserved_lexd := p;
    if lex = base then bas_lexd := p;
    if lex = cmp_base_lex then cmp_base_lexd := p;
    p := prvlex
  end
end F_SET_LEX;



{ ******************************************* }
{ *                                         * }
{ *      Initialization    functions        * }
{ *                                         * }
{ ******************************************* }


[global]
procedure EXPORT_IDENTIFIER( ll: obj_ref );
var
  flg: boolean;
  id: ident_ptr;
  obj: obj_ref;

begin
  flg := GET_EVLFLAG( ll );        { get the value flag }
  ll := GET_LIST( ll, false );     { get the specification list }
  last_lexd := top_lexd;           { set the top lex as unique lex }
  all_lexd := top_lexd;
  while ll.typ = doublety do
  begin
    { get one atome }
    obj := GET_ATOM( NXT_PAR( ll ), true );
    { locate the identifier in the lex }
    with obj.at^.ats.nam^ do
    id := LEVEL_IDENT_SEARCH( body, length, true );
    if id = nil then
    begin
      NEW( id );
      id^.name := obj.at^.ats.nam;
      if flg then id^.atom := NXT_PAR( ll )
             else id^.atom := obj;
      IDENT_NEW_LINK( id )
    end
    else EXEC_ERROR( 'EXID', 1051, e_severe )
  end
end EXPORT_IDENTIFIER;


function FNC_GETOBJ( exp: obj_ref ): obj_ref;
var
  res: obj_ref;

begin
  case exp.typ of
    nullty: res := F_READ;
    truety: res := ALG_READ;
  otherwise
    res := F_EVAL( exp )
  end                   ;
  FNC_GETOBJ := res
end FNC_GETOBJ;


[global]
function CREATE_NEW_IDENT( ll: obj_ref ): obj_ref;
var
  lex: integer;
  svall_lexd, svtop_lexd, svbas_lexd: lex_ptr;
  rdfnc, obfl, res: obj_ref;

{ call forme :
  (SYS_CALL 15 <rdexp> <lex_to_use> [ <Flg> ] )
     <rdexp> is a get symbol expression : () => (READ)
                                          T  => (ALG_READ)
                                          Lisp Expression => (EVAL <rdexp>),

     <lex_to_use> Lex to use : A Given lex   => The lex is used to create any new identifier (lex value).
                                    NIL      => (default) the current lex is used,
                                    T        => A lex can be specified in the input stream.
                                <lex_number> => use the given lex number,
                                    ""       => (or other string or char) The macro lex list,
                                   other     => the used lex is the current lex.     

     <Flg> () or (logically false)           => Normal lex mode (all lex as set by SYS_CALL 11 are used),
           T  or (logically true) (default)  => Declaration Lex mode (only current and reserved search).

}
begin
  rdfnc := F_EVAL( NXT_PAR( ll ) );    { get the read expression }
  obfl   := F_EVAL( NXT_PAR( ll ) );   { get the lex to use when specified }
  if ll.typ = doublety then  { get the not declare flag when specified }
    ident_dcl_flag := not GET_EVLFLAG( ll )
  else ident_dcl_flag := true;         { set the default mode to declare }
  macro_dcl_flag := false;
  case obfl.typ of
    lextyp: { when a lex object related lex is specified }
      begin
        svall_lexd := all_lexd;        { save current lex context } 
        svtop_lexd := top_lexd;
        svbas_lexd := bas_lexd;
        curr_lex := curr_lex + 1;
        obfl.lexd^.prvlex := curr_lexd;{ links with the previously activate lex }
        curr_lexd := obfl.lexd;        { the identifeir search is restricted to given lex }
        if ident_dcl_flag then
          bas_lexd := curr_lexd;       { set the appropriate lex mode }
        all_lexd  := curr_lexd;
        top_lexd  := curr_lexd;
        res := FNC_GETOBJ( rdfnc );
        curr_lex  := curr_lex - 1;
        all_lexd  := svall_lexd;       { restore the initial lex context }
        top_lexd  := svtop_lexd;
        bas_lexd  := svbas_lexd;
        curr_lexd := curr_lexd^.prvlex
      end;

    charty, strty:
      begin
        macro_dcl_flag := true;
        ident_dcl_flag := false;
        res := FNC_GETOBJ( rdfnc );
        macro_dcl_flag := false
      end;

    intty:
      begin { Integer lex specified }
        res := obfl; obfl := obj_true
      end;

  otherwise
    res := FNC_GETOBJ( rdfnc );    { else Read the atom in the current context }
  end;

  { when the specified lex parameter has the T value }
  if (obfl.typ = truety) and (res.typ = intty) then
  begin   { accept a source lex specification }
    lex := INTVAL( res );          { convert to lex specification }
    svall_lexd := all_lexd;
    svtop_lexd := top_lexd;
    svbas_lexd := bas_lexd;
    all_lexd   := top_lexd;
    if lex >= 0 then
      lex := cmp_base_lex + lex    { Absolute lex }
    else
      lex := all_lexd^.lex - lex;  { Relative lex }
    if lex <= cmp_base_lex then lex := cmp_base_lex 
    else if lex > svall_lexd^.lex then lex := svall_lexd^.lex;
    while (all_lexd <> bas_lexd) and (all_lexd^.lex <> lex) do
      all_lexd := all_lexd^.prvlex;
    if all_lexd^.lex = lex then begin
                                  top_lexd := all_lexd;
                                  bas_lexd := all_lexd
                                end
                           else begin
                                  all_lexd := svall_lexd;
                                  top_lexd := svall_lexd;
                                  bas_lexd := svall_lexd
                                end;
    res := FNC_GETOBJ( rdfnc );    { get the identifier and create it }
    all_lexd := svall_lexd;        { restore original top lex }
    top_lexd := svtop_lexd;
    bas_lexd := svbas_lexd
  end;

  ident_dcl_flag := false;         { clear the create identifier mode }
  CREATE_NEW_IDENT := res
end CREATE_NEW_IDENT;



[global]
procedure FREE_MACRO_SYMBOL( ll: obj_ref );
var
  fnd: boolean;
  p0, p1: ident_ptr;
  ob: obj_ref;

begin
  ob := GET_ATOM( F_EVAL( NXT_PAR( ll ) ), true );
  p0 := nil;
  p1 := macro_idlst;
  fnd := false;
  while not fnd and (p1 <> nil) do
  begin
    fnd := (p1^.atom.at = ob.at);
    p0  := p1;
    if not fnd then p1 := p1^.left
  end;
  if fnd then
  begin
    { suppress the macro symbol from the macro list }
    if p0 = nil then macro_idlst := p1^.left
                else p0^.left    := p1^.left;
    OBJECT_FREE( p1^.atom ); { free the atom }
    DISPOSE( p1 )            { free the related identifier record }
  end
end FREE_MACRO_SYMBOL;



PROCEDURE ADD_ELEM_OBLIST( id: ident_ptr );
var
  ob, obj: obj_ref;

begin
  with id^ do
  begin
    if left  <> nil then ADD_ELEM_OBLIST( left );
    if atom.typ >= atomety then
      { for true atom set the atom in the oblist }
      obj := atom
    else  { else ... }
    begin { ... set the string identifier in oblist }
      obj.flg := flg_def;
      obj.typ := strty;
      obj.nam := name;
    end;
    ob := F_CONS( obj, obj_nil );
    if oblist.typ = nullty then
      oblist := ob
    else
      oblast.db^.cdr := ob;
    oblast := ob;
    if right <> nil then ADD_ELEM_OBLIST( right )
  end
end ADD_ELEM_OBLIST;



function BUILD_OBLIST( id: ident_ptr ): obj_ref;
begin
  oblist := obj_nil;
  if id <> nil then ADD_ELEM_OBLIST( id );
  BUILD_OBLIST := oblist
end BUILD_OBLIST;



[global]
function F_OBLIST( parml: obj_ref ): obj_ref;
var
  plex: lex_ptr;
  res, ob, ob1: obj_ref;

begin { F_OBLIST }
  res := obj_nil;
  ob := F_EVAL( NXT_PAR( parml ) ); { get the lex specification }
  case ob.typ of
    lextyp:      res := BUILD_OBLIST( ob.lexd^.tree );

    intty, sflty, flty, strty:
                 begin { with a lex number specification }
                   ob.int := INTVAL( ob );
                   if ob.int < 0 then res := BUILD_OBLIST( reserved_lexd^.tree )
                   else
                   if ob.int = 0 then res := BUILD_OBLIST( top_lexd^.tree )
                   else
                   begin
                     if ob.int > curr_lex then ob.int := curr_lex;
                     plex := curr_lexd;
                     while plex^.lex > ob.int do plex := plex^.prvlex;
                     res := BUILD_OBLIST( plex^.tree )
                   end
                 end;

    truety:      begin { all defined lex to scan }
                   plex := curr_lexd;
                   ob := obj_nil;
                   while plex <> nil do
                   begin
                     ob1 := F_CONS( BUILD_OBLIST( plex^.tree ), obj_nil );
                     if ob.typ = nullty then
                       res := ob1
                     else
                       ob.db^.cdr := ob1;
                     ob := ob1;
                     plex := plex^.prvlex;
                   end
                 end;

  otherwise { top lex only }
    res := BUILD_OBLIST( top_lexd^.tree )
  end;
  F_OBLIST := res  
end F_OBLIST;



end.
