{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*            ***    LISP  OPERATING SYSTEM  INTERFACE   ***             *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}

{
        *** modification(s) from major version ***


			----

		       nothing

			----

}

module LISP__SYSTEM;


%include 'lispsrc:lisp_env';   { Get the LISP Environment Definitions }



[global]
function LISP$_SYSTEM( id: integer; parm_lst: obj_ref ): obj_ref;
const
  mdnam = 'SYST';

var
  f:      flags_file;
  i:      integer;
  s1, s2: string( 255 );
  ob, re: obj_ref;

begin
  re := obj_nil;
  case id of
    1: { *** Get environment symbol (by getenv) *** }
      begin
        GET_STR( s2, parm_lst, '' );
        i := GET_LOGICAL( s1, s2 );           { Get the logical name }
        if (i = 0) and (s2.length > 0) then
        begin
          re.typ := strty;
          re.nam := NEW_LISP_STRINGV( s1 )
        end
      end;

    2: { Get the time as a string }
      begin
        TIME( s1 );
        re.typ := strty;
        re.nam := NEW_LISP_STRINGV( s1 )
      end;

    3: { Get the date as a string }
      begin
        DATE( s1 );
        re.typ := strty;
        re.nam := NEW_LISP_STRINGV( s1 )
      end;

    4: { Perform an Exec }
      begin
        GET_STR( s1, parm_lst, '' );          { Get the program executable file name }
        ob := F_EVAL( NXT_PAR( parm_lst ) );  { Get the wait flag }
        { Stop LISP and Exec. the Application }
        if ob.typ = intty then RUN_PROCESS( '', s1, ob.int )
                          else RUN_PROCESS( '', s1 )
      end;

    5: { Perform a Spawn }
      begin
        GET_STR( s1, parm_lst, '' );          { Get the command }
        ob := F_EVAL( NXT_PAR( parm_lst ) );  { Get the wait flag }
        re.typ := intty;
        if ob.typ = intty then
          re.int := CREATE_PROCESS( '', s1, ob.int )
        else
          re.int := CREATE_PROCESS( '', s1 )
      end;

    7: { Wait End of Sub-Process Execution }
      begin
        re.typ := intty;
        WAIT_PROCESS( re.int, INTEVL( parm_lst ) )
      end;

(* 10: { Create a Local pipe } *)

   11: { Wait a Given Time in seconde (integer) }
      SLEEP( INTEVL( parm_lst ) );

  otherwise
    EXEC_ERROR( mdnam, 981, e_fatal )
  end;
  LISP$_SYSTEM := re
end LISP$_SYSTEM;

end.
