{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*     * * *    L I S P    S e r v i c e   R o u t i n e s    * * *      *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}


module LISP__SERVICE;


%include 'lispsrc:lisp_env';   { Get the LISP Environment Definitions }


const
  joker = -0.9E+30;

type
  sort_ptr = ^ sort_rec;

  sort_rec = record
    sort_link,
    sort_left, sort_right: sort_ptr;
    sort_val,
    sort_item: obj_ref;
  end;

var
  sort_obj,
  sort_hde: sort_ptr;



procedure BUILD_TREE( build, value, test: obj_ref );
var
  ob1, ob2: obj_ref;

begin { BUILD_TREE }
  sort_hde := nil;
  repeat
    ob1 := F_EVAL( build );  { create/get an new item }
    currobj := value.db^.cdr;
    SET_PARM_OBJ( ob1 );
    ob2 := F_EVAL( value );
    if test.typ <> nullty then
    begin
      NEW( sort_obj );     { create the tree entry }
      with sort_obj^ do
      begin
        sort_link  := nil;
        sort_left  := nil;
        sort_right := nil;
        sort_item  := test
      end;
    end;
  until test.typ = nullty;
end BUILD_TREE;



[global]
function LISP$_SERVICE(   id: integer;
                          parm_lst: obj_ref ): obj_ref;
const
  mdnam = 'SERV';

var
  blispflg, bfirst, fl, fl1, fl2, cflg:                           boolean;
  iv, indx, iflag, xoff, yoff, flgoff, sigoff, cflag:             integer;
  xtyp, ytyp, flgtyp, siftyp:                                     obj_type;
  xvl, xtol, xcur, ycur, sigcurr, xmin, xmax, ymin, ymax:         lisp_real;
  s1, s2:                                                         string( 255 );
  blk_list, cur_blk, off_attr, res, ob0, ob1, ob2, ob3, ob4, obp: obj_ref;

begin { LISP_SERVICE }
  res := obj_nil;
  case id of
     1: { *** Compute the minimaxi of a curve list (lisp or link) *** }
        { Form : (SYS_CALL 51 <curve> <attr> ... ) }
      begin
        bfirst := true;               
        while parm_lst.typ = doublety do
        { We must scan all curves points to compute the min/max }
        begin
          indx := 0;
          LIST_BLK_EVL( parm_lst, blk_list );  { Set to first list element }

          REC_ACC_SET( parm_lst, 5 );          { Get X, Y and flag record location }
          REC_GET_ACC(  1, xoff, xtyp );       { Get X location }
          REC_GET_ACC( -3, yoff, ytyp );       { Get optional Y location }
          REC_GET_ACC( -5, flgoff, flgtyp );   { Get optional flg location }

          obp  := F_EVAL( NXT_PAR( parm_lst ) );{ Get "sequ" LISP expression }
          case obp.typ of
            doublety: begin  cflag := 0; cflg := true   end;
            intty:    begin  cflag := obp.int; cflg := false  end;
          otherwise
            cflag := 0; cflg  := false
          end;

          cur_blk := blk_list;

          repeat
            LIST_BLK_NEXT( ob1, cur_blk, indx );

            if indx > 0 then
            begin
              if flgoff >= 0 then
              begin
                iflag := INTVREC( ob1.rec, flgoff, flgtyp );
                if cflg then
                begin
                  if cflag <> iflag then
                  begin
                    cflag := iflag;
                    currobj := obp.db^.cdr;
                    SET_PARM_INT( iflag );
                    iflag := INTVAL( F_EVAL( obp ) )
                  end
                end
                else
                  if cflag <> 0 then if iflag <> cflag then iflag := 0
              end
              else iflag := 1;

              if iflag > 0 then
              begin
                xcur := SFLTVREC( ob1.rec, xoff, xtyp );
                if yoff >= 0 then ycur := SFLTVREC( ob1.rec, yoff, ytyp );
                if (xcur > joker) and (ycur > joker) then
                  if bfirst then
                  begin
                    bfirst := false;
                    xmin := xcur; xmax := xmin;
                    if yoff >= 0 then
                    begin
                      ymin := ycur; ymax := ymin
                    end
                  end
                  else
                  begin
                    if xcur < xmin then xmin := xcur
                    else if xcur > xmax then xmax := xcur;
                    if yoff >= 0 then
                    begin
                      if ycur < ymin then ymin := ycur
                      else if ycur > ymax then ymax := ycur
                    end
                  end
              end
            end
          until indx <= 0; { Loop on all the Curve Point }
        end { while parm_lst };

        res := obj_nil;
        if yoff >= 0 then
        begin
          res := F_CONS_FLT( ymax, res );
          res := F_CONS_FLT( ymin, res )
        end;
        res := F_CONS_FLT( xmax, res );
        res := F_CONS_FLT( xmin, res )
      end;


     2: { *** Locate a block in a Curve List (LISP or Link) *** }
        { Form : (SYS_CALL 52 <curve> <val_attr_loc> <list_build_flag>
                              <value> [<tolerance>] ) }
      begin
        indx := 0;
        LIST_BLK_EVL( parm_lst, blk_list );

        REC_ACC_SET( parm_lst, 5 );            { Get test val and flg record location }
        REC_GET_ACC(  1, xoff, xtyp );         { Get the test val location }
        REC_GET_ACC( -5, flgoff, flgtyp );     { Get optional flg location }

        case xtyp of
          intub, intsb, intuw, intsw, intty,
          sflty, flty: bfirst := true;         { Legal value type }
        otherwise
          bfirst := false                      { Illegal use }
        end;

        if bfirst then
        begin { For legal use only }
          fl2 := GET_EVLFLAG( parm_lst );      { Get the list build flag }
          ob1 := NUMEVL( parm_lst );           { Get the value to locate }
          if ob1.typ = flty then
          begin
            fl1 := true ;                      { Set the float mode }
            xvl := ob1.flt;
            xtol := ABS( FLTEVLDEF( parm_lst, 0.01*xvl ) ) { Get the tolerance }
          end
          else
          begin
            fl1 := false;                      { Set the integer mode }
            iv  := ob1.int
          end;

          ob2 := obj_nil;                      { Initialize the sublist head }
          cur_blk := blk_list;
          fl := false;                         { Init. the rec. list scan }
          LIST_BLK_NEXT( ob1, cur_blk, indx );

          while not fl and (indx > 0) do
          begin
            if flgoff >= 0 then
              iflag := INTVREC( ob1.rec, flgoff, flgtyp )
            else iflag := 1;

            if iflag > 0 then
            begin { For value point only }
              if fl1 then
              begin
                xcur := FLTVREC( ob1.rec, xoff, xtyp );
                fl   := ABS(xcur - xvl) <= xtol;
              end
              else
                fl := (INTVREC( ob1.rec, xoff, xtyp ) = iv);

              if fl2 then
              begin { Append to the sublist when required }
                ob3 := F_CONS( ob1, obj_nil );
                if ob2.typ = nullty then
                  res := ob3
                else
                  ob2.db^.cdr := ob3;
                ob2 := ob3
              end
            end;
            LIST_BLK_NEXT( ob1, cur_blk, indx )
          end;

          if fl2 then
            res := F_CONS( ob2, res )          { Build a queue header }
          else
            if blk_list.typ = vectortyp then
            begin
              res.typ := intty;
              res.int := indx
            end
            else res := ob1
        end
      end;

     3: { *** Build a sorted queue of object *** }
      { form: (SYS_CALL 53 <create_item_function> <test_function>)
        the function return a queue }
      begin
        ob0 := GET_LIST( parm_lst, true );     { Get the creation expression }
        ob1 := GET_LIST( parm_lst, true );     { Get the extract call model }
        ob2 := GET_LIST( parm_lst, true );     { Get the test call model }

        BUILD_TREE( ob0, ob1, ob2 );

      end;



    49: { *** Free all location of a diagram *** }
      begin
      end;



  otherwise
    EXEC_ERROR( mdnam, 981, e_fatal )
  end;
  LISP$_SERVICE := res
end LISP$_SERVICE;

end.
