%pragma trace 1;
{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*     * * *    L I S P    D r a w i n g   I n t e r f a c e   * * *     *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}



(*
[inherit( 'LIB:BASIC_ENV_STR',          { Use string management definitions }
          'LIB:BASIC_ENV_SRC',	    { Use source management definitions }
          'GRAPH:DRAW_DEFS',            { Use basic draw library }
          'LIB:LISP_ENV')]              { Use the lisp environment file }
*)
module LISP__DRAW;

%include 'PASENV:draw_defs';            { Get the DRAW Library Environment }
%include 'LISPSRC:lisp_env';            { Get the Lisp Environment Definitions }


const
  joker = -0.9E+30;

  ldrw_itmax =      128;                { Size of index/face_size table }
  ldrw_vtmax =     4096;                { Size of Vertex table (in Dfloat) }


var
  eqv: record case integer of   { Equivalence for type compatibility }
         0:( lisp: mem_ptr );   { Use for LISP side }
         1:( box:  Dint );      { Use as box pointer }
         2:( axe:  Dint );      { Use as axis pointer }
       end;

  ldrw_equ: record case integer of      { Equivalence for type compatibility }
              0:( svl: bits );
              1:( ivl: Dint );
              2:( bvl: array[1..4] of byte);
              3:( cvl: array[1..4] of char);
              4:( fvl: Dfloat)
            end;

  ldrw_status:     Dint := -1;          { Interface status word }

  ldrw_unit:       unit_type;           { Drawing target unit (0/1 for raster/cm) }

  ldrw_paper_x,                         { Size of the paper/window space }
  ldrw_paper_y,
  ldrw_space_x,                         { Size of the Draw space (3D) }
  ldrw_space_y,
  ldrw_space_z:    Dfloat := 0.0;

  ldrw_space_atm,                       { Draw User Space Atom Reference }
  ldrw_status_atm: obj_ref;             { Draw Status Atom Reference }

  ldrw_task_label: String( 32 );        { Draw user Task label }

  ldrw_stp_anim,                        { flag for animation }
  ldrw_3dflg:      Dbool;               { Flag for 3D Mode }


  ldrw_sgdf_scale: Dfloat;
  ldrw_sgdf_color: Dint;

  ldrw_mat:        Dmatrix;             { Current Transformation Matrix }

  ldrw_itb:  array[1..ldrw_itmax] of Dint;    { Table for face index or size }
  ldrw_ftb:  array[1..ldrw_vtmax] of Dfloat;  { Table for coordinates }

  ldrw_pt1,                             { Dpoint3 object for manager }
  ldrw_pt2,
  ldrw_pt3:        Dpoint3;

  ldrw_maction:    array[1..256] of obj_ref;  { List expressions for each Dialog menu }
  ldrw_mactcnt:    integer;                   { Menu Count }


procedure GET_POINT3( var ll: obj_ref; var pt: Dpoint3 );
begin
  pt[1] := FLTEVL( ll );
  pt[2] := FLTEVL( ll );
  pt[3] := FLTEVL( ll )
end GET_POINT3;




procedure GET_CURVE_ATTR( var lprm, attr: obj_ref; var seg: Dint );
var
  ob: obj_ref;

begin
  ob := F_EVAL( NXT_PAR( lprm ) );
  if ob.typ = doublety then
  begin { list of attribute is specified }
    seg  := INTVAL( NXT_PAR( ob ) );
    attr := ob
  end
  else
  begin { Integer value of segment or 0 }
    attr := obj_nil;
    if ob.typ = nullty then seg := 0
                       else seg := INTVAL( ob )
  end
end GET_CURVE_ATTR;




procedure SET_ATTR_GROUP( ll: obj_ref );
var
  i0, i1, i2: integer;
  f0: Dfloat;

begin
  if ll.typ = doublety then
  begin { Change With attributes }
    i0 := INTEVLDEF( ll, maxint ); if i0 <> maxint then DRAW$COLOR( i0 );
    i0 := INTEVLDEF( ll, maxint ); if i0 <> maxint then DRAW$OUT_MODE( i0 );
    i1 := INTEVLDEF( ll, 1 );
    case i0 of
      1, -3..-1: { line }
        begin
          f0 := SFLTEVLDEF( ll, 0.0 );
          DRAW$LINE_ATTR( i1, f0 )
        end;
      2, 0: { Marker }
        begin
          f0 := SFLTEVLDEF( ll, 0.0 );
          DRAW$MARKER_ATTR( i1, f0 )
        end;
      3, -9..-4: { Area }
        begin
          i2 := INTEVLDEF( ll, -1 );
          DRAW$FILL_ATTR( i1, i2 )
        end;
    otherwise
    end;
    if ll.typ = doublety then
    begin
      ldrw_sgdf_color := INTEVLDEF( ll, 1 );
      ldrw_sgdf_scale := FLTEVLDEF( ll, 1.0 )
    end
    else
    begin
      ldrw_sgdf_color :=    -1;
      ldrw_sgdf_scale := - 1.0
    end
  end
  else { Single Output mode }
    DRAW$OUT_MODE( INTEVLDEF( ll, 1 ) )
end SET_ATTR_GROUP;




procedure Init_Menu_Setting( ll: obj_ref );
var
  sn: string( 255 );
  o1, o2: obj_ref;

begin
  while ll.typ = doublety do
  begin
    o1 := NXT_PAR( ll );
    case o1.typ of
      doublety:
        begin { Sub User menu "nnn" or () for open standard menu }
          o2 := NXT_PAR( o1 );
          if o2.typ = strty then
          begin { To Create a User menu }
            GET_STRING( sn, o2, '- - -' );
            DRAW$SET_MENU_SPC( 3, sn )
          end
          else DRAW$SET_MENU_SPC( 1 ); { To Open a standard menu }
          Init_Menu_Setting( o1 )
        end;

      strty:
        begin
          GET_STRING( sn, o1, '- - -' );
          if ldrw_mactcnt < 256 then
          begin
            ldrw_mactcnt := ldrw_mactcnt + 1;
            ldrw_maction[ldrw_mactcnt] := NXT_PAR( ll );
            DRAW$SET_MENU_SPC( 4, sn, ldrw_mactcnt )
          end
          else DRAW$SET_MENU_SPC( 4, sn )
        end;

      charty:
        case o1.ch of
          'S', 's': { Skip Entry }        DRAW$SET_MENU_SPC( 2 + 16*INTVAL( NXT_PAR( ll ) ) );
          '-', '_',
          'b', 'B': { Barre Insertion }   DRAW$SET_MENU_SPC( 5 );
        otherwise
          { Ignored } 
        end;

    otherwise
      { Ignore all other code }
    end
  end;
  DRAW$SET_MENU_SPC( 0 ) { Close the current menu }
end Init_Menu_Setting;



[global]
function LISP$_DRAW(       id: integer;
                     parm_lst: obj_ref ): obj_ref;
{
  Function To give DRAWLIB access to LISP Program.
}
const
  mdnam = 'DRAW';

type
  typ_tb2d = array[1..1024,1..1024] of integer;
  tb2d_ptr = ^typ_tb2d;

var
  s1, s2, s3: [static] string( 255 );
  o1, o2, o3, o4, o5, o6, l1, l2, l3, re: [static] obj_ref;
  xtyp, ytyp, ftyp, sxtyp, sytyp: obj_type;

  i0, i1, i2, i3, i4, i5, i6, ide, idx, iflg, isg,
  xoff, yoff, foff, sxoff, syoff: Dint;

  f0, f1, f2, f3, f4, f5, f6, f7: Dfloat;
  b0, b1, b2, b3: Dbool;

  itb: array[1..32] of Dint;
  ftb: array[1..32] of Dfloat;
  stb: array[1..32] of string_ptr;

  fre, knd: array[1..4] of Dint;


begin { LISP$_DRAW }
  re := obj_nil;
  id := id mod 100;
  case id of
     0: { *** End of graphic session *** }
        if ldrw_status <> 0 then
        begin
          DRAW$END; { Exit from graphic mode }
          ldrw_status := 0
        end;


     1: { * * *   Init Drawing system with User Menu Define for  DRAW$DIALOG   * * *
          * * *   (use only out of DRAW$INIT.. DRAW$END sequence)              * * * }
        begin
          { * * *   In first, Get the user parameters   * * * }
          ldrw_space_x := FLTEVLDEF( parm_lst, 0.0 );    { Get the Picture space size }
          ldrw_space_y := FLTEVLDEF( parm_lst, 0.0 );
          o1 := F_EVAL( NXT_PAR( parm_lst ) );           { 2D => string or nil, 3D => Float value }
          if (o1.typ = flty) or (o1.typ = sflty) then
          begin
            ldrw_space_z :=  o1.flt;                     { Get the Z Space Dimension }
            o1 := F_EVAL( NXT_PAR( parm_lst ) );         { ... and get the picture label string }
            ldrw_3dflg := true
          end
          else
          begin
            ldrw_space_z :=     0.0;                     { Clear the Z Dimension }
            ldrw_3dflg := false
          end;
          GET_STR( s1, o1, '' );                         { Get the Picture Label }
          b0 := (s1.length > 0);                         { Build the margin flag }
          b1 := GET_EVLFLAG( parm_lst );                 { Get the scale flag }
          re := F_EVAL( NXT_PAR( parm_lst ) );           { Get the result list }

          if ldrw_status <= 0 then
          begin
            GET_STR( s2, F_EVAL( NXT_PAR( parm_lst ) ), 'E-Lisp' );  { Get a Task Label, if specified }
            i0 := INTEVLDEF( parm_lst, 0 );              { Get the required server flags when specified }
            if i0 <> 0 then Draw_Server_Mode := i0;      { If required, set the Server Mode Flags  }

            { * * *   Get the menu task specific directive list when specified   * * * }
            l1 := GET_LIST( parm_lst, false );
            if l1.typ = doublety then
            begin
              ldrw_mactcnt := 0;                         { Init the Menu Setting action table }
              Init_Menu_Setting( l1 )                    { Set the User menu/entry Specifications }
            end;

            { * * *   Init The Draw Server   * * * }
            DRAW$INIT( ldrw_paper_x, ldrw_paper_y, ldrw_unit, s2 );
          end
          else                                           { When it is not the first INIT of DRAW ... }
          begin
            DRAW$FREE_BOX_LIST;                          { ... we free all existing Axis box }
            DRAW$SET_STOP_ANIM( 0 )                      { Stop any animation mode }
          end;

          { * * *   Set the actual DRAW Status atom   * * * }
          with ldrw_Link.at^ do                          { With the DRAW Link Atom }
          begin
            val       := obj_zero;
            val.int   := Draw_Anim_State;                { Initialise value to animation mode ... }
            plist     := obj_zero;
            plist.int := Draw_Server_Mode                { ... and the server mode in Plist. }
          end;


          { * * *   Define a new picture   * * * }

          if ldrw_space_x <= 0.0 then ldrw_space_x := ldrw_paper_x;
          if ldrw_space_y <= 0.0 then ldrw_space_y := ldrw_paper_y;

          if ldrw_3dflg then b0 := DRAW$PICTURE3( s1, ldrw_space_x, ldrw_space_y, ldrw_space_z, b1, b0 )
                        else b0 := DRAW$PICTURE( s1, ldrw_space_x, ldrw_space_y, b1, b0 );

          ldrw_stp_anim   := false;                      { Set No animation runing state }
          ldrw_sgdf_scale := -1.0;                       { Set the Sigma Scale and Color default }
          ldrw_sgdf_color := -1;

          if re.typ = doublety then
          begin
            currobj := re;                               { Build the Resulting List }
            SET_PARM_BOOL( b0 );                         { Put the resulting Scale Flag }
            SET_PARM_BOOL( ldrw_unit <> 0 );             { Put the unit cm flag }
            SET_PARM_SFLT( ldrw_paper_x );               { Put the size of display:printer in cm }
            SET_PARM_SFLT( ldrw_paper_y );
            DRAW$GET_SERVER_NAME( s3 );
            SET_PARM_STR( s3"address );                  { Put the Server name }
            SET_PARM_INT( Draw_Server_Ident );           { Put the Server Identifier }
            SET_PARM_INT( Draw_Server_Flags )            { Put the Server Capability Flags word }
          end
          else
            re := log_val[ b0 ];
          ldrw_status := 1
        end;


     2: { * * *   Set/Clear/Enable/Disable Various Server Mode   * * * }
      while parm_lst.typ = doublety do
      begin
        i0 := INTEVLDEF( parm_lst, 0 );                  { Get selection the code }
        case i0 of
          1: begin { * * *   Enable/Disable As Soon As (ASA) Display Mode   * * * }
               b0 := GET_EVLFLAG( parm_lst );            { Get the ASA Enable/Disable flag }
               if b0 then DRAW$PIC_VIEW                  { If true then Set ASA Display mode ... }
                     else DRAW$PIC_RESET                 { ... else Clear it }
             end;

          2: begin { * * *   Enable/Disable the animation mode   * * * }
               i0 := INTEVLDEF( parm_lst, 0 );           { Get the user request value }
               if (i0 >= 0) and (i0 <= 255) then
               begin
                 ldrw_stp_anim := (i0 > 0);              { Keep the mode in memory }
                 DRAW$SET_STOP_ANIM( i0 )                { Set the specified Animation mode }
               end
             end;

          3: { * * *   Select an Alpha modes   * * * }
             DRAW$ALPHA_SET( INTEVLDEF( parm_lst, 0 ) );

          4: begin { * * *   Set On or Off a Light   * * * }
               i0 := INTEVLDEF( parm_lst, 1 );           { Get the light number }
               DRAW$LIGHT_ON_OFF( i0, INTEVLDEF( parm_lst, 1 ) )
             end;

          5, 6:
             begin { * * *   Define any Light Configuration   * * * }
                   { * * *   or Material Light Properties     * * * }
               i1 := INTEVLDEF( parm_lst, 1 );           { Get the light number or face code }
               i2 := INTEVLDEF( parm_lst, 1 );           { Get the kind of light attribute }
               i3 := 0;
               while (parm_lst.typ = doublety) and (i3 < 4) do
               begin                                     { Get each floatting value }
                 i3 := i3 + 1;
                 ftb[i2] := FLTEVLDEF( parm_lst, 0.0 )
               end;
               if i0 = 5 then DRAW$LIGHT_DEFINE( i1, i2, ftb[1], i3 )
                         else DRAW$MAT_LIGHT_PROP( i1, i2, ftb[1], i3 )
             end;

          7: begin { * * *   Set a New Indexed Color Definition   * * * }
               i1 := INTEVLDEF( parm_lst, 1 );           { Get the color index }
               f0 := FLTEVLDEF( parm_lst, 0.0 );         { Get the Red Level }
               f1 := FLTEVLDEF( parm_lst, 0.0 );         { Get the Green Level }
               f2 := FLTEVLDEF( parm_lst, 0.0 );         { Get the Blue Level }
               f3 := FLTEVLDEF( parm_lst, 1.0 );         { Get the related Alpha Value }
               DRAW$DEFINE_COLOR( i1, f0, f1, f2, f3 )   { Set the New Color Definition }
             end;

          8: begin { * * *   Get a current Indexed Color Definition   * * * }
               i1 := INTEVLDEF( parm_lst, 1 );           { Get the color index }
               re := GET_LIST( parm_lst, false );        { Get the resulting List to put r,g,b,a values }
               DRAW$INQUIRE_COLOR( i1, f0, f1, f2, f3 ); { Get the Indexed  Color Definition }
               re := SET_RESULT_LIST( re, 4 );           { Build the Resulting List }
               SET_PARM_SFLT( f0 );                      { Put the resulting RGBA values }
               SET_PARM_SFLT( f1 );
               SET_PARM_SFLT( f2 );
               SET_PARM_SFLT( f3 )
             end;

          9: begin { * * *   Set a new Refresh Window State Periode   * * * }
               re.typ := intty;
               re.int := DRAW$TIME_ANIM( INTEVLDEF( parm_lst, 100 ) )
             end;

        otherwise
        end
      end;


     3: { * * *   Get the current animation mode   * * * }
      begin
        re.typ := intty;
        re.int := Draw_Anim_State
      end;


     4: { * * *   Set a view parameter set   * * * }
      begin
        f0 := FLTEVLDEF( parm_lst, 0.0 );                { Get the View distance (in cm) }
        DRAW$VIEW( f0 )
      end;


     5: { * * *   Start the DRAW Dialogue User Session and wait   * * * }
      begin
        re.typ := intty;
        re.int := DRAW$DIALOG( INTEVLDEF( parm_lst, 0  ) );
        if re.int > 0 then re := ldrw_maction[re.int] 
      end;


     6: { * * *   Invoque a DRAW Display(L2) Action/Interaction   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the function code }
        case i1 of
          1: DRAW$PRINT;
          2: DRAW$ZOOM;
          3: DRAW$SCALE;
          4: DRAW$RELOAD( false );
          5: DRAW$REFRESH;
          6: DRAW$GRID( false );
        otherwise
        end
      end;


    10: { * * *   Set Current Color  * * * }
      begin
        o1 := NUMEVL( parm_lst );
        if o1.typ <> flty then DRAW$COLOR( o1.int )
        else
        begin
          f0 := o1.flt;
          f1 := FLTEVL( parm_lst ); f2 := FLTEVL( parm_lst );
          f3 := FLTEVLDEF( parm_lst, 1.0 );
          DRAW$COLOR( f0, f1, f2, f3 )
        end 
      end;


    11: { * * *   Set Various Graphic Object Attributes   * * * }
      while parm_lst.typ = doublety do
      begin
        i0 := INTEVLDEF( parm_lst, 0 );
        case i0 of
          1, -1, -2, -3:
            begin { Line or GL: (LINES, LINE_STRIP, LINE_LOOP }
              i1 := INTEVLDEF( parm_lst, 1 );            { Line type number and Line (width) Size }
              DRAW$LINE_ATTR( i1, SFLTEVLDEF( parm_lst, 1.0 ) )
            end;

          2, 0:
            begin { Marker or GL: POINTS }
              i1 := INTEVLDEF( parm_lst, 1 );            { Marker type number and Marker Size }
              DRAW$MARKER_ATTR( i1, SFLTEVLDEF( parm_lst, 1.0 ) )
            end;

          3, -4, -5, -6, -7, -8, -9:
            begin { Fill Area or GL: (TRIANGLES, TRIANGLE_STRIP, TRIANGLE_FAN, QUADS, QUAD_STRIP, POLYGON)}
              i1 := INTEVLDEF( parm_lst, 1 );            { Fill Area mode: 1 Hollow,2 Color,3 and 4 ... }
              i2 := INTEVLDEF( parm_lst, 1 );            { ... Hatched; Style number for Hatching }
              DRAW$FILL_ATTR( i1, i2 )
            end;

          4: { Text Attr }
             begin
               i1 := INTEVLDEF( parm_lst, 1 );           { Text Horizontal Alignement }
               i2 := INTEVLDEF( parm_lst, 1 );           { Text Vertical Alignement }
               i3 := INTEVLDEF( parm_lst, 1 );           { Text Path (default left to right) }
               f0 := FLTEVLDEF( parm_lst, 1.0 );         { Text large/high Character expention factor }
               f1 := FLTEVLDEF( parm_lst, 0.0 );         { Text Character Spacing }
               DRAW$TEXT_ATTR( i1, i2, i3, f0, f1 )
             end;

          5: { Text Font }
             begin
               i1 := INTEVLDEF( parm_lst, 1 );           { Text Font Number }
               i2 := INTEVLDEF( parm_lst, 3 );           { text Font Precision }
               DRAW$TEXT_FONT( i1, i2 )
             end;

          9: { Segment Attr }
             begin
               i1 := INTEVL( parm_lst );                 { Get the segment number }
               i2 := INTEVLDEF( parm_lst, 0 );   { 2/1/0 => Detectable/Not_Detectable/No_Ch }
               i3 := INTEVLDEF( parm_lst, 0 );   { 2/1/0 => HighLighting/No_HighLighting/No_Ch }
               i4 := INTEVLDEF( parm_lst, 0 );   { 2/1/0 => Visible/Not_Visible/No_Change }
               f0 := FLTEVLDEF( parm_lst, 0.5 ); { Relative Priority of the Segment }
               DRAW$SEG_ATTR( i1, i2, i3, i4, f0 ) 
             end;

         15: begin { * * *   Set the Current Sigma Scale and Color   * * * }
               ldrw_sgdf_color := INTEVLDEF( parm_lst, 1 );
               ldrw_sgdf_scale := FLTEVLDEF( parm_lst, 1.0 )
             end;

        otherwise
        end
      end;


    12: { * * *   The OutPut Mode and attributes Command   * * * }
      SET_ATTR_GROUP( F_EVAL( NXT_PAR( parm_lst ) ) );


    13: { * * *   The ORG (2D/3D) Command   * * * }
      begin
        f0 := FLTEVL( parm_lst );
        f1 := FLTEVL( parm_lst );
        o1 := NUMEVL( parm_lst );
        if o1.typ = flty then DRAW$ORG3( f0, f1, Dfloat( o1.flt ), INTEVL( parm_lst ) )
                         else DRAW$ORG( f0, f1, o1.int )
      end;


    14: { * * *   The Plot  (2D/3D) Command   * * * }
      begin
        f0 := FLTEVL( parm_lst );
        f1 := FLTEVL( parm_lst );
        o1 := F_EVAL( NXT_PAR( parm_lst ) );
        if (o1.typ = flty) or (o1.typ = sflty) then
          DRAW$PLOT3( f0, f1, Dfloat( o1.flt ), GET_EVLFLAG( parm_lst ) )
        else
          DRAW$PLOT( f0, f1, GET_VALFLAG( o1 ) )
      end;


    15: { * * *   The RPlot (2D/3D) Command   * * * }
      begin
        f0 := FLTEVL( parm_lst );
        f1 := FLTEVL( parm_lst );
        o1 := NUMEVL( parm_lst );
        if (o1.typ = flty) or (o1.typ = sflty) then
          DRAW$RPLOT3( f0, f1, Dfloat( o1.flt ), GET_EVLFLAG( parm_lst ) )
        else
          DRAW$RPLOT( f0, f1, GET_VALFLAG( o1 ) )
      end;


    16: { * * *   The WHERE (2D/3D) Command   * * * }
      begin
        re := GET_LIST( parm_lst, false );               { Get the resulting List to put r,g,b,a values }
        DRAW$WHERE3( f0, f1, f2 );                       { Get the Current Plot Position (in 3D) }
        re := SET_RESULT_LIST( re, 3 );                  { Build the Resulting List }
        SET_PARM_SFLT( f0 );                             { Put the resulting x/y/z values }
        SET_PARM_SFLT( f1 );
        SET_PARM_SFLT( f2 )
      end;


    20: { * * *   The Generalized Plot 2D/3D Command   * * * }
      begin
        ldrw_equ.ivl := INTEVL( parm_lst );              { Get The Flag Word for bits analyse }
        l1 := GET_LIST( parm_lst, true );                { Get a list of points }
        b0 := b00 in ldrw_equ.svl;                       { Get the Begin UP flag }
        b1 := b01 in ldrw_equ.svl;                       { Get the End UP flag }
        b2 := b02 in ldrw_equ.svl;                       { Get the Relative flag }
        b3 := b03 in ldrw_equ.svl;                       { Get the 3d flag }
        if b0 then
        begin
          f0 := GET_FLT( l1 );                           { Get the X Coordinate }
          f1 := GET_FLT( l1 );                           { Get the Y Coordinate }
          if b3 then
          begin
            f2 := GET_FLT( l1 );
            if b2 then DRAW$RPLOT3( f0, f1, f2, false )
                  else DRAW$PLOT3( f0, f1, f2, false )
          end
          else
            if b2 then DRAW$RPLOT( f0, f1, false )
                  else DRAW$PLOT( f0, f1, false )
        end;
        while parm_lst.typ = doublety do
        begin                                            { Loop on the whole point directive }
          f0 := GET_FLT( l1 );                           { Get the X Coordinate }
          f1 := GET_FLT( l1 );                           { Get the Y Coordinate }
          if b3 then
          begin
            f2 := GET_FLT( l1 );                         { Get the Z Coordinate }
            if b2 then DRAW$RPLOT3( f0, f1, f2, true )   { 3D Relative mode }
                  else DRAW$PLOT3( f0, f1, f2, true )    { 3D Absolute mode }
          end
          else
            if b2 then DRAW$RPLOT( f0, f1, true )        { 2D Relative mode }
                  else DRAW$PLOT( f0, f1, true )         { 2D Absolute mode }
        end;
        if b1 then                                       { Up the Pen at the End }
          if b3 then DRAW$RPLOT3( 0.0, 0.0, 0.0, false )
                else DRAW$RPLOT( 0.0, 0.0, false )
      end;


    21: { * * *   Plot a String   * * * }
      begin
        DRAW$WHERE( f0, f1 );                            { Get the current coordinates }
        f0 := FLTEVLDEF( parm_lst, lisp_real( f0 ) );    { Get X coordinate }
        f1 := FLTEVLDEF( parm_lst, lisp_real( f1 ) );    { Get Y coordinate }
        f2 := FLTEVLDEF( parm_lst, 1E25 );               { Get the Theta angle in degrees }
        f3 := FLTEVLDEF( parm_lst, 0.0 );                { Get the character high }
        GET_STR( s1, parm_lst, '' );                     { Get the string to plot }
        i1 := INTEVLDEF( parm_lst, 0 );                  { Get the related Absolute(not Org dep) flag }
        DRAW$STRING( f0, f1, f2, f3, s1, i1 )            { Plot the string }
      end;


    22: { * * *   Plot a Circle or an Arc of Circle   * * * }
      begin
        f0 := FLTEVLDEF( parm_lst, 0.0 );                { Get the X center coordinate }
        f1 := FLTEVLDEF( parm_lst, 0.0 );                { Get the Y center coordinate }
        f2 := FLTEVLDEF( parm_lst, 1.0 );                { Get the radius }
        f3 := FLTEVLDEF( parm_lst, 0.0 );                { Get the start arc angle }
        ftb[1] := FLTEVLDEF( parm_lst, 0.0 );            { Get the end arc angle }
        ftb[2] := FLTEVLDEF( parm_lst, 1.0 );            { Get the angle step }
        i1 := INTEVLDEF( parm_lst, 0 );                  { Get the related Absolute(not Org dep) flag }
        DRAW$CIRCLE( f0, f1, f2, f3, ftb[1], ftb[2], i1 )
      end;


    23: { * * *   Plot a Sphere   * * * }
      begin
        f0 := FLTEVLDEF( parm_lst, 0.0 );                { Get the X center coordinate }
        f1 := FLTEVLDEF( parm_lst, 0.0 );                { Get the Y center coordinate }
        f2 := FLTEVLDEF( parm_lst, 0.0 );                { Get the Z center coordinate }
        f3 := FLTEVLDEF( parm_lst, 1.0 );                { Get the sphere radius }
        i2 := INTEVLDEF( parm_lst, 32 );                 { Get the number of slice (longitude) }
        i3 := INTEVLDEF( parm_lst, 16 );                 { Get the number of stack (latitude) }
        i1 := INTEVLDEF( parm_lst, 0 );                  { Get the related Absolute(not Org dep) flag }
        DRAW$SPHERE( f0, f1, f2, f3, i2, i3, i1 )
      end;


    24: { * * *   Plot a Cylinder or a Cone   * * * }
      begin
        f0 := FLTEVLDEF( parm_lst, 0.0 );                { Get the X base center coordinate }
        f1 := FLTEVLDEF( parm_lst, 0.0 );                { Get the Y base center coordinate }
        f2 := FLTEVLDEF( parm_lst, 0.0 );                { Get the Z base center coordinate }
        f3 := FLTEVLDEF( parm_lst, 0.0 );                { Get the orientation Theta angle }
        ftb[1] := FLTEVLDEF( parm_lst, 0.0 );            { Get the orientation Phi angle }
        ftb[2] := FLTEVLDEF( parm_lst, 1.0 );            { Get the cylinder high (length) }
        ftb[3] := FLTEVLDEF( parm_lst, 1.0 );            { Get the cylinder base radius }
        ftb[4] := FLTEVLDEF( parm_lst, 1.0 );            { Get the cylinder top radius }
        i2 := INTEVLDEF( parm_lst, 32 );                 { Get the number of slice (longitude) }
        i3 := INTEVLDEF( parm_lst, 16 );                 { Get the number of stack (latitude) }
        i1 := INTEVLDEF( parm_lst, 0 );                  { Get the related Absolute(not Org dep) flag }
        DRAW$CYLINDER( f0, f1, f2, f3, ftb[1], ftb[2], ftb[3], ftb[4], i2, i3, i1 )
      end;


    25: { * * *   Plot a Disk or a Ring   * * * }
      begin
        f0 := FLTEVLDEF( parm_lst, 0.0 );                { Get the X base center coordinate }
        f1 := FLTEVLDEF( parm_lst, 0.0 );                { Get the Y base center coordinate }
        f2 := FLTEVLDEF( parm_lst, 0.0 );                { Get the Z base center coordinate }
        f3 := FLTEVLDEF( parm_lst, 0.0 );                { Get the orientation Theta angle }
        ftb[1] := FLTEVLDEF( parm_lst, 0.0 );            { Get the orientation Phi angle }
        ftb[2] := FLTEVLDEF( parm_lst, 1.0 );            { Get the external radius }
        ftb[3] := FLTEVLDEF( parm_lst, 0.0 );            { Get the internal radius }
        ftb[4] := FLTEVLDEF( parm_lst, 0.0 );            { Get the start angle }
        ftb[5] := FLTEVLDEF( parm_lst, 360.0 );          { Get the end angle }
        i2 := INTEVLDEF( parm_lst, 8 );                  { Get the number of slice (longitude) }
        i3 := INTEVLDEF( parm_lst, 8 );                  { Get the number of stack (latitude) }
        i1 := INTEVLDEF( parm_lst, 0 );                  { Get the related Absolute(not Org dep) flag }
        DRAW$DISK( f0, f1, f2, f3, ftb[1], ftb[2], ftb[3], ftb[4], ftb[5], i2, i3, i1 )
      end;


    26: { * * *   Generalised Surface Draw   * * * }
      begin
        l1 := GET_LIST( parm_lst, true );                { Get the list of Polygon size }
        l2 := GET_LIST( parm_lst, true );                { Get the list of Vertex }
        i1 := INTEVLDEF( parm_lst, 0 );                  { Get Abs.Org.Ind Flag }
        i2 := 0;
        while (l1.typ = doublety) and (i2 < ldrw_itmax) do
        begin  i2 := i2 + 1; ldrw_itb[i2] := GET_INT( l1 )  end;
        i3 := 0;
        while (l2.typ = doublety) and (i3 < ldrw_vtmax) do
        begin
          i3 := i3 + 1; ldrw_ftb[i3] := Dfloat( GET_FLT( l2 ) )
        end;
        DRAW$POLYHEDRAL( i2, i3 div 3, ldrw_itb"address, ldrw_ftb"address, i1 )
      end;



    30: { * * *   Create a NEW or UPDATE SEGment  * * * }
      begin
        i0 := INTEVLDEF( parm_lst, 0 );                  { Get the segment number }
        if i0 <= 0 then i0 := DRAW$NEW_SEG( i0 )         { Create a new segment }
                   else DRAW$UPDATE_SEG( i0 );           { Update an possible existing segment }
        DRAW$SET_PICKID( INTEVLDEF( parm_lst, 1 ) );
        re.typ := intty;
        re.int := i0
      end;


    31: { * * *   SEGment END   * * * }
      DRAW$SEG_END;


    32: { * * *   DELete SEGment   * * * }
      begin
        DRAW$SEG_END;
        DRAW$DEL_SEG( INTEVL( parm_lst ) )
      end;


    33: { * * *   Set a new pick identifier   * * * }
        DRAW$SET_PICKID( INTEVLDEF( parm_lst, 1 ) );


    34: { * * *   Set a segment as Detectable or not   * * * }
        DRAW$DETECTABLE( INTEVLDEF( parm_lst, 1 ) );


    35: { * * *   INCLUDE a SEGgment   * * * }
        DRAW$INCLUDE_SEG( INTEVLDEF( parm_lst, 1 ) );

    36: { * * *   INQUIRE SEGgment identifier  * * * }
      begin
        re.typ := intty;
        re.int := DRAW$SEG_INQUIRE
      end;

    40: { * * *   PUSH MATRIX   * * * }
      begin
        re.typ := intty;
        re.int := - DRAW$PUSH_MATRIX
      end;


    41: { * * *   POP MATRIX   * * * }
      DRAW$POP_MATRIX;


    42: { * * *   Init a Matrix Transformation   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        b1 := GET_EVLFLAG( parm_lst );
        if b0 then DRAW$SEG_UNIT_TRANSF( i1, ORD( b1 ) )
              else DRAW$MAT_UNIT_TRANSF( i1, ORD( b1 ) )
      end;


    43: { * * *   Set a 2D Matrix Transformation   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        for ii := 1 to 5 do ftb[ii] := FLTEVLDEF( parm_lst, 0.0 );
        for ii := 6 to 7 do ftb[ii] := FLTEVLDEF( parm_lst, 1.0 );
        if b0 then DRAW$TRANSF_SEG( i1, ftb[1], ftb[2], ftb[3], ftb[4], ftb[5], ftb[6], ftb[7] )
              else DRAW$TRANSF_MAT( i1, ftb[1], ftb[2], ftb[3], ftb[4], ftb[5], ftb[6], ftb[7] )
      end;


    44: { * * *   Set a 3D Matrix Transformation   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        for ii := 1 to 9 do ftb[ii] := FLTEVLDEF( parm_lst, 0.0 );
        for ii := 10 to 12 do ftb[ii] := FLTEVLDEF( parm_lst, 1.0 );
        if b0 then DRAW$TRANSF_SEG3( i1, ftb[ 1], ftb[ 2], ftb[ 3], ftb[ 4], ftb[ 5], ftb[ 6],
                                         ftb[ 7], ftb[ 8], ftb[ 9], ftb[10], ftb[11], ftb[12] )
              else DRAW$TRANSF_MAT3( i1, ftb[ 1], ftb[ 2], ftb[ 3], ftb[ 4], ftb[ 5], ftb[ 6],
                                         ftb[ 7], ftb[ 8], ftb[ 9], ftb[10], ftb[11], ftb[12] )
      end;


    45: { * * *   Set a 2D Matrix Translation   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        f0 := FLTEVLDEF( parm_lst, 0.0 );
        f1 := FLTEVLDEF( parm_lst, 0.0 );
        if b0 then DRAW$MOVE_SEG( i1, f0, f1 )
              else DRAW$MOVE_MAT( i1, f0, f1 )
      end;


    46: { * * *   Set a 3D Matrix Translation   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        f0 := FLTEVLDEF( parm_lst, 0.0 );
        f1 := FLTEVLDEF( parm_lst, 0.0 );
        f2 := FLTEVLDEF( parm_lst, 0.0 );
        if b0 then DRAW$MOVE_SEG3( i1, f0, f1, f2 )
              else DRAW$MOVE_MAT3( i1, f0, f1, f2 )
      end;



    47: { * * *   Set a 2D Matrix Rotation   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        f0 := FLTEVLDEF( parm_lst, 0.0 );
        f1 := FLTEVLDEF( parm_lst, 0.0 );
        f2 := FLTEVLDEF( parm_lst, 0.0 );
        if b0 then DRAW$ROTATE_SEG( i1, f0, f1, f2 )
              else DRAW$ROTATE_MAT( i1, f0, f1, f2 )
      end;


    48: { * * *   Set a 3D Matrix U Rotation   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        for ii := 1 to 6 do ftb[ii] := FLTEVLDEF( parm_lst, 0.0 );
        if b0 then DRAW$UROT_SEG3( i1, ftb[1], ftb[2], ftb[3], ftb[4], ftb[5], ftb[6] )
              else DRAW$UROT_MAT3( i1, ftb[1], ftb[2], ftb[3], ftb[4], ftb[5], ftb[6] )
      end;


    49: { * * *   Set a 3D Matrix Euler Rotation   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        for ii := 1 to 6 do ftb[ii] := FLTEVLDEF( parm_lst, 0.0 );
        if b0 then DRAW$ROTATE_SEG3( i1, ftb[1], ftb[2], ftb[3], ftb[4], ftb[5], ftb[6] )
              else DRAW$ROTATE_MAT3( i1, ftb[1], ftb[2], ftb[3], ftb[4], ftb[5], ftb[6] )
      end;


    50: { * * *   Set a 2D Matrix Scale   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        f0 := FLTEVLDEF( parm_lst, 0.0 );
        f1 := FLTEVLDEF( parm_lst, 0.0 );
        f2 := FLTEVLDEF( parm_lst, 1.0 );
        f3 := FLTEVLDEF( parm_lst, 1.0 );
        if b0 then DRAW$SCALE_SEG( i1, f0, f1, f2, f3 )
              else DRAW$SCALE_MAT( i1, f0, f1, f2, f3 )
      end;


    51: { * * *   Set a 3D Matrix Scale   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        f0 := FLTEVLDEF( parm_lst, 0.0 );
        f1 := FLTEVLDEF( parm_lst, 0.0 );
        f2 := FLTEVLDEF( parm_lst, 0.0 );
        f3 := FLTEVLDEF( parm_lst, 1.0 );
        f4 := FLTEVLDEF( parm_lst, 1.0 );
        f5 := FLTEVLDEF( parm_lst, 1.0 );
        if b0 then DRAW$SCALE_SEG3( i1, f0, f1, f2, f3, f4, f5 )
              else DRAW$SCALE_MAT3( i1, f0, f1, f2, f3, f4, f5 )
      end;


    52: { * * *   Get a Transformation Matrix   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        re := GET_LIST( parm_lst, false );               { Get the resulting List }
        if b0 then i2 := DRAW$GET_SEG_MAT( i1, ldrw_mat )
              else i2 := DRAW$GET_MATRIX( i1, ldrw_mat );
        if i2 < 0 then re := obj_nil
        else
        begin
          re := SET_RESULT_LIST( re, 12 );               { Build (or use) the Resulting List }
          for ii := 1 to 3 do
            for jj := 1 to 4 do
              SET_PARM_SFLT( ldrw_mat[ii,jj] )           { Put the resulting matrix elements }
        end
      end;


    53: { * * *   Set a new Transformation Matrix   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the SEGment/Matrix identifier }
        if i1 < 0 then begin  b0 := false; i1 := - i1  end
                  else b0 := true;
        re.typ := intty;
        for ii := 1 to 3 do
          for jj := 1 to 4 do
            ldrw_mat[ii,jj] := FLTEVL( parm_lst );
        if b0 then re.int := DRAW$PUT_SEG_MAT( i1, ldrw_mat )
              else re.int := DRAW$PUT_MATRIX( i1, ldrw_mat );
      end;


    60: { * * *   Display a Message   * * * }
      begin
        GET_STR( s1, parm_lst, 'Message' );              { Get the string to display }
        DRAW$MESSAGE( s1 )
      end;


    61: { * * *   Get a Choice   * * * }
      begin
        GET_STR( s1, parm_lst, 'Choice' );               { Get the Choice Title }
        l1 := F_EVAL( NXT_PAR( parm_lst ) );             { Get the list of choice string }
        i1 := 0;
        while (l1.typ = doublety) and (i1 < 32) do
        begin
          i1 := i1 + 1;
          GET_STR( s2, l1, '' );                         { Get a menu entry string }
          if s2.length < 1 then WRITEV( s2, 'Choice ', i1:0 );
          NEW( stb[i1], s2.length );
          stb[i1]^ := s2
        end;
        re.typ := intty;
        re.int := DRAW$GET_CHOICE( s1, stb, i1 );
        for ii := 1 to i1 do  DISPOSE( stb[ii] );        { Free all created strings }
        sys_eoln.at^.val := log_val[ re.int < 0 ]
      end;


    62: { * * *   Select a File   * * * }
      begin
        GET_STR( s1, parm_lst, 'File' );                 { Get the Title }
        l1 := GET_LIST( parm_lst, false );               { Get the list of filter }
        i1 := 0;
        while l1.typ = doublety do
        begin                                            { Get all the filter }
          GET_STR( s2, l1, '' );
        exit if s2.length <= 0;                          { A null string stop the filter list }
          i1 := i1 + 1;
          NEW( stb[i1], s2.length );
          stb[i1]^ := s2
        end;
        if i1 = 0 then                                   { Set a Default filter "*" when required }
        begin
          NEW( stb[1], 1 );
          stb[1]^ := '*';
          i1 := 1
        end;
        GET_STR( s2, parm_lst, '' );                     { Get the default File specification }
        i2 := INTEVLDEF( parm_lst, 1 );                  { Get the default File Filter entry }
        b0 := GET_EVLFLAG( parm_lst );                   { Get the New File Mode Flag }
        { Execute the Draw Interaction Request }
        i0 := DRAW$SELECT_FILE( s1, stb, s2, s3, i2, ORD( b0 ), i1 );
        for ii := 1 to i1 do  DISPOSE( STB[ii] );      { Free the Filter list table }
        if i0 > 0 then
        begin
          re := GET_LIST( parm_lst, false );             { Get the Result list reference }
          re := SET_RESULT_LIST( re, 2 );                { Build (or use) the Resulting List }
          SET_PARM_STR( s3"address );                    { Form the result list with the string ... }
          SET_PARM_INT( i2 );                            { ... and the selected filter number }
        end
        else re.int := i0;
        sys_eoln.at^.val := log_val[ i0 < 0 ]
      end;


    63: { * * *   Send a Question and Get an Answerd   * * * }
      begin
        GET_STR( s1, parm_lst, 'YES/NO' );
        re.typ := intty;
        re.int := DRAW$GET_ANSWERD( s1 );
        sys_eoln.at^.val := log_val[ re.int < 0 ]
      end;


    64: { * * *   Get a Value   * * * }
      begin
        GET_STR( s1, parm_lst, 'Get_Value' );
        f0 := FLTEVL( parm_lst );
        f1 := FLTEVL( parm_lst );
        f2 := FLTEVLDEF( parm_lst, 0.0);
        i1 := DRAW$GET_VALUE( s1, f2, f0, f1 );
        if i1 = 1 then
        begin
          re.typ := flty;
          re.flt := f2
        end;
        sys_eoln.at^.val := log_val[ i1 < 0 ]
      end;


    65: { * * *   Get a String   * * * }
      begin
        GET_STR( s1, parm_lst, 'Get_String' );
        GET_STR( s2, parm_lst, '' );
        s3 := '';
        i1 := DRAW$GET_STRING( s1, s2, s3 );
        if i1 >= 0 then { success }
          case LENGTH( s3 ) of
            0: { re := obj_nil already done };
            1: begin
                 re.typ := charty;
                 re.ch := s3[1]
               end;
          otherwise
            re     := obj_nuls;
            re.nam := NEW_LISP_STRINGV( s3 )
          end;
        sys_eoln.at^.val := log_val[ i1 < 0 ]
      end;


    66: { * * *   Get a Point Coordinates (2D) in the DRAW Canvas   * * * }
      begin
        f0 := FLTEVLDEF( parm_lst, 0.0 );
        f1 := FLTEVLDEF( parm_lst, 0.0 );
        re := F_EVAL( NXT_PAR( parm_lst ) );
        i1 := DRAW$GET_POSITION( f0, f1 );
        if i1 = 1 then
        begin
          re := SET_RESULT_LIST( re, 2 );
          SET_PARM_SFLT( f0 );
          SET_PARM_SFLT( f1 )
        end
        else re := obj_nil;
        sys_eoln.at^.val := log_val[ i1 < 0 ]
      end;


    67: { * * *   Get A window of coordinates (2D) in the DRAW Canvas   * * * }
      begin
        f0 := FLTEVLDEF( parm_lst, 0.0 );
        f1 := FLTEVLDEF( parm_lst, 0.0 );
        f2 := FLTEVLDEF( parm_lst, 1.0 );
        f3 := FLTEVLDEF( parm_lst, 1.0 );
        re := F_EVAL( NXT_PAR( parm_lst ) );
        i1 := DRAW$GET_WINDOW( f0, f1, f2, f3 );
        sys_eoln.at^.val := obj_nil;
        if i1 = 1 then { success }
        begin
          re := SET_RESULT_LIST( re, 4 );
          SET_PARM_SFLT( f0 );
          SET_PARM_SFLT( f1 );
          SET_PARM_SFLT( f2 );
          SET_PARM_SFLT( f3 )
        end
        else re := obj_nil; { no input }
        sys_eoln.at^.val := log_val[ i1 < 0 ]
      end;


    68: { * * *   SEGment PICK   * * * }
      begin
        i1 := INTEVLDEF( parm_lst, 1 );
        i2 := INTEVLDEF( parm_lst, 1 );
        re := F_EVAL( NXT_PAR( parm_lst ) );
        i0 := DRAW$SEG_PICK( i1, i2 );
        sys_eoln.at^.val := obj_nil;
        if i0 = 1 then { success }
        begin
          re := SET_RESULT_LIST( re, 2 );
          SET_PARM_INT( i1 );
          SET_PARM_INT( i2 )
        end
        else re := obj_nil; { no input }
        sys_eoln.at^.val := log_val[ i0 < 0 ]
      end;


    69: { * * *   Line/Curve Input   * * * }
      begin
        b0 := GET_EVLFLAG( parm_lst );                   { Get the Plot flag }
        b1 := GET_EVLFLAG( parm_lst );                   { Get the stroke flag }
        re := obj_nil; 
        i1 := 0;
        i0 := DRAW$GET_CURVE( ldrw_ftb, i1, b0, b1 );    { Performs the Get Curve Interaction }
        if i0 > 0 then
        begin                                            { Build the list for the point reception }
          i2 := i1*2;
          while i2 > 0 do                                { Loop on the points }
          begin { Put the 2D points coordinates X and Y }
            re := F_CONS_FLT( lisp_real( ldrw_ftb[i2] ), re );
            i2 := i2 - 1;
            re := F_CONS_FLT( lisp_real( ldrw_ftb[i2] ), re );
            i2 := i2 - 1;
          end
        end;
        sys_eoln.at^.val := log_val[ i0 < 0 ]
      end;


    80: { * * *   Build a NEW AXIS structure   * * * }
      begin
        GET_POINT3( parm_lst, ldrw_pt1 );                { Get the U vector }
        GET_POINT3( parm_lst, ldrw_pt2 );                { Get the V vector }
        f0 := FLTEVL( parm_lst );                        { Get Length }
        f1 := FLTEVL( parm_lst );                        { Get vinf }
        f2 := FLTEVL( parm_lst );                        { Get vsup }
        i1 := INTEVLDEF( parm_lst, 0 );                  { Get ntck }
        i2 := INTEVLDEF( parm_lst, 0 );                  { Get the Axis Flags }
        re.typ := intty;
        re.int := DRAW$NEW_AXIS( ldrw_pt1, ldrw_pt2, f0, f1, f2, i1, i2 )
      end;


    81: { * * *   Build a NEW BOX structure   * * * }
      begin
        GET_POINT3( parm_lst, ldrw_pt1 );                { Get the Org }
        i1 := INTEVL( parm_lst );                        { Get ix, iy, iz }
        i2 := INTEVL( parm_lst );
        i3 := INTEVL( parm_lst );
        l1 := GET_LIST( parm_lst, true );                { Get the list of axis directive }
        l2 := GET_LIST( parm_lst, true );                { Get the list of axis shift }
        i4 := 0;
        while (l1.typ = doublety) and (i4 < 32) do
        begin
          i4 := i4 + 1; itb[i4] := INTEVL( l1 )
        end;
        i5 := 0;
        while (l2.typ = doublety) and (i5 < 32) do
        begin
          i5 := i5 + 1; ftb[i5] := FLTEVL( l2 )
        end;
        re.typ := intty;
        re.int := DRAW$NEW_BOX( ldrw_pt1, i1, i2, i3, itb, ftb, i4, i5 )
      end;


    82: { * * *   Build a NEW BOX structure (Easy method form model)  * * * }
      begin
        o1 := GET_LIST( parm_lst, true );                { Get curve(s) mini-maxi list }
        f0 := FLTEVL( parm_lst );                        { Get the org. of x axis }
        f1 := FLTEVL( parm_lst );                        { Get the org. of y axis }
        f2 := FLTEVL( parm_lst );                        { Get the size of x axis }
        f3 := FLTEVL( parm_lst );                        { Get the size of y axis }
        GET_STR( s1, parm_lst, 'X' );                    { Get the x unit }
        GET_STR( s2, parm_lst, 'Y' );                    { Get the y unit }
        i1 := INTEVLDEF( parm_lst, 0 );                  { Get the Box Schema Number }
        f4 := FLTEVL( o1 );
        f5 := FLTEVL( o1 );
        f6 := FLTEVL( o1 );
        f7 := FLTEVL( o1 );
        re.typ := intty;
        re.int := DRAW$Easy_Box_2D( f0, f1, f2, f3, f4, f5, f6, f7, s1, s2, i1 )
      end;


    83: { * * *   FREE a BOX structure   * * * }
      begin
        i1 := INTEVL( parm_lst );
        b0 := GET_EVLFLAG( parm_lst );
        DRAW$FREE_BOX( i1, b0 )
      end;


    84: { * * *   FREE all BOX in the box LIST   * * * }
      DRAW$FREE_BOX_LIST;


    85: { * * *   SET AXIS VALUE   * * * }
      begin
        i0 := INTEVL( parm_lst );                        { Get the Axis identifier }
        i1 := INTEVL( parm_lst );                        { Get the field code }
        case i1 of
          0: { Set the Flags Word }
             DRAW$SET_AXIS_FLAGS( i0, INTEVL( parm_lst ) );
          1: { Set the Ticks Configuration }
             begin
               i1 := INTEVL( parm_lst );                 { Get the number of ticks division }
               i2 := INTEVL( parm_lst );                 { Get the model number (if < 0) or the tick's key # }
               if i1 > 0 then                            { For a user tick configuration }
                 for ii := 1 to (i4 rem 8) do            { For each tick }
                 begin
                   fre[ii] := INTEVL( parm_lst );        { Get the tick Frequency }
                   knd[ii] := INTEVL( parm_lst );        { Get the tick kind # }
                   ftb[ii] := FLTEVL( parm_lst )         { Get the tick size }
                 end;
               DRAW$SET_AXIS_TICKS( i0, i1, i2, fre, knd, ftb )
             end;
          2, { Set the Ticks Value String Attributes }
          4: { Set the Unit String Attributes }
             begin
               i2 := INTEVL( parm_lst );                 { Get the Set of bits }
               o1 := F_EVAL( NXT_PAR( parm_lst ) );      { Get the list of parameters }
               i5 := i2;
               if ODD( i5 ) then f0 := FLTEVL( parm_lst ); { Get first float if required }
               i5 := i5 div 2;
               if ODD( i5 ) then f1 := FLTEVL( parm_lst ); { Get second float if required }
               i5 := i5 div 2;
               if ODD( i5 ) then f2 := FLTEVL( parm_lst ); { Get third float if required }
               i5 := i5 div 2;
               if ODD( i5 ) then f3 := FLTEVL( parm_lst ); { Get fourth float if required }
               i5 := i5 div 2;
               if ODD( i5 ) then i3 := INTEVL( parm_lst ); { Get first integer if required }
               i5 := i5 div 2;
               if ODD( i5 ) then i4 := INTEVL( parm_lst ); { Get second integer if required }
               i5 := i5 div 2;
               if ODD( i5 ) then i5 := INTEVL( parm_lst ); { Get third integer if required }

               DRAW$SET_AXIS_VALUE( i0, i1, i2, f0, f1, f2, f3, i3, i4, i5 )
             end;
          3: { Set the Unit String }
             begin
               GET_STR( s1, parm_lst, '' );
               DRAW$SET_AXIS_UNIT( i0, s1 )
             end;
        otherwise
        end
      end;


    86: { * * *   GET AXIS VALUE   * * * }
      begin
        i0 := INTEVL( parm_lst );                        { Get the Axis identifier }
        i1 := INTEVL( parm_lst );                        { Get the field code }
        case i1 of
          0: { Get the Flags }
             begin
               re.typ := intty;
               re.int := DRAW$GET_AXIS_FLAGS( i0 )
             end;
          1: { Get the Ticks Configuration }
             begin
               re := GET_LIST( parm_lst, false );
               DRAW$GET_AXIS_TICKS( i0, i2, 4, fre, knd, ftb );
               re := SET_RESULT_LIST( re, 4 );           { Prepare the Lisp result with: }
               SET_PARM_INT( i2 );                       { The number of ticks }
               for ii := 1 to 4 do                       { ... and for each defined ticks : }
               begin
                 SET_PARM_INT( fre[ii] );                { the Frequency, }
                 SET_PARM_INT( knd[ii] );                { the kind # of ticks ... }
                 SET_PARM_FLT( Lisp_Real( ftb[ii] ) )    { and its size }
               end
             end;
          2, { Get the Ticks Value String Attributes }
          4, { Get the Unit String Attributes }
          5, { Get the Axis Characteristics 1 }
          6: { Get the Axis Characteristics 2 }
             begin
               DRAW$GET_AXIS_VALUE( i0, i1, i2, f0, f1, f2, f3, i3, i4, i5 );
               i0 := i2;
               i1 := 0;
               while i0 > 0 do
               begin  if ODD( i0 ) then i1 := i1 + 1; i0 := i0 div 2  end;
               if ODD( i0 ) then
               re := GET_LIST( parm_lst, false );
               re := SET_RESULT_LIST( re, i1 );          { Prepare the Lisp result with: }
               if ODD( i2 ) then SET_PARM_FLT( lisp_real( f0 ) ); i2 := i2 div 2;
               if ODD( i2 ) then SET_PARM_FLT( lisp_real( f1 ) ); i2 := i2 div 2;
               if ODD( i2 ) then SET_PARM_FLT( lisp_real( f2 ) ); i2 := i2 div 2;
               if ODD( i2 ) then SET_PARM_FLT( lisp_real( f3 ) ); i2 := i2 div 2;
               if ODD( i2 ) then SET_PARM_INT( i3 ); i2 := i2 div 2;
               if ODD( i2 ) then SET_PARM_INT( i3 ); i2 := i2 div 2;
               if ODD( i2 ) then SET_PARM_INT( i3 )
             end;
          3: { Get the Unit String }
             begin
               DRAW$GET_AXIS_UNIT( i0, s1 );
               re     := obj_nuls;
               re.nam := NEW_LISP_STRINGV( s1 )
             end;
        otherwise
        end
      end;


    87: { * * *   PLOT AXIS   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the Axis identifier }
        GET_POINT3( parm_lst, ldrw_pt1 );                { Get the Origine }
        i2 := INTEVL( parm_lst );                        { Get the Flags }
        DRAW$PLOT_AXIS( i1, ldrw_pt1, i2 )
      end;


    88: { * * *   PLOT BOX   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the Box identifier }
        DRAW$PLOT_BOX( i1 )
      end;


    89: { * * *   OPEN BOX   * * * }
      begin
        i1 := INTEVL( parm_lst );                        { Get the Box identifier }
        DRAW$OPEN_BOX( i1 )  
      end;


    90: { * * *   CLOSE BOX   * * * }
      DRAW$CLOSE_BOX;


    91: { * * *   Conversion of Coordinates (on opened box)  * * * }
      begin
        b0 := GET_EVLFLAG( parm_lst );                   { Get the direction Flag }
        f0 := FLTEVLDEF( parm_lst, 0.0 );                { Get input x, y, z }
        f1 := FLTEVLDEF( parm_lst, 0.0 );
        f2 := FLTEVLDEF( parm_lst, 0.0 );
        re := GET_LIST( parm_lst, false );
        DRAW$CONV_BOX( b0, f0, f1, f2, f3, f4, f5 );
        re := SET_RESULT_LIST( re, 3 );                  { Build the Resulting List }
        SET_PARM_SFLT( f3 );                             { Put the resulting x/y/z values }
        SET_PARM_SFLT( f4 );
        SET_PARM_SFLT( f5 )
      end;



    99: { * * *   All Integrated Function   * * * }
      begin
        re := obj_zero;
        i0 := INTEVL( parm_lst );                        { Get the Integrated Function Id }
        case i0 of                                       { Dispatch to the required function }
           1: {   * * *   Plot Curves   * * *   }
             begin
               GET_CURVE_ATTR( parm_lst, o2, isg );
               if isg <> 0 then
               begin
                 b0 := true;
                 if isg < 0 then isg := DRAW$NEW_SEG( isg )  { Create a new segment }
                            else DRAW$UPDATE_SEG( isg )  { Update an possible existing segment }
               end
               else b0 := false;                         { When no segment Generation }

               SET_ATTR_GROUP( o2 );

               while parm_lst.typ = doublety do
               begin
                 idx := 0;
                 LIST_BLK_EVL( parm_lst, l1 );           { Init the curve list scan }
                 { Pick identifier of the curve }
                 ide := ABS( INTEVLDEF( parm_lst, 0 ) );
                 REC_ACC_SET( parm_lst, 5 );             { Get x, y and flag record location }
                 REC_GET_ACC(  1, xoff, xtyp );
                 REC_GET_ACC(  3, yoff, ytyp );
                 REC_GET_ACC( -5, foff, ftyp );

                 i0 := INTEVLDEF( parm_lst, 0 );         { Get the Ignore Curve Flag Value or Zero }
                 if i0 < 0 then i0 := 0;

                 if ide > 0 then DRAW$SET_PICKID( ide ); { Assign a pick identifier at this curve }
                 b1 := false; l2 := l1;                  { Pen up for the first point }
                 repeat
                   LIST_BLK_NEXT( o1, l2, idx );         { Get a record reference }
                   if idx > 0 then
                   begin
                     if foff >= 0 then                   { Get the Flag when used }
                     begin                               { ... and manage it }
                       iflg := INTVREC( o1.rec, foff, ftyp );
                       if (i0 <> 0) and (iflg <> i0) then iflg := 0
                     end else iflg := 1;

                     if iflg > 0 then
                     begin                               { For any valid point/element } 
                       f0 := SFLTVREC( o1.rec, xoff, xtyp );     { Get the point coordinates }
                       f1 := SFLTVREC( o1.rec, yoff, ytyp );
                       if (f0 > joker) and (f1 > joker) then     { ... and plot it if required }
                       begin  DRAW$PLOT( f0, f1, b1 ); b1 := true  end
                     end
                   end
                 until idx <= 0;                         { Loop on all the curve points }
                 DRAW$PLOT( 0.0, 0.0, false )            { Set the pen up state }
               end { While parm_lst };                   { Loop on all Curve to plot }

               if b0 then                                { When the segment managment is enabled }
               begin                                     { Close the Segment }
                 DRAW$SEG_END;
                 DRAW$SEG_ATTR( isg, 2, 1, 2, 0.0 )      { Set pick detectable normal and visible }
               end;
               re.int := isg
             end;

           2: {   * * *   Plot the Sigma   * * *   }
             begin
               GET_CURVE_ATTR( parm_lst, o2, isg );

               if isg <> 0 then                          { When the segment managment is used }
               begin b0 := true;
                 if isg < 0 then DRAW$NEW_SEG( isg )     { Create a new segment }
                            else DRAW$UPDATE_SEG( isg )  { Update an possible existing segment }
               end else b0 := false;                     { When the segment management is disable }

               SET_ATTR_GROUP( o2 );

               { Set the curve sigma color and thinkness }
               if ldrw_sgdf_color > 0 then DRAW$COLOR( ldrw_sgdf_color );
               if ldrw_sgdf_scale > 0.0 then DRAW$LINE_ATTR( 1, ldrw_sgdf_scale );

               DRAW$OUT_MODE( PLOT_LINES );              { Set the Multi-lines mode }

               while parm_lst.typ = doublety do          { Loop on all curve }
               begin
                 idx := 0;
                 LIST_BLK_EVL( parm_lst, l1 );           { Init the Points Scan on the specified curve }
                 { Pick identifier of the curve }
                 ide := ABS( INTEVLDEF( parm_lst, 0 ) ); { Get the related curve pick identifier }
                 REC_ACC_SET( parm_lst, 5 );             { Get x, y, flg, sigx, sigy offsets and types }
                 REC_GET_ACC(  1,  xoff,  xtyp );
                 REC_GET_ACC( -2, sxoff, sxtyp );
                 REC_GET_ACC(  3,  yoff,  ytyp );
                 REC_GET_ACC( -4, syoff, sytyp );
                 REC_GET_ACC( -5,  foff,  ftyp );

                 i0 := INTEVLDEF( parm_lst, 0 );
                 if i0 <= 0 then i0 := 0;

                 if (sxoff >= 0) or (syoff >= 0) then
                 begin
                   if ide > 0 then DRAW$SET_PICKID( ide ); { Assign a pick identifier at this curve }
                   b1 := false; l2 := l1;                { Pen up for the first point }
                   repeat
                     LIST_BLK_NEXT( o1, l2, idx );       { Get one curve point record/element }
                     if idx > 0 then
                     begin
                       if foff >= 0 then                 { Get the point Flag }
                       begin
                         iflg := INTVREC( o1.rec, foff, ftyp );
                         if (i0 <> 0) and (iflg <> i0) then iflg := 0
                       end else iflg := 1;               { End of Curve Reached }

                       if iflg > 0 then                  { For a valid point }
                       begin                             { Get the point coordinates }
                         f0 := SFLTVREC( o1.rec, xoff, xtyp );
                         f1 := SFLTVREC( o1.rec, yoff, ytyp );
                         if sxoff >= 0 then              { Get the X sigma when defined and plot it }
                         begin
                           f2 := SFLTVREC( o1.rec, sxoff, sxtyp );
                           if (f0 > joker) and (f1 > joker) and (f2 > joker) then
                           begin  DRAW$PLOT( f0 - f2, f1, b1 );
                                  DRAW$PLOT( f0 + f2, f1, true  ); b1 := true
                           end
                         end;

                         if syoff >= 0 then              { Get the Y sigma when defined and plot it }
                         begin
                           f3 := SFLTVREC( o1.rec, syoff, sytyp );
                           if (f0 > joker) and (f1 > joker) and (f3 > joker) then
                           begin  DRAW$PLOT( f0, f1 - f3, b1 );
                                  DRAW$PLOT( f0, f1 + f3, true  ); b1 := true
                           end
                         end
                       end
                     end
                   until idx <= 0;                       { Loop on all the curve point }
                   DRAW$PLOT( 0.0, 0.0, false )          { Set the pen up state }
                 end
               end { while parm_lst };                   { Loop on all Curves }

               if b0 then
               begin
                 DRAW$SEG_END;
                 DRAW$SEG_ATTR( isg, 2, 1, 2, 0.0 )        { Set pick detectable normal and visible }
               end;
               re.int := isg
             end;

           3: {   * * *   Plot a list of vertical marker   * * *   }
             begin
               GET_CURVE_ATTR( parm_lst, o2, isg );

               if isg <> 0 then
               begin  b0 := true;
                 if isg < 0 then isg := DRAW$NEW_SEG( isg ) { Create a new segment }
                            else DRAW$UPDATE_SEG( isg )  { Update an possible existing segment }
               end else b0 := false;

               SET_ATTR_GROUP( o2 );

               while parm_lst.typ = doublety do
               begin
                 idx := 0;
                 LIST_BLK_EVL( parm_lst, l1 );           { Init the Scan on specified data list }
                 ide := INTEVLDEF( parm_lst, 0 );        { Pick identifier of the marker }
                 b2 := (ide < 0); ide := ABS( ide );     { Get incr ident flag }
                 REC_ACC_SET( parm_lst, 3 );             { Get x, y, flg }
                 REC_GET_ACC(  1, xoff, xtyp );          { Get X location }
                 REC_GET_ACC( -2, yoff, ytyp );          { Skip one field in attr. }
                 REC_GET_ACC( -3, foff, ftyp );          { Get flag location }

                 f1 := SFLTEVL( parm_lst );              { The current Y value }
                 f3 := SFLTEVL( parm_lst );              { The current vertical high }

                 DRAW$OUT_MODE( PLOT_LINES );            { Set the Multi-lines mode }

                 b1 := false; l2 := l1;                  { Pen up for the first point }
                 repeat
                   LIST_BLK_NEXT( o1, l2, idx );         { Get the point/element } 
                   if idx > 0 then
                   begin
                     if foff >= 0 then iflg := INTVREC( o1.rec, foff, ftyp )
                                  else iflg := 1;
                     if iflg > 0 then                    { For a valid point/element }
                     begin
                       f0 := SFLTVREC( o1.rec, xoff, xtyp );     { Get the abscisse }
                       if (f0 > joker) and (f1 > joker) and (f2 > joker) then
                       begin  DRAW$PLOT( f0, f1 - f3, b1 );
                              DRAW$PLOT( f0, f1 + f3, true  ); b1 := true
                       end;
                       { Assign a pick identifier at this curve }
                       if b1 then
                       begin  if b2 then ide := ide + 1; if ide > 0 then DRAW$SET_PICKID( ide )  end
                     end
                   end
                 until idx <= 0;                         { Loop on all the curve point }
                 DRAW$PLOT( 0.0, 0.0, false )            { Set the pen up state }
               end { While parm_lst };

               if b0 then
               begin
                 DRAW$SEG_END;
                 DRAW$SEG_ATTR( isg, 2, 1, 2, 0.0 )      { Set pick detectable normal and visible }
               end;
               re.int := isg
             end;

           4: {   * * *   Plot some curve from the same list   * * *   }
             begin
               while parm_lst.typ = doublety do
               begin { Loop on all list }
                 idx := 0;
                 LIST_BLK_EVL( parm_lst, l1 );           { Init the curve list scan }
                 REC_ACC_SET( parm_lst, 5 );             { Get x, y and flag record location }
                 REC_GET_ACC(  1, xoff, xtyp );
                 REC_GET_ACC(  3, yoff, ytyp );
                 REC_GET_ACC(  5, foff, ftyp );

                 o2  := GET_LIST( parm_lst, true );      { Get "sequ" LISP expression }
                 o3  := obj_nil;                         { Initialize the list evaluation result }

                 i0 :=  0;                               { Set for the begin of list }
                 l2 := l1;
                 repeat { Loop inside a list }
                   LIST_BLK_NEXT( o1, l2, idx );         { Get the current point }
                   if idx > 0 then
                   begin
                     iflg := INTVREC( o1.rec, foff, ftyp );
                     if (i0 <> iflg) and (iflg > 0) then
                     begin
                       if i0 <> 0 then
                       begin { End of a previous curve }
                         DRAW$PLOT( 0.0, 0.0, false );   { Set the pen up state }
                         if b0 then
                         begin
                           DRAW$SEG_END;                 { Set end of segment }
                           DRAW$SEG_ATTR( isg, 2, 1, 2, 0.0 )    { Set pick detectable }
                         end
                       end;
                       i0 := iflg;
                       currobj := o2.db^.cdr;
                       SET_PARM_INT( iflg );             { Set the flag value as first parm. }
                       { Execute the user sequence to set box, attributs ... }
                       o3 := F_EVAL( o2 );               { Execute the sequence }
                       if o3.typ = doublety then         { When the result is a list }
                       begin { When a valid new curve must be plotted }
                         isg := INTEVLDEF( o3, 0 );      { Get the segment spc and manage it }
                         if isg <> 0 then
                         begin
                           b0 := true;
                           { Create or Update the segment }
                           if isg < 0 then DRAW$NEW_SEG( isg )
                                      else DRAW$UPDATE_SEG( isg )
                         end
                         else b0 := false;
                         { Set the pick identifier of the curve }
                         ide := ABS( INTEVLDEF( parm_lst, 0 ) );
                         if ide > 0 then DRAW$SET_PICKID( ide );
                         b1 := false
                       end
                       else iflg := 0
                     end;

                     if iflg > 0 then
                     begin  f0 := SFLTVREC( o1.rec, xoff, xtyp );
                            f1 := SFLTVREC( o1.rec, yoff, ytyp )
                     end;
                     if (f0 > joker) and (f1 > joker) then
                     begin  DRAW$PLOT( f0, f1, b1 ); b1 := true  end
                   end
                 until idx <= 0;                         { Loop on all the curve point }
                 DRAW$PLOT( 0.0, 0.0, false )            { Set the pen up state }
               end                                       { While parm_lst: Loop on Curves }
             end;

           5:  {   * * *   Plot some sigma of curve from the same list   * * *   }
             begin
               re := obj_zero;
               while parm_lst.typ = doublety do
               begin
                 idx := 0;
                 LIST_BLK_EVL( parm_lst, l1 );

                 REC_ACC_SET( parm_lst, 5 );              { Get x, y, flg, sigx, sigy }
                 REC_GET_ACC(  1,  xoff,  xtyp );
                 REC_GET_ACC( -2, sxoff, sxtyp );
                 REC_GET_ACC(  3,  yoff,  ytyp );
                 REC_GET_ACC( -4, syoff, sytyp );
                 REC_GET_ACC(  5,  foff,  ftyp );

                 o2  := GET_LIST( parm_lst, true );       { Get "sequ" LISP expression }
                 o3  := obj_nil;                          { Initialize the o3 () result }

                 DRAW$OUT_MODE( PLOT_LINES );             { set the Multi line mode }

                 if (sxoff >= 0) or (syoff >= 0) then
                 begin { Defined sigma }
                   i0 := 0; l2 := l1;                     { Set for the begin of list }
                   repeat                                 { Loop inside a list }
                     LIST_BLK_NEXT( o1, l2, idx );
                     if idx > 0 then
                     begin
                       iflg := INTVREC( o1.rec, foff, ftyp );
                       if (i0 <> iflg) and (iflg > 0) then
                       begin                              { First point of a new curve }
                         if i0 <> 0 then
                         begin { End of a previous curve }
                           DRAW$PLOT( 0.0, 0.0, false );  { Set the pen up state }
                           if b0 then
                           begin
                             DRAW$SEG_END;                { Set end of segment }
                             DRAW$SEG_ATTR( isg, 2, 1, 2, 0.0 )   { Set pick detectable }
                           end
                         end;
                         i0 := iflg;
                         currobj := o2.db^.cdr;
                         SET_PARM_INT( iflg );            { Set the flag value as first parm. }
                         { Execute the user sequence to set box, attributs ... }
                         o3 := F_EVAL( o2 );
                         if o3.typ = doublety then
                         begin { When a valid new curve must be plotted }
                           isg := INTEVLDEF( o3, 0 );
                           if isg <> 0 then
                           begin
                             b0 := true;
                             { Create or update the segment }
                             if isg < 0 then DRAW$NEW_SEG( isg )
                                        else DRAW$UPDATE_SEG( isg )
                           end
                           else b0 := false;
                           { Set the pick identifier of the curve }
                           ide := INTEVLDEF( parm_lst, 0 );
                           b2 := (ide < 0);               { Get incr ident flag }
                           ide := ABS( ide );
                           if ldrw_sgdf_color > 0 then DRAW$COLOR( ldrw_sgdf_color );
                           if ldrw_sgdf_scale > 0.0 then
                           begin  DRAW$OUT_MODE( 1 ); DRAW$LINE_ATTR( 1, ldrw_sgdf_scale )  end;
                           DRAW$SET_PICKID( ide );
                           b1 := false
                         end else iflg := 0
                       end;

                       if iflg > 0 then
                       begin
                         f0 := SFLTVREC( o1.rec, xoff, xtyp ); f1 := SFLTVREC( o1.rec, yoff, ytyp );
                         if sxoff >= 0 then
                         begin
                           f2 := SFLTVREC( o1.rec, sxoff, sxtyp );
                           if (f0 > joker) and (f1 > joker) and (f2 > joker) then
                           begin  DRAW$PLOT( f0 - f2, f1, false ); DRAW$PLOT( f0 + f2, f1, true  )  end
                         end;

                         if syoff >= 0 then
                         begin
                           f3 := SFLTVREC( o1.rec, syoff, sytyp );
                           if (f0 > joker) and (f1 > joker) and (f3 > joker) then
                           begin  DRAW$PLOT( f0, f1 - f3, false ); DRAW$PLOT( f0, f1 + f3, true  )  end
                         end;
                         { Assign a pick identifier at this curve }
                         if b1 then
                         begin  if b2 then ide := ide + 1; DRAW$SET_PICKID( ide )  end
                       end
                     end
                   until idx <= 0; { Loop on all the curve point }
                   DRAW$PLOT( 0.0, 0.0, false );          { Set the pen up state }
                 end
               end { While parm_lst };

               if b0 then
               begin
                 DRAW$SEG_END;
                 DRAW$SEG_ATTR( isg, 2, 1, 2, 0.0 )       { Set pick detectable normal and visible }
               end;
               re.int := isg
             end;

        otherwise
          EXEC_ERROR( mdnam, 1299, e_fatal )
        end
      end;



  otherwise
    EXEC_ERROR( mdnam, 1299, e_fatal )
  end;
  LISP$_DRAW := re
end LISP$_DRAW;

end.
