#
# make file for E-LISP
#

include $(PAS_DIR)/system.make

PAS	=	$(PAS_BIN)/pcmp

oDir	=	.
Bin	=	.
Src	=	.
# Dsrc	=	../Draw_Library

libDirs = -L/usr/local/lib

# incDirs	=	-I../include
incDirs =

LIBS	=	-ldraw -lcpas -lm
#LIBS	=       -lcpas -lm

C_FLAGS = -O

P_FLAGS =

L_FLAGS =


SRCP =\
	$(Src)/lisp_main.pas $(Src)/lisp_init.pas \
	$(Src)/lisp_alfr.pas $(Src)/lisp_error.pas \
	$(Src)/lisp_io.pas $(Src)/lisp_math.pas \
	$(Src)/lisp_dmp.pas \
	$(Src)/lisp_routines.pas $(Src)/lisp_sysca.pas \
	$(Src)/lisp_expr.pas $(Src)/lisp__ser.pas \
	$(Src)/lisp__sys.pas $(Src)/lisp__draw.pas \
	$(Src)/lisp__lsq.pas $(Src)/lsq_loader.pas \
	$(Src)/lsq_comput.pas

SRCS =\
	$(Src)/lisp_main.c $(Src)/lisp_init.c $(Src)/lisp_alfr.c \
	$(Src)/lisp_error.c $(Src)/lisp_io.c $(Src)/lisp_math.c \
	$(Src)/lisp_dmp.c \
	$(Src)/lisp_routines.c $(Src)/lisp_sysca.c $(Src)/lisp_expr.c \
	$(Src)/lisp__ser.c $(Src)/lisp__sys.c $(Src)/lisp__draw.c \
	$(Src)/lisp__lsq.c $(Src)/lsq_loader.c $(Src)/lsq_comput.c

EXOBJS =\
	$(oDir)/lisp_main.o $(oDir)/lisp_init.o \
	$(oDir)/lisp_alfr.o $(oDir)/lisp_error.o \
	$(oDir)/lisp_io.o $(oDir)/lisp_math.o \
	$(oDir)/lisp_dmp.o \
	$(oDir)/lisp_routines.o $(oDir)/lisp_sysca.o \
	$(oDir)/lisp_expr.o $(oDir)/lisp__ser.o \
	$(oDir)/lisp__sys.o $(oDir)/lisp__draw.o \
	$(oDir)/lisp__lsq.o $(oDir)/lsq_loader.o \
	$(oDir)/lsq_comput.o


ALLOBJS =	$(EXOBJS)
ALLBIN  =	$(Bin)/lisp
ALLTGT  =	$(Bin)/lisp


# User defines:

#@# Targets follow ---------------------------------

all:	$(ALLTGT)

objs:	$(ALLOBJS)

cleanobjs:
	rm -f $(SRCS); rm -f $(ALLOBJS)

cleanbin:
	rm -f $(ALLBIN)

clean:	cleanobjs cleanbin

cleanall:	cleanobjs cleanbin

#@# User Targets follow ---------------------------------


#@# Dependency rules follow -----------------------------

$(Bin)/lisp: $(EXOBJS)
	$(CC) -o $(Bin)/lisp $(L_FLAGS) $(EXOBJS) $(incDirs) $(libDirs) $(LIBS)

$(oDir)/lisp_main.o: lisp_main.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_main.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_main.c

$(oDir)/lisp_init.o: lisp_init.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_init.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_init.c

$(oDir)/lisp_alfr.o: lisp_alfr.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_alfr.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_alfr.c

$(oDir)/lisp_error.o: lisp_error.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_error.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_error.c

$(oDir)/lisp_io.o: lisp_io.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_io.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_io.c

$(oDir)/lisp_math.o: lisp_math.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_math.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_math.c

$(oDir)/lisp_routines.o: lisp_routines.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_routines.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_routines.c

$(oDir)/lisp_sysca.o: lisp_sysca.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_sysca.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_sysca.c

$(oDir)/lisp_expr.o: lisp_expr.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_expr.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_expr.c

$(oDir)/lisp_dmp.o: lisp_dmp.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp_dmp.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp_dmp.c

$(oDir)/lisp__ser.o: lisp__ser.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp__ser.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp__ser.c

$(oDir)/lisp__sys.o: lisp__sys.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp__sys.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp__sys.c

#$(oDir)/lisp__pdraw.o: lisp__pdraw.pas
#	$(PAS) $(P_FLAGS) $(Src)/lisp__pdraw.pas
#	$(CC) $(C_FLAGS) $(incDirs) -c lisp__pdraw.c

$(oDir)/lisp__draw.o: lisp__draw.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp__draw.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp__draw.c

$(oDir)/lisp__lsq.o: lisp__lsq.pas
	$(PAS) $(P_FLAGS) $(Src)/lisp__lsq.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lisp__lsq.c

$(oDir)/lsq_loader.o: lsq_loader.pas
	$(PAS) $(P_FLAGS) $(Src)/lsq_loader.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lsq_loader.c

$(oDir)/lsq_comput.o: lsq_comput.pas
	$(PAS) $(P_FLAGS) $(Src)/lsq_comput.pas
	$(CC) $(C_FLAGS) $(incDirs) -c lsq_comput.c
#