//=======================================================================
//@V@:Note: This file generated by vgen V1.04 (12:03:15 22 Jun 1998).
//	sboxcnv.cpp:	Source for sboxOGLCanvasPane class
//=======================================================================
/*
 * Spinning box.  This program is in the public domain.
 *
 * Brian Paul
 */

#include "sboxcnv.h"

#include <math.h>
#include <stdlib.h>

static GLfloat Xrot, Xstep;
static GLfloat Yrot, Ystep;
static GLfloat Zrot, Zstep;
static GLfloat Step = 5.0;
static GLfloat Scale = 1.0;
static GLuint Objectg;

static GLuint 
make_object(void)
{
  GLuint list;

  list = glGenLists(1);

  glNewList(list, GL_COMPILE);

  glBegin(GL_LINE_LOOP);
  glVertex3f(1.0, 0.5, -0.4);
  glVertex3f(1.0, -0.5, -0.4);
  glVertex3f(-1.0, -0.5, -0.4);
  glVertex3f(-1.0, 0.5, -0.4);
  glEnd();

  glBegin(GL_LINE_LOOP);
  glVertex3f(1.0, 0.5, 0.4);
  glVertex3f(1.0, -0.5, 0.4);
  glVertex3f(-1.0, -0.5, 0.4);
  glVertex3f(-1.0, 0.5, 0.4);
  glEnd();

  glBegin(GL_LINES);
  glVertex3f(1.0, 0.5, -0.4);
  glVertex3f(1.0, 0.5, 0.4);
  glVertex3f(1.0, -0.5, -0.4);
  glVertex3f(1.0, -0.5, 0.4);
  glVertex3f(-1.0, -0.5, -0.4);
  glVertex3f(-1.0, -0.5, 0.4);
  glVertex3f(-1.0, 0.5, -0.4);
  glVertex3f(-1.0, 0.5, 0.4);
  glEnd();

  glEndList();

  return list;
}

static void 
reshape(int width, int height)
{
  glViewport(0, 0, (GLint) width, (GLint) height);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-1.0, 1.0, -1.0, 1.0, 5.0, 15.0);
  glMatrixMode(GL_MODELVIEW);
}
static void 
draw(void)
{
  glClear(GL_COLOR_BUFFER_BIT);

  glPushMatrix();

  glTranslatef(0.0, 0.0, -10.0);
  glScalef(Scale, Scale, Scale);
  if (Xstep) {
    glRotatef(Xrot, 1.0, 0.0, 0.0);
  } else if (Ystep) {
    glRotatef(Yrot, 0.0, 1.0, 0.0);
  } else {
    glRotatef(Zrot, 0.0, 0.0, 1.0);
  }

  glCallList(Objectg);

  glPopMatrix();

}

static void 
idle(void)
{
  Xrot += Xstep;
  Yrot += Ystep;
  Zrot += Zstep;

  if (Xrot >= 360.0) {
    Xrot = Xstep = 0.0;
    Ystep = Step;
  } else if (Yrot >= 360.0) {
    Yrot = Ystep = 0.0;
    Zstep = Step;
  } else if (Zrot >= 360.0) {
    Zrot = Zstep = 0.0;
    Xstep = Step;
  }
  draw();
  
}



//===================>>> sboxOGLCanvasPane::sboxOGLCanvasPane <<<====================
  sboxOGLCanvasPane::sboxOGLCanvasPane(unsigned int vGLmode, PaneType pt)
  {
    initDone = 0;
  }

//===================>>> sboxOGLCanvasPane::~sboxOGLCanvasPane <<<====================
  sboxOGLCanvasPane::~sboxOGLCanvasPane()
  {
  }

//======================>>> sboxOGLCanvasPane::TimerAnimate <<<========================
  void sboxOGLCanvasPane::TimerAnimate(void)
  {
    // **** Called by CmdWindow AuxTimer for animation.

    vglMakeCurrent();  // Typically done here
    idle();
    vglFlush();  // After you draw, typically flush
    

  }
//======================>>> sboxOGLCanvasPane::graphicsInit <<<========================
  void sboxOGLCanvasPane::graphicsInit(void)
  {
    vBaseGLCanvasPane::graphicsInit();	// Always call the superclass first!

    // **** Your OpenGL initialization code goes here!
  Objectg = make_object();
  glCullFace(GL_BACK);
  glDisable(GL_DITHER);
  glShadeModel(GL_FLAT);

  glColor3f(1.0, 1.0, 1.0);

  Xrot = Yrot = Zrot = 0.0;
  Xstep = Step;
  Ystep = Zstep = 0.0;
  reshape(300,300);



    initDone = 1;
  }
//======================>>> sboxOGLCanvasPane::HPage <<<========================
  void sboxOGLCanvasPane::HPage(int shown, int top)
  {
    vBaseGLCanvasPane::HPage(shown, top);
  }

//======================>>> sboxOGLCanvasPane::VPage <<<========================
  void sboxOGLCanvasPane::VPage(int shown, int top)
  {
    vBaseGLCanvasPane::VPage(shown, top);
  }

//=======================>>> sboxOGLCanvasPane::HScroll <<<======================
  void sboxOGLCanvasPane::HScroll(int step)
  {
    vBaseGLCanvasPane::HScroll(step);
  }

//======================>>> sboxOGLCanvasPane::VScroll <<<======================
  void sboxOGLCanvasPane::VScroll(int step)
  {
    vBaseGLCanvasPane::VScroll(step);
  }

//======================>>> sboxOGLCanvasPane::MouseDown <<<======================
  void sboxOGLCanvasPane::MouseDown(int X, int Y, int button)
  {
    vBaseGLCanvasPane::MouseDown(X,Y,button);
  }

//========================>>> sboxOGLCanvasPane::MouseUp <<<======================
  void sboxOGLCanvasPane::MouseUp(int X, int Y, int button)
  {
    vBaseGLCanvasPane::MouseUp(X,Y,button);
  }

//======================>>> sboxCanvasPane::MouseMove <<<======================
  void sboxOGLCanvasPane::MouseMove(int x, int y, int button)
  {
    vBaseGLCanvasPane::MouseMove(x,y,button);
  }

//=========================>>> sboxOGLCanvasPane::Redraw <<<======================
  void sboxOGLCanvasPane::Redraw(int x, int y, int w, int h)
  {
    static int inRedraw = 0;

    if (inRedraw || !initDone)  // Don't draw until initialized
        return;

    inRedraw = 1;  // Don't allow recursive redraws.

    vglMakeCurrent();  // Typically done here

    // *** Your drawing code typically goes here. You may
    // insert it here, or just call a drawing routine.

    draw();
    vglFlush();  // After you draw, typically flush

    inRedraw = 0;  // Out of Redraw

  }

//======================>>> sboxOGLCanvasPane::Resize <<<======================
  void sboxOGLCanvasPane::Resize(int w, int h)
  {
    vBaseGLCanvasPane::Resize(w,h);
    reshape(w,h);
  }

