//===============================================================
// vPopMenu.cxx - vPopupMenu class functions - X
//
// Copyright (C) 1995-1999  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================


#include <v/vpopmenu.h>
#include <v/vwindow.h>
#include <v/vutil.h>


#include <stdlib.h>
#include <v/vctlclrs.h>

extern "C"
{
#include <X11/Core.h>
#include <X11/Shell.h>

#ifndef Athena

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/Separator.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>		// for checked items. cfb
#include <Xm/Label.h>
#define setLabel(x,y) XmString x = XmStringCreateLocalized(y);
#define freeLabel(x) XmStringFree(x);
#define Ncallback XmNactivateCallback
#define Nsensitive XmNsensitive
#define Nlabel XmNlabelString

    extern XEvent* VGlobalButtonPressedEvent;	// nasty but easy

#endif

}


// Define static data of the class

#define menux_width 9
#define menux_height 9

static char menux_bits[] = {
   0xff, 0x01, 0x83, 0x01, 0x45, 0x01, 0x29, 0x01, 0x11, 0x01, 0x29, 0x01,
   0x45, 0x01, 0x83, 0x01, 0xff, 0x01};
static Pixmap menux_bitmap = 0;		// the check for menus

#define menuclr_width 9
#define menuclr_height 9
static char menuclr_bits[] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
static Pixmap menuclr_bitmap = 0;	// the no-check for menus

#define rtarrow_width 9
#define rtarrow_height 9
static char rtarrow_bits[] = {
   0x03, 0x00, 0x0f, 0x00, 0x3f, 0x00, 0xff, 0x00, 0xff, 0x01, 0xff, 0x00,
   0x3f, 0x00, 0x0f, 0x00, 0x03, 0x00};
static Pixmap rtarrow_bitmap = 0;	// right arrow for submenus

static char curLbl[100];	// for fixed labels
static char _Mnemonic;

//==================>>> vPopupMenu::vPopupMenu <<<===========================
  vPopupMenu::vPopupMenu(VCONST vMenu* menu, VCONST vWindow* pWin)
  {
#ifndef Athena
    int i;

    // set up menus -----------------------------------------------

    // SysDebug(Constructor,"vPopupMenu::vPopupMenu() constructor\n")

    
    _parentWin = pWin;

    _nextMenuButton = 0;	// no menus defined so far

    for (i = 0 ; i < MAX_PMENU_BUTTONS ; ++i)
      {
	_mb[i].label = 0;	// null out menu button array
	_mb[i].XMenuButton = 0;
	_mb[i].SubMenu = 0;
	_mb[i].mInfo = 0;
      }

    _mb[0].label = "";
    _mb[0].SubMenu = menu;
    _nextSubMenu =		// we will start submenus here
    _nextMenuButton = 1;	// this many menus defined
    _topLevelMenu = 0;
    _popParent = 0;

    initialize();

#endif
  }

//==================>>> vPopupMenu::vPopupMenu <<<===========================
  vPopupMenu::vPopupMenu(const vPopupMenu& m)
  {

    vSysError("V Semantics do not allow copy constructors.");
  }

//====================>>> vPopupMenu::~vPopupMenu <<<=======================
  vPopupMenu::~vPopupMenu()			// destructor
  {

    SysDebug(Destructor,"vPopupMenu::~vPopupMenu() destructor\n")

#ifndef Athena
    if (_topLevelMenu != 0)			// delete top + childern
	XtDestroyWidget(_topLevelMenu);
    if (_popParent != 0)			// delete container
	XtDestroyWidget(_popParent);
    
    for (int i = 0 ; i < _nextSubMenu ; ++i)	// all menus
      {
	delete _mb[i].mInfo;		// free the space
      }
#endif
  }

//======================>>> vPopupMenu::isImplemented <<<========================
  int vPopupMenu::isImplemented()
  {
#ifndef Athena
    return 1;
#else
    return 0;
#endif
  }

//======================>>> vPopupMenu::fixLabel <<<========================
  void vPopupMenu::fixLabel(const char* lbl, const char* key) VCONST
  {
#ifndef Athena
    // copy label to global curLbl

    const char* cp;
    int ix = 0;

    _Mnemonic = 0;

    curLbl[0] = ' '; curLbl[1] = ' '; ix = 2;	// to add * checkmark

    for (cp = lbl ; *cp && ix < 99 ; ++cp)	// Scan label
      {
 	if (*cp != '&')
	  {
	    curLbl[ix++] = *cp;
	  }
	else
	    _Mnemonic = *(cp+1);
      }

    curLbl[ix] = 0;		// finish off
#endif
  }

//======================>>> vPopupMenu::doAddMenu <<<========================
  void vPopupMenu::doAddMenu(int id, Widget parent)
  {
#ifndef Athena
    // create a button on the menu button bar

    _mb[id].XPopUp = parent;		// a submenu
    _mb[id].XMenuButton = parent;		// a submenu

    // loop through the list

    _mb[id].mInfo = 0;			// empty list so far

    vMenu* item = _mb[id].SubMenu;	// The first item in list

    PMenuInfo* info;			// for current info
    for (int ix = 0 ; item[ix].label != 0 ; ++ix)
      {
	info = new PMenuInfo;		// new space or current tem
	info->NxtInfo = _mb[id].mInfo;	// add to front of list
	_mb[id].mInfo = info;		// fix front pointer
	info->ItemIndex = ix;		// index to item list
	info->SubMenuIndex = 0;		// no submenu normally

	if (item[ix].menuId == M_Line)
	  {
	    info->WItem = XtVaCreateManagedWidget(
	        "-",			// widget name
	        xmSeparatorWidgetClass,	// widget class 
	        _mb[id].XPopUp,		// parent widget
	        NULL);			// argument list
	  }
	else if (item[ix].SubMenu != 0)	// a submenu
	  {
	    if(_nextSubMenu >= MAX_PMENU_BUTTONS)
	      {
		SysDebug(BadVals,"Too many submenus!\n");
		continue;
	      }
	    fixLabel(item[ix].label);
	    setLabel(tmp,curLbl);

	    // Create a pulldown for pullright

	    info->WItem =  XmCreatePulldownMenu(_mb[id].XPopUp,
		"vPullRight",0,0);
	
	    // Create the cascade button

	    _mb[id].XMenuButton = XtVaCreateManagedWidget(
	    	"vMenuButton",				// name for widget
		xmCascadeButtonWidgetClass,		// widget class 
//		xmPushButtonWidgetClass,		// widget class 
	        _mb[id].XPopUp,				// parent widget
		Nlabel, tmp,				// display name
		XmNsubMenuId,info->WItem,
		XmNmnemonic, _Mnemonic,
		NULL);					// argument list

	    freeLabel(tmp);

	    // we will create a submenu
	    // copy the definitions, track the new index

	    int sub = _nextSubMenu++;	// get our index, bump for next time

	    _mb[sub].label = item[ix].label;
	    _mb[sub].XMenuButton = 0;
	    _mb[sub].SubMenu = item[ix].SubMenu;
	    info->SubMenuIndex = sub;		// no submenu normally
	    // Now, recursively call doAddMenu with the submenu

	    doAddMenu(sub,info->WItem);
	  }
	else
	  {
	    // create the item widget

	    fixLabel(item[ix].label, item[ix].keyLabel);
//
//@@@ Note: we don't yet support accelerators on Motif -- we
// have to convert the X keycode to a Motif "Alt<key>X" format...
//
// documentation says popups do not support accelerators.  cfb

	    // different check set, see below. cfb
//	    if (item[ix].checked)	// was it checked?
//		curLbl[0] = '*';	// flaky checks

	    setLabel(tmp,curLbl);

	    info->WItem = XtVaCreateManagedWidget(
		item[ix].label,
	        xmToggleButtonWidgetClass,	// widget class toggle button
	        _mb[id].XPopUp,		// parent widget
		Nlabel,tmp,	// item[ix].label, // the label on the item
		Nsensitive,item[ix].sensitive,  // if sensitive
		XmNtoggleMode, XmTOGGLE_BOOLEAN,	// only true/false
		XmNfillOnSelect,0,		// leave background when checked
		XmNindicatorType,XmN_OF_MANY,	// check box not radio button
		XmNindicatorOn,XmINDICATOR_NONE,	// check mark for indicator
		XmNdetailShadowThickness, 0,	// only check mark, no shadow
		XmNshadowThickness,1,
		XmNmnemonic, _Mnemonic,	// mnemonic added 22-jun-2002
	        NULL);			// argument list

	    if (item[ix].checked)	// was it checked?
	      {
		XtVaSetValues(info->WItem,	// to this menu item
			XmNindicatorOn,
			XmINDICATOR_CHECK,	// check mark for indicator
			XmNset,			// set the toggle button
			XmSET,		// 
			NULL);
	      }

//	    info->WItem = XtVaCreateManagedWidget(
//		item[ix].label,
//	        xmPushButtonWidgetClass,	// widget class 
//	        _mb[id].XPopUp,		// parent widget
//		Nlabel,tmp,	// item[ix].label, // the label on the item
//		Nsensitive,item[ix].sensitive,  // if sensitive
//		XmNfillOnSelect,1,
//		XmNindicatorOn,0,
//		XmNshadowThickness,1,
//		XmNindicatorType,XmN_OF_MANY,
//	        NULL);			// argument list
	
	    // and add the call back for each item
	    freeLabel(tmp);

	    // different callback for togglebuttons
	    XtAddCallback(info->WItem,
	        XmNvalueChangedCallback, CPmenuCB, (XtPointer)this);
//	    XtAddCallback(info->WItem,
//	        Ncallback, CPmenuCB, (XtPointer)this);
	  }
      }
#endif
  }

//====================>>> vPopupMenu::GetValue <<<======================
  int vPopupMenu::GetValue(ItemVal id) VCONST
  {
#ifndef Athena
    // scan all menus in this window to retrieve the what value
    // then scan button bar if not found

    vMenu* item;

    // Search all menus in this list
    for (int ix = 0 ; ix < _nextSubMenu ; ++ix)
      {
	PMenuInfo* info;			// for current info

	// scan the list of info for each menu entry

	for (info = _mb[ix].mInfo ; info != 0 ; info = info->NxtInfo)
	  {
	    item = _mb[ix].SubMenu;	// The current item in list
	    // see if its menuId is the same as the one we are setting
	    if (item[info->ItemIndex].menuId == id)
	      {
		// Ah Ha! We found the value we want
		return item[info->ItemIndex].checked;
	      }
	  }
      }
#endif
    return 0;		// assume 0 if not found
  }

//======================>>> vPopupMenu::initialize <<<=======================
  void vPopupMenu::initialize(void)
  {
#ifndef Athena
    // First, create the Pixmaps, but only once!
    //++    Widget tmpHandle = _parentWin->vHandle();
    // fixed 1.90 - need to use the top window for the popup because
    // by using _parentWin's, it was grabbing the keyboard!
    Widget tmpHandle = theApp->vHandle();

    // create a container parent for popup menu
    _popParent = XtVaCreateManagedWidget("tmp",
				  xmLabelWidgetClass,
				  tmpHandle,
				  XmNmappedWhenManaged,False,
				  NULL);
    _topLevelMenu = XmCreatePopupMenu(_popParent,"popupmenu",NULL,0);
    // Now we have to add our menus

    doAddMenu(0, _topLevelMenu);
    // remove passive grab
//1.90    XtUngrabButton(_popParent, AnyButton, AnyModifier);
#endif
  }

//============================>>> vPopupMenu::PmenuCB <<<==========================
  void vPopupMenu::PmenuCB(Widget w)
  {
#ifndef Athena
    //	menu button class callback
    //
    // We will do some work here
    // scan all menus until we find the widget

    vMenu* item;
    ItemVal menu_val = 0;

    // Scan all menus in this window looking for widget corresponding
    // to the widget that generated the callback
    for (int ix = 0 ; ix < _nextSubMenu ; ++ix)
      {
	PMenuInfo* info;			// for current info

	for (info = _mb[ix].mInfo ; info != 0 ; info = info->NxtInfo)
	  {
	    if (info->WItem == w)	// found it!
	      {
		item = _mb[ix].SubMenu;	// The first item in list
		menu_val = item[info->ItemIndex].menuId;
		goto FoundIt;
	      }
	  }
      }
FoundIt: 
    _parentWin->MenuCommand(menu_val);
#endif
  }

extern "C"
{
//============================>>> CPmenuCB <<<==========================
  void CPmenuCB(Widget w, XtPointer ItmPtr, XtPointer call_data)
  { 
#ifndef Athena
    //	menu button "C" Call Back
    // ItmPtr will have the this pointer of our object

   ((vPopupMenu*)ItmPtr)->PmenuCB(w);
#endif
  }
}

//==================>>> vPopupMenu::SetValue <<<========================
  void vPopupMenu::SetValue(ItemVal id, int val, ItemSetType setType)
  {
#ifndef Athena
    // Set the given item on or off

    vMenu* item;

    // Search all menus in this list
    for (int ix = 0 ; ix < _nextSubMenu ; ++ix)
      {
	PMenuInfo* info;			// for current info

	// scan the list of info for each menu entry
	for (info = _mb[ix].mInfo ; info != 0 ; info = info->NxtInfo)
	  {
	    item = _mb[ix].SubMenu;	// The current item in list
	    // see if its menuId is the same as the one we are setting
	    if (item[info->ItemIndex].menuId == id)
	      {
		// Ah Ha! We found the value we want
		switch (setType)
		  {
		    case Value:			// check box
		    case Checked:		// check box
			item[info->ItemIndex].checked = val;
			if (val)		// turning it on
			  {
// OK, I know this isn't the best, but I tried and couldn't
// get ToggleButtons to work like I wanted, so I'm faking
// check marks with an '*'. If Motif had nice lefthand
// Bitmaps like Athena....
			// not needed for toggle buttons. cfb
//			    fixLabel(item[info->ItemIndex].label);
//			    curLbl[0] = '*';
//			    setLabel(tmp,curLbl);
//			    XtVaSetValues(info->WItem,	// to this menu item
//			        Nlabel,tmp,
//				NULL);
//			    freeLabel(tmp);
			    XtVaSetValues(info->WItem,	// to this menu item
				XmNindicatorOn,
				XmINDICATOR_CHECK,	// check mark for indicator
				XmNset,			// set the toggle button
				XmSET,		// may be overkill. cfb
				NULL);
			  }
			else
			  {
			// not for toggle buttons. cfb
//			    fixLabel(item[info->ItemIndex].label);
//			    setLabel(tmp,curLbl);
//			    XtVaSetValues(info->WItem,	// to this menu item
//			        Nlabel,tmp,
//				NULL);
//			    freeLabel(tmp);
			    XtVaSetValues(info->WItem,	// to this menu item
				XmNindicatorOn,
				XmINDICATOR_NONE,	// no indicator
				XmNset,			// set the toggle button
				XmUNSET,	//may be overkill, should be set. cfb 
				NULL);
			  }
			break;

		    case Sensitive:			// sensitive
			item[info->ItemIndex].sensitive = val;
			XtVaSetValues(info->WItem,	// set sens or not
			    Nsensitive, val,		// how to set
			    NULL);
			break;
		  }	// end switch
	      }
	  }
      }
#endif
  }

//================>>> vPopupMenu::SetString <<<========================
  void vPopupMenu::SetString(ItemVal id, const char* str) 
  {
#ifndef Athena
    // Set the given item on or off

    vMenu* item;

    // Search all menus in this window 
    for (int ix = 0 ; ix < _nextSubMenu ; ++ix)
      {
	PMenuInfo* info;			// for current info

	// scan the list of info for each menu entry
	for (info = _mb[ix].mInfo ; info != 0 ; info = info->NxtInfo)
	  {
	    item = _mb[ix].SubMenu;	// The current item in list

	    if (item[info->ItemIndex].menuId == id)
	      {
		// Ah Ha! We found the value we want
		fixLabel(str);
		item[info->ItemIndex].label = str;
		// This is flakey, but you have to check for check here
		if (item[info->ItemIndex].checked)
		    XtVaSetValues(info->WItem,	// to this menu item
			XmNindicatorOn,
			XmINDICATOR_CHECK,	// check mark for indicator
			XmNset,			// set the toggle button
			XmSET,		// maybe overkill, should be set already. cfb
			NULL);

		setLabel(tmp,curLbl);
	  
		XtVaSetValues(info->WItem,	// change label
		    Nlabel, tmp,
		    NULL);

		freeLabel(tmp);
	      }
	  }
      }
#endif
  }

//==================>>> vPopupMenu::doSubMenu <<<========================
  void vPopupMenu::doSubMenu(Widget parent, Widget subitem, int x, int y)
  {
#ifndef Athena
    // Maybe popup a submenu

    // Scan all menus in this window looking for widget corresponding
    // to the widget that generated the callback
    for (int ix = 0 ; ix < _nextSubMenu ; ++ix)
      {
	if (_mb[ix].XPopUp == parent)
	  {
	    PMenuInfo* info;			// for current info
	    for (info = _mb[ix].mInfo ; info != 0 ; info = info->NxtInfo)
	      {
		if (info->WItem == subitem)
		  {
		    vMenu* item = _mb[ix].SubMenu;  // The first item in list

		    // look at static definition to see if this one had a
		    // submenu. If so, then it is the one we are looking for.
		    if (item[info->ItemIndex].SubMenu != 0)
		      {
			// get the popup shell for the submenu and pop it up.
			Widget submenu = _mb[info->SubMenuIndex].XPopUp;
			XtVaSetValues(submenu, XtNx, x, XtNy, y, NULL);
//1.90			XtPopup(submenu, XtGrabExclusive);
			XtPopup(submenu, XtGrabNone);
		 	theApp->XWaitUntilMapped(submenu);
			return;
		      }
		  }
	      }
	    break;
	  }
      }
    // we didn't find a value
#endif
  }

//====================>>> vPopupMenu::ShowMenu <<<======================
  void vPopupMenu::ShowMenu(int x, int y)
  {
#ifndef Athena
    XmMenuPosition(_topLevelMenu,
	(XButtonPressedEvent *)VGlobalButtonPressedEvent);
    XtManageChild(_topLevelMenu);
//1.90    XtUngrabButton(_popParent, AnyButton, AnyModifier);
#endif
  }
