//===============================================================
// vnotice.cxx - vNoticeDialog class functions - X11R5
//
// Copyright (C) 1995-2003  Bruce E. Wampler
// date: 15 Apr 2003 10:41:14
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#include <v/vnotice.h>		// our header
#include <v/vicon.h>		// our header

// Define static data of the class

//vbm8
#define bang_depth 8
#define bang_width 40
#define bang_height 32
static unsigned char bang_bits[] = {
3,
0,0,0,
255,255,255,
255,255,0,
255,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0,0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,2,2,0,0,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,0,0,
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
0,2,2,0,0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0,0,2,2,0,3,0,0,2,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,3,3,3,0,0,2,0,0,0,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,0,3,3,3,0,0,2,
2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,
2,0,3,3,3,0,0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0,0,0,2,2,2,0,3,3,3,0,0,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,2,2,0,3,3,3,0,0,2,2,2,2,0,0,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,0,3,3,3,0,0,2,
2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,
2,0,3,3,3,0,0,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0,0,2,2,2,2,2,2,0,3,3,3,0,0,2,2,2,2,2,2,0,0,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,0,3,3,3,0,0,2,2,2,2,2,2,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,2,0,3,3,3,0,0,2,
2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,
2,0,3,3,3,0,0,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
0,2,2,2,2,2,2,2,2,0,3,3,3,0,0,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,
1,1,1,1,1,1,0,0,2,2,2,2,2,2,2,2,2,0,3,3,3,0,0,2,2,2,2,2,2,2,2,2,
0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,0,3,0,0,2,2,
2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,
2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,0,0,0,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,
1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,
2,2,0,0,0,1,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,3,0,0,0,2,
2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,
2,0,3,3,3,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,0,0,0,2,2,2,2,
2,2,2,2,2,2,2,2,2,0,0,3,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,
1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,0,0,0,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1
};

    static vIcon bang(&bang_bits[0], bang_height, bang_width,
	bang_depth,Transparent);

    static CommandObject NoticeDialog[] =
      {
	{C_Icon, 1, 0, "Notice", (void*)&bang, CA_None,isSens,NoFrame, 0, 0},

	{C_Text, 2, 0, "UserMessage",
		 NoList, CA_NoBorder | CA_MainMsg, isSens, NoFrame, 1,0},

	{C_Button, M_OK, M_OK, " OK ", NoList,CA_DefaultButton,isSens,NoFrame, 0, 1},
	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };

//======================>>> vNoticeDialog::Notice <<<=======================
  void vNoticeDialog::Notice(const char* msg)
  {
    //	Show a message, and OK
    //	no important return

    int dummy;

    if (!_cmdsAdded)				// Only once
      {
	AddDialogCmds(NoticeDialog);		// Set up standard dialog
	_cmdsAdded = 1;
      }
    (void) ShowModalDialog(msg,dummy);		// show and wait
  }

//====================>>> vNoticeDialog::DialogCommand <<<=======================
  void vNoticeDialog::DialogCommand(ItemVal id, ItemVal val, CmdType ctype)
  {
    vModalDialog::DialogCommand(id,val,ctype);
//    if (id == M_OK)
//	CloseDialog();
  }

// --------------------------------------------------------------------- 
