//=======================================================================
//	vgdefs.h:	Defs for vg app
//=======================================================================
#ifndef VGDEFS_H
#define VGDEFS_H
// Define where V lives on your system

#include <v/v_defs.h>

#define VGEN_VERS "1.09"
#define VGEN_WELCOME "Welcome to the V Application Generator - Version 1.09 10 Apr 2003\n\n"

#define DEF_VPATH "/include"	// to find v_defs.h, etc. for compile, link

#ifdef V_VersionWindows

#define DEF_HOMEV "C:/mingw"	 // to find libV.a
#define DEF_LIBS "-mwindows"
#define OGLDEF_LIBS "-mwindows"

#define BOR_HOMEV "C:\\Borland\\BCC55" // to find libV.a
#define BOR_LIBS "-v- -Tpe -aa -c"

#define OGLBOR_LIBS "-v- -Tpe -aa -c"

#else

#ifdef LINUX
#define DEF_HOMEV "/usr" // to find libV.a
#else
#define DEF_HOMEV "/usr/local/v" // to find libV.a
#endif

#ifndef Athena
#define DEF_LIBS ""
#define OGLDEF_LIBS ""
#else
#define DEF_LIBS ""
#define OGLDEF_LIBS ""
#endif

#endif

    enum cnvType {Canvas, Text, OpenGL, NoCanvas};
    typedef struct vgOptions
      {
	    char appName[100];	// base name of app classes
	    char fileName[100]; // base name of app files
	    char title[100];    // title of app
	    char home[100];     // V home
	    int	addDialog,	// if add a dialog
		addModal, 	// if add modal dialog
		addMake, 	// if add makefile
		addVproj,	// if add project file
		extraDialog,	// if making an extra dialog
		addMenu,	// for a menuless app
		addToolBar,	// if add tool bar
		addStatus, 	// if add status bar
		addDate,	// if add date/time
		addTimer,	// if add a timer
		vScroll,	// if include v Scroll bar
		hScroll,	// if include h scroll bar
		winSDI,		// if a Windows SDI model
		isBorland,	// if for Borland
		dialogOnly,	// if dialog only
		fullMenu;	// if a full menu or short menu
	    cnvType canvasType;	// kind of canvas to generate

      } vgOptions;
#endif
