//=======================================================================
//@V@:Note: This file generated by vgen V1.07 (14:44:21 01 Dec 2000).
//	VGLdrw_cnv.cpp:	Source for VGL_Draw_ServerOGLCanvasPane class
//=======================================================================

#include <v/vapp.h>
#include <v/vnotice.h>    // for vNoticeDialog
#include <v/vkeys.h>      // to map keys
#include <v/vynreply.h>   // for vYNReplyDialog
#include <v/vpen.h>       // for pen managment.

#include <stdio.h>

#include "VGLdrw_cnv.h"

#include "Draw_VGL.h"
#include "Draw_AxisBox.h"


static char * def_unit = "cm";

static int pex, pey, pew, peh;

static Draw_Ptr Curve_Seg = NULL;

static vPen pen;

static int clic_requ      =    0;



//===================>>> VGL_Draw_ServerOGLCanvasPane::VGL_Draw_ServerOGLCanvasPane <<<====================
  VGL_Draw_ServerOGLCanvasPane::VGL_Draw_ServerOGLCanvasPane( unsigned int vGLmode, PaneType pt )
  {

    initDone   = 0;         // Set not initialized state for exchange,
    initGLDone = 0;         // ... and for GL Library.
    reqflg     = 0;         // Disable the input client requests.
    reqnxt     = 0;         // Enable the User Task Command mode.

  }

//===================>>> VGL_Draw_ServerOGLCanvasPane::~VGL_Draw_ServerOGLCanvasPane <<<====================
  VGL_Draw_ServerOGLCanvasPane::~VGL_Draw_ServerOGLCanvasPane()
  {
  }

//======================>>> VGL_Draw_ServerOGLCanvasPane::TimerAnimate <<<========================
  void VGL_Draw_ServerOGLCanvasPane::TimerAnimate(void)
  {
    // **** Called by CmdWindow AuxTimer for animation.

  }

//======================>>> VGL_Draw_ServerOGLCanvasPane::graphicsInit <<<========================
  void VGL_Draw_ServerOGLCanvasPane::graphicsInit(void)
  {
    vBaseGLCanvasPane::graphicsInit();	// Always call the superclass first!

    // **** Your OpenGL initialization code goes here!

    Sdrw_read_lock();           // Lock the User Directive Execution Graph.

    vglMakeCurrent();
    DrwGL_Init();               // Init all GL context.
    vglFlush();                 // After you draw, typically flush.  

    Sdrw_read_unlock();         // Unlock the User Directive Execution Graph 

    initGLDone   = 1;           // Flag Init is done.
    mouse_status = 0;           // Initialize the Cursor status.
  }

//======================>>> VGL_Draw_ServerOGLCanvasPane::HPage <<<========================
  void VGL_Draw_ServerOGLCanvasPane::HPage( int shown, int top )
  { /* When move the Horizontal Scroll Bare */
    float larg = 2.0*dw_cwsx;

    dw_cxmin = dw_sxmin + 0.02*(float)top*dw_swsx;
    dw_cxmax = dw_cxmin + larg;

    if (dw_cxmax > dw_sxmax) {
      dw_cxmin = dw_sxmax - larg;
      dw_cxmax = dw_sxmax;
    }
    else
      if (dw_cxmin < dw_sxmin) {
        dw_cxmin = dw_sxmin;
        dw_cxmax = dw_cxmin + larg;
      }      fprintf( fmsg, " *** Orientation.\n" );
      Draw_Fmsgupdate();


    dw_cwpx  = 0.5*(dw_cxmax + dw_cxmin);

//  fprintf( fmsg, " HPAGE e: l = %f, p = %f, mi = %f, ma = %f\n",
//                 dw_cwsx, dw_cwpx, dw_cxmin, dw_cxmax );
//  Draw_Fmsgupdate();

    /* Perform A picture Redraw */
    Redraw( 0, 0, dt_rx, dt_ry );

    vBaseGLCanvasPane::HPage( shown, top );
  }

//======================>>> VGL_Draw_ServerOGLCanvasPane::VPage <<<========================
  void VGL_Draw_ServerOGLCanvasPane::VPage( int shown, int top )
  { /* When move the vertical Scroll Bare */
    float larg = 2.0*dw_cwsy;

    dw_cymax = dw_symax - 0.02*(float)top*dw_swsy;
    dw_cymin = dw_cymax - larg;

    if (dw_cymax > dw_symax) {
      dw_cymin = dw_symax - larg;
      dw_cymax = dw_symax;
    }//@V@:Case m_Reload
    else
      if (dw_cymin < dw_symin) {
        dw_cymin = dw_symin;
        dw_cymax = dw_cymin + larg;
      }

    dw_cwpy  = 0.5*(dw_cymax + dw_cymin);

    /* Perform A picture Redraw */
    Redraw( 0, 0, dt_rx, dt_ry );

    vBaseGLCanvasPane::VPage( shown, top );
  }

//=======================>>> VGL_Draw_ServerOGLCanvasPane::HScroll <<<======================
  void VGL_Draw_ServerOGLCanvasPane::HScroll( int step )
  { /* When do an Incremental Horizontal Scroll */
    float larg = 2.0*dw_cwsx;

    dw_cxmin += 0.02*(float)step*dw_swsx;
    dw_cxmax = dw_cxmin + larg;

    if (dw_cxmax > dw_sxmax) {
      dw_cxmin = dw_sxmax - larg;
      dw_cxmax = dw_sxmax;
    }
    else//@V@:Case m_Reload
      if (dw_cxmin < dw_sxmin) {
        dw_cxmin = dw_sxmin;
        dw_cxmax = dw_cxmin + larg;
      }

    dw_cwpx = 0.5*(dw_cxmax + dw_cxmin);

//  fprintf( fmsg, " HSCROLL e: l = %f, p = %f, mi = %f, ma = %f\n",
//                 dw_cwsx, dw_cwpx, dw_cxmin, dw_cxmax );
//  Draw_Fmsgupdate();

    /* Perform A picture Redraw */
    Redraw( 0, 0, dt_rx, dt_ry );

    vBaseGLCanvasPane::HScroll( step );
  }

//======================>>> VGL_Draw_ServerOGLCanvasPane::VScroll <<<======================
  void VGL_Draw_ServerOGLCanvasPane::VScroll( int step )
  { /* When do an Incremental Vertical Scroll */
    float larg = 2.0*dw_cwsy;

    dw_cymax -= 0.02*((float)step)*dw_swsy; /* Change y Limits */
    dw_cymin = dw_cymax  - larg;

    if (dw_cymax > dw_symax) {
      dw_cymin = dw_symax - larg;
      dw_cymax = dw_symax;
    }
    else
      if (dw_cymin < dw_symin) {
        dw_cymin = dw_symin;
        dw_cymax = dw_cymin + larg;
      }

    dw_cwpy = 0.5*(dw_cymax + dw_cymin);

    /* Perform A picture Redraw */
    Redraw( 0, 0, dt_rx, dt_ry );

    vBaseGLCanvasPane::VScroll( step );
  }

//================>>> VGL_Draw_ServerOGLCanvasPane::Picture_Scale <<<===============
  int VGL_Draw_ServerOGLCanvasPane::Picture_Scale( int cfflg )
  { /* To set a new Picture View after a Zoom/Scale or Reload Command */
    int topx, topy, ratx, raty, rq;
    float exc, sc, dxi, dxa, dyi, dya, px, py,
          ryx, sx, sy, sx1, sy1;
    Draw_Ptr check_seg;

    /********************************************************************/
    /* We must set the new plot in the same proportions by setting      */
    /* the variables draw_u(x/y)(min/max) for the user space and the    */
    /* variables ws_(x/y)(min/max) for the system space the originals   */
    /*  value are saved in draw_su(x/y)(min/max) and ws_s(x/y)(min/max) */
    /*  variables.                                                      */
    /********************************************************************/

    /* Force coord/ycoord to be the minimums and */
    /* ... xcurr/ycurr to be the maximums.       */

//  ryx = dw_swsy/dw_swsx;
    ryx = ds_ry/ds_rx;

    if (cfflg >= 0) { /* When we define a New View */
      if ( Drwgl_xcoord > Drwgl_xcurr)
        { exc = Drwgl_xcoord; Drwgl_xcoord = Drwgl_xcurr; Drwgl_xcurr = exc; }
      if ( Drwgl_ycoord > Drwgl_ycurr)
        { exc = Drwgl_ycoord; Drwgl_ycoord = Drwgl_ycurr; Drwgl_ycurr = exc; }

      /* Set the Correct High/Width Proportions */

      sx = (Drwgl_xcurr - Drwgl_xcoord)*0.5;
      sy = (Drwgl_ycurr - Drwgl_ycoord)*0.5;
      px = (Drwgl_xcurr + Drwgl_xcoord)*0.5;
      py = (Drwgl_ycurr + Drwgl_ycoord)*0.5;

      /* Adjust to keep the same Y/X proportions */
      if (sy > ryx*sx) { sx1 = sy/ryx; sy1 = sy; }
                  else { sy1 = sx*ryx; sx1 = sx; }

      if (cfflg) { /* Mode with confirmation */
        vYNReplyDialog ynd(theApp);

        check_seg = Draw_New_Sys_Seg( 3, 0 );
        Draw_GPlot_Rect( px - sx1, py - sy1, px + sx1, py + sy1 );
        draw_curseg = NULL;

        /* Perform A picture Redraw */
        Redraw( 0, 0, dt_rx, dt_ry );

        /* Prompt the User for Agreement and delete the check rectangle */
        rq = (ynd.AskYN( "OK for Zoom?" ) == 1);
        Draw_Destroye( check_seg );

        if (!rq) return 0;
      }
      else /* Check for too small limits when cfflg = 0 */
        if (sx < dw_cwsx*0.01) return 0;

      /* Save last View Setting */
      sdw_cwsx  =  dw_cwsx; sdw_cwsy  =  dw_cwsy;
      sdw_cwpx  =  dw_cwpx; sdw_cwpy  =  dw_cwpy;
//    fprintf( fmsg, " Pict_Scale Saved parm = (%f,%f,%f,%f)\n",
//                   sdw_cwsx, sdw_cwsy, sdw_cwpx, sdw_cwpy );
//    Draw_Fmsgupdate();
    }
    else { /* Restore old View */
      sx = sdw_cwsx; sy = sdw_cwsy;
      px = sdw_cwpx; py = sdw_cwpy;
    }

    /* Here sx, sy, px and py are the new parameters */

//  fprintf( fmsg, " Pict_Scale Initial Usr Size = %f,%f\n", dw_cwsx, dw_cwsy );
//  fprintf( fmsg, " Pict_Scale required parm =(%f,%f,%f,%f)\n", sx, sy, px, py );
//  Draw_Fmsgupdate();

    ratx = (int)(100.0*sx/dw_swsx + 0.5);
    raty = (int)(100.0*sy/dw_swsy + 0.5);
    ShowHScroll((int) (df_Hscr = (ratx < 100)) );
    ShowVScroll((int) (df_Vscr = (raty < 100)) );

    /* Re-Adjust to keep the (New?) Window Y/X proportions */
    if (sy > ryx*sx) sx = sy/ryx;
                else sy = sx*ryx;

    dw_cwsx = sx; dw_cwsy = sy; dw_cwpx = px; dw_cwpy = py;

    dw_cxmin = px - sx; dw_cymin = py - sy;
    dw_cxmax = px + sx; dw_cymax = py + sy;

    ratx = (int)(100.0*sx/dw_swsx + 0.5);
    raty = (int)(100.0*sy/dw_swsy + 0.5);
    topx = (int)( 50.0*(dw_cxmin - dw_sxmin)/dw_swsx + 0.5);
    topy = (int)( 50.0*(dw_symax - dw_cymax)/dw_swsy + 0.5);

    if (df_Hscr) SetHScroll( ratx, topx );
    if (df_Vscr) SetVScroll( raty, topy );

//  fprintf( fmsg, " Pict_Scale final parm = (%f,%f,%f,%f)\n", sx, sy, px, py );
//  fprintf( fmsg, "*Pict_Scale -> minmax = (%f,%f,%f,%f)\n",
//                 dw_cxmin, dw_cymin, dw_cxmax, dw_cymax );
//  fprintf( fmsg, " Pict_Scale Bare parms %d,%d  %d,%d\n",
//                 ratx, topx, raty, topy );
//  fprintf( fmsg, " sxy_scale = %f, xy_scale = %f\n", sxy_scale, xy_scale );
//  Draw_Fmsgupdate();

    /* Adjust the scales */
    xy_scale = sxy_scale*dw_swsx/dw_cwsx;
    vw_scale = cv_scale*xy_scale;
    efxy_scale = 1.0/xy_scale;
    efvw_scale = 1.0/vw_scale;

//  fprintf( fmsg, "*sxy_scale = %f, xy_scale = %f, vw_scale = %f\n",
//                 sxy_scale, xy_scale, vw_scale );
//  Draw_Fmsgupdate();

    return 1;
  }


//======================>>> VGL_Draw_ServerOGLCanvasPane::MouseDown <<<======================
  void VGL_Draw_ServerOGLCanvasPane::Send_Curve( int button )
  { /* End of Get Line Request */
    vYNReplyDialog ynd( theApp );

    /* Finish to Create the new Segment */
    if (Drwgl_gptcnt) {
      if (!Plot_Size) Draw_GPlot1();
      Draw_GPlot( Drwgl_xcurr, Drwgl_ycurr, 0 );
      draw_curseg = NULL;
//    fprintf( fmsg, " Send Curve point # %d/%d\n", Plot_Size, Drwgl_gptcnt );
//    Draw_Fmsgupdate();
      /* Re-Draw to Display it */
      Redraw( 0, 0, dt_rx, dt_ry );
      /* Request User for Agreement */
      if (ynd.AskYN( "OK to Keep these Graphic Input?" ) == 1) {
        /* Send the points to the User Program */
        /* When Required, Insert the Points in the Current User List */
        Drwgl_senddir = Draw_User_Append( Curve_Seg );
//      fprintf( fmsg, " Send Curve send the first data Packet.\n" );
//      Draw_Fmsgupdate();
        Draw_Send_Points( 0 ); /* Send the first packet (2D) */
        return;
      }
    }

    Draw_Destroye( Curve_Seg );
    Drwgl_senddir = NULL;
    Sdrw_Put_Int( 1 );
    Sdrw_Put_Int( 0 );
  }


//======================>>> VGL_Draw_ServerOGLCanvasPane::MouseDown <<<======================
  void VGL_Draw_ServerOGLCanvasPane::MouseDown( int x, int y, int button )
  {

//  vBaseGLCanvasPane::MouseDown(x,y,button);

    if (reqflg) { /* Defaulted Zoom/View Init */
      Drwgl_Proceed = (Drwgl_zomeview)?drwgl_view:drwgl_zoom;  /* Set The Request Kind */
      reqflg = 0;
      clic_requ = 1;
      mouse_status  = 0;
      Drwgl_mactive = 1;
      if (Drwgl_xusr_unt[0]) Drwgl_unitx = Drwgl_xusr_unt;
                        else Drwgl_unitx = def_unit;
      if (Drwgl_yusr_unt[0]) Drwgl_unity = Drwgl_yusr_unt;
                        else Drwgl_unity = def_unit;
      Drwgl_cursor  = GetCursor();
      SetCursor( VC_CrossHair );
    }

    if (Drwgl_mactive&&(!mouse_status))
    {
      DrwGL_Get_World_XY( x, y, Drwgl_Proceed );

      cursor_ix = x; cursor_iy = y;     // Save Current Screen Position.
      /* Process The Request */
      switch (Drwgl_Proceed) {
        case drwgl_pick:
        case drwgl_position:
          Drwgl_xcoord = Drwgl_xcurr;
          Drwgl_ycoord = Drwgl_ycurr;
        break;

        case drwgl_usr_zoom:
        case drwgl_zoom:
        case drwgl_savewindow:
        case drwgl_window:
          cursor_px = x; cursor_py = y;
          Drwgl_xcoord = Drwgl_xcurr;
          Drwgl_ycoord = Drwgl_ycurr;
        break;

        case drwgl_line:
          cursor_px = x; cursor_py = y;
        break;

        case drwgl_stroke:
          pen.SetWidth( 2 );
          SetPen( pen );
          DrawPoint( x, y );
          cursor_px = x; cursor_py = y;
          Curve_Seg = Draw_New_Sys_Seg( 11, 0 );
          Draw_GPlot( Drwgl_xcurr, Drwgl_ycurr, 0 );
          Drwgl_gptcnt = 1;
        break;

        case drwgl_usr_view:
        case drwgl_view:
          DrwGL_Init_View_Matrix( button == 2 ); /* Button 1|3 are same - 2 do only to see */
        break;

        default: /* Ignore */;
      }
      mouse_status =  1;
    }
  }



//========================>>> VGL_Draw_ServerOGLCanvasPane::MouseUp <<<======================
  void VGL_Draw_ServerOGLCanvasPane::MouseUp( int x, int y, int button )
  {
    int     i, isc,  itp,  w,   h;
    float usx, usy, usz, uxc, uyc, ssx, ssy, sxc, syc,
           sx,  sy,  xc,  yc,  zc, ryx, sca, exc,
           xd,  yd,  zd;
    Draw_Ptr check_seg;
    vYNReplyDialog ynd( theApp );

//  vBaseGLCanvasPane::MouseUp(x,y,button);

    if (Drwgl_mactive&&mouse_status)
    {
      DrwGL_Get_World_XY( x, y, Drwgl_Proceed );

      mouse_status = 0; Drwgl_mactive = 0;
      switch (Drwgl_Proceed) {
        case drwgl_pick:
        case drwgl_position:
          SetCursor( Drwgl_cursor );
          /* Compute the Screen Coordinates */
          Drwgl_xcoord = Drwgl_xcurr;
          Drwgl_ycoord = Drwgl_ycurr;
          Drwgl_status = (button != 2)?1:-1;
          if (Drwgl_Proceed == drwgl_pick) {
            if (Drwgl_pecho) {
              DrawRubberRectangle( pex, pey, pew, peh );
              Drwgl_pecho = 0;
            }
            if (!Drwgl_segment) Drwgl_status = -1;
            Sdrw_Put_Int( Drwgl_status );
            Sdrw_Put_Int( Drwgl_segment );
            Sdrw_Put_Int( Drwgl_ident );
          }
          else {
            Sdrw_Put_Int( Drwgl_status );
            if (Draw_Opened_Box) {
              Draw_UnScale( &xc, &yc, &zc, Drwgl_xcoord, Drwgl_ycoord, 0.0 );
            } else {
              xc = Drwgl_xcoord - orgx;
              yc = Drwgl_ycoord - orgy;
            }
            Sdrw_Put_Float( xc );
            Sdrw_Put_Float( yc );
          }
          Drwgl_Proceed = drwgl_nothing;
          Sdrw_Resume_User_Pipe();
        break;

        case drwgl_window:
          if ((x != cursor_ix)&&(y != cursor_iy))
          { w = cursor_ix - cursor_px; h = cursor_iy - cursor_py;
            DrawRubberRectangle( cursor_px, cursor_py, w, h ); /* Delete Old */
            cursor_ix = x; cursor_iy = y; cursor_ib;
          }
          SetCursor( Drwgl_cursor );
          if ( Drwgl_xcoord > Drwgl_xcurr)
            { exc = Drwgl_xcoord; Drwgl_xcoord = Drwgl_xcurr; Drwgl_xcurr = exc; }
          if ( Drwgl_ycoord > Drwgl_ycurr)
            { exc = Drwgl_ycoord; Drwgl_ycoord = Drwgl_ycurr; Drwgl_ycurr = exc; }

          Sdrw_Put_Int( (button != 2)?1:-1 );
          if (Draw_Opened_Box) {
            Draw_UnScale( &xc, &yc, &zc, Drwgl_xcoord, Drwgl_ycoord, 0.0 );
            Draw_UnScale( &xd, &yd, &zd,  Drwgl_xcurr,  Drwgl_ycurr, 0.0 );
          } else {
            xc = Drwgl_xcoord - orgx; yc = Drwgl_ycoord - orgy;
            xd = Drwgl_xcurr  - orgx; yd = Drwgl_ycurr  - orgy;
          }
          Sdrw_Put_Float( xc );
          Sdrw_Put_Float( yc );
          Sdrw_Put_Float( xd );
          Sdrw_Put_Float( yd );
          Drwgl_Proceed = drwgl_nothing;
          Sdrw_Resume_User_Pipe();
        break;

        case drwgl_usr_zoom:
        case drwgl_zoom:
        {
          w = cursor_ix - cursor_px; h = cursor_iy - cursor_py;
          DrawRubberRectangle( cursor_px, cursor_py, w, h ); /* Delete Old */
          if ((x != cursor_ix)&&(y != cursor_iy)) { cursor_ix = x; cursor_iy = y; }

          SetCursor( Drwgl_cursor );

          i = Picture_Scale( (clic_requ == 0) );
          Redraw( 0, 0, dt_rx, dt_ry );

          if (Drwgl_Proceed == drwgl_usr_zoom)
          { /* Zoom User Request */
            Drwgl_Proceed = drwgl_nothing;
            Sdrw_Resume_User_Pipe();
          }
          else
          { /* Zoom Command */
            Drwgl_Proceed = drwgl_nothing;
            Drwgl_Input   = drwgl_dialog;
            clic_requ     = 0;
            reqflg        = 1;
          }
        break;
        }

        case drwgl_usr_view:
        case drwgl_view:
          SetCursor( Drwgl_cursor );
          i = DrwGl_Finish_View_Request();
          if (Drwgl_Proceed == drwgl_usr_view)
          { /* View User Request */
            if (i) Redraw( 0, 0, dt_rx, dt_ry );
            Sdrw_Put_Int( (i)?-1:1 );
            Drwgl_Proceed = drwgl_nothing;
            Sdrw_Resume_User_Pipe();
          }
          else
          { /* View Command */
            Drwgl_Proceed = drwgl_nothing;
            Drwgl_Input   = drwgl_dialog;
            clic_requ     = 0;
            reqflg        = 1;
          }
        break;

        case drwgl_savewindow:
        { Draw_Ptr seg;

          w = cursor_ix - cursor_px; h = cursor_iy - cursor_py;
          DrawRubberRectangle( cursor_px, cursor_py, w, h ); /* Delete Old */
          if ((x != cursor_ix)&&(y != cursor_iy))
          { cursor_ix = x; cursor_iy = y;
            if (cursor_ix < cursor_px) {
              cursor_ix = cursor_px; cursor_px = x;
              exc = Drwgl_xcoord; Drwgl_xcoord = Drwgl_xcurr; Drwgl_xcurr = exc;
            }
            if (cursor_iy < cursor_py) {
              cursor_iy = cursor_py; cursor_py = y;
            }
            else
            {
              exc = Drwgl_ycoord; Drwgl_ycoord = Drwgl_ycurr; Drwgl_ycurr = exc;
            }
            w = cursor_ix - cursor_px; h = cursor_iy - cursor_py;
          }

          SetCursor( Drwgl_cursor );

          seg = Draw_New_Sys_Seg( 3, 0 );
          Draw_GPlot_Rect( Drwgl_xcoord, Drwgl_ycoord, Drwgl_xcurr, Drwgl_ycurr );
          draw_curseg = NULL;

          /* Perform A picture Redraw */
          Redraw( 0, 0, dt_rx, dt_ry );

          /* Prompt the User for Agreement and delete the check rectangle */
          i = (ynd.AskYN( "OK to Save this Window?" ) == 1);
          Draw_Destroye( seg );

          Redraw( 0, 0, dt_rx, dt_ry );

          if (i) Draw_Save_Image( cursor_px, cursor_py, w, h );

          Drwgl_Proceed = drwgl_nothing;
          Drwgl_Input   = drwgl_dialog;
          reqflg = 1;
        break;
        }

        case drwgl_line:
          /* The cursor should not move */
          if (button == 1)
            if (Drwgl_gptcnt) {
              Draw_GPlot( Drwgl_xcurr, Drwgl_ycurr, 1 );
              Drwgl_gptcnt++;
            }
            else {
              Curve_Seg = Draw_New_Sys_Seg( 11, 0 );
              Draw_GPlot( Drwgl_xcurr, Drwgl_ycurr, 0 );
              pen.SetWidth( 2 );
              SetPen( pen );
              Drwgl_gptcnt = 1;
            }

          if ((button != 1)||(Drwgl_gptcnt >= Drwgl_gptmax)) {
//          fprintf( fmsg, " Get_Line End point # %d\n", Drwgl_gptcnt );
//          Draw_Fmsgupdate();
            pen.SetWidth( 1 );
            SetCursor( Drwgl_cursor );
            Send_Curve( button );
            Curve_Seg = NULL;
            Drwgl_Proceed = drwgl_nothing;
            Sdrw_Resume_User_Pipe();
          }
          else {
            DrawPoint( x, y );
            Drwgl_mactive = 1;
            return;
          }
        break;

        case drwgl_stroke:
          if ((x != cursor_ix)||(y != cursor_iy)&&(Drwgl_gptcnt < Drwgl_gptmax)) {
            Draw_GPlot( Drwgl_xcurr, Drwgl_ycurr, 1 );
            Drwgl_gptcnt++;
          }
//        fprintf( fmsg, " Get_Stroke End point # %d\n", Drwgl_gptcnt );
//        Draw_Fmsgupdate();
          pen.SetWidth( 1 );
          SetCursor( Drwgl_cursor );
          Send_Curve( button );
          Drwgl_Proceed = drwgl_nothing;
          Sdrw_Resume_User_Pipe();
        break;

        default: /* Ignore */;
      }
      Drwgl_Proceed = drwgl_nothing;
    }
  }



//================ ====>>> VGL_Draw_ServerCanvasPane::MouseMotion <<<=====================
  void VGL_Draw_ServerOGLCanvasPane::MouseMotion( int x, int y )
  { Draw_Ptr q;

    if (Drwgl_mactive&&(!mouse_status))
    {
      DrwGL_Get_World_XY( x, y, Drwgl_Proceed );
      mouse_status  = 0;
      if (Drwgl_Proceed == drwgl_pick) {
        DrwGL_Pick_Search( x, y );
        if (Drwgl_pecho) { DrawRubberRectangle( pex, pey, pew, peh );
                           Drwgl_pecho = 0;
                         }
        if (Drwgl_segment) {
          pex = Drwgl_pechx; pey = Drwgl_pechy;
          pew = Drwgl_pechw; peh = Drwgl_pechh;
          DrawRubberRectangle( pex, pey, pew, peh );
          Drwgl_pecho = 1;
        }
      }
    }
  }

//======================>>> VGL_Draw_ServerCanvasPane::MouseMove <<<======================
  void VGL_Draw_ServerOGLCanvasPane::MouseMove( int x, int y, int button )
  {
    int    h,  w;
    float xx, yy;

//  vBaseGLCanvasPane::MouseMove(x,y,button);

    if (Drwgl_mactive&&mouse_status&&((x != cursor_ix)||(y != cursor_iy)))
    {
      DrwGL_Get_World_XY( x, y, Drwgl_Proceed );
      mouse_status  = 1;
      switch (Drwgl_Proceed) {
        case drwgl_savewindow:
        case drwgl_usr_zoom:
        case drwgl_zoom:
        case drwgl_window:
          w = cursor_ix - cursor_px; h = cursor_iy - cursor_py;
          DrawRubberRectangle( cursor_px, cursor_py, w, h ); /* Del. Old Rect. */
          w = x - cursor_px;         h = y - cursor_py;
          DrawRubberRectangle( cursor_px, cursor_py, w, h ); /* New Rect. */
          cursor_ix = x;             cursor_iy = y;
        break;

        case drwgl_stroke:
          cursor_ix = x;             cursor_iy = y;
          Drwgl_gptcnt++;
          Draw_GPlot( Drwgl_xcurr, Drwgl_ycurr, 1 );
          if (Drwgl_gptcnt >= Drwgl_gptmax) {
            Send_Curve( button );
            SetCursor( Drwgl_cursor );
            Drwgl_Proceed = drwgl_nothing;
            Sdrw_Resume_User_Pipe();
          }
          else DrawPoint( x, y );
        break;

        case drwgl_usr_view:
        case drwgl_view:
          DrwGL_Change_View_Matrix();
          /* Perform A picture Redraw */
          Redraw( 0, 0, dt_rx, dt_ry );
        break;

        default: /* Ignore */;
      }
    }
  }

//=========================>>> VGL_Draw_ServerOGLCanvasPane::Redraw <<<======================
  void VGL_Draw_ServerOGLCanvasPane::Redraw( int x, int y, int w, int h )
  {
    static int inRedraw = 0;

    if (!initGLDone||inRedraw)  // Nothing to do before init GL.
      return;

    inRedraw = 1;               // Don't allow recursive redraws.

//  fprintf( fmsg, " Redraw Start.\n" );
//  Draw_Fmsgupdate();

    if (!initDone)              // Don't draw until initialized.
    { // Force the original canvas size.
      SetWidthHeight( s_dt_rx, s_dt_ry );
      dt_rx    = GetWidth(); dt_ry    = GetHeight();
      s_dt_rx  =      dt_rx; s_dt_ry  =       dt_ry;  // Save it.

      ds_rx   = dt_rx/d_xscale;  // Update the Window Size in (cm).
      ds_ry   = dt_ry/d_yscale;

      SetHScroll( 100, 1 );     // Init the Scroll Bares.
      SetVScroll( 100, 1 );
      ShowHScroll(0);           // Default image is complete (no Scroll Bare).
      ShowVScroll(0);

      dhs_rx   = dt_rx - s_dt_rx; dvs_ry   = dt_ry - s_dt_ry;
      s_dt_rx  =           dt_rx; s_dt_ry  =           dt_ry;  // Save it.
      d_Hscrol = dhs_rx/d_xscale; d_Vscrol = dvs_ry/d_yscale;
      df_Hscr  =               0; df_Vscr  =               0;  // Set No Scroll Bare State.

//    fprintf( fmsg, " Set init Window Init Size to (%d*%d) Pixels\n", s_dt_rx, s_dt_ry );
//    fprintf( fmsg, "                           or (%f*%f) cm.\n", ds_rx, ds_ry );
//    fprintf( fmsg, " Scroll Bare sizes = (%d,%d) Rasters or (%f,%f) cm.\n", dhs_rx, dvs_ry,
//                                               d_Hscrol, d_Vscrol );
//    Draw_Fmsgupdate();

      Draw_Extern_Init();       // Perform the implied draw_init and start the pipe pthread.
      reqflg   = 0;             // Remember for next client request.
      initDone = 1;             // Flag Init is done.
      mouse_status = 0;         // Cursor Up state.
    }


    // *** Your drawing code typically goes here. You may
    // insert it here, or just call a drawing routine.
 
    Sdrw_read_lock();           // Lock the User Directive Execution Graph 

//  fprintf( fmsg, " Redraw: Read Lock Set.\n" );
//  Draw_Fmsgupdate();

    if (draw_lock_flag >= 1)
    {

      Drwgl_flags &= ~DRWSTATUS_UPDATE; // Clear the Update flag.

      vBaseGLCanvasPane::Redraw( x, y, w, h ); // Call Default redraw routine.

      // *** Your drawing code typically goes here. You may
      // insert it here, or just call a drawing routine.
      // VGL_Draw_ServerOGLCanvasPane::Draw_Picture( x, y, w, h );

      vglMakeCurrent();

      DrwGL_Display( 0 );

      vglFlush();               // After you draw, typically flush.  

    }



    // ********* Here is the Normal Exit of DRAW_SERVER Task *************

    if (reqnxt < 0) theApp->Exit();  // Exit on Draw_End/Exchange_Error Call.


    // We are here in dialog mode when reqnxt == 1 and reqflg = 1.

    Sdrw_read_unlock();         // Now unlock the User Directive execution.

    inRedraw = 0;               // Out of Redraw

  }

//======================>>> VGL_Draw_ServerOGLCanvasPane::Resize <<<======================
  void VGL_Draw_ServerOGLCanvasPane::Resize( int w, int h )
  {
    float ryx, sca, ssca, scr, csx, csy, cpx, cpy, wsx, wsy, wpx, wpy;

//  fprintf( fmsg, " Resize from [%d,%d] to [%d,%d]\n", dt_rx, dt_ry, w, h );
//  Draw_Fmsgupdate();

    if ((w > 10)&&(h > 10)) { /* Not Null size */
      /* Get the new window size in (station) cm */
      ds_rx = ((float) w)/d_xscale;
      ds_ry = ((float) h)/d_yscale;
      dt_rx = w; dt_ry = h;             /* Set new window(= glViewport) sizes. */

//    fprintf( fmsg, " rx=%f, ry=%f, Pic_xx = %f, Pic_yy = %f\n",
//                   ds_rx, ds_ry, Draw_pic_sx, Draw_pic_sy );
//    fprintf( fmsg, " OLD: sw = (%f,%f), cw=(%f,%f).\n", dw_swsx, dw_swsy, dw_cwsx, dw_cwsy );

      if (p_id) {
        /* Update the Window/Printer sconversion scale */
        if (ds_rx*ps_ry >= ps_rx*ds_ry) cv_scale = ds_ry/ps_ry;
                                   else cv_scale = ds_rx/ps_rx;
        /* The xy_scale and sxy_scale (Printer/User scale) are not changed */
        svw_scale =  cv_scale*sxy_scale;
        vw_scale  =  cv_scale*xy_scale;
      } else {
        if (ds_rx*Draw_pic_yx >= ds_ry) svw_scale = ds_ry/Draw_pic_sy;
                                   else svw_scale = ds_rx/Draw_pic_sx;
        vw_scale   = svw_scale*(dw_swsx/dw_cwsx);
        sxy_scale = svw_scale;
        xy_scale  =  vw_scale;
      }
      efvw_scale = 1.0/vw_scale;

//    fprintf( fmsg, " svw_scale = %f, vw_scale = %f, efvw_scale = %f\n",
//                   svw_scale, vw_scale, efvw_scale );

      dw_swsx = 0.5*ds_rx/svw_scale; dw_cwsx = 0.5*ds_rx*efvw_scale;
      dw_swsy = 0.5*ds_ry/svw_scale; dw_cwsy = 0.5*ds_ry*efvw_scale;

      /* Set the new World Window limits and saved one */

      dw_sxmin = dw_swpx - dw_swsx; dw_symin = dw_swpy - dw_swsy;
      dw_sxmax = dw_swpx + dw_swsx; dw_symax = dw_swpy + dw_swsy;
      dw_cxmin = dw_cwpx - dw_cwsx; dw_cymin = dw_cwpy - dw_cwsy;
      dw_cxmax = dw_cwpx + dw_cwsx; dw_cymax = dw_cwpy + dw_cwsy;

//    fprintf( fmsg, " w_new_position = (%f,%f), w_new_size = (%f,%f).\n",
//                   dw_cwpx, dw_cwpy, dw_cwsx, dw_cwsy );
//    fprintf( fmsg, " ws_new_position = (%f,%f), ws_new_size = (%f,%f).\n",
//                   dw_swpx, dw_swpy, dw_swsx, dw_swsy );
//    fprintf( fmsg, " Resize Deduced Win space [%f,%f,%f,%f]\n",
//                   dw_cxmin, dw_cxmax, dw_cymin, dw_cymax );
//    Draw_Fmsgupdate();

      vBaseGLCanvasPane::Resize( dt_rx, dt_ry );
    }
    else
      vBaseGLCanvasPane::Resize( 0, 0 ); /* Set the Null Canvas Size */
  }

//=========>>> VGL_Draw_ServerOGLCanvasPane::Draw_Input_Request <<<=========
  void VGL_Draw_ServerOGLCanvasPane::Draw_Input_Request(void)
  { /* Canvas User Input Request */    
    mouse_status  = 0;
    Drwgl_mactive = 1;

    if (Drwgl_xusr_unt[0]) Drwgl_unitx = Drwgl_xusr_unt;
                      else Drwgl_unitx = def_unit;
    if (Drwgl_yusr_unt[0]) Drwgl_unity = Drwgl_yusr_unt;
                      else Drwgl_unity = def_unit;

    Plot_Size     = 0;
    clic_requ     = 0;
    Drwgl_Proceed = Drwgl_Input;
    Drwgl_cursor  = GetCursor();
    SetCursor( VC_CrossHair );

// vBaseGLCanvasPane::Resize( GetWidth(), GetHeight() ); // Do a Refresh.

    Drwgl_Input = drwgl_nothing;
  }

