//=======================================================================
//@V@:Note: This file generated by vgen V1.07 (14:44:21 01 Dec 2000).
//	VGLdrw_cmdw.cpp:	Source for VGL_Draw_ServerCmdWindow class
//=======================================================================

#include <v/vnotice.h>    // for vNoticeDialog
#include <v/vreply.h>     // for vReplyDialog
#include <v/vynreply.h>   // for vYNReplyDialog
#include <v/vfilesel.h>   // for vFileSelect
#include <v/vkeys.h>      // to map keys


#include "VGLdrw_cmdw.h"  // Our headers.
#include "Draw_VGL.h"
#include "Draw_AxisBox.h"



#define  MENU_OK  1


//	Start defines for the main window with 100

//@V@:BeginIDs
    enum {
        m_FirstCmd = 100, // Dummy Command
        m_Dialog,         // TestDialog menu
        m_View,           // View Menu.
        m_Scale,          // Change Scale
        m_Zoom,           // Perform a Zoom
        m_unzoom,         // Undo last Zoom
        m_ChView,         // Mouse Change of View
        m_Reload,         // Reload Canvas at Original Scale.
        m_Refresh,        // Refresh Canvas.
        m_Grid,           // Set/lear the Grid.
        m_VDraw,          // Our Technical Information.
        m_Help,           // Help on VGL_Server.
        m_wsave,          // Save a part Image as a bitmap.
        m_resume,         // Continue after a Dialog User Request.
        m_astop,          // Stop of User Animation.
        m_usereq,         // User task answerd via dialog request.
        m_landscape,      // Set Landscape Orientation.
        m_portrait,       // Set Portrait Orintation.
        lsta_Title,       // Status Bar title.
        lsta_status,      // Server status field.
        lsta_CurTime,     // Date/Time Event ID.
        lsta_currxy,      // Cursor X and Y Current value.
        lbl_MenuTitle,    // User Menu Title.
        lbl_UserMenu,     // User Menu.
        lbl_ValueTitle,   // User Value Title.
        lbl_UserValue,    // User Value Input Request.
        lbl_TextValue,    // User Value Displayed.
        lbl_InpValue,     // User Input Typein Numeric Value.
        blkLast           // Last item.
      };
//@V@:EndIDs

//@V@:BeginIDs
    enum { lblMenuTitle = 1000,  // User Menu Title.
           //         lblMainMsg  = 1100,
//         btnTestDlg            // add your id's here
  };
//@V@:EndIds


//@V@:BeginPulldownMenu FileMenu
    static vMenu FileMenu[] =
      {
        {"&Save",      M_Save,   isSens,  notChk, noKeyLbl, noKey, noSub},
        {"&W_Save",    m_wsave,  isSens,  notChk, noKeyLbl, noKey, noSub},
        {"&Print",     M_Print,  isSens,  notChk, noKeyLbl, noKey, noSub},
        {"-",          M_Line,  notSens,  notChk, noKeyLbl, noKey, noSub},
        {"&Stop Anim", m_astop,  isSens,  notChk, noKeyLbl, noKey, noSub},
        {"E&xit Draw", M_Exit,   isSens,  notChk, noKeyLbl, noKey, noSub},
        {"R&esume",    m_resume, isSens,  notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu ViewMenu
    static vMenu ViewMenu[] =
      {
        {"&View_Ch  ", m_ChView,   isSens, notChk,  noKeyLbl, noKey, noSub},
        {"&Zoom     ", m_Zoom,     isSens, notChk,  noKeyLbl, noKey, noSub},
        {"&Scale    ", m_Scale,    isSens, notChk,  noKeyLbl, noKey, noSub},
        {"&UnZoom   ", m_unzoom,   isSens, notChk,  noKeyLbl, noKey, noSub},
        {"&Reload   ", m_Reload,   isSens, notChk,  noKeyLbl, noKey, noSub},
        {"&Grid     ", m_Grid,     isSens, notChk,  noKeyLbl, noKey, noSub},
        {"&Landscape", m_landscape,isSens, notChk,  noKeyLbl, noKey, noSub},
        {"&Portrait ", m_portrait, isSens, notChk,  noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu HelpMenu
    static vMenu HelpMenu[] =
      {
        {"&Help  ", m_Help,   isSens, notChk,  noKeyLbl, noKey, noSub},
        {"&Draw  ", m_VDraw,  isSens, notChk,  noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginMenu StandardMenu
    static vMenu StandardMenu[] =
      {
        {"&File", M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},
        {"&View", M_View, isSens, notUsed, notUsed, noKey, &ViewMenu[0]},
        {"&Help", M_Help, isSens, notUsed, notUsed, noKey, &HelpMenu[0]},
        {NULL}
      };
//@V@:EndMenu

    static vMenu * Main_Menu;

//@V@:BeginStatPane StatBar
    static vStatus StatBar[] =
      { //1234567890123456789012345678901234567890123456789012345678901234567.
        {"Running for the User program ", lsta_Title, CA_NoBorder, isSens,  0},
        {"<<<<<<<< Initializing >>>>>>>", lsta_status,    CA_None, isSens,  0},
        {"                                                                      ", lsta_currxy,    CA_None, isSens,  0},
        {0,0,0,0,0}
      };
//@V@:EndStatPane


//@V@:BeginDialogCmd User_Menu and User_Value
  CommandObject User_Menu[] =
    {
      {C_Label,  lbl_MenuTitle, 0, "User Menu ",
                                  NoList, CA_MainMsg, isSens, NoFrame, 0, 0 },
      {C_List,   lbl_UserMenu,  0, "Menu", NULL, CA_Size,
                                  isSens, NoFrame, 0, lbl_MenuTitle },
      {C_Button, M_Cancel, M_Cancel, " Cancel ",NoList, CA_None,
                                  isSens, NoFrame,0, lbl_UserMenu },
      {C_EndOfList,0,0,0,0,CA_None,0,0,0}
    };

  CommandObject User_Value[] =
    {
      {C_Label,  lbl_ValueTitle, 0, "User Value Title",
                                  NoList, CA_MainMsg, isSens, NoFrame, 0, 0 },
      {C_Slider, lbl_UserValue,  0, "", NULL, /* CA_Large */ CA_Vertical,
                                  isSens, NoFrame, 0, lbl_ValueTitle },
      {C_Text,   lbl_TextValue,  0, "", (void *)" 0.0000         ", CA_None,
                                  isSens, NoFrame, 0, lbl_UserValue },
      {C_Button, M_OK, lbl_UserValue, " OK ",NoList, CA_None,
                                  isSens, NoFrame, 0, lbl_TextValue },        
      {C_Button, M_Cancel, lbl_UserValue, " Cancel ",NoList, CA_None,
                                  isSens, NoFrame, 0, M_OK },        
      {C_EndOfList,0,0,0,0,CA_None,0,0,0}
    };
//@V@:EndDialogCmd


static   int  Spc_Cmd  = 0,
              Spc_Vlog = 0;

static char * Task_Name[32];


#if MENU_OK > 0

#  define  VM_STACK  64          // Size of Menu Stack.

typedef struct VM_Entry {
                 vMenu   Menu;   // Menu Reference a.
                 vMenu*  sPrv;   // Std. Previous Menu.
                 int     sLen,   // Saved Dynamic Menu Length.
                         mTyp;
               } VM_Entry;


static VM_Entry M_Stk[VM_STACK]; // Stack of menu to build the menu tree.

static int      Msp_Stk,         // Menu stack Pointer.
                Msp_Len,         // Dynamic Menu Length.
                Mcnt_ide;        // Menu Identifier Count.

static vMenu *  Mstd_Menu;       // Standard menu scan Pointer.


#endif


#define EXCH(t,u,v) t = u; u = v; v = t


//=====>>> X<->Y Printer Display Exchange for Portrait/Landscape <<<========

  static void XY_Exchange( int pcd )
  {
    int    iv;
    float  rv;

    if (p_id) {
//    EXCH( iv, pr_rx, pr_ry );
//    EXCH( rv, p_width, p_height );
//    EXCH( rv, ps_rx, ps_ry );
//    EXCH( rv, p_xscale, p_yscale );
//    EXCH( iv, pt_rx, pt_ry );
//    EXCH( rv, pw_sxmin, pw_symin );
//    EXCH( rv, pw_sxmax, pw_symax );
//    EXCH( rv, pw_cxmin, pw_cymin );
//    EXCH( rv, pw_cxmax, pw_cymax );
//    ws_rx = ps_rx;
//    ws_ry = ps_ry;
//    if (Draw_pic_yx >= ws_ry/ws_rx) /* Adjust it with the Required size Ratio */
//      xy_scale = ws_ry/Draw_pic_sy;
//    else
//      xy_scale = ws_rx/Draw_pic_sx;
//    sxy_scale = xy_scale;
//    if (ps_ry*ds_rx > ps_rx*ds_ry)  /* if ps_ry/ps_rx > ds_ry/ds_rx then */
//      cv_scale = ds_ry/ps_ry;       /* ... Set relative scale from y sizes */
//    else
//      cv_scale = ds_rx/ps_rx;       /* ... else, form x sizes. */

      /* It is possible and better to get a Strict Scaled Printer Page View */
//    if ((cv_scale >= 1.0)&&(cv_scale <= 1.5)) cv_scale = 1;

//    vw_scale = cv_scale*xy_scale; /* Compute the Conversion Scale */
//    svw_scale = vw_scale;
//    efxy_scale = 1.0/xy_scale;
//    efvw_scale = 1.0/vw_scale;
    }
  }


//==>>> Prepare The Menu structure as Required by User Task <<<========

  static vMenu* Push_Entry( char* name, int iclic, int isub )
  {
    vMenu* me;

    if (Msp_Stk < VM_STACK-1) {
      me = &(M_Stk[++Msp_Stk].Menu);
      me->label     = name;
      me->menuId    = (iclic)?Mcnt_ide:M_Line;
      me->sensitive = (iclic)?isSens:notSens;
      me->checked   = notChk;
      me->keyLabel  = noKeyLbl;
      me->accel     = noKey;
      me->SubMenu   = noSub;
      me->kShift    = 0;
      M_Stk[Msp_Stk].sPrv = NULL;
      if (isub) {
        M_Stk[Msp_Stk].sLen = Msp_Len + 1;
        M_Stk[Msp_Stk].mTyp = 1;
        Msp_Len = 0;
      } else {
        M_Stk[Msp_Stk].sLen = 0;
        M_Stk[Msp_Stk].mTyp = 0;
        Msp_Len++;
        if (iclic) Mcnt_ide++;
      }
    } else me = NULL;
    return me;
  }




  static vMenu* Push_Std_Entry( int openflg )
  {
    vMenu* me;

    if ((Msp_Stk < VM_STACK-1)&&Mstd_Menu) {
      M_Stk[++Msp_Stk].Menu.SubMenu = (me = Mstd_Menu++);
      if (!(Mstd_Menu->label)) Mstd_Menu = NULL;
      if (openflg&&(me->SubMenu)) {
        M_Stk[Msp_Stk].sPrv = Mstd_Menu;
        M_Stk[Msp_Stk].sLen = Msp_Len + 1;
        M_Stk[Msp_Stk].mTyp = 3;  /* Set Std Open Flag */
        Mstd_Menu = me->SubMenu;  /* Set the Std Scan Pointer in the Menu */
        Msp_Len = 0;
      } else {
        M_Stk[Msp_Stk].sPrv = NULL;
        M_Stk[Msp_Stk].sLen = 0;
        M_Stk[Msp_Stk].mTyp = 2;
        Msp_Len++;
      }
    } else me = NULL;
    return me;
  }




  static void Pop_Entry( vMenu* md )
  {
    vMenu* me;

    if (Msp_Stk >= 0) {
      if (M_Stk[Msp_Stk].mTyp&2) me = M_Stk[Msp_Stk--].Menu.SubMenu;
                            else me = &(M_Stk[Msp_Stk--].Menu);
      md->label     = me->label;
      md->menuId    = me->menuId;
      md->sensitive = me->sensitive;
      md->checked   = me->checked;
      md->keyLabel  = me->keyLabel;
      md->accel     = me->accel;
      md->SubMenu   = me->SubMenu;
      md->kShift    = me->kShift;
    }
  }



  static void Set_In_Usr_Entry( VM_Entry * entr )
  {
    vMenu* ms;
    vMenu* md;

    ms = entr->Menu.SubMenu;
    md = &(entr->Menu);
    md->label     = ms->label;
    md->menuId    = ms->menuId;
    md->sensitive = ms->sensitive;
    md->checked   = ms->checked;
    md->keyLabel  = ms->keyLabel;
    md->accel     = ms->accel;
    md->SubMenu   = ms->SubMenu;
    md->kShift    = ms->kShift;
    Mstd_Menu  = entr->sPrv;
    Msp_Len    = entr->sLen;
    entr->sPrv = NULL;
    entr->sLen = 0;
    entr->mTyp = 0;
  }



  void  Show_Menu_Tree( vMenu * tree, int n )
  {
    do {
      fprintf( fmsg, " Menu_Tree #%6d %6d : %s.\n",
                     n, tree->menuId, tree->label );
      Draw_Fmsgupdate();
      if (tree->SubMenu) Show_Menu_Tree( tree->SubMenu, n + 1 );
    } while ((tree++)->label);
  }



  void  DrwGL_Usr_Menu_Init()
  { /* Routine to prepare the Menu structure by using user information */
    int cd, i, Menu_Req;
    VM_Entry * entr;
    vMenu    * menu;
    char     * name;
    vMenu    * res;

    Menu_Req = (Drwgl_usr_request&SERVER_DO_USER_MENUS)?1:0;

//  fprintf( fmsg, " Draw Task Name = %s.\n", Drwgl_taskname );
//  Draw_Fmsgupdate();

    Main_Menu = StandardMenu;  // Assume the default Menu Tree.
    res = NULL;

    if (Menu_Req) {
      // Now We manage the User Menu Specifications.
      Mstd_Menu = StandardMenu;
      Msp_Stk   =  0;          // Initialize the stack to Empty.
      Msp_Len   =  0;          //
      Mcnt_ide  = blkLast + 1; // ... and the Identifier count.
      M_Stk[0].Menu.SubMenu = NULL;
      M_Stk[0].sPrv = NULL;    // The Standard menu has no Owner.
      M_Stk[0].sLen = 0;
      M_Stk[0].mTyp = 3;       // It is an Opened Standard Menu.

      do { // Loop on the Menu Request.
        Sdrw_Put_Int( cd_continue ); // Send acknowledge to user task.
        Sdrw_Write();          // Write the last Client Answerd.
        i = Sdrw_Read();       // Wait for Read Buffer from User task.
        cd  = Sdrw_Get_Char(); // Get the Menu code operator.

        switch (cd) {
          case 0: /* Close */
            entr = &(M_Stk[Msp_Stk - Msp_Len]); // Get Owner Menu Record.
            if (entr->mTyp == 3) { // For an Opened Standard Menu.
              // We must append all unloaded entry.
              while (Mstd_Menu) Push_Std_Entry( 0 );
            }

            /* Allocate a Menu table of required size */
            menu = (vMenu *) malloc( sizeof( vMenu )*(Msp_Len + 1) );
            /* Now we Pop the Msp_Len menu entry from the stack */
            menu[Msp_Len].label     = NULL;
            menu[Msp_Len].menuId    =    0;
            menu[Msp_Len].sensitive = notSens;
            menu[Msp_Len].checked   =    0;
            menu[Msp_Len].keyLabel  = NULL;
            menu[Msp_Len].accel     =    0;
            menu[Msp_Len].SubMenu   = NULL;
            menu[Msp_Len].kShift    =    0;

            while (Msp_Len) Pop_Entry( &(menu[--Msp_Len]) );

//          Show_Menu_Tree( menu, 10 );

            if (Msp_Stk > 0) {
              if (entr->mTyp&2) Set_In_Usr_Entry( entr ); // Std Menu.
                           else { // User Menu.
                             Msp_Len = entr->sLen;
                             entr->sLen = 0;
                             entr->mTyp = 0;
                           }
              entr->Menu.SubMenu = menu;  // Set the New Menu Table.
            } else res = menu;
          break;

          case 1: /* Open_Std */
            menu = Push_Std_Entry( 1 );
          break;

          case 2: /* Skip */
            i = Sdrw_Get_Int();
            if (M_Stk[Msp_Stk - Msp_Len].mTyp == 3) {
              if (!i) i = 1;
              if (i > 0)
                while ((i-- > 0)&&Mstd_Menu) Push_Std_Entry( 0 );
              else
                while (Mstd_Menu) Push_Std_Entry( 0 );
            }
          break;

          case 3: /* New Menu */
            name = Sdrw_Get_String_Tmp();
            Push_Entry( name, 1, 1 );
          break;

          case 4: /* Entry */
          case 5: /* Barre */
            name = Sdrw_Get_String_Tmp();
            Push_Entry( name, (cd == 4), 0 );
          break;

          default: ;
        }
      } while (res == NULL);
      Main_Menu = res;  // Set the Resulted Menu Tree.
    }
//  Show_Menu_Tree( Main_Menu, 0 );
  }



//====================>>> protoAuxTimer::TimerTick <<<====================
  void VGL_Draw_ServerAuxTimer::TimerTick()
  {
    static int clk_cnt = 0;
    static int astpmod = 0;
    int ret, status, i;
    char buf[128];

    if (Drwgl_astpmod != astpmod) {
      cmdw->SetSens( m_astop, (Drwgl_astpmod)?1:0 ); // Set sensitivity.
      astpmod = Drwgl_astpmod;
    }

    if (Drwgl_period_set) { // Set a new timer Period.
      Drwgl_time_period = Drwgl_period_set;
      Drwgl_period_set = 0;
      TimerSet( Drwgl_time_period ); // Reset time Intervals
    }

    // Drwgl_timcnt += Drwgl_time_period*1.0E-3; // The period is an integer number of second.

    if (clk_cnt++ >= Drwgl_clock_count) clk_cnt = 0;
    if (clk_cnt == 0)
      cmdw->WindowCommand( lsta_CurTime, lsta_CurTime, C_Button ); // Update X/Y

    if (Drwgl_flags&DRWSTATUS_UPDATE)
      cmdw->VGL_Draw_ServerCanvas->Redraw( 0, 0, dt_rx, dt_ry );

    if (Drwgl_flags&DRWSTATUS_INPUT)
    {
      status = 1;
      Drwgl_flags &= ~(DRWSTATUS_UPDATE|DRWSTATUS_INPUT); // Clear the Update flag.
      switch (Drwgl_Input) {
        case drwgl_dialog:
        { reqflg = 1;
          status = 0; ////
          cmdw->WindowCommand( m_Refresh, lbl_UserMenu, C_Button );
          cmdw->SetDialogSens( 1 );   // Set the Dialog Menu sensitivity.
          Drwgl_Dstatus = 0;          // Exit Status is set.
          break;
        }

        case drwgl_message:
        { vNoticeDialog note( theApp );
          note.Notice( Drwgl_strmsg );
          break;
        }

        case drwgl_choice:
        {
          Spc_Cmd = 1;
          cmdw->WindowCommand( m_Dialog, lbl_UserMenu, C_Button );
          break;
        }

        case drwgl_answerd:
        { vYNReplyDialog ynd( theApp );
          ret = ynd.AskYN( Drwgl_strmsg );
          Sdrw_Put_Int( ret );
          break;
        }

        case drwgl_string:
        { vReplyDialog rep( theApp );
          if (Drwgl_strcap > DRWSTRBUF_LENGTH) Drwgl_strcap = DRWSTRBUF_LENGTH;
          strcpy( Drwgl_strbuf, Drwgl_strdef );
          ret = rep.Reply( Drwgl_strmsg, Drwgl_strbuf, Drwgl_strcap, Drwgl_strdef );
          if (ret == M_OK) Sdrw_Put_String( Drwgl_strbuf, 0 );
                      else Sdrw_Put_Char( 0 );
          break;
        }

        case drwgl_file:
        { vFileSelect fsel( theApp );
          if (Drwgl_strcap > DRWSTRBUF_LENGTH) Drwgl_strcap = DRWSTRBUF_LENGTH;
          strcpy( Drwgl_strbuf, Drwgl_strdef );
          if (Drwgl_newmd)
            ret = fsel.FileSelectSave( Drwgl_strmsg, Drwgl_strbuf, Drwgl_strcap,
                                       Drwgl_strtab, Drwgl_fidx );
          else
            ret = fsel.FileSelect( Drwgl_strmsg, Drwgl_strbuf, Drwgl_strcap,
                                   Drwgl_strtab, Drwgl_fidx );
          Sdrw_Put_Char( Drwgl_fidx );
          if (ret&&*Drwgl_strbuf) Sdrw_Put_String( Drwgl_strbuf, 0 );
                             else Sdrw_Put_Char( 0 );
          break;
        }

        case drwgl_value:
        {
          Spc_Cmd = 1; Spc_Vlog = 0;
          if (Drwgl_valmin > Drwgl_valmax) {
            Drwgl_valmin = fabs( Drwgl_valmin );
            Drwgl_valmax = fabs( Drwgl_valmax );
            if ((Drwgl_valmin >= Drwgl_valmax)&&(Drwgl_valmin > 0.0))
              Drwgl_valmin = Drwgl_valmax;
            else
              Spc_Vlog = 1;
          }
          if (Drwgl_valmin == Drwgl_valmax) {
            Drwgl_valmin = 0.0; Drwgl_valmax = 1.0;
          }

          if ((Drwgl_valdef < Drwgl_valmin)||(Drwgl_valdef > Drwgl_valmax))
                 Drwgl_valdef=Drwgl_valmin;
          Drwgl_valret = Drwgl_valdef;
          cmdw->WindowCommand( m_Dialog, lbl_UserValue, C_Button );
          break;
        }

        default: /* For All Mouse Requests */
          cmdw->VGL_Draw_ServerCanvas->Draw_Input_Request();
          status = 0;
      }
      /* Resume the User Request */
      if (status)
      {
        Drwgl_Input   = drwgl_nothing;
        Sdrw_Resume_User_Pipe();
      } else
        if (!reqflg) cmdw->SetDialogSens( 0 );   // Clear the Dialog Menu sensitivity.
    }
  }


//========================>>> VGL_Draw_Dialog::VGL_Draw_DialogDisplayed <<<=========================
  void VGL_Draw_Dialog::DialogDisplayed()
  {
    char buff[32];
    int  lval;

    Drwgl_status = 1;

    switch (Drwgl_Input)
    {
      case drwgl_choice:
      {
        User_Menu[1].itemList = (void *) Drwgl_strtab;
        /* V_User_Menu-> */ SetValue( lbl_UserMenu, 0, ChangeListPtr );
        break;
      }

      case drwgl_value:
      {
        Drwgl_valret = Drwgl_valdef;
        if (Spc_Vlog) {
          Drwgl_valmin = log10( Drwgl_valmin );
          Drwgl_valmax = log10( Drwgl_valmax );
          Drwgl_valdef = log10( Drwgl_valdef );
        }
        lval = (int)((Drwgl_valdef - Drwgl_valmin)*100.0/(Drwgl_valmax - Drwgl_valmin) + 0.5);
        SetValue( lbl_UserValue, lval, Value );
        sprintf( buff, "%f", Drwgl_valret );
        SetString( lbl_TextValue, buff );
        break;
      }

      default: ;
    }
  }

//==============================>>> VGL_Draw_Dialog::DialogCommand <<<==============================
  void VGL_Draw_Dialog::DialogCommand( ItemVal id, ItemVal retval, CmdType ctype )
  {
    UserDebug2(CmdEvents,"VGL_Draw_Dialog::DialogCommand(id:%d, val:%d)\n",id, retval)

    char buff[32];
    int  ans;

    switch (id)             // We will do some things depending on value
      {
        case lbl_UserMenu:
          {
            Drwgl_status = retval + 1;
            CloseDialog();  // Go Out of Menu on a Single answerd Clic.
            break;
          }

        case lbl_UserValue:
          {
            Drwgl_valret = ((float) retval)*(Drwgl_valmax - Drwgl_valmin)/100.0 + Drwgl_valmin;
            if (Spc_Vlog) Drwgl_valret = pow( 10.0, Drwgl_valret );
            sprintf( buff, "%f", Drwgl_valret );
            SetString( lbl_TextValue, buff );
            Drwgl_status = 1;
            break;
          }

        case M_Cancel:
          {
            Drwgl_status = -1;
            break;
          }

        default: ;
      }

    // Let the super class handle M_Cancel.
    vDialog::DialogCommand( id, retval, ctype );
  }



//====================>>> VGL_Draw_ServerCmdWindow::VGL_Draw_ServerCmdWindow <<<====================
  VGL_Draw_ServerCmdWindow::VGL_Draw_ServerCmdWindow( char* name, int width, int height ) :
    vCmdWindow( name, width, height )
  {
    char buff[64] = " Running for ";

//  UserDebug1(Constructor,
//    "VGL_Draw_ServerCmdWindow::VGL_Draw_ServerCmdWindow(%s) Constructor\n",name)

    // The Menu Bar
    VGL_Draw_ServerMenu = new vMenuPane( Main_Menu );
    AddPane( VGL_Draw_ServerMenu );

    // The Canvas
    VGL_Draw_ServerCanvas = new VGL_Draw_ServerOGLCanvasPane(
                            vGL_RGB + vGL_Alpha + vGL_Depth + vGL_DoubleBuffer );
    AddPane( VGL_Draw_ServerCanvas );

    // The Status Bar with the User Task Name and Status.
    VGL_Draw_ServerStatus = new vStatusPane( StatBar );
    AddPane( VGL_Draw_ServerStatus );
    strcat( buff, Drwgl_taskname );
    SetString( lsta_Title, buff );

    Drwgl_Proceed = drwgl_nothing; // Initialize/Runing status is set.

    _auxTimer = new VGL_Draw_ServerAuxTimer( this );  // Create aux timer
    _auxTimer->TimerSet( DRWTIME_PERIOD );            // Time Intervals

    // Associated dialogs

    V_User_Menu  = new VGL_Draw_Dialog( this );
    V_User_Menu->AddDialogCmds( User_Menu );

    V_User_Value = new VGL_Draw_Dialog( this );
    V_User_Value->AddDialogCmds( User_Value );

    // Show Window

    ShowWindow();

    // The Scroll Bare are set to measure there place in pixel unit.
    VGL_Draw_ServerCanvas->ShowVScroll( 1 );    // Show Vert Scroll
    VGL_Draw_ServerCanvas->ShowHScroll( 1 );    // Show Horiz Scroll

    dhs_rx   =   0; dvs_ry   =   0;
    d_Hscrol = 0.0; d_Vscrol = 0.0;

    // Set the Initial Sensitive (or not) Menu Functions.
    // V error ->  The following Line => No dialog possible in X version.
    // SetDialogSens( 0 );   // Clear the Dialog Menu sensitivity.
    SetSens( m_astop, 0 );
    Drwgl_zomeview = 0;        /* Set implicite Zoom */

    if (w_flag == 2) {
      Drwgl_usr_orient = (p_wtype&2)?0:1;
      SetSens( m_landscape, Drwgl_usr_orient );
      SetSens( m_portrait, 1 - Drwgl_usr_orient );
    }
    else
    {
      SetSens( m_landscape, 0 );
      SetSens( m_portrait,  0 );
    }
  }

//====================>>> VGL_Draw_ServerCmdWindow::~VGL_Draw_ServerCmdWindow <<<====================
  VGL_Draw_ServerCmdWindow::~VGL_Draw_ServerCmdWindow()
  {
    UserDebug(Destructor,"VGL_Draw_ServerCmdWindow::~VGL_Draw_ServerCmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.

    delete VGL_Draw_ServerMenu;
    delete VGL_Draw_ServerCanvas;
    _auxTimer->TimerStop();         // end it
    delete _auxTimer;               // free it
    delete V_User_Menu;
    delete V_User_Value;
  }

//====================>>> VGL_Draw_ServerCmdWindow::VGL_Draw_ServerCmdWindow <<<====================
  void VGL_Draw_ServerCmdWindow::SetSens( ItemVal id, int val )
  {
    SetValueAll( id, (val)?isSens:notSens, Sensitive );
  }

//====================>>> VGL_Draw_ServerCmdWindow::VGL_Draw_ServerCmdWindow <<<====================
  void VGL_Draw_ServerCmdWindow::SetDialogSens( int flg )
  {
    static ItemVal
      flg_on[]  = { M_Save, m_wsave,  M_Print, m_resume,
                    m_Zoom, m_Scale, m_unzoom, m_Reload,
                    m_Grid,  m_Help,  m_VDraw,
                        -1,       0 };
    int i = 0;

    while (flg_on[i]) SetSens( flg_on[i++], flg );              // Enable or Disable the Dialog Functions.
    for (i = blkLast+1; i <= Mcnt_ide; i++) SetSens( i, flg );  // Enable or Disable the User Dialog Functions.
    if (Drwgl_astpmod) SetSens( m_astop, (flg)?0:1 );           // Enable or Disable the Animation stop function.
    SetSens( m_ChView, (Drwgl_ViewMat&&flg) );                  // Enable or Disable the Change view (Orientation) Function.
  }

//====================>>> VGL_Draw_ServerCmdWindow::KeyIn <<<====================
  void VGL_Draw_ServerCmdWindow::KeyIn( vKey keysym, unsigned int shift )
  {
    vCmdWindow::KeyIn( keysym, shift );
  }

//================>>> VGL_Draw_ServerCmdWindow::WindowCommand <<<================
  void VGL_Draw_ServerCmdWindow::WindowCommand( ItemVal id, ItemVal val, CmdType cType )
  {
    int  lid, idia, lval;
    char buff[128], date[20];

    static Draw_Ptr Grid_Seg = NULL;


    // Default: route menu and toolbar commands here
    static int prv_mstatus = 0;

    UserDebug1(CmdEvents,"VGL_Draw_ServerCmdWindow:WindowCommand(%d)\n",id)

    if (reqflg||Spc_Cmd||
        (id == lsta_CurTime)||(id == m_Refresh)||(id == m_astop))
    switch (id)
      {
        //@V@:Case m_Help
        case m_Help:
          {
            vNoticeDialog note(this);
            note.Notice("Help Not implemented.");
            break;
          } //@V@:Case m_Help

        //@V@:Case m_astop
        case m_astop:
          {
            if (Drwgl_astpmod) Drwgl_astpstate = Drwgl_astpmod;
            break;
          } //@V@:Case m_astop

        //@V@:Case M_Open
        case M_Open:
          {
            vNoticeDialog note(this);
            note.Notice("Open Not implemented.");
            break;
          }  //@V@:EndCase

        //@V@:Case M_Save
        case M_Save:
          {
            VGL_Draw_ServerCanvas->Draw_Save_Image( 0, 0, dt_rx, dt_ry );
            break;
          }  //@V@:EndCase

        //@V@:Case M_Print
        case M_Print:
          {
            VGL_Draw_ServerCanvas->Draw_Print_Out( 0 );
            break;
          }  //@V@:EndCase

        //@V@:Case M_Exit and Case m_resume
        case M_Exit:
          {
            theApp->Exit();
            break;
          } //@V@:Case M_Exit

        //@V@:Case m_resume
        case m_resume:
          { // Exit from Draw Server.
            // Resume from Dialog Request.
            // Start the redraw to manage users request end screen.
            reqflg        = 0;
            Drwgl_Dstatus = 0;
            SetDialogSens( 0 );   // Clear the Dialog Menu sensitivity.
            Drwgl_Input   = drwgl_nothing;
            Sdrw_Resume_User_Pipe();
            break;
          }  //@V@:Case m_resume

        //@V@:Case m_Reload
        case m_Reload:
          {
            /* Possible PB: Disable the Scroll bare change the Window Size */
            df_Hscr  =       0; df_Vscr  =        0;

            VGL_Draw_ServerCanvas->ShowVScroll( 0 );
            VGL_Draw_ServerCanvas->ShowHScroll( 0 );

            dw_cxmin = dw_sxmin; dw_cxmax = dw_sxmax;
            dw_cymin = dw_symin; dw_cymax = dw_symax;
            dw_cwsx  =  dw_swsx; dw_cwsy  =  dw_swsy;
            dw_cwpx  =  dw_swpx; dw_cwpy  =  dw_swpy;
 
            xy_scale = sxy_scale; /* Restore the Current Scales */
            vw_scale = svw_scale;
            efxy_scale = 1.0/xy_scale;
            efvw_scale = 1.0/vw_scale;

            VGL_Draw_ServerCanvas->Redraw( 0, 0, dt_rx, dt_ry );
            break;
          }  //@V@:Case m_Reload

        //@V@:Case m_Refresh
        case m_Refresh:
          {
            VGL_Draw_ServerCanvas->Redraw( 0, 0, dt_rx, dt_ry );
            break;
          }  //@V@:Case m_Refresh

        //@V@:Case m_Zoom
        case m_Zoom:
          {
            Drwgl_zomeview = 0;        /* Set implicite Zoom */
            Drwgl_Input = drwgl_zoom;  /* Set The Request Kind */
            reqflg = 0;
            VGL_Draw_ServerCanvas->Draw_Input_Request();
            break;
          }  //@V@:EndCase

        //@V@:Case m_ChView
        case m_ChView:
          {
            Drwgl_zomeview = 1;        /* Set implicite Change of View */
            Drwgl_Input = drwgl_view;  /* set the View change Request */
            reqflg = 0;
            VGL_Draw_ServerCanvas->Draw_Input_Request();
            break;
          }

        //@V@:Case m_landscape
        case m_landscape:
          { Drwgl_usr_orient = 0;
            XY_Exchange( 0 );
            SetSens( m_landscape, 0 );
            SetSens( m_portrait, 1 );
            VGL_Draw_ServerCanvas->Redraw( 0, 0, dt_rx, dt_ry );
            break;
          }  //@V@:EndCase

        //@V@:Case m_portrait
        case m_portrait:
          { Drwgl_usr_orient = 1;
            XY_Exchange( 1 );
            SetSens( m_landscape, 1 );
            SetSens( m_portrait, 0 );
            VGL_Draw_ServerCanvas->Redraw( 0, 0, dt_rx, dt_ry );
            break;
          }  //@V@:EndCase

        //@V@:Case m_wsave
        case m_wsave:
          {
            Drwgl_Input = drwgl_savewindow;  /* Set The Request Kind */
            reqflg = 0;
            VGL_Draw_ServerCanvas->Draw_Input_Request();
            break;
          }  //@V@:EndCase

        //@V@:Case m_unzoom
        case m_unzoom:
          {
            VGL_Draw_ServerCanvas->Picture_Scale( -1 );
            VGL_Draw_ServerCanvas->Redraw( 0, 0, dt_rx, dt_ry );
            break;
          }

        //@V@:Case m_Scale
        case m_Scale:
          {
            Drwgl_Inptyp Save_Input = Drwgl_Input;
            double ch_sca, szx, szy;

            Drwgl_Input = drwgl_value;
            Spc_Vlog = 1;
            Drwgl_valdef = xy_scale;
            Drwgl_valmin = (float) pow( 10.0, ((int) (log10( Drwgl_valdef ) + 0.5) - 1));
            Drwgl_valmax = Drwgl_valmin*100.0;
            lval = 0;

            lid = V_User_Value->ShowModalDialog( "Scale (Log)", lval );
            Spc_Vlog = 0; Drwgl_Input = Save_Input;
            if (Drwgl_status <= 0) break;

//          fprintf( fmsg, " Scale Change res = %f to %f, %d.\n", xy_scale, Drwgl_valret, lval );
//          Draw_Fmsgupdate();

            ch_sca = xy_scale/Drwgl_valret;
            szx    = dw_cwsx*ch_sca;
            szy    = dw_cwsy*ch_sca;

            Drwgl_xcoord = dw_cwpx - szx; Drwgl_xcurr = dw_cwpx + szx;
            Drwgl_ycoord = dw_cwpy - szy; Drwgl_ycurr = dw_cwpy + szy;

            VGL_Draw_ServerCanvas->Picture_Scale( 0 );
            VGL_Draw_ServerCanvas->Redraw( 0, 0, dt_rx, dt_ry );
            break;
          }  //@V@:EndCase

        //@V@:Case m_Grid
        case m_Grid:
          {
            if (!Grid_Seg)
              Grid_Seg = Draw_GPlot_Grid();
            else {
              Draw_Destroye( Grid_Seg );
              Grid_Seg = NULL;
            }

            VGL_Draw_ServerCanvas->Redraw( 0, 0, dt_rx, dt_ry );
            break;
          }  //@V@:EndCase

        //@V@:Case m_Dialog
        case m_Dialog:
          {
            Spc_Cmd = 0;
            switch (val) {
              case lbl_UserMenu: // User Menu Input Request.
//              fprintf( fmsg, " Dialog/User_Menu Enabling with %d .\n", val );
//              Draw_Fmsgupdate();
                lid  = V_User_Menu->ShowModalDialog( Drwgl_strmsg, lval );

                if (lid == M_Cancel) lval = -1;
                                else lval = V_User_Menu->GetValue( lbl_UserMenu ) + 1;

//              fprintf( fmsg, " Choice Results = %d, %d.\n", lid, lval );
//              Draw_Fmsgupdate();

                Sdrw_Put_Int( Drwgl_status );
              break;

              case lbl_UserValue:  // User Value Input Request
//              fprintf( fmsg, " Dialog/User_get_Value Enabling with %d .\n", val );
//              Draw_Fmsgupdate();
                lid = V_User_Value->ShowModalDialog( Drwgl_strmsg, lval );
                Sdrw_Put_Int( /* (lid == M_Cancel)?-1:1 */ Drwgl_status );
                Sdrw_Put_Float( Drwgl_valret );
              break;

              default: ;
            }
            break;
          } //@V@:EndCase


        case lsta_CurTime:  // Update the status bar
          {
            if (Drwgl_Proceed >= drwgl_position)
              SetString( lsta_status, Drwgl_StatusStr[Drwgl_Proceed] );
            else 
              SetString( lsta_status, Drwgl_StatusStr[Drwgl_Input] );

            if (Drwgl_mactive)
            { /* Input Interaction Is Active */
              float xx, yy, zz;
              Draw_Axis_Ptr u, v;
              char* xunit;
              char* yunit;
              char  defstr[] = "  ";

              if (Draw_Opened_Box) { /* An Axis Box is currently Opened */
                u = Draw_Opened_Box->box_axis[0];
                v = Draw_Opened_Box->box_axis[1];
                xunit = (u)?u->axis_unit:NULL;
                yunit = (v)?v->axis_unit:NULL;

                Draw_UnScale( &xx, &yy, &zz, Drwgl_xcurr, Drwgl_ycurr, 0.0 ); 
              } else {
                xx = Drwgl_xcurr - orgx;
                yy = Drwgl_ycurr - orgy;
                xunit = Drwgl_unitx;
                yunit = Drwgl_unity;
              }
              if (!xunit) xunit = defstr;
              if (!yunit) yunit = defstr;
              sprintf( buff, " X = %8.2f %s, Y = %8.2f %s ",
                             xx, xunit, yy, yunit );
              SetString( lsta_currxy, buff );
              prv_mstatus = 1;
            }
            else
              if (prv_mstatus)
              { prv_mstatus = 0;
                SetString( lsta_currxy, " " );
              }
          }

        default:            // Route unhandled commands up
          {
            if ((id > blkLast)&&(id < Mcnt_ide)) {
              /* User Menu Identifier code => Simule a Resume */
              reqflg        = 0;
              Drwgl_Dstatus = id - blkLast;
              Drwgl_Input   = drwgl_nothing;
              SetDialogSens( 0 );   // Clear the Dialog Menu sensitivity.
              Sdrw_Resume_User_Pipe();
	    } else {
              vCmdWindow::WindowCommand(id, val, cType);
            }
            break;
           }
      }
    else
    {
      vNoticeDialog note(this);
      note.Notice("User Process busy, Wait Please.");
    }
  }
