/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               D R A W   -   S E R V E R   M O D U L E                 *
*                                                                       *
*               Application module (in the V app model)                 *
*                                                                       *
*                               by                                      *
*                                                                       *
*          Pierre Wolfers, Laboratoire de Cristallographie              *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                 Version V1.3 of the 09-Aug-2006                       *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/

/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/



//=======================================================================
//@V@:Note: This file generated by vgen V1.07 (14:44:21 01 Dec 2000).
//	VGLdrw_app.cpp:	Source for VGL_Draw_ServerApp class
//=======================================================================

#include "VGLdrw_app.h"		// Header file

#include "Draw_VGL.h"           // Specific Task.

#include <v/vynreply.h>         // For Exit Server Methode.




//=========================>>> VGL_Draw_ServerApp::VGL_Draw_ServerApp <<<==========================
  VGL_Draw_ServerApp::VGL_Draw_ServerApp(char* name, int sdi, int h, int w) : vApp(name, sdi, h, w)
  {
    // Constructor

   _VGL_Draw_ServerCmdWin = 0;
  }

//=========================>>> VGL_Draw_ServerApp::VGL_Draw_ServerApp <<<==========================
  VGL_Draw_ServerApp::~VGL_Draw_ServerApp()
  {
    // Destructor
  }

//=====================>>> VGL_Draw_ServerApp::NewAppWin <<<==========================
  vWindow* VGL_Draw_ServerApp::NewAppWin(vWindow* win, char* name,
    int w, int h, vAppWinInfo* winInfo)
  {
    vAppWinInfo* awinfo = winInfo;
    char *appname = name;

    if (!*name)
      {
	 appname = "V GL Draw Server";		// Default name
      }
	
    UserDebug1(Build,"VGL_Draw_ServerApp::NewAppWin(%s)\n",appname);

    // Create the first window using provided CmdWindow

    _VGL_Draw_ServerCmdWin = (VGL_Draw_ServerCmdWindow*) win;
    if (!_VGL_Draw_ServerCmdWin)
      {
	_VGL_Draw_ServerCmdWin = new VGL_Draw_ServerCmdWindow(appname, w, h);
      }

    if (!awinfo)
	awinfo = new vAppWinInfo(appname);

    return vApp::NewAppWin(_VGL_Draw_ServerCmdWin, appname, w, h, awinfo);
  }

//============================>>> VGL_Draw_ServerApp::Exit <<<===========================
  void VGL_Draw_ServerApp::Exit(void)
  {
    vYNReplyDialog ynd( theApp );
    int ret;

    // This is called to close all windows.

    UserDebug(Build,"VGL_Draw_ServerApp::Exit()\n");

//  fprintf( fmsg, " Exit With reqflg=%d, reqnxt=%d, exitmd=%d.\n",
//                 reqflg, reqnxt, Drwgl_exitmd );
//  Draw_Fmsgupdate();

    if (reqflg) { // Exit When Dialog is Enabled.
      Drwgl_Dstatus = (Drwgl_exitmd&1)?-1:-10; // Set Dialog Exit Status.
      if (Drwgl_Dstatus == -10)
        ret = ynd.AskYN( "Not User Task Managed Exit, Are You Sure ?" );
      else
        ret = 1;
      if (ret > 0) { // Simule an Dialog Resume Request.
        reqflg = 0;
        Drwgl_Input  = drwgl_nothing;
        Sdrw_Resume_User_Pipe();
      } else Drwgl_Dstatus = 0;
    } else {
      if ((reqnxt >= 0)|(reqnxt == -10)) { // Suspect Exit tentative.
        ret = ynd.AskYN( "Debugging Cancel Graphic Server, Are You Sure ?" );
        if (ret > 0) reqnxt = -10; 
      }

      // Exit when required.
      if (reqnxt < 0) vApp::Exit();
    }
  }

//======================>>> VGL_Draw_ServerApp::CloseAppWin <<<===========================
  int VGL_Draw_ServerApp::CloseAppWin(vWindow* win)
  {
    // This will be called BEFORE a window has been unregistered or
    // closed.  Default behavior: unregister and close the window.

    UserDebug(Build,"VGL_Draw_ServerApp::CloseAppWin()\n");

    return vApp::CloseAppWin(win);
  }

//=====================>>> VGL_Draw_ServerApp::AppCommand <<<==============================
  void VGL_Draw_ServerApp::AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType)
  {
    // Commands not processed by the window will be passed here

    UserDebug1(Build,"VGL_Draw_ServerApp::AppCmd(ID: %d)\n",id);
    vApp::AppCommand(win, id, val, cType);
  }

//=========================>>> VGL_Draw_ServerApp::KeyIn <<<==============================
  void VGL_Draw_ServerApp::KeyIn(vWindow* win, vKey key, unsigned int shift)
  {
    // Key strokes not processed by the window will be passed here

    vApp::KeyIn(win, key, shift);
  }

//###########################################################################

  static VGL_Draw_ServerApp VGL_Draw_Server_App("V GL Draw Server",1);	// The instance of the app

//============================>>> AppMain <<<==============================
  int AppMain(int argc, char** argv)
  {
  int i;
    Drwgl_taskname = " User program ";

    // Use AppMain to create the main window

    dr_rx = 600; dr_ry = 440;      /* Set default resolution. */

    Sdrw_Pre_Init();               /* Pre Init Setting to perform in first */

    Sdrw_Params_Setting();         /* Set Display and Printer Parameters. */

    Sdrw_Init( argc, argv );       /* Perform the Basic Draw init */

    fprintf( fmsg, " Start Draw Server.\n" );
    Draw_Fmsgupdate();

    Sdrw_Open_Gate( argc, argv );  /* Init the Pipe I/O channels.   */

    fprintf( fmsg, " Draw Bidirectional Pipe Enabled.\n" );
    Draw_Fmsgupdate();

    Draw_Exchange_Init();          /* Initiate the Client Server Request */

    DrwGL_Usr_Menu_Init();         /* Initialize the Main Menu Structures */

    fprintf( fmsg, " Draw User Menu Handled.\n" );
    Draw_Fmsgupdate();

//  if ((argc > 4)&&(argv[4]!=NULL)) Drwgl_taskname = argv[4];

    fprintf( fmsg, " Create Window of (%d*%d)\n", dtr_rx, dtr_ry );
    Draw_Fmsgupdate();

    Sdrw_Start_User_Pipe();        /* Start the User Pipe Thread */

    (void) theApp->NewAppWin( 0, Drwgl_taskname, dtr_rx, dtr_ry );

    return 0;
  }
