#
# Standard defines:
#
include $(PASENV)/system.make
#
# next are done by system.make
# CXX  	=	g++
# CC	=	gcc

Src	=	.
oDir	=	.
Bin	=	.

V_LIB	=	/usr/local/lib
GL_LIB	=

V_INC	=	/usr/local/include
GL_INC	=


libDirs	=	-L$(V_LIB)

incDirs	=	-I$(V_INC) -I../include/ -I/usr/X11R6/GL/lib -I/usr/X11R6/lib

LIBS	=	-lV -lVgl $(GLIBS) -lpthread

C_FLAGS	=	-O

SRCS	=\
	$(Src)/VGLdrw_insymbol.cpp\
	$(Src)/VGLdrw_exchange_man.cpp\
	$(Src)/VGLdrw_proceed.cpp\
	$(Src)/VGLdrw_app.cpp\
	$(Src)/VGLdrw_cmdw.cpp\
	$(Src)/VGLdrw_cnv.cpp\
	$(Src)/VGLdrw_gl2ps.cpp\
	$(Src)/Draw_VGL_Print.cpp\
	$(Src)/Draw_VGL.cpp\
	$(Src)/Draw_Init_Server.cpp\
	$(Src)/Draw_Base_Server.cpp\
	$(Src)/Draw_AxisBox.cpp\
	$(Src)/Draw_NumCV.cpp\
	$(Src)/Draw_Make_Font.c

EXOBJS	=\
	$(Src)/VGLdrw_insymbol.o\
	$(Src)/VGLdrw_exchange_man.o\
	$(Src)/VGLdrw_proceed.o\
	$(Src)/VGLdrw_app.o\
	$(Src)/VGLdrw_cmdw.o\
	$(Src)/VGLdrw_cnv.o\
	$(oDir)/VGLdrw_gl2ps.o\
	$(Src)/Draw_VGL_Print.o\
	$(Src)/Draw_VGL.o\
	$(Src)/Draw_Init_Server.o\
	$(Src)/Draw_Base_Server.o\
	$(Src)/Draw_AxisBox.o\
	$(Src)/Draw_NumCV.o


ALLOBJS	=	$(EXOBJS)
ALLBIN	=	$(Bin)/VGL_Draw_Server $(Bin)/VGL_Make_Font
ALLTGT	=	$(Bin)/VGL_Draw_Server $(Bin)/VGL_Make_Font

# User defines:

#@# Targets follow ---------------------------------

all:	$(ALLTGT)

objs:	$(ALLOBJS)

cleanobjs:
	rm -f $(ALLOBJS)

cleanbin:
	rm -f $(ALLBIN)

clean:	cleanobjs cleanbin

cleanall:	cleanobjs cleanbin

#@# User Targets follow ---------------------------------


#@# Dependency rules follow -----------------------------

$(Bin)/VGL_Draw_Server: $(EXOBJS)
	$(CXX) -o $(Bin)/VGL_Draw_Server $(EXOBJS) $(incDirs) $(libDirs) $(LIBS)

$(oDir)/VGLdrw_insymbol.o: VGLdrw_insymbol.cpp
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_exchange_man.o: VGLdrw_exchange_man.cpp
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_proceed.o: VGLdrw_proceed.cpp Draw_VGL.h VGLdrw_cmdw.h \
 VGLdrw_cnv.h Draw_AxisBox.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_app.o: VGLdrw_app.cpp VGLdrw_app.h VGLdrw_cmdw.h VGLdrw_cnv.h \
 Draw_VGL.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_cmdw.o: VGLdrw_cmdw.cpp VGLdrw_cmdw.h VGLdrw_cnv.h Draw_VGL.h \
 Draw_AxisBox.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_cnv.o: VGLdrw_cnv.cpp VGLdrw_cnv.h Draw_VGL.h VGLdrw_cmdw.h \
 Draw_AxisBox.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_gl2ps.o: VGLdrw_gl2ps.cpp VGLdrw_gl2ps.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_VGL.o: Draw_VGL.cpp Draw_VGL.h VGLdrw_cmdw.h VGLdrw_cnv.h \
	VGLdrw_gl2ps.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_VGL_Print.o: Draw_VGL_Print.cpp VGLdrw_cmdw.h VGLdrw_cnv.h \
 Draw_VGL.h VGLdrw_gl2ps.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_Init_Server.o: Draw_Init_Server.cpp VGLdrw_cnv.h VGLdrw_cmdw.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_Base_Server.o: Draw_Base_Server.cpp Draw_VGL.h VGLdrw_cmdw.h \
 VGLdrw_cnv.h Draw_AxisBox.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_AxisBox.o: Draw_AxisBox.cpp Draw_VGL.h VGLdrw_cmdw.h VGLdrw_cnv.h \
 Draw_AxisBox.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_NumCV.o: Draw_NumCV.cpp Draw_VGL.h VGLdrw_cmdw.h VGLdrw_cnv.h
	$(CXX) $(C_FLAGS) $(incDirs) -c -o $@ $<

# To Build the Font Generator.

$(Bin)/VGL_Make_Font: Draw_Make_Font.c
	$(CC) $(C_FLAGS) -o $(Bin)/VGL_Make_Font $(incDirs) Draw_Make_Font.c -lm
