#include <draw/sdrw_null_env.h>


//#include "Draw_VGL.h"           // Specific Task.


/* include the environment SERVER */

#include <draw/draw_common.h>
//#include <draw/sdrw_env.h>
#include <draw/sdrw_routines.h>

//#include "Draw_VGL.h"
#include "Draw_AxisBox.h"


#define Menu_Max    32
#define Menu_ItmSz  64
#define Menu_BfSize Menu_Max*(Menu_ItmSz + 1)


void   Sdrw_Close_Gate();  /* End of Client-Server relation for reverse mode */


/****  Local Variables  ****/

static eqv_if  equ;        /* An equivalent model for Sdrw routines */

static char * menu[Menu_Max + 1];    /* Pointer for strings */
static char   menu_buf[Menu_BfSize];
static int    menu_topn, menu_tops;

static char draw_pvw = 0;  /* Flag for DRAW$PIC_VIEW */



/* Debugging Output Update procedure */

void Sdrw_Pre_Init()
{ /* Initialize the Draw/GL Interface */
  int i;

  /* Init Color Tables */
  for (i=0;i<15;i++)
  { draw_srccoltb[i][0] = draw_defcoltb[i][0];
    draw_srccoltb[i][1] = draw_defcoltb[i][1];
    draw_srccoltb[i][2] = draw_defcoltb[i][2];
    draw_lprcoltb[i][0] = draw_defcoltb[i][0];
    draw_lprcoltb[i][1] = draw_defcoltb[i][1];
    draw_lprcoltb[i][2] = draw_defcoltb[i][2];
  }
}



/**************************************************************************/

void Sdrw_Init( int argc, char ** argv )
{
  int i, wflag;
  
  fmsg = fopen( "DRAW_ERROR.TXT", "w" );

  for (i=0;i<argc;i++)
    if (argv[i]!=NULL)
      fprintf( fmsg, " argv %d = ""%s""\n", i, argv[i] );

  w_flag = 0;                   /* To flag no output display choice */
  
  if (d_id&&(dr_rx > 0.0)&&(dr_ry > 0.0))
  { /* The Screen Work Station is Defined. */
    fprintf( fmsg, " Specified Display type is %d, %d.\n", d_wtype, d_categ );
    fprintf( fmsg, " Screen Display Setup:\n" );
    fprintf( fmsg, "  Resolution = %d * %d\n", dr_rx, dr_ry );

    if (d_width > 0.0)
    { /* A metric is defined for the Screen Graphic Work Station. */
      d_unit = centimeter;
      if (d_hight <= 0.0) d_hight = (((float)dr_ry)/((float)dr_rx))*d_width;
    }
    else
    {
      d_unit  = raster;
      d_width = dr_rx;
      d_hight = dr_ry;
    }
    if ((ds_rx >= d_width)||(ds_rx <= 0.0)) ds_rx = 0.8*d_width;
    if ((ds_ry >= d_hight)||(ds_ry <= 0.0)) ds_ry = 0.8*d_hight;

    ds_rx = floor( ds_rx ); /* Round Down W. Size */
    ds_ry = floor( ds_ry );
    d_xscale = dr_rx/d_width;
    d_yscale = dr_ry/d_hight;
    dt_rx = (int) (ds_rx*d_xscale);
    dt_ry = (int) (ds_ry*d_yscale);
    fprintf( fmsg, "  Screen Size (cm) = %f * %f\n", d_width, d_hight );
    fprintf( fmsg, "  Window Size (cm) = %f * %f\n", ds_rx, ds_ry );
    fprintf( fmsg, "  Window Size (pixels) = %d * %d\n", dt_rx, dt_ry );
    fprintf( fmsg, "  => %f * %f pixels/cm.\n", d_xscale, d_yscale );
    w_flag = 1;
  }

  if (!w_flag)
  { /* No defined Display => Set a default Screen Display */
    d_wtype = 1;
    d_categ = 3;
    d_id  = 1;                  /* Force a Defaulted Screen */
    dr_rx = 640; dr_ry = 480;   /* Select a default resolution */
    ds_rx = (float) dr_rx;
    ds_ry = (float) dr_ry;
    d_hight = sqrt( ds_rx*ds_rx + ds_ry*ds_ry ); /* Diagonal size in pixels */
    d_xscale = d_hight/(15.0*2.54); /* Scale for a 15" Screen */
    d_yscale = d_xscale;
    d_width  = dr_rx/d_xscale;
    d_hight  = dr_ry/d_yscale;
    ds_rx = ceil( 0.8*d_width );
    ds_ry = ceil( 0.8*d_hight );
    dt_rx = (int) (ds_rx*d_xscale);
    dt_ry = (int) (ds_ry*d_yscale);
    fprintf( fmsg, "  Defaulted Screen Size (cm?) = %f * %f\n", d_width, d_hight );
    fprintf( fmsg, "  Defaulted Window Size (cm?) = %f * %f\n", ds_rx, ds_ry );
    fprintf( fmsg, "  Defaulted Window Size (pixels) = %d * %d\n", dt_rx, dt_ry );
    fprintf( fmsg, "  => %f * %f pixels/cm.\n", d_xscale, d_yscale );
    d_unit  = centimeter;
  }

  ws_rx  = ds_rx;
  ws_ry  = ds_ry;
  w_unit = d_unit;
  w_flag = 1;      


  if (p_id&&(pr_rx > 0.0)&&(pr_ry > 0.0))
  { /* The Printer/Plotter Work Station is Defined. */
    fprintf( fmsg, " Specified Printer type is %d, %d.\n", p_wtype, p_categ );
    fprintf( fmsg, " Printer Display Setup:\n" );
    fprintf( fmsg, "  Resolution = %d * %d\n", pr_rx, pr_ry );

    if (p_width > 0.0)
    { /* A metric is defined for the Hard Copy Graphic Work Station. */
      p_unit = centimeter;
      if (p_hight <= 0.0) p_hight = (((float)pr_ry)/((float)pr_rx))*p_width;
    }
    else
    {
      p_unit  = raster;
      p_width = pr_rx;
      p_hight = pr_ry;
    }
    if ((ps_rx >= p_width)||(ps_rx <= 0.0)) ps_rx = 0.8*p_width;
    if ((ps_ry >= p_hight)||(ps_ry <= 0.0)) ps_ry = 0.8*p_hight;
    ps_rx = floor( ps_rx ); /* Round Down W. Size */
    ps_ry = floor( ps_ry );
    p_xscale = pr_rx/p_width;
    p_yscale = pr_ry/p_hight;
    pt_rx = (int) (ps_rx*p_xscale);
    pt_ry = (int) (ps_ry*p_yscale);
    fprintf( fmsg, "  Paper Size (cm) = %f * %f\n", p_width, p_hight );
    fprintf( fmsg, "  Window Size (cm) = %f * %f\n", ps_rx, ps_ry );
    fprintf( fmsg, "  Window Size (pixels) = %d * %d\n", pt_rx, pt_ry );
    fprintf( fmsg, "  => %f * %f pixels/cm.\n", p_xscale, p_yscale );

    pw_sxmin = pw_cxmin = - (pw_sxmax = pw_cxmax = ps_rx*0.5);
    pw_symin = pw_cymin = - (pw_symax = pw_cymax = ps_ry*0.5);

    /* Set the printer parameters as Display parameters */
    ws_rx  = ps_rx;
    ws_ry  = ps_ry;
    w_unit = p_unit;
    w_flag = 2;
  }
  else p_id = 0; /* Simule No Printer if Illegal Printer Setup */

  dtr_rx = dt_rx + (int)(d_xscale + 0.5);  /* Add 1cm for req. Window Size ... */
  dtr_ry = dt_ry + (int)(d_yscale + 0.5);  /* ... To set the good V window size. */

  s_dt_rx  =  dt_rx; s_dt_ry  =  dt_ry;    /* Save the Window sizes (pixels) */

  dw_ixmin = dw_sxmin = dw_cxmin = - (
                dw_ixmax = dw_sxmax = dw_cxmax = ws_rx*0.5);
  dw_iymin = dw_symin = dw_cymin = - (
                dw_iymax = dw_symax = dw_cymax = ws_ry*0.5);

  emarginx = 1.0;  /* Set the Default Picture Margins (cm) or (cm?) */
  emarginy = 1.0;
  /* Initialize the Drawing Structure to Empty state */

  draw_root      = NULL;
  draw_fsegm     = NULL;
  draw_lsegm     = NULL;
  draw_fsysseg   = NULL;
  draw_lsysseg   = NULL;
  draw_curseg    = NULL;
  draw_seg_count =    0;

  draw_lock_flag =   -1; /* Init the lock flag */

  g_flags = 1;
  Draw_Fmsgupdate();
}




/**************************************************************************/



void Draw_Fmsgupdate()
{
  fclose( fmsg );
  fmsg = fopen( "DRAW_ERROR.TXT", "a+" );
}



void Draw_Error( char *msg )
{
  if (!fmsg) fmsg = fopen( "DRAW_ERROR.TXT", "w" );
  fprintf( fmsg, " *Draw Error: %s", msg );
  Draw_Fmsgupdate();
}



void Draw_Extern_Init( void )
{ /* */
//Char  b0, b1, b2, b3;
//float x, y;
  
//status = Draw_Init( &x, &y, &b0, &b1, &b2, &b3 );
  /* Return the Server and Display Specifications to client Application. */
  Sdrw_Put_Float( 21.0 );
  Sdrw_Put_Float( 17.0 );
  Sdrw_Put_Char( 0 );
  Sdrw_Put_Char( 0 );        /* What Server...GKS...PHIGS... V ...or others. */
  Sdrw_Put_Char( 0 );        /* DRAW functions selection. */
  Sdrw_Put_Char( 0 );        /* Hight bits to set or not. */

  Sdrw_Write();              /* Write the last Client Answerd */
  reqnxt = 0;                /* Turn to User Task Command Mode */

  //Draw_End_Dialog();         /* Return to continue pipe input */ 

 }



void Draw_Sequence_Exec( void )
{ /* Main DRAW code Processor */
  Char  b0, b1, b2, b3, bupd;
  int   code, flg, i, i0, i1, i2, len, n;
  float r, v0, v1, v2, x, x0, x1, y, y0, y1, z, z0, z1;
  float ftb[16];
  int   itb[16];
  Char  btb[16];
  Draw_Ptr p;
  Draw_Box_Ptr pb;

  static char s0[256], s1[256], s2[256];
 
  while (1)
  { /* Loop on Pipe User Program Requests */
    bupd = 0;                 /* Assume no update */
    len = Sdrw_Read();        /* Wait for Read Buffer from User Application. */
//  fprintf( fmsg, " Draw msg of %d bytes.\n", len );
    code = Sdrw_Get_Code();   /* Get the Draw Operator code. */
//  fprintf( fmsg, " Draw Code %d.\n", code );
//  Draw_Fmsgupdate();
    reqnxt = 0;
 
//  Sdrw_read_lock( 0 );      /* Lock the User Directive Execution Graph. */

    switch(code) {            /* Dispatch to the related DRAW routine. */

    case cd_picture:
      Sdrw_Get_String( sv_title );
      x  = Sdrw_Get_Float();  /* Get the Required space */
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      b1 = Sdrw_Get_Char();
      b2 = Sdrw_Get_Char();
//    b0 = Draw_Picture( sv_title, x, y, z, b1, b2 );
      bupd = draw_pvw;
      Sdrw_Put_Char( 1 );
    break;

    case cd_pic_view:
      flg = Sdrw_Get_Char();
      draw_pvw = 1;
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_pic_reset:
      flg = Sdrw_Get_Char();
      draw_pvw = 0;
      Sdrw_Put_Char( 0 );
    break;

    case cd_clipon:
//    Draw_Gen_Box_Ref( 1 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_clipoff:
//    Draw_Gen_Box_Ref( 0 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_org:
      x = Sdrw_Get_Float();
      y = Sdrw_Get_Float();
      z = Sdrw_Get_Float();
      i = Sdrw_Get_Int();
      if (i == 0)
      { /* Relative To previous Origine */
        orgx += x;
        orgy += y;
        orgz += z;
      } else { /* Absolute (as after Picture Call) Origine */
        orgx = org_orgx + x;
        orgy = org_orgy + y;
        orgz = org_orgz + z;
      }
      Sdrw_Put_Char( 0 );
    break;

    case cd_color:
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      v0 = Sdrw_Get_Float();
//    Draw_Gen_Color( x, y, v0 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_out_mode:
      draw_out_mode = Sdrw_Get_Int();
      Sdrw_Put_Char( 0 );
    break;

    case cd_mplot:
      n  = Sdrw_Get_Int();
      i0 = Sdrw_Get_Int();
//    Draw_Gen_Mplot( n, i0, NULL );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
   break;

    case cd_circle:
      i0 = Sdrw_Get_Int();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      r  = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
      if (!(i0&8)) { x += orgx; y += orgy; }
//    Draw_Gen_Circle( x, y, r, v1, v2 );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_string:
      i0 = Sdrw_Get_Char();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
//    fprintf( fmsg, " => At (%f,%f) Draw String .\n", x, y );
      if (!(i0&8)) { x += orgx; y += orgy; }
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      i  = Sdrw_Get_String( s0 );
//    fprintf( fmsg, " => At (%f,%f) %d:String %s .\n", x, y, i, s0 );
//    Draw_Fmsgupdate();
//    Draw_Gen_Text( x, y, v0, v1, i, s0 );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_sphere:
      i0 = Sdrw_Get_Int();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      r  = Sdrw_Get_Float();
      if (!(i0&8)) { x += orgx; y += orgy; z += orgz; }
//    Draw_Gen_Sphere( x, y, z, r );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_view: /* Params are: float left,right,bottom,top,near,far
                            and: int */
      Draw_View_Dist = Sdrw_Get_Float() + (draw_uzmax + draw_uzmin)/2.0;
      if (Draw_View_Dist <= draw_uzmax) Draw_View_Dist = 0.0;
      Sdrw_Put_Char( 0 );
    break;

    case cd_wplane3: /* Define a plot plane for next drawing directive */
      for (i = 0; i < 12; i++) ftb[i] = Sdrw_Get_Float();
//    Draw_Gen_Eplane( ftb );
      Sdrw_Put_Char( 0 );
    break;

    case cd_nplane3: /* Release a plot plane for next drawing directive */
//    Draw_Gen_Eplane( NULL );
      Sdrw_Put_Char( 0 );
    break;

    case cd_define_color:
      n  = Sdrw_Get_Int();
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
      v2 = Sdrw_Get_Float();
//    Draw_Set_Color_Def( n, v0, v1, v2 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_inquire_color:
//    Draw_Get_Color_Def( Sdrw_Get_Int(), &v0, &v1, &v2 );
      Sdrw_Put_Int( status );
      Sdrw_Put_Float( 1.0 );
      Sdrw_Put_Float( 1.0 );
      Sdrw_Put_Float( 1.0 );
    break;

    case cd_line_attr:
      n = Sdrw_Get_Int();
      r = Sdrw_Get_Float();
//    Draw_Gen_Lattr( n, r );
      Sdrw_Put_Char( 0 );
    break;

    case cd_marker_attr:
      n = Sdrw_Get_Int();
      r = Sdrw_Get_Float();
//    Draw_Gen_Mattr( n, r );
      Sdrw_Put_Char( 0 );
    break;

    case cd_fill_area_attr:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
//    Draw_Gen_Fattr( i0, i1 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_text_font:
      n  = Sdrw_Get_Int();
      i0 = Sdrw_Get_Int();
//    Draw_Gen_Font( n, i0 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_text_attr:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      v0 = Sdrw_Get_Float();
      v1 = Sdrw_Get_Float();
//    Draw_Gen_Tattr( i0, i1, i2, v0, v1 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_new_seg:
      i0 = Sdrw_Get_Int();
//    p = Draw_New_Segment( i0, 0 );
//    Sdrw_Put_Int( p->seg.seg_ide );
      Sdrw_Put_Int( 100 );
    break;

    case cd_seg_end:
      draw_curseg = NULL;
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_del_seg:
//    p =  Draw_Locate_Seg( n );
//    if (p) Draw_Destroye( p );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_update_seg:
      i0 = Sdrw_Get_Int();
//    p = Draw_New_Segment( i0, 1 );
//    Sdrw_Put_Int( p->seg.seg_ide );
      Sdrw_Put_Int( 100 );
    break;

    case cd_seg_attr:
      n  = Sdrw_Get_Int();
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      r  = Sdrw_Get_Float();
//    if (Draw_Set_Seg_Attr( n, i0, i1, i2, r )) bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_seg_picid:
      i0 = Sdrw_Get_Int();
      if (i0 > 0) draw_curr_pid = i0;
      Sdrw_Put_Char( 0 );
    break;

    case cd_seg_inquire:
      if (draw_curseg) Sdrw_Put_Int( draw_curseg->seg.seg_ide );
                  else Sdrw_Put_Int( -1 );
    break;

    case cd_valdispl_mod:
//    Drwgl_xlogflg = Sdrw_Get_Char();
//    Drwgl_ylogflg = Sdrw_Get_Char();
//    for (i = 0; i < 6; i++) Drwgl_inpmat[i] = Sdrw_Get_Float();
//    if (Drwgl_xlogflg) Sdrw_Get_String( Drwgl_xusr_unt );
//                  else Drwgl_xusr_unt[0] = 0;
//    if (Drwgl_ylogflg) Sdrw_Get_String( Drwgl_yusr_unt );
//                  else Drwgl_yusr_unt[0] = 0;
      Sdrw_Put_Char( 0 );
    break;

    case cd_init_trans_seg:
//    p  = Draw_Locate_Seg( Sdrw_Get_Int() );  /* Get the Segment Number */
//    DrwGL_Seg_Unit_Transform( p );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_move_seg:
//    p  = Draw_Locate_Seg( Sdrw_Get_Int() );  /* Get the Segment Number */
//    x  = Sdrw_Get_Float();
//    y  = Sdrw_Get_Float();
//    z  = Sdrw_Get_Float();
//    DrwGL_Move_Seg( p, x, y, z );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_rotate_seg:
//    p  = Draw_Locate_Seg( Sdrw_Get_Int() );  /* Get the Segment Number */
//    x  = Sdrw_Get_Float() + orgx;
//    y  = Sdrw_Get_Float() + orgy;
//    z  = Sdrw_Get_Float() + orgz;
//    v0 = Sdrw_Get_Float();
//    v1 = Sdrw_Get_Float();
//    v2 = Sdrw_Get_Float();
//    DrwGL_Rotate_Seg( p, x, y, z, v0, v1, v2 );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_scale_seg:
//    p  = Draw_Locate_Seg( Sdrw_Get_Int() );  /* Get the Segment Number */
//    x  = Sdrw_Get_Float() + orgx;
//    y  = Sdrw_Get_Float() + orgy;
//    z  = Sdrw_Get_Float() + orgz;
//    x1 = Sdrw_Get_Float();
//    y1 = Sdrw_Get_Float();
//    z1 = Sdrw_Get_Float();
//    DrwGL_Scale_Seg( p, x, y, z, x1, y1, z1 );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_transform_seg:
//    p  = Draw_Locate_Seg( Sdrw_Get_Int() );  /* Get the Segment Number */
//    x  = Sdrw_Get_Float();          /* Get the Translation */
//    y  = Sdrw_Get_Float();
//    z  = Sdrw_Get_Float();
//    x0 = Sdrw_Get_Float() + orgx;   /* Get the fixed point */
//    y0 = Sdrw_Get_Float() + orgy;
//    z0 = Sdrw_Get_Float() + orgz;
//    v0 = Sdrw_Get_Float();          /* Get the rotation angles */
//    v1 = Sdrw_Get_Float();
//    v2 = Sdrw_Get_Float();
//    x1 = Sdrw_Get_Float();          /* Get the x,y,z Scaling */
//    y1 = Sdrw_Get_Float();
//    z1 = Sdrw_Get_Float();
//    DrwGL_Transf_Seg( p, x, y, z, x0, y0, z0, v0, v1, v2, x1, y1, z1 );
      bupd = draw_pvw;
      Sdrw_Put_Char( 0 );
    break;

    case cd_new_axis:
      for (i = 0; i < 6; i++) ftb[i] = Sdrw_Get_Float();
      x  = Sdrw_Get_Float();
      y  = Sdrw_Get_Float();
      z  = Sdrw_Get_Float();
      i0 = Sdrw_Get_Int();
//    Sdrw_Put_Int( Draw_Gen_Axis( ftb, ftb+3, x, y, z, i0 ) );
      Sdrw_Put_Int( 1 );
    break;

    case cd_new_box:
      for (i = 0; i < 3; i++) ftb[i] = Sdrw_Get_Float();
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      i2 = Sdrw_Get_Int();
      n  = Sdrw_Get_Int();
      if (n > 12) n = 12;
      for (i = 0; i < n; i++) btb[i] = Sdrw_Get_Char();
//    Sdrw_Put_Int( Draw_Gen_Box( ftb, i0, i1, i2, n, btb ) );
      Sdrw_Put_Int( 1 );
    break;

    case cd_free_box:
//    pb  = Draw_Locate_Box( Sdrw_Get_Int() );  /* Get the Segment Number */
//    Draw_Free_Box( pb );
      Sdrw_Put_Char( 0 );
    break;

    case cd_free_all_box:
//    Draw_Free_Box_List();
      Sdrw_Put_Char( 0 );
    break;

    case cd_set_values:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      n  = Sdrw_Get_Int();
//    if (i1 < 0)
//      Draw_Axis_Setv( Draw_Locate_Axis( Sdrw_Get_Int() ),
//                      -i1, n, Sdrw_Get_Address( n ) );
//    else
//      Draw_Box_Setv(  Draw_Locate_Box( Sdrw_Get_Int() ),
//                       i1, n, Sdrw_Get_Address( n ) );
      Sdrw_Put_Char( 0 );      
    break;

    case cd_get_values:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      n  = Sdrw_Get_Int();
//    if (i0 < 0)
//      Draw_Axis_Getv( Draw_Locate_Axis( - i0 ),
//                       i1, n, Sdrw_Put_Address( n ) );
//    else
//      Draw_Box_Getv(  Draw_Locate_Box( i0 ),
//                       i1, n, Sdrw_Put_Address( n ) );
    break;

    case cd_plot_axis:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
      /* Get the World Axis Origine */
      for (i = 0; i < 3; i++) ftb[i] = Sdrw_Get_Float();
//    Draw_Plot_Axis( Draw_Locate_Axis( i0 ), ftb, i1 );
      Sdrw_Put_Char( 0 );      
    break;

    case cd_plot_box:
      i0 = Sdrw_Get_Int(); /* Get the Box ident */
//    Draw_Plot_Box( Draw_Locate_Box( i0 ) );
      Sdrw_Put_Char( 0 );      
    break;

    case cd_open_box:
//    pb  = Draw_Locate_Box( Sdrw_Get_Int() );  /* Get the Segment Number */
//    Draw_Open_Box( pb );
      Sdrw_Put_Char( 0 );      
    break;

    case cd_close_box:
//    Draw_Close_Box();
      Sdrw_Put_Char( 0 );      
    break;

    case cd_smplot:
      n  = Sdrw_Get_Int();
      i0 = Sdrw_Get_Int();
//    Draw_Gen_SMplot( n, i0, NULL );
      Sdrw_Put_Char( 0 );      
    break;

    case cd_continue:
      /* Send a 2D/3D Plot Data block to Client */
//    Draw_Send_Points( Sdrw_Get_Char() );
    break;

    case cd_message:
//    Sdrw_Get_String( Drwgl_strmsg );/* Set the Message String */
//    Drwgl_Input = drwgl_message;    /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 100 ); /* Send the Request to VGL */
    break;

    case cd_get_choice:
      n = Sdrw_Get_Int();
      if ((n < 1)||(n > Menu_Max))
      {
        Sdrw_Put_Int( -2 );
        break;
      }
//    Sdrw_Get_String( Drwgl_strmsg );
      menu_tops = 0;
      for (menu_topn = 0; menu_topn < n; menu_topn++)
      {
        menu[menu_topn] = menu_buf+menu_tops;
        len = Sdrw_Get_Char();
        if (len > Menu_ItmSz) len = Menu_ItmSz;
        while (len--)
          menu_buf[menu_tops++] = Sdrw_Get_Char();
        menu_buf[menu_tops++] = 0;
      }
      menu[n] = NULL;
//    Drwgl_strtab = menu;
//    Drwgl_Input = drwgl_choice;     /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 101 ); /* Send the Request to VGL */
    break;

    case cd_get_answerd:
//    Sdrw_Get_String( Drwgl_strmsg );
//    Drwgl_Input = drwgl_answerd;    /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 102 );    /* Send the Request to VGL */
    break;

    case cd_get_string:
//    i = Sdrw_Get_String( Drwgl_strmsg );
//    n = Sdrw_Get_String( Drwgl_strdef );
//    Drwgl_strcap = Sdrw_Get_Char();
//    Drwgl_Input = drwgl_string;     /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 103 );      /* Send the Request to VGL */
    break;

    case cd_get_file:
//    fprintf( fmsg, " *** Get File Request 0.\n" );
//    Draw_Fmsgupdate();
//    Drwgl_newmd = Sdrw_Get_Char();  /* Get the Create New File Flag */
      n = Sdrw_Get_Char();            /* Get number of filter entries */
//    Sdrw_Get_String( Drwgl_strmsg );/* Get the Title */
      menu_tops = 0;
//    fprintf( fmsg, " *** Get File Request 1.\n" );
//    Draw_Fmsgupdate();
      for (menu_topn = 0; menu_topn < n; menu_topn++)
      { /* Get each Filter table element */
        menu[menu_topn] = menu_buf+menu_tops;
        len = Sdrw_Get_Char();
        if (len > Menu_ItmSz) len = Menu_ItmSz;
        while (len--)
          menu_buf[menu_tops++] = Sdrw_Get_Char();
        menu_buf[menu_tops++] = 0;
      }
      menu[n] = NULL;
//    fprintf( fmsg, " *** Get File Request 2.\n" );
//    Draw_Fmsgupdate();
//    Drwgl_strtab = menu;
//    Drwgl_fidx = Sdrw_Get_Char();   /* Get the filter index */
//    Sdrw_Get_String( Drwgl_strdef );/* Get the Default file spc. */
//    Drwgl_strcap = Sdrw_Get_Char(); /* ... and the target string capacity */
//    Drwgl_Input = drwgl_file;       /* Set The Request Kind */
//    fprintf( fmsg, " *** Get File Request.\n" );
//    Draw_Fmsgupdate();
//    _Inp_Req_Display( &bupd,104 );      /* Send the Request to VGL */
    break;


    case cd_sget_position:
    case cd_get_position:
//    Drwgl_Input = drwgl_position;   /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 105 );      /* Send the Request to VGL */
    break;

    case cd_sget_window:
    case cd_get_window:
//    Drwgl_Input = drwgl_window;     /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 106 );      /* Send the Request to VGL */
    break;

    case cd_get_value:
//    Sdrw_Get_String( Drwgl_strmsg );
//    Drwgl_valdef = Sdrw_Get_Float();
//    Drwgl_valmin = Sdrw_Get_Float();
//    Drwgl_valmax = Sdrw_Get_Float();
//    Drwgl_Input  = drwgl_value;     /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 107 );      /* Send the Request to VGL */
    break;

    case cd_sget_stroke:
    case cd_sget_line:
    case cd_get_stroke:
    case cd_get_line:
//    Drwgl_gptmax = Sdrw_Get_Int();  /* Get Application Capacity */
//    Drwgl_gptins = Sdrw_Get_Char(); /* Get the Plot insertion flag */
//    Drwgl_gptcnt = 0;
//    if (code == cd_get_line)        /* Set The Request Kind */
//      Drwgl_Input  = drwgl_line;
//    else
//      Drwgl_Input  = drwgl_stroke;
//    fprintf( fmsg, " => Enter in Get_Line/Stroke_Req.\n" );
//    Draw_Fmsgupdate();
//    _Inp_Req_Display( &bupd, 108 );      /* Send the Request to VGL */
    break;

    case cd_seg_pick:
//    Drwgl_segment = Sdrw_Get_Int();
//    Drwgl_ident   = Sdrw_Get_Int();
//    Drwgl_Input = drwgl_pick;       /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 109 );      /* Send the Request to VGL */
    break;

    case cd_dialog:
      /* draw__dialog(); */
//    Drwgl_Input = drwgl_dialog;     /* Set The Request Kind */
//    _Inp_Req_Display( &bupd, 110 );      /* Send the Request to VGL */
      Sdrw_Put_Int( 0 );
    break;

    case cd_zoom:
//    Drwgl_Input = drwgl_usr_zoom;   /* Set The Request Kind */
//    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
//    Draw_Fmsgupdate();
//    _Inp_Req_Display( &bupd, 111 );      /* Send the Request to VGL */
    break;

    case cd_scale:
//    Drwgl_Input = drwgl_usr_scale;  /* Set The Request Kind */
//    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
//    Draw_Fmsgupdate();
//    _Inp_Req_Display( &bupd, 112 );      /* Send the Request to VGL */
    break;

    case cd_reload:
//    Drwgl_Input = drwgl_reload;     /* Set The Request Kind */
//    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
//    Draw_Fmsgupdate();
//    _Inp_Req_Display( &bupd, 113 );      /* Send the Request to VGL */
    break;

    case cd_refresh:
//    Drwgl_Input = drwgl_refresh;    /* Set The Request Kind */
//    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
//    Draw_Fmsgupdate();
//    _Inp_Req_Display( &bupd, 114 );      /* Send the Request to VGL */
    break;

    case cd_grid:
//    Drwgl_Input = drwgl_usr_grid;   /* Set The Request Kind */
//    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
//    Draw_Fmsgupdate();
//    _Inp_Req_Display( &bupd, 115 );      /* Send the Request to VGL */
    break;

    case cd_print:
//    Drwgl_Input = drwgl_usr_print;  /* Set The Request Kind */
//    fprintf( fmsg, " => Enter in Zoom_Req.\n" );
//    Draw_Fmsgupdate();
//    _Inp_Req_Display( &bupd, 116 );      /* Send the Request to VGL */
    break;

    case cd_add_opt:
//    draw__add_opt();
      Sdrw_Put_Char( 0 );
    break;

    case cd_usropt:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
//    draw__usropt( i0, i1 );
      Sdrw_Put_Char( 0 );
    break;

    case cd_edit:
      i0 = Sdrw_Get_Int();
      i1 = Sdrw_Get_Int();
//    draw__edit( i0, i1 );
      Sdrw_Put_Char( 0 );
    break;

    default:
      /* Normal Draw_End and Illegal or Unsupported Draw Code */
//    Draw_End();            /* Close All Draw Display. */
      Sdrw_Put_Char( 0 );    /* Return the account code to client */
      Sdrw_Write();
      Sdrw_Close_Gate();     /* Used for debug in reverse mode. */
      /* Return the value -1 on Normal Draw_End call and ... */
      /* ... -2 on ERROR Draw_End call. */
      reqnxt = (code == cd_end)?-1:-2;
      goto Sequence_Exit;
    }

//  Sdrw_read_unlock(-1);    /* Lock the User Directive Execution Graph */

//  if (bupd) DrwGL_Update_Display();
    Sdrw_Write();            /* Write the answerd to the user. */
    reqnxt = 0;              /* Return to continue pipe input */
  }

Sequence_Exit: /* Exit form proceed routine */

//Sdrw_read_unlock( -2);     /* UnLock the User Directive Execution Graph */

//fprintf( fmsg, " Draw Proceed Return\n" );
//Draw_Fmsgupdate();

  ;

}





//============================>>> AppMain <<<==============================
  int main(int argc, char** argv)
  {
    char * Drwgl_taskname;

    Drwgl_taskname = " User program ";

    // Use AppMain to create the main window

    dr_rx = 600; dr_ry = 440;      /* Set default resolution. */
    
    Sdrw_Pre_Init();               /* Pre Init Setting to perform in first */

    Sdrw_Params_Setting();         /* Set Display and Printer Parameters. */

    Sdrw_Init( argc, argv );       /* Perform the Basic Draw init */

    Sdrw_Open_Gate( argc, argv );  /* Init the Pipe I/O channels.   */  

    fprintf( fmsg, " Draw Pipe Enabled.\n" );
    Draw_Fmsgupdate();

    if ((argc > 4)&&(argv[4]!=NULL)) Drwgl_taskname = argv[4];

    if (!fmsg) fmsg = fopen( "DRAW_ERROR.TXT", "w" );

    fprintf( fmsg, " Create Window of (%d*%d)\n", dtr_rx, dtr_ry );
    Draw_Fmsgupdate();

//  (void) theApp->NewAppWin( 0, Drwgl_taskname, dtr_rx, dtr_ry );

    Draw_Extern_Init();

    Draw_Sequence_Exec();

    return 0;
}


