/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*         D R A W   -   S E R V E R   S E T U P     M O D U L E         *
*                                                                       *
*          (Read the Setup files and set the DRAW parameters)           *
*                                                                       *
*                               by                                      *
*                                                                       *
*          Pierre Wolfers, Laboratoire de Cristallographie              *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/

/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/

/***********************************************************************/
/**                                                                   **/
/**              To Set all Graphic Devices parameters                **/
/**                                                                   **/
/***********************************************************************/

#  define _DEF_GLOBAL     0


#include <draw/draw_common.h>
#include <draw/sdrw_null_env.h>



typedef enum { alpha,digit,period,comma,semicol,colon,addo,subo,mulo,divo,powo,
               quot,lpar,rpar,equo,oth,eofo,eolno,spacech,baseo,
               clto,cgto,ando,commento,lbra,rbra
             } chcat;



/* Item attribute definitions */


typedef enum { identsy, stringsy, integersy, floatsy,
               commasy, semicolonsy, equalsy,
               separatorsy,
               eolnsy, eofsy, nothing
             } symbol;


/* Identifier(s) definitions */


typedef struct { char   * idname;        /* Name of the identifier */
                 symbol   idtype;        /* Type of the identifier */
                 int      nbvalue,       /* Number of value to set */
                          vindex;        /* Index of C identifier pointer(s) */
               } ident;



/* Item record definition */


typedef struct { symbol      sy;         /* Type of item */
                 nameid      sy_ident;   /* Ident... */
                 ident       *ptid;      /* Pointer to identifier */
                 int         intv;       /* Read integer value */
                 float       fltv;       /* Read float value */
                 char        separ;      /* Read char separator */
                 line_string valst;      /* String value... */
				                 /*...and stlength */
                 } item;


/* Define an array of identifier pointers */


static ident wsidtab[] =
                 {
                   {         "WS_TYPE", integersy, 1,  0 },
                   {        "WS_CATEG", integersy, 1,  1 },
                   {     "COLOR_FLAGS", integersy, 1,  2 },
                   {   "ONE_PAGE_FLAG", integersy, 1,  3 },
                   {    "PLOTTER_FLAG", integersy, 1,  4 },
                   {      "PET_STRING", integersy, 1,  5 },
                   {      "PET_CHOICE", integersy, 1,  6 },
                   {     "PET_ANSWERD", integersy, 1,  7 },
                   {    "PET_POSITION", integersy, 1,  8 },
                   {        "PET_LINE", integersy, 1,  9 },
                   {      "PET_STROKE", integersy, 1, 10 },
                   {      "PET_WINDOW", integersy, 1, 11 },
                   {       "PET_VALUE", integersy, 1, 12 },
                   {        "PET_PICK", integersy, 1, 13 },
                   {"IMMEDIATE_ACTION", integersy, 1, 14 },
                   {   "WS_RESOLUTION", integersy, 2, 15 },
                   {        "WS_WIDTH",   floatsy, 1, 17 },
                   {        "WS_HIGHT",   floatsy, 1, 18 },
                   {      "WS_BORDERS",   floatsy, 2, 19 },
                   {        "WS_SIZES",   floatsy, 2, 21 },
                   {     "CHOICE_AREA",   floatsy, 4, 23 },
                   {     "STRING_AREA",   floatsy, 4, 27 },
                   {    "ANSWERD_AREA",   floatsy, 4, 31 },
                   {      "VALUE_AREA",   floatsy, 4, 35 },
                   {         "COLOR_0",   floatsy, 3, 39 },
                   {         "COLOR_1",   floatsy, 3, 42 },
                   {         "COLOR_2",   floatsy, 3, 45 },
                   {         "COLOR_3",   floatsy, 3, 48 },
                   {         "COLOR_4",   floatsy, 3, 51 },
                   {         "COLOR_5",   floatsy, 3, 54 },
                   {         "COLOR_6",   floatsy, 3, 57 },
                   {         "COLOR_7",   floatsy, 3, 60 },
                   {        "WS_TITLE",  stringsy, 1, 63 },
                   {              NULL,   nothing, 1,  0 }
                 };


/* Work station fields and access variables */


/****  Identifier Address Table  ****/

static void * (display_varaddr[]) =
  { /* INTEGER */
        &d_wtype,                    /* Work station type identifier (GKS/PHIGS). */
        &d_categ,                    /* Work Station Category. */

  &d_color_flags,                    /* Flag for Draw Color Use. */
&d_one_page_flag,                    /* Flag for One Page Output File. */
       &d_pltflg,                    /* Flag for plotter mode. */

     &pet_string,      &pet_choice,  /* Prompts Echo Type (GKS/PHIGS) for ... */
    &pet_answerd,    &pet_position,  /* String input, Choice-menu, Answerd, ... */
       &pet_line,      &pet_stroke,  /* Get Position, Line, Stroke, window, ... */
     &pet_window,       &pet_value,  /* Value, Pick Segment. */
       &pet_pick,        &immediat,
          &dr_rx,           &dr_ry,  /* Screen Resolution in pixels. */

    /* FLOAT */
        &d_width,         &d_hight,  /* Screen Size in cm. */
    &d_borders_x,     &d_borders_y,  /* Screen Position of Main Window (cm). */
          &ds_rx,           &ds_ry,  /* Main Window Sizes (cm). */

   &d_ch_area_x1,    &d_ch_area_x2,  /* Echo Area for User menu. */
   &d_ch_area_y1,    &d_ch_area_y2,

   &d_st_area_x1,    &d_st_area_x2,  /* Echo Area for User Input String Request. */
   &d_st_area_y1,    &d_st_area_y2,

   &d_an_area_x1,    &d_an_area_x2,  /* Echo Area for User Answerd Request. */
   &d_an_area_y1,    &d_an_area_y2,

   &d_va_area_x1,    &d_va_area_x2,  /* Echo Area for User Value Request. */
   &d_va_area_y1,    &d_va_area_y2,

   /* Color table for the Screen. */

   &draw_srccoltb[0][0], &draw_srccoltb[0][1], &draw_srccoltb[0][2],
   &draw_srccoltb[1][0], &draw_srccoltb[1][1], &draw_srccoltb[1][2],
   &draw_srccoltb[2][0], &draw_srccoltb[2][1], &draw_srccoltb[2][2],
   &draw_srccoltb[3][0], &draw_srccoltb[3][1], &draw_srccoltb[3][2],
   &draw_srccoltb[4][0], &draw_srccoltb[4][1], &draw_srccoltb[4][2],
   &draw_srccoltb[5][0], &draw_srccoltb[5][1], &draw_srccoltb[5][2],
   &draw_srccoltb[6][0], &draw_srccoltb[6][1], &draw_srccoltb[6][2],
   &draw_srccoltb[7][0], &draw_srccoltb[7][1], &draw_srccoltb[7][2],

    /* STRING */
          NULL };


static void * (printer_varaddr[]) =
  { /* INTEGER */
        &p_wtype,                    /* Work station type identifier (GKS/PHIGS). */
        &p_categ,                    /* Work Station Category. */

  &p_color_flags,                    /* Flag for Draw Color Use. */
&p_one_page_flag,                    /* Flag for One Page Output File. */
       &p_pltflg,                    /* Flag for plotter mode. */

      &dummy_int,       &dummy_int,       &dummy_int,
      &dummy_int,       &dummy_int,       &dummy_int,       &dummy_int,
      &dummy_int,       &dummy_int,       &dummy_int,
          &pr_rx,           &pr_ry,  /* Printer Resolution in pixels/page. */

    /* FLOAT */
        &p_width,         &p_hight,  /* Page Printer Size in cm. */
    &p_borders_x,     &p_borders_y,  /* Position of "window" in the page (cm). */
          &ps_rx,           &ps_ry,  /* Main "window" size (cm). */

      &dummy_flt,       &dummy_flt,       &dummy_flt,       &dummy_flt,
      &dummy_flt,       &dummy_flt,       &dummy_flt,       &dummy_flt,
      &dummy_flt,       &dummy_flt,       &dummy_flt,       &dummy_flt,
      &dummy_flt,       &dummy_flt,       &dummy_flt,       &dummy_flt,

   /* Color table for the Printer. */

   &draw_lprcoltb[0][0], &draw_lprcoltb[0][1], &draw_lprcoltb[0][2],
   &draw_lprcoltb[1][0], &draw_lprcoltb[1][1], &draw_lprcoltb[1][2],
   &draw_lprcoltb[2][0], &draw_lprcoltb[2][1], &draw_lprcoltb[2][2],
   &draw_lprcoltb[3][0], &draw_lprcoltb[3][1], &draw_lprcoltb[3][2],
   &draw_lprcoltb[4][0], &draw_lprcoltb[4][1], &draw_lprcoltb[4][2],
   &draw_lprcoltb[5][0], &draw_lprcoltb[5][1], &draw_lprcoltb[5][2],
   &draw_lprcoltb[6][0], &draw_lprcoltb[6][1], &draw_lprcoltb[6][2],
   &draw_lprcoltb[7][0], &draw_lprcoltb[7][1], &draw_lprcoltb[7][2],


    /* STRING */
            NULL
  };


static int  binstring   = false;
static int  cter        = false;
static int  ch, cmaj;

static chcat categ  = eolno;


            /* Character attribute array */

static chcat  attchr[96]	=
      {     /* _oth_ pour tous les autres */

   spacech,  commento, quot,     baseo,    alpha,    baseo,    ando,     quot,
/*   ' '       '!'     '"'        '#'       '$'       '%'      '&'       '\'' */

   lpar,     rpar,     mulo,     addo,     comma,    subo,     period,   divo,
/* '('       ')'       '*'       '+'        ','      '-'        '.'      '/'  */

   digit,    digit,    digit,    digit,    digit,    digit,    digit,    digit,
/*  '0'       '1'       '2'       '3'       '4'       '5'       '6'       '7' */

   digit,    digit,    colon,    semicol,  clto,     equo,     cgto,     oth,
/*  '8'       '9'       ':'        ';'     '<'       '='       '>'       '?'  */

   oth,      alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/* '@'        'A'       'B'       'C'       'D'       'E'       'F'       'G' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  'H'       'I'       'J'       'K'       'L'       'M'       'N'       'O' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  'P'       'Q'       'R'       'S'       'T'       'U'       'V'       'W' */

   alpha,    alpha,    alpha,    lbra,     oth,      rbra,     powo,     alpha,
/*  'X'       'Y'       'Z'      '['       '\\'      ']'       '^'        '_' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  '`'       'a'       'b'       'c'       'd'       'e'       'f'       'g' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  'h'       'i'       'j'       'k'       'l'       'm'       'n'       'o' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  'p'       'q'       'r'       's'       't'       'u'       'v'       'w' */

   alpha,    alpha,    alpha,    oth,      oth,      oth,      oth,      oth
/*  'x'       'y'       'z'      '{'       '|'       '}'       '~'       '?'  */

      };






/* ------------- Character attribute definitions --------------- */

static int    num_stat = 0;     /* Static count of Graphical Work Station. */

static int    ierr;
static item   sym;

static FILE * fp;



static int match( char *s1, char *s2 )
{ /*
    To compare two identifier names
    the result value is :
      0 if s1 and s2 match,
      1 if s1 > s2 and -1 if s1 < s2
  */

  int i, j, bl;

  /* match */
  i = strlen(s1);
  j = strlen(s2);
  if (i > j) j = i;
  i = 1;
  bl = true;

  while ((i <= j) && bl)
  {
    bl = (s1[i] == s2[i]);
    if (bl) i = i + 1;
  }

  if (bl)
  {
    if (strlen(s1) == strlen(s2))
      return 0;
    else
      if (strlen(s1) > strlen(s2))
        return 1;
      else
        return -1;
  }
  else
    if (s1[i] > s2[i])
      return 1;
    else
      return -1;

} /* match */


static ident *searchid( ident idt[], char *p )
/* to search an identifier */
{ /* searchid */
  int icmp, i;
  ident *id = NULL;

  icmp = -1;
  i = 0;
  while ((idt[i].idname != NULL) && (icmp != 0))
    icmp = match( (idt[i++].idname/*->s*/), p );

  if (icmp != 0) {
    fprintf( fmsg, " *Draw Error: Logical %s does not exist.\n", p );
    Draw_Fmsgupdate();
  }
  else
    id = &idt[--i];

  return id;
} /* searchid */


static void getdchar()
/* to get one character in the current line
   and set these characteristics */
{
  ch = getc(fp);
  if (ch == EOF) {
    ch = ' '; cmaj = ch; categ = eofo;
  }
  else
    if ((ch == 0) || ((ch == '\n' /* LINE FEED */)&&cter)) {
      categ = eolno; ch = 0;
    }
    else {
      if ((ch < ' ') || (ch > '~')) ch = ' ';
      cmaj = ch;
      if (cmaj > '_') cmaj = cmaj - 32;  /* convert lower to upper case */
      categ = attchr[ch - ' '];
    }
} /* getdchar */



static void comment(char cs)
{ /* READ A COMMENT TO PROCEED IN INPUT STREAM */

  cter = true;
  getdchar();
  while ((ch != cs) && (categ != eofo)) {
    getdchar();
  }
  cter = false;
  cmaj = ' ';
  categ = spacech;
  ch = ' '; /* set the space state */
} /* comment */



static void nextch()
{ /* get a character from the input stream */
  /* with comment elimination */
  /* nextch */

  getdchar();
  if (!binstring)
    if (ch == '{') comment( '}' );
              else if (ch == '!') comment( 0 );
} /* nextch */



static void skipspace()
{ /* to skip unsignificative space and comment */
  do {
    nextch();
  }
  while ((ch <= ' ') && (categ != eolno) && (categ != eofo));
} /* skipspace */



static void insymbol()
{ /* insymbol */
  /* Get a symbol in the source input stream and decode it */
  int	  bint;
  double  rdig, rexp, rfac, rval;
  int	  ivl, i1, i, base;
  char	  spch, pch;

  if ((ch == ' ') && (categ != eolno) && (categ != eofo)) skipspace();
  sym.ptid = NULL;
  switch (categ)
  {
    case digit:	 /* '0'...'9' */
    case period: /* '.'...number */
      /* assuming integer until shown other */
      ierr = false;
      rval = 0.0;
      rexp = ten;
      rfac = one;
      sym.sy = integersy;
      while (categ == digit)
      {
        rdig = ch - '0';
        nextch();
        rval = rval * ten + rdig;
      }
      if (categ == period)
      {
        nextch();
        sym.sy = floatsy;
        while (categ == digit)
        {
          rdig = ch - '0';
          nextch();
          rfac = rfac / ten;
          rval = rval + rfac * rdig;
        }
      }

      if ((cmaj == 'e') || (cmaj == 'E'))
      {
        sym.sy = floatsy;
        nextch();
        if ((ch == '+') || (ch == '-'))
        {
          if (ch == '-') rexp = one/rexp;
          nextch();
        }
        ivl = 0;
        while (categ == digit)
	{
          ivl = ivl * 10 + ( ch - '0');
          nextch();
        }
        if (ivl > 38)
        {
          Draw_Error(" EXPOSANT > 38 ");
          ierr = true;
        }
        rfac = one;
        while (ivl != 0)
        {
          if ((ivl % 2) == 1) /* ivl ODD */
          {
            ivl = ivl - 1;
            rfac = rfac * rexp;
          }
          else /* ivl PAIR */
          {
            ivl = ivl / 2; /* ivl div 2;*/
            rexp = rexp * rexp; /* sqr(rexp) */
          }
        }
        rval = rval * rfac;
      }

      if ((sym.sy == integersy) &&
          (rval <= RMAXINT) && (rval >= -RMAXINT-1.0))
      {
        sym.fltv = floor( rval + 0.5 ); /* ROUND(rval) */
        sym.intv = (int) sym.fltv;
      }
      else
      {
        sym.intv = 0;
        sym.sy = floatsy;
      }
      sym.fltv = rval;
    break;

    case alpha: /* 'a'...'z'....IDENTIFIER or KEYWORD or OPERATOR */
      sym.sy_ident.s[0] = 0;
      sym.sy_ident.l    = 0;
      ivl = 0;
      while ((categ == alpha) || (categ == digit) || (categ == period))
      {
        if (ivl < MAXIDSIZE) sym.sy_ident.s[ivl] = cmaj;
        ivl = ivl + 1;
        nextch();
      }
      if (ivl >= MAXIDSIZE) ivl = MAXIDSIZE;
      sym.sy_ident.s[ivl] = 0;
      sym.sy = identsy;
    break;

    case baseo:	/* '#' or '%' --> IT IS A BASE */
      ierr = false;
      sym.sy = integersy;
      if (ch == '#')
      {
        nextch();
        base = 0;
        while (categ == digit)
        {
          base = base * 10 + ( ch - '0');
          nextch();
        }
        if (ch != '#')
        {
          Draw_Error( "  ERROR BASE in file " );
          ierr = true;
        }
      }
      else
        if (ch == '%')
        {
          base = 10;
          nextch();
          switch(ch)
          {
            case 'X':
            case 'x':
            case 'H':
            case 'h':
              base = 16;
            break;

            case 'D':
            case 'd':
              base = 10;
            break;

            case 'O':
            case 'o':
              base =  8;
            break;

            case 'B':
            case 'b':
              base =  2;
            break;

            default: /*base = 10;*/
            break;
          }
        }
        if (!ierr)
        {
          nextch();
          ivl = 0;
          while (ch > ' ')
          {
            if ((ch >= '0') && (ch <= '9')) ch = ch - '0';
            else
              if ((ch >= 'a') && (ch <= 'f')) ch = ch - 'a' + 10;
              else
                if ((ch >= 'A') && (ch <= 'F')) ch = ch - 'A' + 10;
            if (ch < base)
            {
              ivl = base*ivl + ch;
              nextch();
            }
            else ch = 0;
          }
          sym.intv = ivl;
          sym.fltv = sym.intv;
        }
    break;

    case equo:	/* '=' */
      sym.sy = equalsy;
      nextch();
    break;

    case comma:	/* ',' */
      sym.sy = commasy;
      nextch();
    break;

    case semicol: /* ';' */
      sym.sy = semicolonsy;
      nextch();
    break;

    case quot: /* const string */
      bint = true;
      ivl = 0;
      binstring = true;
      while (bint)
      {
        nextch();
        if (categ == eolno) nextch(); /* to skip the begin of line */
        if (categ == eofo) bint = false;
        if (ch == '\'')
        {
          nextch();
          if (ch == '\'')
            sym.valst.line[ivl] = ch;
          else
            bint = false;
        }
        else
        {
          sym.valst.line[ivl] = ch;
          if (bint && (ivl < MAXLINESZ))
            ivl = ivl + 1;
          else
            if (bint)
            {
              Draw_Error(" LINE TOO LONG ");
              bint = false;
            }
        }
	binstring = false;
	sym.sy = stringsy;
      }
    break;

    case eolno:
      sym.sy = eolnsy;
      nextch();
    break;

    case eofo:
      sym.sy = eofsy;
    break;

    default:	/* separator */
      sym.sy = separatorsy;
      nextch();
    break;

  } /* switch (categ) */
} /* insymbol */


static void skip_to_symbol( /*enum*/ symbol syv )
{
  while ((sym.sy != eofsy) && (sym.sy != syv)) insymbol();
}


static void errandskip( char *msg, /*enum*/ symbol syv )
{
  Draw_Error( msg );
  skip_to_symbol( syv );
}


static void params_setting( char *   fspc, ident idtb[],
                            void * adtb[], int * w_stat )
{
  union {char  *c;
         int   *i;
         float *f;
        } ptr;

  int nval, idx, i;
  char  * s      = NULL;
  ident * currid = NULL;

  s = getenv( fspc );

  if (s)
    if (!(fp = fopen( s, "r" )))
      Draw_Error( "we can't open the PARAMS_FILE" );
    else
    {
      *w_stat = ++num_stat;
      ch    = ' ';
      cmaj  = ' ';
      categ = spacech;
      insymbol();
      while (sym.sy != eofsy)
      {
        if (sym.sy == identsy)
        {
          currid = searchid( idtb, sym.sy_ident.s );
          if (currid != NULL)
          {
            sym.ptid = currid;
            insymbol(); /* gobble up the identifier */
            if (sym.sy == equalsy) insymbol();
            nval = 0;
            while (nval < currid->nbvalue)
            {
              if ((currid->idtype == floatsy) && (sym.sy == integersy))
              {
                sym.fltv = sym.intv;
                sym.sy   = floatsy;
              }
              else
              if ((currid->idtype == integersy) && (sym.sy == floatsy))
              {
                if (sym.fltv >= 0.0) sym.intv = (int) (sym.fltv + 0.5);
                                else sym.intv = (int) (sym.fltv - 0.5);
                sym.sy   = integersy;
              }
              idx = currid->vindex + nval;
              if (currid->idtype == sym.sy)
              {
                ptr.i = (int *)(adtb[idx]);
                switch (sym.sy)
                {
                  case integersy:
                    *ptr.i = sym.intv;
                    insymbol();
                  break;

                  case floatsy:
                    *ptr.f = sym.fltv;
                    insymbol();
                  break;

                  case stringsy:
                    sym.valst.linelength = strlen(sym.valst.line);
                    for (i = 0; i < sym.valst.linelength; i++)
                      ptr.c[i] = sym.valst.line[i];
                    ptr.c[i] = 0;
                    insymbol();
                  break;
                }
              }
              else
                errandskip( "parameter value type do not match.", semicolonsy );

              if (sym.sy == commasy)
              {
                insymbol();
                nval++;
                if (nval >= currid->nbvalue)
                  Draw_Error( " Too many value for a parameter." );
              }
              else
                nval = currid->nbvalue;
            } /* while (nval < currid->nbvalue) */
          }
          else
            errandskip( "unknown identifier name.", semicolonsy );
        }
        else
          errandskip( "a setting identifier was expected.", semicolonsy );
        if (sym.sy == semicolonsy)
          insymbol();
        else
          Draw_Error( " a semicolon was expected." );
      } /* while (sym.sy != eofsy) ... */
    }
} /* params_setting */


void Sdrw_Params_Setting()
{
  g_flags = 0; // Set the server to uninitialized state.
  d_id    = 0; // Set the Graphical Work Stations as unreachable.
  p_id    = 0;
  
  // Now set the Draw Display Characteristic from Display_Setting files.
  
  params_setting( "DRAW_DISPLAY_SETTING", wsidtab, display_varaddr, &d_id );
  params_setting( "DRAW_PRINTER_SETTING", wsidtab, printer_varaddr, &p_id );
 
} /* all_params_setting */

