#
# Standard defines:
#
CC  	=	g++
SC	=	gcc

Src	=	.
oDir	=	.
Bin	=	$(BIN_DIR)

include VGL_Unix_Lib.make

libDirs	=	-L$(V_LIB) $(GLIB_DIR)

incDirs	=	-I$(V_INC) -I../include/ $(GINC_DIR)

LIBS	=	-lV -lVgl $(GLIBS) -lpthread

C_FLAGS	=	-O

SRCS	=\
	$(Src)/VGLdrw_insymbol.cpp\
	$(Src)/VGLdrw_exchange_man.cpp\
	$(Src)/VGLdrw_proceed.cpp\
	$(Src)/VGLdrw_app.cpp\
	$(Src)/VGLdrw_cmdw.cpp\
	$(Src)/VGLdrw_cnv.cpp\
	$(Src)/Draw_VGL_Print.cpp\
	$(Src)/Draw_VGL.cpp\
	$(Src)/Draw_Init_Server.cpp\
	$(Src)/Draw_Base_Server.cpp\
	$(Src)/Draw_AxisBox.cpp\
	$(Src)/Draw_NumCV.cpp
#	$(Src)/Draw_GL2PS.c

EXOBJS	=\
	$(oDir)/VGLdrw_insymbol.o\
	$(oDir)/VGLdrw_exchange_man.o\
	$(oDir)/VGLdrw_proceed.o\
	$(oDir)/VGLdrw_app.o\
	$(oDir)/VGLdrw_cmdw.o\
	$(oDir)/VGLdrw_cnv.o\
	$(oDir)/Draw_VGL_Print.o\
	$(oDir)/Draw_VGL.o\
	$(oDir)/Draw_Init_Server.o\
	$(oDir)/Draw_Base_Server.o\
	$(oDir)/Draw_AxisBox.o\
	$(oDir)/Draw_NumCV.o
#	$(oDir)/Draw_GL2PS.o


ALLOBJS	=	$(EXOBJS)
ALLBIN	=	$(Bin)/VGL_Draw_Server $(Bin)/VGL_Make_Font
ALLTGT	=	$(Bin)/VGL_Draw_Server $(Bin)/VGL_Make_Font

# User defines:

#@# Targets follow ---------------------------------

all:	$(ALLTGT)

objs:	$(ALLOBJS)

cleanobjs:
	rm -f $(ALLOBJS)

cleanbin:
	rm -f $(ALLBIN)

clean:	cleanobjs cleanbin

cleanall:	cleanobjs cleanbin

#@# User Targets follow ---------------------------------


#@# Dependency rules follow -----------------------------

$(Bin)/VGL_Draw_Server: $(EXOBJS)
	$(CC) -o $(Bin)/VGL_Draw_Server $(EXOBJS) $(incDirs) $(libDirs) $(LIBS)

$(oDir)/VGLdrw_exchange_man.o: VGLdrw_exchange_man.cpp
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_AxisBox.o: Draw_AxisBox.cpp Draw_VGL.h VGLdrw_cmdw.h VGLdrw_cnv.h \
 Draw_AxisBox.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_Base_Server.o: Draw_Base_Server.cpp Draw_VGL.h VGLdrw_cmdw.h \
 VGLdrw_cnv.h Draw_AxisBox.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_Init_Server.o: Draw_Init_Server.cpp VGLdrw_cnv.h VGLdrw_cmdw.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_NumCV.o: Draw_NumCV.cpp Draw_VGL.h VGLdrw_cmdw.h VGLdrw_cnv.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_VGL.o: Draw_VGL.cpp Draw_VGL.h VGLdrw_cmdw.h VGLdrw_cnv.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/Draw_VGL_Print.o: Draw_VGL_Print.cpp VGLdrw_cmdw.h VGLdrw_cnv.h
 Draw_VGL.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

#
#$(oDir)/Draw_VGL.o: Draw_VGL.cpp Draw_VGL.h VGLdrw_cmdw.h VGLdrw_cnv.h \
# Draw_GL2PS.h
#	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<
#
#$(oDir)/Draw_GL2PS.o: Draw_GL2PS.c Draw_GL2PS.h
#	$(SC) $(C_FLAGS) $(incDirs) -c -o $@ $<
#
#$(oDir)/Draw_VGL_Print.o: Draw_VGL_Print.cpp VGLdrw_cmdw.h VGLdrw_cnv.h \
# Draw_VGL.h Draw_GL2PS.h
#	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<
#

$(oDir)/VGLdrw_app.o: VGLdrw_app.cpp VGLdrw_app.h VGLdrw_cmdw.h VGLdrw_cnv.h \
 Draw_VGL.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_cmdw.o: VGLdrw_cmdw.cpp VGLdrw_cmdw.h VGLdrw_cnv.h Draw_VGL.h \
 Draw_AxisBox.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_cnv.o: VGLdrw_cnv.cpp VGLdrw_cnv.h Draw_VGL.h VGLdrw_cmdw.h \
 Draw_AxisBox.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_insymbol.o: VGLdrw_insymbol.cpp
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

$(oDir)/VGLdrw_proceed.o: VGLdrw_proceed.cpp Draw_VGL.h VGLdrw_cmdw.h \
 VGLdrw_cnv.h Draw_AxisBox.h
	$(CC) $(C_FLAGS) $(incDirs) -c -o $@ $<

# To Build the Font Generator.

$(Bin)/VGL_Make_Font: Draw_Make_Font.c
	$(SC) $(C_FLAGS) -o $(Bin)/VGL_Make_Font $(incDirs) Draw_Make_Font.c -lm

