program DUMP_BMP( input, output );


var

  equ: record case integer of
         0:( ch0, ch1, ch2, ch3: char);
         1:( wd0, wd1: word_integer);
         2:( int: integer);
         3:( flt: single);
       end;


  inp: file of char;
  out: text;



function READ_CH: char;
var
  ch: char;

begin
  ch := inp^; GET( inp );
  READ_CH := ch;
end READ_CH;

function READ_W16: integer;
begin
  equ.ch0 := READ_CH;
  equ.ch1 := READ_CH;
  equ.ch2 := CHAR( 0 );
  equ.ch3 := CHAR( 0 );
  READ_W16 := equ.wd0
end READ_W16;


function READ_INT: integer;
begin
  equ.ch0 := READ_CH;
  equ.ch1 := READ_CH;
  equ.ch2 := READ_CH;
  equ.ch3 := READ_CH;
  READ_INT := equ.int
end READ_INT;




function READ_PIX: integer;
begin
  equ.ch0 := READ_CH;
  equ.ch1 := READ_CH;
  equ.ch2 := READ_CH;
  equ.ch3 := CHAR( 0 );
  READ_PIX := equ.int
end READ_PIX;




function READ_FLT: real;
begin
  equ.ch0 := READ_CH;
  equ.ch1 := READ_CH;
  equ.ch2 := READ_CH;
  equ.ch3 := READ_CH;
  READ_FLT := equ.flt
end READ_FLT;




procedure DUMP_BIT_MAP24( Width, Heigh, Map_Size: integer );
type
  pline( sz: integer ) = array[1..sz] of integer;

var
  irep, i1, ln, fpix, lpix, npad, szline: integer;
  line: ^pline;

begin
  szline := ((Width*3 + 3) div 4)*4; { Round Up to multiple of 4 }
  npad   := szline - Width*3;        { Get the number of pade bytes }
  NEW( line, Width );
  for i := 1 to Heigh do
  begin
    for j := 1 to Width do  line^[j] := READ_PIX;
    for j := 1 to npad do equ.ch0 := READ_CH;

    WRITELN( out, ' Pixel Line # ', i:0, ' :' );
    ln := 0;
    i1   := 1;
    lpix := line^[1];
    while i1 <= Width do
    begin
      fpix := lpix;  { Get the first pixel of a line }
      irep := 1;
      loop
        i1 := i1 + 1;
      exit if i1 > Width;
        lpix := line^[i1];
      exit if lpix <> fpix;
        irep := irep + 1
      end;
      WRITE( out, ' ' ); ln := ln + 1;
      if irep > 1 then
      begin
        WRITE( out, irep:5, '*' ); ln := ln + 6
      end;
      WRITE( out, ' ', fpix:-6:16 ); ln := ln + 7;
      if (ln > 110) and (i1 <= Width) then
      begin
        WRITELN( out ); ln := 0;
      end
      else
        if i1 <= Width then
        begin
          WRITE( out, ',' ); ln := ln + 1
        end;
      fpix := lpix
    end;
    if ln > 0 then WRITELN( out );
    WRITELN( out )
  end
end DUMP_BIT_MAP24;




procedure PROCEED_BMP;
var
  hdr: array[1..2] of char;
  bmsz, rw1, rw2, shd, doff, hds, imw, imh, npl, nbp,
  nzip, ntsz, hres, vres, ncol, nico: integer;

begin
  { Read and Dump the BMP Header }
  hdr[1] := READ_CH;
  hdr[2] := READ_CH;
  WRITELN( out );
  WRITELN( out, ' Dump of Bit Map File "', argv[1], '" with ''', hdr,''' head.' );
  WRITELN( out );
  bmsz := READ_INT;
  rw1  := READ_W16;
  rw2  := READ_W16;
  doff := READ_INT;
  shd  := READ_INT;
  imw  := READ_INT; imh := READ_INT;
  npl  := READ_W16;
  nbp  := READ_W16;
  nzip := READ_INT;
  ntsz := READ_INT;
  hres := READ_INT; vres := READ_INT; ncol := READ_INT; nico := READ_INT;

  WRITELN( out, ' Total Bit Map File Size = ', bmsz:0, ' bytes.' );
  WRITELN( out, ' Reserved words(16bits) are ', rw1:0, ' and ', rw1:0 );
  WRITELN( out, ' The Beginning Data offset is ', doff:-6 );
  WRITELN( out, ' The Bit Map Header Size is ', shd:0:16 );
  WRITELN( out, ' The Image size (in pixel) is ', imw:0, ' * ', imh:0 );
  WRITELN( out, ' The Number of defined plane is ', npl:0, ' and there are ', nbp:0, ' bits/pixel.' );
  WRITELN( out, ' The Compression flag is ', nzip:0 );
  WRITELN( out, ' The total size of the Bit Map is ', ntsz:0 );
  WRITELN( out, ' The resolution (in pixels/meter) are ', hres:0, ' * ', vres:0 );
  WRITELN( out, ' The Total number of used color is ', ncol:0 );
  WRITELN( out, ' The Number of important color is ', nico:0 );

  if nbp = 24 then DUMP_BIT_MAP24( imw, imh, ntsz )
              else WRITELN( out, ' The Bit MAP isn''t in a supported format for dump.' );
  WRITELN( out )
end PROCEED_BMP;


begin { Main }
  if argc > 2 then
  begin
    RESET( inp, argv[1]^ );
    REWRITE( out, argv[2]^ );
    PROCEED_BMP;
    CLOSE( inp );
    CLOSE( out )
  end
end DUMP_BMP.
