/***** DRAW Interface ROUTINES for OpenGL Graphic Libary *******/
/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               D R A W   -   S E R V E R   M O D U L E                 *
*                                                                       *
*           (Draw interface for V function and procedures)              *
*                                                                       *
*                               by                                      *
*                                                                       *
*          Pierre Wolfers, Laboratoire de Cristallographie              *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/

/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/



/* include the environment SERVER */

#include "Draw_VGL.h"

#include "VGLdrw_cmdw.h"


#define Hits_Bufsz             128
#define Hits_Preci            10.0


#define Pick_Bufsz             512
#define Pick_Preci (GLdouble) 10.0



/***********************************************************************/
/*                                                                     */
/*                    DRAW/GL Interface Routines                       */
/*                                                                     */
/***********************************************************************/






/***********************************************************************/
/*                         Local  Variable                             */
/***********************************************************************/


typedef struct { int   seg;
                 int   pid;
                 float xmin, xmax,
                       ymin, ymax,
                       zmin, zmax;
                } Hitst;

static Hitst    HitsHeap[Hits_Bufsz];
static int      HitsSp = -1;

static GLint    curr_viewport[4];
static GLdouble curr_projmat[16],
                curr_modlmat[16];

static GLuint   pick_buf[Pick_Bufsz];
static GLint    pick_cnt;

static GLfloat  smix, smax, smiy, smay, smiz, smaz, /* Selection min max */
                lmix, lmax, lmiy, lmay, lmiz, lmaz, /* Local Limits */    
                hmix, hmax, hmiy, hmay, hmiz, hmaz; /* Image Limits */

static GLfloat  sel_min, sel_max, tmix, tmax, tmiy, tmay,
                Hitx, Hity, Hitz;

static int      Hits = 0;




/***********************************************************************/
/*                      Basic   Pick   Routines                        */
/***********************************************************************/




static void DrwVertex3f( float x, float y, float z )
{ GLdouble wx, wy, wz;
  int ret;

  /* Test For Local Clipping */
  if ((x >= lmix)&&(x < lmax)&&
      (y >= lmiy)&&(x < lmay)&&
      (z >= lmiz)&&(x < lmaz)) /* Selection Active */

    /* Perform all geometrical transformations */
    if (gluProject( (GLdouble) x, (GLdouble) y, (GLdouble) z,
                     curr_modlmat, curr_projmat, curr_viewport,
                     &wx, &wy, &wz ) == GL_TRUE)
      if ((wx >= smix)&&(wx < smax)&&(wy >= smiy)&&(wx < smay)) {
        Hits = 1;
        Hitx = wx; Hity = wy; Hitz = wz;
        if (hmix > wx) hmix = wx; if (hmax < wx) hmax = wx;
        if (hmiy > wy) hmiy = wy; if (hmay < wy) hmay = wy;
        if (hmiz > wz) hmiz = wz; if (hmaz < wz) hmaz = wz;
      }
}




void DrwGL_Pick_Plot( int flag, int dim, float * tab )
{ /* Display a particular Segment */
  float x, y, z;
  int         i;

  i = 0;
  while (i++ < dim) {
    x = *(tab++); y = *(tab++);
    z = (flag&DRWPLOT_3D)?*(tab++):0.0;
    DrwVertex3f( x, y, z );
  }
}





# define TXT_PATH_RIGHT   0
# define TXT_PATH_LEFT    1
# define TXT_PATH_UP      2
# define TXT_PATH_DOWN    3

# define TXT_HALN_NORMAL  1
# define TXT_HALN_LEFT    2
# define TXT_HALN_CENTRE  3
# define TXT_HALN_RIGHT   4

# define TXT_VALN_NORMAL  1
# define TXT_VALN_TOP     2
# define TXT_VALN_CAP     3
# define TXT_VALN_HALF    4
# define TXT_VALN_BASE    5
# define TXT_VALN_BOTTOM  6

# define GET_VAL           *(wp++)
# define GET_XY( x, y )    x = *(wp++); y = *(wp++)


void DrwGL_Pick_Text( float xc, float yc, float high, float ang,
                      int len, char * str )
{ /* Draw a Line of text */
  int  i, il, ix, iy, npt;
  wptr wp, ws;
  GLfloat xx, yy, txt_size, txt_width, txt_xtrans, txt_ytrans;
  Draw_Font_Ptr pf;
  GLdouble tran_mat[16];

  pf = Drwgl_txt_font;

  if (str)
  {
    glMatrixMode( GL_MODELVIEW );
    glPushMatrix();
    glTranslatef( xc, yc, 0.0 );
    glRotatef( (GLfloat) ang, 0.0, 0.0, 1.0 );
    glScalef( Drwgl_txt_expf*high/((GLfloat)pf->fnt_nmszx),
                             high/((GLfloat)pf->fnt_nmszy), 1.0 );
    glGetDoublev( GL_MODELVIEW_MATRIX, curr_modlmat );
//  Show_Mat( " Text Matrix Transform", curr_modlmat );

//  fprintf( fmsg, " Text Attr: haln = %d  valn = %d  path = %d\n",
//                 Drwgl_txt_haln, Drwgl_txt_valn, Drwgl_txt_path );
//  fprintf( fmsg, " exp = %f, spc = %f\n", Drwgl_txt_expf, Drwgl_txt_spcf );
//  Draw_Fmsgupdate();

    /* Find total length or height of the string to displayed */

    txt_size  =      0.0;
    txt_width = - 9999.0;

    for (i = 0; i < len; i++ ) { /* For each character of the string */

      il = pf->fnt_idx[str[i]];
      if (il >= 0)
      { /* Graphic character is available */
        wp = &(pf->fnt_grph[il]); /* Set the Graphic list ptr. */
        /* wp[0..3] are xmin, ymin, xmax ymax */
        switch (Drwgl_txt_path) {
          case TXT_PATH_LEFT:
          case TXT_PATH_RIGHT:
            txt_size += (GLfloat) wp[2] + pf->fnt_nmszx*Drwgl_txt_spcf;
            break;
          case TXT_PATH_UP:
          case TXT_PATH_DOWN:
            txt_size += (GLfloat) (wp[3] - wp[1]) + pf->fnt_nmszy*Drwgl_txt_spcf;
            if (wp[2] > txt_width) txt_width = (GLfloat) wp[2];
            break;
          default: ;
        }
      }
    }

    /* Translate the origin alignement point to first character position */

    il = pf->fnt_idx[str[0]];
    if (il >= 0) { /* Graphic character is available */
      wp = &(pf->fnt_grph[il]); /* Set the Graphic list ptr. */
      switch (Drwgl_txt_path) {
        default:
        case TXT_PATH_RIGHT:
          switch (Drwgl_txt_haln) {
            default:
            case TXT_HALN_NORMAL:
            case TXT_HALN_LEFT:    txt_xtrans =                  0.0; break;

            case TXT_HALN_CENTRE:  txt_xtrans =       - txt_size/2.0; break;

            case TXT_HALN_RIGHT:   txt_xtrans =           - txt_size; break;
          }
          switch (Drwgl_txt_valn) {
            case TXT_VALN_TOP:     txt_ytrans =        - pf->fnt_top; break;

            case TXT_VALN_CAP:     txt_ytrans =        - pf->fnt_cap; break;

            case TXT_VALN_HALF:    txt_ytrans =       - pf->fnt_half; break;

            default:
            case TXT_VALN_NORMAL:
            case TXT_VALN_BASE:    txt_ytrans =       - pf->fnt_base; break;

            case TXT_VALN_BOTTOM:  txt_ytrans =     - pf->fnt_bottom; break;
          }
          break;

        case TXT_PATH_LEFT:      
          switch (Drwgl_txt_haln) {
            case TXT_HALN_LEFT:    txt_xtrans = txt_size     - wp[2]; break;

            case TXT_HALN_CENTRE:  txt_xtrans = txt_size/2.0 - wp[2]; break;

            default:
            case TXT_HALN_NORMAL:
            case TXT_HALN_RIGHT:   txt_xtrans =              - wp[2]; break;
          }
          switch (Drwgl_txt_valn) {
            case TXT_VALN_TOP:     txt_ytrans =        - pf->fnt_top; break;

            case TXT_VALN_CAP:     txt_ytrans =        - pf->fnt_cap; break;

            case TXT_VALN_HALF:    txt_ytrans =       - pf->fnt_half; break;

            default:
            case TXT_VALN_NORMAL:
            case TXT_VALN_BASE:    txt_ytrans =       - pf->fnt_base; break;

            case TXT_VALN_BOTTOM:  txt_ytrans =     - pf->fnt_bottom; break;
          }
          break;

        case TXT_PATH_UP:
          switch (Drwgl_txt_haln) {
            default:
            case TXT_HALN_LEFT:    txt_xtrans =                  0.0; break;

            case TXT_HALN_NORMAL:
            case TXT_HALN_CENTRE:  txt_xtrans =      - txt_width/2.0; break;

            case TXT_HALN_RIGHT:   txt_xtrans =          - txt_width; break;
          }
          switch (Drwgl_txt_valn) {
            case TXT_VALN_TOP:     txt_ytrans =           - txt_size; break;

            case TXT_VALN_CAP:     txt_ytrans =           - txt_size
                                      - pf->fnt_nmszy*Drwgl_txt_spcf; break;

            case TXT_VALN_HALF:    txt_ytrans =       - txt_size/2.0; break;

            default:
            case TXT_VALN_NORMAL:
            case TXT_VALN_BASE:    txt_ytrans =                  0.0; break;

            case TXT_VALN_BOTTOM:  txt_ytrans =     - pf->fnt_bottom; break;
          }
          break;

        case TXT_PATH_DOWN:
          switch (Drwgl_txt_haln) {
            default:
            case TXT_HALN_LEFT:    txt_xtrans =                  0.0; break;

            case TXT_HALN_NORMAL:
            case TXT_HALN_CENTRE:  txt_xtrans =      - txt_width/2.0; break;

            case TXT_HALN_RIGHT:   txt_xtrans =          - txt_width; break;
          }
          switch (Drwgl_txt_valn) {
            default:
            case TXT_VALN_NORMAL:
            case TXT_VALN_TOP:     txt_ytrans =        - pf->fnt_top; break;

            case TXT_VALN_CAP:     txt_ytrans =        - pf->fnt_cap; break;

            case TXT_VALN_HALF:    txt_ytrans =  -txt_size/2.0-wp[3]; break;

            case TXT_VALN_BASE:    txt_ytrans =   - txt_size - wp[3]; break;

            case TXT_VALN_BOTTOM:  txt_ytrans =   - txt_size - wp[3] -
                                                      pf->fnt_bottom; break;
          }
          break;
      }

      /* Initial Position and set transformation */

      for (i = 0; i < len; i++ ) {  /* Loop to plot the character */
        il = Drwgl_txt_font->fnt_idx[str[i]];
        if (il >= 0) { /* Graphic character is available */
          ws = &(Drwgl_txt_font->fnt_grph[il]);
          wp = ws + 4;

          while (npt = GET_VAL) { /* Execute each plot directive. */
            while (npt--) {
              GET_XY( ix, iy );

              xx = (GLfloat) ix + txt_xtrans;
              yy = (GLfloat) iy + txt_ytrans;

              DrwVertex3f( xx, yy, 0.0 );
            }
          }

          /* Modify the translation to set for the next character */

          switch (Drwgl_txt_path) {
            default:
            case TXT_PATH_RIGHT: txt_xtrans += ws[2] + pf->fnt_nmszx*Drwgl_txt_spcf;
                                 break;

            case TXT_PATH_LEFT:  txt_xtrans -= ws[2] + pf->fnt_nmszx*Drwgl_txt_spcf;
                                 break;

            case TXT_PATH_UP:    txt_ytrans += ws[3] + pf->fnt_nmszy*Drwgl_txt_spcf;
                                 break;

            case TXT_PATH_DOWN:  txt_ytrans -= ws[3] + pf->fnt_nmszy*Drwgl_txt_spcf;
                                 break;
          }
        }
      }

    }


    glPopMatrix();
  }
}



void DrwGL_Pick_Seg( Draw_Ptr p, GLenum mode )
{ /* Display a particular Segment */
  Draw_Ptr           q;
  float *     tab;
  float  mix, max, miy, may, miz, maz;
  int    cod, dim, flg, icnt, pid, iseg;
  GLint  hitcnt, hitcd;


  glMatrixMode( GL_MODELVIEW );
  glPushMatrix();
  glMultMatrixf( p->seg.seg_mat );
  glGetDoublev( GL_MODELVIEW_MATRIX, curr_modlmat );

  iseg = p->seg.seg_ide;
  
  q = p->seg.seg_fdir;
  while (q)
  { /* Loop on all Segment Directive */
    pid = q->seg.dcom.dir_pid;
    switch (q->seg.dcom.dir_knd) {
      case Draw_Segment:
      break;

      case Draw_Clip_Win:
      break;

      case Draw_Plot:
        tab = q->tab.plo_tab;
        dim = q->tab.plo_npt;
        flg = q->tab.plo_flg;
        DrwGL_Pick_Plot( flg, dim, tab );
        if (Hits) {
          mix = q->tab.plo_lm[0]; max = q->tab.plo_lm[2];
          miy = q->tab.plo_lm[1]; may = q->tab.plo_lm[3];
          
        }
      break;

      case Draw_Text:
        DrwGL_Pick_Text( q->txt.txt_x, q->txt.txt_y, q->txt.txt_high,
                         q->txt.txt_ang, q->txt.txt_len, q->txt.txt_str );
        if (Hits) {
          mix = q->txt.txt_lm[0] = tmix; miy = q->txt.txt_lm[1] = tmiy;
          max = q->txt.txt_lm[2] = tmax; may = q->txt.txt_lm[3] = tmay;
        }
      break;

      case Draw_Circle:
        mix = q->circ.circl_x - q->circ.circl_r;
        miy = q->circ.circl_y - q->circ.circl_r;
        max = q->circ.circl_x + q->circ.circl_r;
        may = q->circ.circl_y + q->circ.circl_r;
      break;

      case Draw_Sphere:
        mix = q->sphere.sphere_x - q->sphere.sphere_r;
        miy = q->sphere.sphere_y - q->sphere.sphere_r;
        miz = q->sphere.sphere_z - q->sphere.sphere_r;
        max = q->sphere.sphere_x + q->sphere.sphere_r;
        may = q->sphere.sphere_y + q->sphere.sphere_r;
        maz = q->sphere.sphere_y + q->sphere.sphere_r;
      break;

      case Draw_Text_Attr:
//      DrwGL_text_Attr( q->txtattr.txta_haln, q->txtattr.txta_valn,
//                       q->txtattr.txta_path, q->txtattr.txta_expf,
//                       q->txtattr.txta_spcf );
      break;

      default:
      break;
    }


    if (Hits) { /* Hits was detected */
      if (HitsSp < Hits_Bufsz-1) {
        HitsSp++;
        HitsHeap[HitsSp].seg  = iseg;
        HitsHeap[HitsSp].pid  =  pid;
        HitsHeap[HitsSp].xmin =  mix;
        HitsHeap[HitsSp].xmax =  max;
        HitsHeap[HitsSp].ymin =  miy;
        HitsHeap[HitsSp].ymax =  may;
        HitsHeap[HitsSp].zmin =  miz;
        HitsHeap[HitsSp].zmax =  maz;
      }
//#define Hits_Bufsz             128
//#define Hits_Preci            10.0
//static Hitst    HitsHeap[Hits_Bufsz];
//static int      HitsSp = 0;
      
      fprintf( fmsg, " Hits Plot Seg # %d %f %d.\n", p->seg.seg_ide,
                     p->seg.seg_pri, q->seg.dcom.dir_pid );
      fprintf( fmsg, " Hits Echo Area [%f,%f,%f,%f]\n", mix, miy, max, may );
      Draw_Fmsgupdate();

    }

//  fprintf( fmsg, " Pick Seg Loop.\n" );
//  Draw_Fmsgupdate();
    q = q->seg.dcom.dir_nxt;
  }
  glPopMatrix();

//fprintf( fmsg, " Pick Seg End.\n" );
//Draw_Fmsgupdate();
}




void DrwGL_Pick_Search( int xm, int ym )
{ /* To locate a Draw Segment as pointed by the mouse at (xm, ym). */
  GLint viewport[4];
  unsigned int    i, icnt, iseg, id;
  GLuint       *ptr;
  Draw_Ptr p, q, qs;
  float    mix, miy, max, may, pri, prior, x1, y1, x2, y2;

//fprintf( fmsg, "  Pick Seg Hits Test init.\n" );
//Draw_Fmsgupdate();

  q = NULL;
  p = draw_fsegm;
  if (p) {
    glSelectBuffer( Pick_Bufsz, pick_buf );
    (void) glRenderMode( GL_SELECT );

    glInitNames();
//  glPushName( 0 );

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();

//  glViewport( 0, 0, dt_rx, dt_ry );
    glGetIntegerv( GL_VIEWPORT, viewport ); /* Get Current Viewport */

    gluPickMatrix( (GLdouble) xm, (GLdouble) (dt_ry - ym),
                   Pick_Preci, Pick_Preci, viewport );

    glOrtho( (GLdouble) dw_cxmin, (GLdouble) dw_cxmax,
             (GLdouble) dw_cymin, (GLdouble) dw_cymax, draw_uzmax, draw_uzmin );

    glMatrixMode( GL_MODELVIEW );
 
    /* Set all Plot Defaults */

    DrwGL_Line_Attr( 1, 1.0 );
    DrwGL_Marker_Attr( 1, 1.0 );
    DrwGL_Fill_Attr( 2, 1 );
    DrwGL_Color( 1 );

    while (p)
    { /* Loop to display the System Segments */
      if (p->seg.seg_stat&DRWSEG_DETECT) {
        Drwgl_segment = p->seg.seg_ide;
        DrwGL_Display_Seg( p, GL_SELECT );
      }
      // DRWSEG_HLIGHT for highlight on.
      p = p->seg.seg_nxt;
    }
  }

  glMatrixMode( GL_PROJECTION );
  glPopMatrix();
  glFlush();
  pick_cnt = glRenderMode( GL_RENDER );

//fprintf( fmsg, "  Pick Seg Hits count = %d\n", pick_cnt );
//Draw_Fmsgupdate();

  if (pick_cnt)
  { /* Examine the Hits table */ 
    ptr   = (GLuint *) pick_buf;
    mix = 1.0; max = 0.0;
    pri = prior = -1.0;
    qs    = NULL;
    for (i = 0; i < pick_cnt; i++) { /* For Each hits */
      /* Do not select from priority value */
      ptr++; /* Skip the number of name (always same) */
      Drwgl_pickzmin = (float) *ptr/0x7fffffff; /* Get the minimum of z */
      ptr++;
      Drwgl_pickzmax = (float) *ptr/0x7fffffff; /* Get the maximum of z */
      ptr++;
      iseg           = *ptr;                    /* Get the Segment Identifier */
      ptr++;
//    pri            = (float) *(ptr++)/0x7fff;     /* Get the segment Priority */
//    id             = *(ptr++);                    /* Get the Pick Ident */
//    x1             = (float) *(ptr++)/0x7fff;     /* Get the Dir. Min Max */
//    y1             = (float) *(ptr++)/0x7fff;
//    x2             = (float) *(ptr++)/0x7fff;
//    y2             = (float) *(ptr++)/0x7fff;

      fprintf( fmsg, "  Pick Hits Seg # %d %f %d.\n", iseg, pri, id );
//    fprintf( fmsg, " fentre [%f,%f,%f,%f]\n", x1, y1, x2, y2 );
      Draw_Fmsgupdate();

      if (pri >= prior) { /* Select the segment of greatest priority */
        Drwgl_segment = iseg;
        Drwgl_ident   =   id;
        prior         =  pri;
        qs            =    q;
        mix = x1; miy = y1;
        max = x2; may = y2;
      }

      fprintf( fmsg, "  Pick Seg Hits: zmi = %f, zma = %f, s = %d, i = %d\n",
                 Drwgl_pickzmin, Drwgl_pickzmin, Drwgl_segment, Drwgl_ident );
      Draw_Fmsgupdate();

      if (Drwgl_pickecho) {
        Draw_Destroye( Drwgl_pickecho );
        fprintf( fmsg, " Pick Del Echo.\n" );
        Draw_Fmsgupdate();
      }
      if (mix <= max) {
        Drwgl_pickecho = Draw_New_Sys_Seg( 4, 0 );
//      Draw_GPlot_Rect( minx, miny, maxx, maxy );
        draw_curseg = NULL;

        fprintf( fmsg, "  Pick Seg Echo [%f,%f,%f,%f].\n",
                       mix, miy, max, may );
        Draw_Fmsgupdate();
      }
    }
  }
}





