/***** DRAW Interface ROUTINES for OpenGL Graphic Libary *******/
/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               D R A W   -   S E R V E R   M O D U L E                 *
*                                                                       *
*           (Draw interface for V function and procedures)              *
*                                                                       *
*                               by                                      *
*                                                                       *
*          Pierre Wolfers, Laboratoire de Cristallographie              *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/

/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


#ifndef _VGL_BASE_ENV

# define _VGL_BASE_ENV 0



/* include the environment SERVER */

# include <draw/draw_common.h>
# include <draw/sdrw_env.h>
# include <draw/sdrw_routines.h>


# include "VGLdrw_cmdw.h"





/**************************************************************************/
/*                                                                        */
/*                 DRAW/GL Font Structure Definitions                     */
/*                                                                        */
/**************************************************************************/




      /******* Compatible with the font file of X-GKS ***********/

# define MXFBFSZ   16384          /* Maximal size of a Font draw table */


/* vc_type : semantics of vc_x and vc_y:
 *	s = character extent minimum
 *	S = character extent maximum
 *	m = move current position to
 *	d = draw to 
 *	e = end of character definition
 */
typedef struct { /* Character Drawing directive */
                 char         chd_dir,
                              chd_flag;
                 word         chd_x;
                 word         chd_y;
               } drwfnt_dir;



/*
 * Each font has 256 characters (some may be undefined) each of which is
 * defined by an array of vcharst structuresDraw_Locate_Seg( n );
 */

typedef struct drwfnt_buf * drwlft_ptr;

typedef struct drwfnt_buf { /* Font Descriptor */
                    char    fnt_name[30];   /* Font Name */
                    word    fnt_nominalx,   /* Nominal Char. Size (size 'm') */
                            fnt_nominaly,
                            fnt_top,        /* Displacment from y == 0 */
                            fnt_cap,
                            fnt_half,
                            fnt_base,
                            fnt_bottom;
                    int     fnt_off_tb[256];/* offset into fnt_dtb to the
                                             * beginning of each character.
                                             * -1 => undefined char. */
                    drwfnt_dir fnt_dtb[1];  /* the graphic directives */
} drwfnt_buf;



/**************************************************************************/
/*                                                                        */
/*                 DRAW/GL Data Structure Definitions                     */
/*                                                                        */
/**************************************************************************/

# define DRWSTRBUF_LENGTH  256

# define DRWSTATUS_UPDATE    1
# define DRWSTATUS_INPUT     2
# define DRWSTATUS_LIFE      4

# define ATTRSTKSZ 256           /* Attribute Stack size */

# define DRWGL_BLD_ENA       1
# define DRWGL_BLD_DIS       2
# define DRWGL_BLD_DENA      4
# define DRWGL_BLD_DDIS      8



/* Define the Time Clock default periods */
/* 500ms for Clock Event and 1s for Clock Update */

# define DRWTIME_PERIOD    500
# define DRWCLOCK_COUNT   (1000/DRWTIME_PERIOD)

# define UnitSz             32

#  ifdef _VGL_DEF_GLOBAL
#    define exvglrf
#    define exvglini( val ) = val
#  else
#    define exvglrf extern
#    define exvglini( val )
#  endif



  /* Types for attribute stack */

typedef struct { /* Attribute Stack Element */
                 int   lin_kind,
                       mrk_kind,
                       fil_kind,
                       fil_styl,
                       txt_haln,
                       txt_valn,
                       txt_path,
                       txt_prec;
         Draw_Font_Ptr txt_font;
                 float lin_size,
                       mrk_size,
                       txt_expf,
                       txt_spcf;
         Draw_RGBA     col_rgba;
               } drwgl_astkel;



  /* Types of user Input Interaction */

typedef char  Drwgl_Strtyp[DRWSTRBUF_LENGTH];

typedef enum  { drwgl_nothing,
                drwgl_dialog,
                drwgl_message,
                drwgl_choice,
                drwgl_answerd,
                drwgl_string,
                drwgl_file,
                drwgl_value,
                drwgl_position,
                drwgl_window,
                drwgl_savewindow,
                drwgl_line,
                drwgl_stroke,
                drwgl_pick,
                drwgl_zoom,
                drwgl_usr_zoom,
                drwgl_view,
                drwgl_usr_view,
                drwgl_scale,
                drwgl_usr_scale,
                drwgl_print,
                drwgl_usr_print,
                drwgl_grid,
                drwgl_usr_grid,
                drwgl_reload,
                drwgl_refresh,
                drwgl_exit,
                drwgl_null
              } Drwgl_Inptyp;





/**************************************************************************/
/*                                                                        */
/*                       DRAW/GL Local Variables                          */
/*                                                                        */
/**************************************************************************/

#  ifdef _VGL_DEF_GLOBAL

char * Drwgl_StatusStr[drwgl_null] =
         { "Runing",               // drwgl_nothing or Run,
           "Dialogue Request",     // drwgl_dialog
           "Message Request",      // drwgl_message
           "Choice Request",       // drwgl_choice
           "Answerd Request",      // drwgl_answerd,
           "String Request",       // drwgl_string,
           "File Request",         // drwgl_file,
           "Value Request",        // drwgl_value,
           "Position Request",     // drwgl_position,
           "Window Request",       // drwgl_window,
           "Save Window",          // drwgl_savewindow,
           "Line Request",         // drwgl_line,
           "Stroke Request",       // drwgl_stroke,
           "Segment Pick Request", // drwgl_pick,
           "Zoom Command",         // drwgl_zoom,
           "Zoom Request",         // drwgl_usr_zoom,
           "View_Command",         // drwgl_view,
           "View_Request",         // drwgl_usr_view,
           "Scale Command",        // drwgl_scale,
           "Scale Request",        // drwgl_usr_scale,
           "Print Command",        // drwgl_print,
           "Print Request",        // drwgl_usr_print,
           "Grid Command",         // drwgl_grid,
           "Grid Request",         // drwgl_usr_grid,
           "Reload Request",       // drwgl_reload,
           "Refresh Request"       // drwgl_refresh.
         };

#  else

extern char * Drwgl_StatusStr[drwgl_zoom+1];

#  endif



exvglrf char *       Drwgl_taskname,      /* Task Name pointer */
             *       Drwgl_unitx,         /* Current X Unit */
             *       Drwgl_unity;         /* Current Y Unit */

exvglrf char         Drwgl_xusr_unt[UnitSz],    /* User X Unit */
                     Drwgl_yusr_unt[UnitSz];    /* User Y Unit */

exvglrf GLuint       Drwgl_flags;         /* Status Flag Word for Interface */

exvglrf GLfloat *    Drwgl_ViewMat exvglini( NULL );   /* Pointer to view matrix to edit by drwgl_view */

exvglrf int          Drwgl_viewflg,       /* View flag */
                     Drwgl_zomeview,      /* Implicite Zoom - View Fip-flop */
                     Drwgl_print,         /* Print mode flag */
                     Drwgl_status,        /* Saved Status for some Request */
                     Drwgl_Dstatus,       /* Status for Dialog Request. */
                     Drwgl_clipflg,       /* Enable Clipping flag */
                     Drwgl_strcap,        /* Get String Capacity */
                     Drwgl_mactive,       /* Mouse ACtive Flag */
                     Drwgl_fidx,          /* Filter Index for get file */
                     Drwgl_newmd,         /* New mode flag for get file */
                     Drwgl_segment,       /* Picked Segment */
                     Drwgl_ident,         /* Returned Pick Identifier */
                     Drwgl_pecho,         /* Pick echo Flag */
                     Drwgl_pechx,         /* Echo Rectangle values */
                     Drwgl_pechy,
                     Drwgl_pechw,
                     Drwgl_pechh,
                     Drwgl_gptmax,        /* Get Line/Strocke Task Capacity */
                     Drwgl_gptcnt,        /* Get Line/Strocke Point Count */
                     Drwgl_gptins,        /* Get Line/Strocke Insertion flag */
                     Drwgl_sendflg,       /* Get Line/Strocke Send Flag */
                     Drwgl_inpmdflg,      /* Model Coord Input Flag */ 
                     Drwgl_xlogflg,       /* X Log Scale Axis flag */
                     Drwgl_ylogflg,       /* Y Log Scale Axis flag */
                     Drwgl_segplcnt,      /* Segment plane Counter */
                     Drwgl_astpmod,       /* Animation Stop Mode */
                     Drwgl_astpstate,     /* Animation Stop State Flags */ 
                     Drwgl_exitmd;        /* Exit mode for Dialog Request */


exvglrf float        Drwgl_timcnt      exvglini( 0.0 ); /* Time Event IT count. */
exvglrf int          Drwgl_time_period exvglini( DRWTIME_PERIOD );
exvglrf int          Drwgl_clock_count exvglini( DRWCLOCK_COUNT );
exvglrf int          Drwgl_period_set  exvglini( 0 );

exvglrf int          Drwgl_blend_flag  exvglini( 0 ); /* Blending enable flag */
exvglrf int          Drwgl_light_flag  exvglini( 0 ); /* Lighting enable flag */

exvglrf int          Drwgl_usr_request exvglini( 0 ); /* User Requested options */

exvglrf int          Drwgl_usr_orient  exvglini( 0 ); /* Orientation flag */

/* Table of enabled light flag for LIGHT_NUMBER=4 enabled Lights */
exvglrf int          Drwgl_light_entb[LIGHT_NUMBER];


exvglrf Drwgl_Inptyp Drwgl_Input,         /* Current Requested Input Request */
                     Drwgl_Proceed;       /* Current Handled Input Request */

exvglrf Drwgl_Strtyp Drwgl_strmsg,        /* Current Message/Title to output */
                     Drwgl_strdef,        /* Current Input String Default */
                     Drwgl_strbuf;        /* String Input Buffer */

exvglrf char * *     Drwgl_strtab;        /* Menu string array */

exvglrf Draw_Ptr     Drwgl_pickptr,       /* Pointer of picked directive */
                     Drwgl_senddir,       /* Pointer to directive to Send */
                     Drwgl_currbrf,       /* Pointer to current box reference */
                     Drwgl_currplane;     /* Pointer to current 2D plot plane */

exvglrf float        Drwgl_FixX,          /* Fix point for Mouse Rotation */
                     Drwgl_FixY,
                     Drwgl_FixZ,
                     Drwgl_xcurr,         /* Current Cursor position */
                     Drwgl_ycurr,
                     Drwgl_xmodel,        /* Current model (coord.) position */
                     Drwgl_ymodel,
                     Drwgl_xcoord,        /* Current Selected position */
                     Drwgl_ycoord,
                     Drwgl_xfirst,        /* First X and Y Coordinates in the World ... */
                     Drwgl_yfirst,        /* ... reference with Origine at center */
                     Drwgl_winxsz,        /* Current Selected Region Size */
                     Drwgl_winysz,
                     Drwgl_valmin,        /* MiniMaxi for Get_Value */
                     Drwgl_valmax,
                     Drwgl_valdef,        /* Get_Value Default value */
                     Drwgl_valret,        /* Get Value result */
                     Drwgl_pickzmin,      /* Pick Minimum of z */
                     Drwgl_pickzmax;      /* Pick Maximum of z */

exvglrf VCursor      Drwgl_cursor;        /* Kind of Cursor */

exvglrf GLdouble     Drwgl_mat_unit[16],  /* Unit Matrix to Keep */
                     Drwgl_proj_wrd[16],  /* System Projection Matrix */
                     Drwgl_modlview[16],  /* Current ModelView Matrix */
                     Drwgl_inpmat[16];    /* Current Input Model Matrix */

exvglrf GLboolean    Drwgl_stipple_state; /* Stipple enabled or disabled */

exvglrf GLfloat      Drwgl_line_size,     /* Line width saved value */
                     Drwgl_mrk_size,      /* Current Size of marker */
                     Drwgl_txt_expf,      /* Current Text Expanssion */
                     Drwgl_txt_spcf;      /* Current Text Space Factor */

exvglrf Draw_Font_Ptr  Drwgl_txt_font;    /* Current Text Font Pointer */



exvglrf GLint        Drwgl_wrdvport[4],   /* System View Port */
                     Drwgl_wprtport[4],   /* System Print View Port */
                     Drwgl_lin_kind,      /* Kind of line */
                     Drwgl_mrk_kind,      /* Kind of marker */
                     Drwgl_line_stipple,  /* Flag for Line Stipple Requirement */
                     Drwgl_fill_stipple,  /* Flag for Fill Area Stipple Requirement */
                     Drwgl_fill_front,    /* Flag for front face fill mode */
                     Drwgl_fill_back,     /* Flag for back face fill mode */
                     Drwgl_fill_Shift,    /* Flag for Polygon Depth Shift */
                     Drwgl_txt_haln,      /* Text Horizontal Alignement Mode */
                     Drwgl_txt_valn,      /* Text vertical Alignement Mode */
                     Drwgl_txt_path,      /* Text Path type */
                     Drwgl_txt_prec;      /* Current Text Font Precision */

exvglrf GLdouble     Drwgl_cliplane0[4],  /* Plane of clipping */
                     Drwgl_cliplane1[4],
                     Drwgl_cliplane2[4],
                     Drwgl_cliplane3[4];

exvglrf drwgl_astkel Drwgl_AStack[ATTRSTKSZ]; /* Dynamic Attribute Stack */

exvglrf int          Drwgl_AStkSp;        /* Dynamic Attribute Stack pointer */




/****  All DRAW-GL_V interface routines  ****/

void          DrwGL_Usr_Menu_Init();

void          DrwGL_Init();
void          DrwGL_Set_Clear_Color();

void          DrwGL_Seg_Unit_Transform( GLfloat* p );
void          DrwGL_Move_Seg(   GLfloat* p, float  tx, float  ty, float  tz );
void          DrwGL_URot_Seg(   GLfloat* p, float  px, float  py, float  pz,
                                          float  th, float  ph, float  an );
void          DrwGL_Rotate_Seg( GLfloat* p, float  px, float  py, float  pz,
                                            float ome, float chi, float psi );
void          DrwGL_Scale_Seg(  GLfloat* p, float  px, float  py, float  pz,
                                            float  sx, float  sy, float  sz );
void          DrwGL_Transf_Seg( GLfloat* p, float  tx, float  ty, float  tz,
                                            float  px, float  py, float  pz,
                                            float ome, float chi, float psi,
                                            float  sx, float  sy, float  sz );

void          DrwGL_Alpha_Set( int flg );
void          DrwGL_Light_OnOff( int lnb, int lst );
void          DrwGL_ColorRGB( Draw_RGBA rgba );
void          DrwGL_Color( int idc );
void          DrwGL_Line_Attr( int linetype, float sz );
void          DrwGL_Marker_Attr( int typ, float sz );
void          DrwGL_Fill_Attr( int kind, int style );

void          DrwGL_Push_Bxrf( Draw_Ptr p );
void          DrwGL_Pop_Bxrf();

void          DrwGL_Display_Seg( Draw_Ptr p, GLenum mode );
void          DrwGL_Display( int prflg );
void          DrwGL_Update_Display();
void          DrwGL_Inp_Req_Display( Char * bupdate );

void          DrwGL_Get_World_XY( int xsc, int ysc, Drwgl_Inptyp cd );
void          DrwGL_Init_View_Matrix( int button2 );
void          DrwGL_Change_View_Matrix( void );
int           DrwGl_Finish_View_Request();

void          DrwGL_Pick_Search( int xm, int ym );

void          Drwgl_Out_PS( int iflg );

#endif
