/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*              (Additional Control Graphic Directives)               *
*                     (Multi-Language Support)                       *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/

#include <math.h>

/* include the environment SERVER */

#include <draw/sdrw_env.h>
#include <draw/sdrw_routines.h>


#include "Draw_VGL.h"



/* module CPAS__WRITE_NUM translated in C */

#define    LN10  ((double)  2.3025851249695E+00) /* LN( 10.0 ) */
#define    TEN   ((double) 10.0)                 /* Constant 10.0 in double */
#define    ODT   ((double)  0.1)                 /* Constant 0.1 in double */

#define    PUTCH( ch )  s[(*ip)++] = ch




void Draw_Write_Int( char * s, int * ip, int iv, int f )
{ /* iv is the integer value, f the field and b the base */
  char ditb[68];
  char fch;
  int  bneg, dig, i, j, k;

  fch = ' ';                              /* Set as Fill character */
  if (!iv) {                              /* For zero integer number */
    bneg = 0;
    ditb[0] = '0'; j = 1;
  }
  else {                                  /* != 0 number */
    bneg = (iv < 0)?1:0;                  /* Set number to be positive */
    iv = abs( iv ); j = 0;
    while (iv) {
      dig = iv%10;
      ditb[j++] = (char) (dig + (int) '0');
      iv /= 10;
    }
  }
  if (!f) f = j + bneg;                   /* We set the field in agreement of the number */
     else if (f < 0) { fch = '0';         /* We set the field as positive with "0' at left */
                       f   = - f;
                     }
  i = f - j;                              /* Get the number of digit at left */
  if (bneg) i--;
  if (i >= 0) {                           /* If the write is possible */
    if (bneg&&(fch == '0')) PUTCH( '-' );
    for (k = 0; k < i; k++) PUTCH( fch );
    if (bneg&&(fch == ' ')) PUTCH( '-' );
    while (j) PUTCH( ditb[--j] );
  }
  else                                    /* Too small field */
    for (k = 0; k < f; k++) PUTCH( '*' );
} /* Draw_Write_Int */




static void Draw__Write_DEC( char * s, int * ip, double dv, int ndig, int pent, int bneg )
{ /* dv is a positive normalized number in the range [0.1,1.0[. or 0.0,
     ndig is the number of digit to write,
     pent is the number of digit for the integer part,
     bneg is the negative flag. */

  int    dig, fdig;

  fdig = 1;                               /* Set to first character search flag */
  while (ndig) {                          /* Loop on all digits */
    dv *= TEN;                            /* Get a digit */
    dig = (int) dv;
    dv -= dig;                            /* Take off the digit value */
    if (fdig)                             /* In first character search mode */
      if ((!dig)&&(pent > 1))
        PUTCH( ' ' );                     /* First character do not fall */
      else {                              /* First character is falling */
             fdig = 0;                    /* Clear the first character search flag */
             if (bneg) PUTCH( '-' );      /* output the negative sign when required */
           }
    if (!fdig) PUTCH( (char) (dig + (int) '0') );
    ndig--; pent--;
    /* insert the period when required */
    if ((!pent)&&(ndig > 0)) PUTCH( '.' );
  }
} /* Draw__Write_DEC */




static void Draw__Size_Double( double *   dv,   /* The float to normalize */
                               int    * iexp,   /* The resulting exponent */
                               int    * bneg,   /* The negative flag */
                               int      bfix )  /* The fixed mode flag */
{ /* TO size and normalize a floatting number */
  double dv1;

  if (*dv < 0.0) { *dv = -(*dv); *bneg = 1; }
           else *bneg = 0;
  if (*dv > 0.0) {
    dv1 = log( *dv )/LN10;
    *iexp = (dv1 >= 0.0)?(int)(dv1 + 1.0):(int)dv1;
    /* Set the value in range [0.1..1.0[ or [0.0..1.0[ for fixed */
    dv1 = (*dv)/pow( TEN, *iexp );
    if (dv1 >= 1.0) { dv1 = dv1*ODT; (*iexp)++; }
               else if (dv1 < ODT) { dv1 *= TEN; (*iexp)--; }
    if (bfix&&(*iexp <= 0)) *dv *= ODT;
                       else *dv  = dv1;
  }
  else *iexp = 0;
} /* Draw__Size_Double */




void Draw_Write_Float( char * s, int * ip,
                       double  dv,        /* The value to output */
                       int     fs,        /* The field size */
                       int  intsz,        /* The wished integer part size */
                       int   dcsz,        /* The wished decimal part size */
                       int     es )       /* The wished exponent field size */
{
  int   iexp,   ses,   ef,    i,   j,  ndg;
  int   bneg,  eneg, bdec, bnsp;
  char chexp, chsgn;

//fprintf( fmsg, " Write Float at %d : %f,%d,%d,%d,%d .\n", *ip, dv,fs,intsz,dcsz,es );
//Draw_Fmsgupdate();

  es = abs( es );
  /* Check for correct parameter values */
  dcsz = (dcsz <= -1)?7:abs( dcsz );
  if (dcsz > 20) dcsz = 20;
  if (fs < 0) { bnsp = 1; fs = abs( fs ); }
         else bnsp = 0;
  if (!fs) fs = 22;
  if (intsz < 1) intsz = 1;
  /* size the number to write and set it as positive number */
  Draw__Size_Double( &dv, &iexp, &bneg, 0 );
  /* iexp is the power of 10 to write on the form 0.d...E... */
  /* dv is now in the range [0.1 1.0] */
  /* modify the exponant by the size of integer part */
  iexp -= intsz;
  /* select the sign character for the exponant */
  if (iexp >= 0) chexp = '+';
            else { iexp = - iexp; chexp = '-'; }
  /* determine the necessary exponant field size */
  if (iexp < 10) ses = 2;
            else ses = (iexp < 100)?3:4;
  /* and set it when the user specifier is too small */
  if (ses > es) es = ses;
  /* Compute the size of unused space where 2 for "E+" or "E-" */
  bdec = (dcsz > 0)?1:0;
  ef = fs - dcsz - es - intsz - bneg - 2 - bdec;
  if (ef < 0) {                           /* not enouph room in the field */
    /* Try to supress exponent sign */
    if (chexp == '+') { ef++; chexp = ' '; }
    /* If not enough, try to supress some exponent figures */
    while ((es > ses)&&(ef < 0)) { es--; ef++; }
    /* If is not enough, try to supress some decimal figures */
    if ((ef < 0)&&(dcsz > 0)) {           /* we can try to suppress some decimal digits */
      i = ef + dcsz;                      /* get the number of figure to suppress */
      if (i > 0) {                        /* if some decimal are keep ... */
        dcsz = i; ef = 0;                 /* set the new number of decimal */
      }
      else {                              /* when we have not enough space, but ... */
        if ((i == -1)&&bdec) {            /* ... the lack of just one character */
          dcsz = 0; ef = 0; bdec = 0;     /* we have just the good space without "." */
        }
      }
    }
  }

  ndg = dcsz + intsz;
  dv += 0.5*pow( TEN, -ndg );             /* We round up the number */
  if (dv >= 1.0) {                        /* We must change the floatting format parameters */
    dv *= ODT;                            /* The number must be always normalized */
    if (chexp == '-') {                   /* and the exponant must be adapted */
      iexp--;                             /* < 0 then exponent magnitude is decreasing */
      if (!iexp) chexp = '+';
    } else {
      iexp++;                             /* the exponent magnitude is increasing */
      if (iexp >= 10) {                   /* The exp. field can be not enough large */
        /* Adjust the exponant field in the positive case */
        if (chexp == '+') { chexp = ' '; ef++; }
        if ((iexp == 10)&&(es == 1)) { es = 2; ef--; }
        else
          if ((iexp == 100)&&(es == 2)) { es = 3; ef--; }
      }

      if (ef < 0) {                       /* We must find room for one character */
        if (ndg > 1) {
          ndg--;                          /* Suppress one figure */
          if (intsz <= ndg) {             /* If no decimal are ouput we can suppress one decimal */
            if (ndg == intsz) { bdec = 0; ef++; }
          }
          else { intsz--; iexp++; }       /* We must increment the exponent to win one figure */
          ef++;
        }
      }
    }
  }

  if (ef < 0)                             /* It is impossible to write the number */
    for (j = 0; j < fs; j++) PUTCH( '*' );
  else { /* Output the number */
    if (bnsp) ef = 0;
    if (ef > 0)
      for (j = 0; j < ef; j++) PUTCH( ' ' );  /* Output the left space */
    /* Output the number (integer and fractional part) */
    Draw__Write_DEC( s, ip, dv, ndg, intsz, bneg );
    /* Output the exponant character */
    PUTCH( 'E' );
    /* Output exponent sign when required */
    if (chexp != ' ') PUTCH( chexp );
    /* Output the exponent with "0" left character */
    Draw_Write_Int( s, ip, iexp, -es );
  }
} /* Draw_Write_Float; */




void Draw_Write_Fix( char * s, int * ip,
                     double dv,          /* the float number */
                     int    fs,          /* the field size */
                     int  dcsz,          /* the decimal part size */
                     int  dcmin )        /* Minimum of figures */
{
  double  dv1;
  int dc, ef, i, indig, iexp, j, ndg;
  int bneg, bdec;

//fprintf( fmsg, " Write Fix at %d : %f:%d:%d:%d .\n", *ip, dv,fs,dcsz,dcmin );
//Draw_Fmsgupdate();

  /* Check for correct parameter values */
  dcsz = (dcsz == -1)?7:abs( dcsz );
  if (dcsz > 20) dcsz = 20;
  if (fs < 0) fs = abs( fs );
  if (fs == 0) fs = 20;
  if (dcmin < 0) dcmin = abs( dcmin );
  /* Size the number to write and set it as positive number */
  dv1 = dv;                               /* Keep a copy of the number to write */
  Draw__Size_Double( &dv1, &iexp, &bneg, 1 );
  /* Select the number sign */
  /* Determine the number of digits for the integer part */
  indig = (iexp > 1)?iexp:1;
  bdec  = (dcsz > 0)?1:0;                 /* Get if period is required */

  /* Get the unused space in the allocated character field as required */
//fprintf( fmsg, " Write Fix %f, ef = %d-%d-%d-%d-%d .\n", dv1, fs, bneg,dcsz,indig,bdec );
  ef = fs - bneg - dcsz - indig - bdec;

//fprintf( fmsg, " Write Fix Analyse = %d, %d, %d, %d .\n", ef, indig, iexp, bneg );
//Draw_Fmsgupdate();

  i  = dcsz + iexp;                       /* Get the number of significative figures */
  dc = dcsz;
  if ((iexp <= 0)&&(i < dcmin)&&(dcmin > 0)) {
    /* For the too small number with too many lost significative digits */
    dc = -iexp + dcmin;                   /* Adjust the decimal part size */
    ef = fs - dc - 2 - bneg;              /* Left characters  with "0." */
    if (!bdec&&(dc > 0))                  /* Add the "." when required */
       { ef--; bdec = 1; }
  }
  else { /* For not too small number, it can be too large */
    if (ef < 0) {                         /* When we have not enough room in the field */
      i = ef + dc;                        /* We try to suppress some decimal digits */
      if (i >= 0) {                       /* when it is possible to keep some fraction part */
        dc = i;                           /* ... we set the new number of decimal */
        if (dc > 0) ef = 0;               /* ... and supress the period when ... */
             else { bdec = 0; ef = 1; }   /* the fractional part is suppressed */
      }
      else
        if ((i == -1)&&bdec) {            /* When we have a lack of just one character */
          dc   = 0; ef = 0 ;              /* ... the fraction part and "." are suppressed */
          bdec = 0;
        }
    }
  }

  if (ef >= 0) {
    ndg = indig + dc;
    dv1 += 0.5*pow( TEN, -ndg );
    if (dv1 >= 1.0) {                     /* We must adjust the dv value, and parameter */
      dv1 *= ODT;                         /* Now dv is reset in the range [0.0..1.0[ */
      indig++; ef--; ndg++;
    }
  }

  /* If we have always a lack of room in the field we try the E format */
  if (ef < 0)
    Draw_Write_Float( s, ip, dv, fs, 1, dcsz, 0 );
  else {                                  /* ok for fixed */
    /* Output the space of the unused field part */
    for (j = 0; j < ef; j++) PUTCH( ' ' );
    /* and now write it */
    Draw__Write_DEC( s, ip, dv1, ndg, indig, bneg );
  }
} /* Draw_Write_Fix */;


