/***** DRAW ROUTINES of Level L1 (Control and Basic Functions) *******/
/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               D R A W   -   S E R V E R   M O D U L E                 *
*                                                                       *
*                 (Basic Draw functionand procedures)                   *
*                                                                       *
*                               by                                      *
*                                                                       *
*          Pierre Wolfers, Laboratoire de Cristallographie              *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/

/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/



/* include the environment SERVER */

#include <draw/draw_common.h>
#include <draw/sdrw_env.h>
#include <draw/sdrw_routines.h>


#include <v/vnotice.h>     // for vNoticeDialog

#include "VGLdrw_cnv.h"    // Get our Canvas Definitions.
#include "VGLdrw_cmdw.h"   // Our header.


/**************************************************************************/
/*                                                                        */
/*                        DRAW Local Variables                            */
/*                                                                        */
/**************************************************************************/





/**************************************************************************/
/*                                                                        */
/*                    DRAW  L1 level Interface Routines                   */
/*                                                                        */
/**************************************************************************/




/**************************************************************************/
/*                                                                        */
/*                    DRAW L1 Init and Screen  Routines                   */
/*                                                                        */
/**************************************************************************/

void Draw_End()
{
  if (g_flags)
  {
    g_flags = 0;
    fclose( fmsg );
  }
}



/**************************************************************************/

void Sdrw_Pre_Init()
{ /* Initialize the Draw/GL Interface */
  int i;

  fmsg = fopen( "DRAW_ERROR.TXT", "w" );

  /* Init Color Tables */
  for (i=0;i<15;i++)
  { draw_srccoltb[i][0] = draw_defcoltb[i][0];
    draw_srccoltb[i][1] = draw_defcoltb[i][1];
    draw_srccoltb[i][2] = draw_defcoltb[i][2];
    draw_srccoltb[i][3] = draw_defcoltb[i][3];
    draw_lprcoltb[i][0] = draw_defcoltb[i][0];
    draw_lprcoltb[i][1] = draw_defcoltb[i][1];
    draw_lprcoltb[i][2] = draw_defcoltb[i][2];
    draw_lprcoltb[i][3] = draw_defcoltb[i][3];
  }

  /* Init The segment and matrix caches to empty */
  for (i=0;i<SEG_CACHE_SIZE;i++) {
    draw_sgtb[i].ref_ref  = NULL;
    draw_sgtb[i].ref_idnt =    0;
  }
  for (i=0;i<TRF_CACHE_SIZE;i++) {
    draw_trtb[i].ref_ref  = NULL;
    draw_trtb[i].ref_idnt =    0;
  }  
}



/**************************************************************************/

void Sdrw_Init( int argc, char ** argv )
{
  int i, wflag;
  
//fprintf( fmsg, " argc = %d\n", argc );

//for (i=0;i<argc;i++)
//  if (argv[i]!=NULL)
//    fprintf( fmsg, " argv %d = ""%s""\n", i, argv[i] );

  w_flag = 0;                   /* To flag no output display choice */
  
  if (d_id&&(dr_rx > 0)&&(dr_ry > 0))
  { /* The Screen Work Station is Defined. */
//  fprintf( fmsg, " Specified Display type is %d, %d.\n", d_wtype, d_categ );
//  fprintf( fmsg, " Screen Display Setup:\n" );
//  fprintf( fmsg, "  Resolution = %d * %d\n", dr_rx, dr_ry );

    if (d_width > 0.0)
    { /* A metric is defined for the Screen Graphic Work Station. */
      d_unit = centimeter;
      if (d_height <= 0.0) d_height = (((float)dr_ry)/((float)dr_rx))*d_width;
    }
    else
    {
      d_unit   = raster;
      d_width  = (float) dr_rx;
      d_height = (float) dr_ry;
    }
    if ((ds_rx >= d_width )||(ds_rx <= 0.0)) ds_rx = 0.8*d_width;
    if ((ds_ry >= d_height)||(ds_ry <= 0.0)) ds_ry = 0.8*d_height;

    ds_rx = floor( ds_rx ); /* Round Down W. Size */
    ds_ry = floor( ds_ry );
    d_xscale = dr_rx/d_width;
    d_yscale = dr_ry/d_height;
    dt_rx = (int) (ds_rx*d_xscale);
    dt_ry = (int) (ds_ry*d_yscale);
    dp_rx = (int) (d_borders_x*d_xscale);
    dp_ry = dr_ry - dt_ry - ((int) (d_borders_y*d_yscale)); /* GL Pixel org at left top */
//  fprintf( fmsg, "  Screen Size (cm) = %f * %f\n", d_width, d_height );
//  fprintf( fmsg, "  Window Size (cm) = %f * %f\n", ds_rx, ds_ry );
//  fprintf( fmsg, "  Window Size (pixels) = %d * %d\n", dt_rx, dt_ry );
//  fprintf( fmsg, "  => %f * %f pixels/cm.\n", d_xscale, d_yscale );
    w_flag = 1;
  }

  if (!w_flag)
  { /* No defined Display => Set a default Screen Display */
    d_wtype = 1;
    d_categ = 3;
    d_id  = 1;                  /* Force a Defaulted Screen */
    dr_rx = 640; dr_ry = 480;   /* Select a default resolution */
    ds_rx = (float) dr_rx;
    ds_ry = (float) dr_ry;
    
    d_height = sqrt( ds_rx*ds_rx + ds_ry*ds_ry ); /* Diagonal size in pixels */
    d_xscale = d_height/(14.0*2.54); /* Scale for a 14" Screen */
    d_yscale = d_xscale;
    d_width  = dr_rx/d_xscale;
    d_height = dr_ry/d_yscale;
    ds_rx = ceil( 0.8*d_width );
    ds_ry = ceil( 0.8*d_height );
    dt_rx = (int) (ds_rx*d_xscale);
    dt_ry = (int) (ds_ry*d_yscale);
    dp_rx = (int) (d_borders_x*d_xscale);
    dp_ry =  dr_ry - dt_ry - ((int) (d_borders_y*d_yscale)); /* GL Pixel org at left top */
//  fprintf( fmsg, "  Defaulted Screen Size (cm?) = %f * %f\n", d_width, d_height );
//  fprintf( fmsg, "  Defaulted Window Size (cm?) = %f * %f\n", ds_rx, ds_ry );
//  fprintf( fmsg, "  Defaulted Window Size (pixels) = %d * %d\n", dt_rx, dt_ry );
//  fprintf( fmsg, "  => %f * %f pixels/cm.\n", d_xscale, d_yscale );
    d_unit  = raster;
  }

  ws_rx  = ds_rx;
  ws_ry  = ds_ry;
  w_unit = d_unit;
  w_flag = 1;      


  if (p_id&&(pr_rx > 0.0)&&(pr_ry > 0.0))
  { /* The Printer/Plotter Work Station is Defined. */
//  fprintf( fmsg, " Specified Printer type is %d, %d.\n", p_wtype, p_categ );
//  fprintf( fmsg, " Printer Display Setup:\n" );
//  fprintf( fmsg, "  Resolution = %d * %d\n", pr_rx, pr_ry );

    if (p_width > 0.0)
    { /* A metric is defined for the Hard Copy Graphic Work Station. */
      p_unit = centimeter;
      if (p_height <= 0.0) p_height = (((float)pr_ry)/((float)pr_rx))*p_width;
    }
    else
    {
      p_unit   = raster;
      p_width  = pr_rx;
      p_height = pr_ry;
    }
    if ((ps_rx >= p_width)||(ps_rx <= 0.0)) ps_rx = 0.8*p_width;
    if ((ps_ry >= p_height)||(ps_ry <= 0.0)) ps_ry = 0.8*p_height;
    ps_rx = floor( ps_rx ); /* Round Down W. Size */
    ps_ry = floor( ps_ry );
    p_xscale = pr_rx/p_width;
    p_yscale = pr_ry/p_height;
    pt_rx = (int) (ps_rx*p_xscale);
    pt_ry = (int) (ps_ry*p_yscale);
    pp_rx = (int) (p_borders_x*p_xscale);
    pp_ry = (int) (p_borders_y*p_yscale); /* Printer Pixel org at left bottom */
    fprintf( fmsg, "  Paper Size (cm) = %f * %f\n", p_width, p_height );
    fprintf( fmsg, "  Window Size (cm) = %f * %f\n", ps_rx, ps_ry );
    fprintf( fmsg, "  Window Borders (cm) at (%f, %f) .\n", p_borders_x, p_borders_y );
    fprintf( fmsg, "  Window Size (pixels) = %d * %d\n", pt_rx, pt_ry );
    fprintf( fmsg, "  => %f * %f pixels/cm.\n", p_xscale, p_yscale );
    fprintf( fmsg, "  => pp_rx = %d, pp_ry = %d .\n", pp_rx, pp_ry );

    pw_sxmin = pw_cxmin = - (pw_sxmax = pw_cxmax = ps_rx*0.5);
    pw_symin = pw_cymin = - (pw_symax = pw_cymax = ps_ry*0.5);

//  fprintf( fmsg, "  pw_cmin = (%f,%f), pw_cmax = (%f,%f).\n",
//                 pw_cxmin, pw_cymin, pw_cxmax, pw_cymax );

    /* Set the printer parameters as Display parameters */
    ws_rx  = ps_rx;
    ws_ry  = ps_ry;
    w_unit = p_unit;
    w_flag = 2;
  }
  else p_id = 0; /* Simule No Printer if Illegal Printer Setup */

  dtr_rx = dt_rx + (int)(d_xscale + 0.5);  /* Add 1cm for req. Window Size ... */
  dtr_ry = dt_ry + (int)(d_yscale + 0.5);  /* ... To set the good V window size. */

  s_dt_rx  =  dt_rx; s_dt_ry  =  dt_ry;    /* Save the Window sizes (pixels) */

  dw_ixmin = dw_sxmin = dw_cxmin = - (
                dw_ixmax = dw_sxmax = dw_cxmax = ws_rx*0.5);
  dw_iymin = dw_symin = dw_cymin = - (
                dw_iymax = dw_symax = dw_cymax = ws_ry*0.5);

//fprintf( fmsg, "  dw_cmin = (%f,%f), dw_cmax = (%f,%f).\n",
//              dw_cxmin, dw_cymin, dw_cxmax, dw_cymax );

  emarginx    =  1.0; /* Set the Default Picture Margins (cm) or (cm?) */
  emarginy    =  1.0;

  Draw_pic_sx = 10.0; /* Init the Picture X,Y Picture Size */
  Draw_pic_sy = 10.0;
  Draw_pic_yx =  1.0; /* Init the Picture Y/X ratio */
  
  dw_swsx = dw_cwsx = 10.0;
  dw_swsy = dw_cwsy = 10.0;
  
  /* Initialize the Drawing Structure to Empty state */

  draw_root      = NULL;
  draw_fsegm     = NULL;
  draw_lsegm     = NULL;
  draw_fsysseg   = NULL;
  draw_lsysseg   = NULL;
  draw_curseg    = NULL;
  draw_seg_count =    0;
  draw_ftrmat    = NULL;
  draw_ltrmat    = NULL;
  draw_trf_count =    0;

  draw_mat_cnt   =    0;

  draw_lock_flag =   -1; /* Init the lock flag */

  draw_curr_detf =    1; /* Init the Pick_Id bit to detectable */
  draw_curr_pid  =    3; /* Init The Pick_Identifier TO 1 and detectable */

  g_flags = 1;
  Draw_Fmsgupdate();
}




/**************************************************************************/

int Draw_Init( float *px, float *py, Char *unit )
{ /* Init the V-GL - DRAW_SERVER.
     In the Draw Server, The Insymbol step is performed
     during the Task init step.
  */
  
  *px = ws_rx;                  /* Transmit the Setup Window sizes and unit */
  *py = ws_ry;
  *unit = w_unit;
  draw_lock_flag   = 0;         /* Set the lock flag in the inited State */
  draw_3D_init     = 0;         /* Set Default to 2D Init */
  draw_3D_flg      = 0;         /* Set Default to 2D plot */
  draw_3D_fill_flg = 0;         /* Init the 3D Fill flag */

//fprintf( fmsg, " Draw_Init -> %f * %f unit: %d .\n", ws_rx, ws_ry, w_unit );
//Draw_Fmsgupdate();

  return 1;
}




/**************************************************************************/

void Draw_Ini_Sys_Seg()
/**********************************************************************/
/*                                                                    */
/* 	SUBROUTINE TO DRAW THE PICTURE FRAMES                         */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
{
  int     slen;
  float y1, y2;

  /*******************  Plot the Sheet Contour ***********************/

  if (p_id) {
    Draw_New_Sys_Seg( 1, 0 );
    Draw_Gen_Lattr( 3, 1.0 );          /* Small point Line, Size = 1 */
    Draw_GPlot_Rect( pw_cxmin, pw_cymin, pw_cxmax, pw_cymax );
    draw_curseg = NULL;
  }

  /******************  Plot the Picture Contour **********************/

  Draw_New_Sys_Seg( 2, 0 );
  Draw_Gen_Lattr( 1, 2.0 );           /* Line, Size = 2 */

  Draw_GPlot_Rect( draw_wxmin, draw_wymin, draw_wxmax, draw_wymax );

  Draw_Gen_Font( 1, 1 /* Stroke Precision */ );

  if (draw_pic_emarg)
  { /* When a Margin is Required */
    Draw_GPlot_Rect( draw_uxmin, draw_uymin, draw_uxmax, draw_uymax );

    /************* Plot the Title *************************/

    slen = strlen( draw_pic_title );
    if (slen > 0)
    {
      Draw_New_Sys_Seg( 3, 0 );
      y1 = 0.50*(draw_wymax + draw_uymax);
      y2 = 0.65*(draw_wymax - draw_uymax);
      /* Set the Mode Center+Middle_of_line+Normal_Path */
      Draw_Gen_Tattr( 3, 4, 0, 1.0, 0.0 );
      Draw_Gen_Text( 0.0, y1, 0.0, y2, slen, draw_pic_title );
      Draw_Gen_Tattr( 1, 1, 0, 1.0, 0.0 );
    }
  }

  Draw_Gen_Lattr( 1, 1.0 );
  draw_curseg = NULL;
}





/**************************************************************************/

int Draw_Picture( char *title, float px, float py, float pz,
                  Char bscale, Char bmarg )
{
/**********************************************************************/
/*                                                                    */
/* 	SUBROUTINE TO SET A PICTURE PLOT AREA.                        */
/*                                                                    */
/*  Init a picture in DRAW/V system.                                  */
/*                                                                    */
/*    - px, py (and pz) are the required Draw Canvas size in cm.      */
/*                                                                    */
/*    - title is the title of the picture.                            */
/*                                                                    */
/*    - bscale is true to get a strict scale when possible.           */
/*       (Possible with metric work station only).                    */
/*                                                                    */
/*    - bmarg is true if the user want keep a margin around his       */
/*      picture (where the title is located).                         */
/*                                                                    */
/*  The returned value time bscale is true when the effective scale   */
/*  resulting scale of picture is 1.0 and false otherwise.            */
/*                                                                    */
/*  N.B. :    DRAW_PICTURE must be called after DRAW_INIT.            */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

  int i, slen, im, Flg2D;
  float x1, y1, x2, y2;

//fprintf( fmsg, "  Draw Picture with %f %f %d %d .\n", px, py, bscale, bmarg );
//Draw_Fmsgupdate();

  /************ Get picture area in world unit ********************/

  Draw_pic_xx = ceil( fabs(px) ); /* Round up to Picture Size. */
  Draw_pic_yy = ceil( fabs(py) );
  Draw_pic_zz = ceil( fabs(pz) ); /* And Picture Deep */

  draw_3D_init   = 0;             /* Assume 2D Init until shown otherwise */
  draw_lock_flag = 0;             /* Set the lock flag in the free state */
  b_grid         = 0;             /* Init the Grid Flag. */

  /*************  Compute the User Display Size  ******************/

  Draw_pic_sx = Draw_pic_xx;
  Draw_pic_sy = Draw_pic_yy;

  if (bmarg)
  { /* Allocate a user margin */
    if (bscale&1)
    { /* User dimension in Cm. */
      emarginx = 1.0;
      emarginy = 1.0;
    }
    else
    { /* User dimension in Arbitrary unit. */
      emarginx = 0.1*Draw_pic_xx;
      emarginy = 0.1*Draw_pic_yy;
    }
    Draw_pic_sx += emarginx;      /* Increase the Used size by the margin */
    Draw_pic_sy += emarginy;
  }
  draw_pic_emarg = bmarg;
  draw_pic_title = title;

  /***********  Adjust Scale for Picture Proportions  ************/

  Draw_pic_yx = Draw_pic_sy/Draw_pic_sx;

  if (Draw_pic_yx >= ws_ry/ws_rx) /* Adjust it with the Required size Ratio */
    xy_scale = ws_ry/Draw_pic_sy;
  else
    xy_scale = ws_rx/Draw_pic_sx;

  /* Here xy_scale is the maximum possible scale in Cm_Station/Cm_User */
  if (bscale)
  { /* A Scale of 1.0 is required by the user */
    if ((xy_scale < 1.0)||(xy_scale > 5.0)) bscale = 0;
                                       else xy_scale = 1.0;
  }

  fprintf( fmsg, "  Picture Scale = %f (Output Cm)/(User Cm),\n", xy_scale );
  fprintf( fmsg, "  Picture Sizes = (%f * %f), ryx = %f.\n",
                 Draw_pic_sx, Draw_pic_sy, Draw_pic_yx );
  Draw_Fmsgupdate();



  /***********  Compute the Usable Display Size  *****************/

  if (p_id) /* When the main station is an output (ex: printer) */
  { /* Set the Screen View (of Printer Display) Scale */
    if (ps_ry*ds_rx > ps_rx*ds_ry) /* if ps_ry/ps_rx > ds_ry/ds_rx then */
      cv_scale = ds_ry/ps_ry;     /* ... Set relative scale from y sizes */
    else
      cv_scale = ds_rx/ps_rx;     /* ... else, form x sizes. */

    /* It is possible and better to get a Strict Scaled Printer Page View */
    if ((cv_scale >= 1.0)&&(cv_scale <= 1.5)) cv_scale = 1;

    vw_scale = cv_scale*xy_scale; /* Compute the Conversion Scale */

    fprintf( fmsg, "  Picture Screen View Scale = %f\n", vw_scale );
    fprintf( fmsg, "  Picture View/output Scale = %f\n", cv_scale );
    Draw_Fmsgupdate();
  }
  else
  { /* Set the Screen/Printer Conversion cv_scale Scale and
           the Global Screen View xy_scale Scale */
    cv_scale = 1.0;
    vw_scale = xy_scale;
  }

  sxy_scale = xy_scale;
  svw_scale = vw_scale;

  efxy_scale = 1.0/xy_scale; /* Scale in user_cm/station_cm to optimize. */
  efvw_scale = 1.0/vw_scale; /* Scale in user_cm/screen_cm */

  pw_sxmin = pw_cxmin = - (pw_sxmax = pw_cxmax = 0.5*ws_rx*efxy_scale);
  pw_symin = pw_cymin = - (pw_symax = pw_cymax = 0.5*ws_ry*efxy_scale);

  /* Set the Work Space Minimaxi in User Cm */
  dw_swsx = sdw_cwsx = dw_cwsx = 0.5*ds_rx*efvw_scale;
  dw_swsy = sdw_cwsy = dw_cwsy = 0.5*ds_ry*efvw_scale;
  dw_swpx = sdw_cwpx = dw_swpx = 0.0;
  dw_swpy = sdw_cwpy = dw_swpy = 0.0;

  dw_ixmin = dw_sxmin = dw_cxmin = - (
                dw_ixmax = dw_sxmax = dw_cxmax = dw_swsx);
  dw_iymin = dw_symin = dw_cymin = - (
                dw_iymax = dw_symax = dw_cymax = dw_swsy);

  fprintf( fmsg, "  Screen Work Space Minimaxi in User Cm [%f,%f,%f,%f]\n",
                    dw_ixmin, dw_ixmax, dw_iymin, dw_iymax );
  fprintf( fmsg, "  Printer Work Space Minimaxi in User Cm [%f,%f,%f,%f]\n",
                    pw_cxmin, pw_cxmax, pw_cymin, pw_cymax );
  Draw_Fmsgupdate();


  /*******   Compute the User World Frame Limits (User Cm)   ********/

  draw_iwxmi = draw_swxmi = draw_wxmin = - (
                       draw_iwxma = draw_swxma = draw_wxmax = 0.5*Draw_pic_sx);
  draw_iwymi = draw_swymi = draw_wymin = - (
                       draw_iwyma = draw_swyma = draw_wymax = 0.5*Draw_pic_sy);
  

  /********   Compute the User World Limits (for Clipping)   ********/

  if (Draw_pic_zz <= 0.05*(Draw_pic_xx + Draw_pic_yy))
  { /* 2D Mode */
    Draw_pic_zz = (Draw_pic_xx + Draw_pic_yy)*0.5;
    Flg2D = 1;
  }
  else Flg2D = 0;

  draw_suxmi = draw_uxmin = - (draw_suxma = draw_uxmax = 0.5*Draw_pic_xx);
  draw_suymi = draw_uymin = - (draw_suyma = draw_uymax = 0.5*Draw_pic_yy);
  draw_suzmi = draw_uzmin = - (draw_suzma = draw_uzmax = 0.5*Draw_pic_zz);



  /*****************  Initialize the Plot System  ********************/

  Draw_Draw_Clear();                  /* Init The Draw Plot System */
  Draw_GPlots();

  Draw_Ini_Sys_Seg();                 /* Plot all Picture Frames */


  /********** Initialyse the Plotting System **************************/

  if (Flg2D)
  { /* Set The Standard Origine at Lower Left Corner. */
    org_orgx = draw_uxmin;
    org_orgy = draw_uymin;
  } else  draw_3D_init   = 1;
  orgx = org_orgx;
  orgy = org_orgy;
  orgz = org_orgz;

  draw_out_mode = 1;
  draw_curr_pid = 1;


  /*************** set device coordinate system window ***************/

  fprintf( fmsg, "  End of Picture.\n" );
  Draw_Fmsgupdate();

  draw_lock_flag = 1;           /* Set the lock flag in the Active State */
  return bscale;
}




/**************************************************************************/

