/************************************************************************
*                                                                       *
*                                                                       *
*            D R A W   -   S E R V E R     P R O C E S S O R            *
*                                                                       *
*              (Environment/Header File for DRAW Library)               *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/



#ifndef _SRV_ENV                     /* To avoid Multi-definitions */
#  define _SRV_ENV    0



/***********************************************************************/
/**                                                                   **/
/**           C O N S T A N T E S    D E F I N I T I O N S            **/
/**                                                                   **/
/***********************************************************************/




/* Reference all the external common objects created by server_gbldef.c */

/* Include the type definitions */


#  include <draw/draw_common.h>
#  include <draw/sdrw_constantes.h>

#  include <v/vicon.h>
#  include <v/vdc.h>


#  include <draw/Draw_Font.h>

extern "C"
{
// OpenGL stuff here
#include <GL/gl.h>
#include <GL/glu.h>
}


#  define _Inp_Req_Display( upd ) \
     DrwGL_Inp_Req_Display( upd ); \
     Sdrw_read_lock()


#define DRWSEG_VISIBLE      1
#define DRWSEG_DETECT       2
#define DRWSEG_HLIGHT       4

#define DRWSEG_SYSTEM    1024

#define DRW_POINTS          0  /* Plot Single Dots */
#define DRW_LINES           1  /* Plot Single Lines */
#define DRW_LINE_STRIP      2  /* Plot a Poly_Line */
#define DRW_LINE_LOOP       3  /* Plot a Loop Poly_line */
#define DRW_TRIANGLES       4  /* Plot Single Triangles */
#define DRW_TRIANGLE_STRIP  5  /* Plot a Rubber of triangles */
#define DRW_TRIANGLE_FAN    6  /* Plot a Fan of Triangles */
#define DRW_QUADS           7  /* Plot Single Quads */
#define DRW_QUAD_STRIP      8  /* Plot a Rubber of Quads */
#define DRW_POLYGON         9  /* Plot a Contour with Fill Area */
#define DRW_MARKERS        10  /* Plot Markers */



#define word  short              /* MACHINE DEPENDENT */



/***********************************************************************/
/**                                                                   **/
/**                T Y P E S    D E F I N I T I O N S                 **/
/**                                                                   **/
/***********************************************************************/


typedef unsigned char       Char;         /* UNsigned char named Char */




typedef enum   { raster,
                 centimeter } unt_ty;     /* Selected unit capacity */


/* String Definition */

typedef struct { Char linelength;         /* Used length of the line */
                 char line[MAXLINESZ];    /* Line string */
               } line_string;



/* Draw Object Definitions */

typedef enum   { Draw_Segment,            /*  0 Segment Head */
                 Draw_Plot,               /*  1 Polyline/Polymarker/Polygone/...Directives */
                 Draw_Text,               /*  2 Text Directive */
                 Draw_Circle,             /*  3 To Plot a Circle */
                 Draw_Sphere,             /*  4 To Plot a Sphere */
                 Draw_Cylinder,           /*  5 To Plot a Cylinder */
                 Draw_Disk,               /*  6 To Plot a Disk */
                 Draw_Line_Attr,          /*  7 To set the Line Attributes */
                 Draw_Marker_Attr,        /*  8 To set the Marker Attributes */
                 Draw_Fill_Attr,          /*  9 To set the Fill Area Attributes */
                 Draw_Text_Attr,          /* 10 To set the Text Attributes */
                 Draw_Font,               /* 11 To select a Font */
                 Draw_Color,              /* 12 To set the Current Color */
                 Draw_PP_Attr,            /* 13 To Push or Pop Current attributes */
                 Draw_Ena_Plane,          /* 14 To Enable a Plot plane */
                 Draw_Dis_Plane,          /* 15 To Disable a Plot Plane */
                 Draw_Box_Ref,            /* 16 To set a Box reference */
                 Draw_Box_Pop,            /* 17 To Pop a Box reference */
                 Draw_Exec_Seg,           /* 18 To Exec a previously defined segment */
                 Draw_PushTrfMat,         /* 19 To Push a Transformation Matrix */
                 Draw_PopTrfMat,          /* 20 To Pop Transformation Matrix */
                 Draw_Blend_Set,          /* 21 Blending Setting Node */
                 Draw_Light_Def,          /* 22 Light Definition/prop. Node */
                 Draw_Mat_Light_Prop      /* 23 Materials Light Prop. */
               } Draw_Dir_Types;


typedef GLfloat Draw_Point[2];            /* 2D Point/Vertex */

typedef GLfloat Draw_Point3[3];           /* 3D Point/Vertex */

typedef GLfloat Draw_RGBA[4];             /* Color in RGBA */

typedef union Draw_Dir * Draw_Ptr;        /* Define a pointer to a Draw Directive */



typedef struct { /* Draw Directive Common */
                 Draw_Ptr       dir_nxt,  /* Link to next Directive of the same level */
                                dir_prv;  /* Link to previous directive */
                 Draw_Dir_Types dir_knd;  /* Directive Kind */
                 int            dir_pid;  /* Current pick identifier */
               } Dir_Common;


typedef struct { /* Draw Segment Drawing Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 int            seg_ide,  /* Segment Identifier Number */
                                seg_stat; /* Segment Status */
                 Draw_Ptr       seg_fdir, /* Link to first Directive of the segment */
                                seg_ldir, /* Link to last Directive of the Segment */
                                seg_ref,  /* Link to segment reference list */
                                seg_prv,  /* Link to previous segment */
                                seg_nxt;  /* Link to next segment */
                 GLfloat    seg_mat[16],  /* Segment Transformation Matrix */
                                seg_pri;  /* Segment priority */
               } Draw_Segm_Dir;

typedef struct { /* Draw General Plot Directive (PolyLine/PolyMarker/Fill_Area/...) */
                 Dir_Common        dcom;  /* Common Directive Part */
                 char           plo_knd,  /* type of plot Line/Marker/Fill... */
                                plo_flg;  /* bit flag */
                 int            plo_npt;  /* Number of point to plot */
                 float     *    plo_tab;  /* The List of Point (in World Coordinates) */
               } Draw_Plot_Dir;

typedef struct { /* Draw String Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 float          txt_x,    /* Coordinate of the text. */
                                txt_y,
                                txt_high, /* High of character */
                                txt_ang;  /* Angle of the line */
                 int            txt_len;  /* Size of the string */
                 char *         txt_str;  /* String to plot */
               } Draw_Text_Dir;

typedef struct { /* Draw Circle Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 float          circl_x,  /* Position of Circle Centre */
                                circl_y,
                                circl_r,  /* Radius of circle */
                                circl_sa, /* Start Circle Arc angle */
                                circl_ea, /* End Arc Circle Angle */
                                circl_ac; /* Accuracy */
                 int            circl_li; /* Related Circle GL List */
                 char           circl_kn; /* type of plot Line/Marker/Fill... */
               } Draw_Circle_Dir;

typedef struct { /* Draw Sphere Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 float          sphere_x, /* Position of Circle Centre */
                                sphere_y,
                                sphere_z,
                                sphere_r; /* Radius of sphere */
                 int            sphere_px, /* Sphere Accuracy longitude */
                                sphere_pz, /* Sphere Accuracy latitude */
                                sphere_li; /* Related Sphere GL List */
                 char           sphere_k; /* Type of plot Line/Fill/With_Normal... */
               } Draw_Sphere_Dir;

typedef struct { /* Draw Cylinder Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 float            cyl_x,  /* Position Of Base centre of cylinder */
                                  cyl_y,
                                  cyl_z,
                                  cyl_th, /* Spherical orientation of cylinder axis */
                                  cyl_ph,
                                  cyl_lg, /* Cylinder Length */
                                  cyl_rb, /* Radius of base */
                                  cyl_rt; /* Radius of top */
                 int              cyl_px, /* Cylinder Accuracy longitude */
                                  cyl_pz, /* Cylinder Accuracy latitude(z) */
                                  cyl_li; /* Related Cylinder GL List */
                 char             cyl_k;  /* Type of plot Line/Fill/With_Normal... */
               } Draw_Cylinder_Dir;

typedef struct { /* Draw Disk Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 float            dsk_x,  /* Position Of Disk centre */
                                  dsk_y,
                                  dsk_z,
                                  dsk_th, /* Spherical orientation of disk axis */
                                  dsk_ph,
                                  dsk_ri, /* Internal Disk Radius */
                                  dsk_re, /* External Disk Radius */
                                  dsk_sa, /* Start angle for part of disk */
                                  dsk_ea; /* Stop angle or <= 0.0 (Complet disk) */
                 int              dsk_pt, /* Disk Accuracy (as part of cake) */
                                  dsk_pr, /* Disk Accuracy (along the radius) */
                                  dsk_li; /* Related disk GL List */
                 char             dsk_k;  /* Type of plot Line/Fill/With_Normal... */
               } Draw_Disk_Dir;

typedef struct { /* Draw Line Attributes Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 int          plia_kind;  /* Kind of line and related ... */
                 float        plia_size;  /* Thickness of line */
               } Draw_LAttr_Dir;

typedef struct { /* Draw Marker Attributes Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 int          mrka_kind;  /* Kind of marker */
                 float        mrka_size;  /* Size of marker */
               } Draw_MAttr_Dir;

typedef struct { /* Draw Fill Attributes Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 int          fila_kind,  /* Kind of fill area */
                              fila_styl;  /* Style of fill area */
               } Draw_FAttr_Dir;

typedef struct { /* Draw Text Attributes Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 int          txta_haln,  /* Horizontal Alignement */
                              txta_valn,  /* Vertical Alignement */
                              txta_path;  /* String Path */
                 float        txta_expf,  /* Width to High Ratio */
                              txta_spcf;  /* Spacing */
               } Draw_TAttr_Dir;

typedef struct { /* Draw Select Font Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 int          fnt_font,   /* Font Number (identifier) */
                              fnt_prec;   /* Precision index */
               } Draw_Font_Dir;

typedef struct { /* Draw Select Color Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 Draw_RGBA    col_rgba;   /* <0 => color index, >0 R, */
               } Draw_Color_Dir;

typedef struct { /* Push or Pop Attribute Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 int          ppa_code;   /* Code for Push or Pop Attribute Directive */
               } Draw_PPAttr_Dir;

typedef struct { /* Open a Plot Plane Reference Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 Draw_Ptr    epl_prev;    /* Pointer to previous box */
                 GLfloat     epl_mat[16]; /* Coordinate Transf. Matrix */
               } Draw_EPlane_Dir;

typedef struct { /* Close a Plot Plane Reference Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
               } Draw_DPlane_Dir;

typedef struct { /* Open a Box Reference Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
                 Draw_Ptr    bxr_prev;    /* Pointer to previous box */
                 float       bxr_lim[24]; /* Coordinate limits (6 clip planes )*/
                 Char        bxr_mod[3];  /* Coordinate mode for each dimension */
                                          /* 2 for log10(x), Linear otherwise */
               } Draw_Boxref_Dir;

typedef struct { /* Close a Box Reference Directive */
                 Dir_Common       dcom;   /* Common Directive Part */
               } Draw_Popbxr_Dir;

typedef struct { /* Exec the specified Segment */
                 Dir_Common       dcom;   /* Common Directive Part */
                 Draw_Ptr      exec_seg,  /* Segment to exec */
                               exec_lst;  /* Link to other segment reference(s) */
               } Draw_ExecSeg_Dir;

typedef struct { /* Push a Transformation Matrix */
                 Dir_Common        dcom;  /* Common Directive Part */
                 int           trsf_ide;  /* Segment to exec */
                 Draw_Ptr      trsf_nxt,  /* Link to other transformation(s) */
                               trsf_prv;
                 GLfloat    trsf_mat[16]; /* Related Transformation matrix */
               } Draw_PushMat_Dir;

typedef struct { /* Pop a Transformation Matrix */
                 Dir_Common        dcom;  /* Common Directive Part */
               } Draw_PopMat_Dir;

typedef struct { /* Blending Set Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 int           bld_flags; /* Blending Flag Word */
                 GLenum        bld_src,   /* Blending Source Factor code */
                               bld_dst;   /* Blending Detination Factor code */
               } Draw_Blend_Dir;

typedef struct { /* Light Definition/prop. Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 GLenum       lig_spc,    /* Light Number */
                              lig_kind;   /* Light Kind */
                 GLfloat      lig_prm[4]; /* Parameters */
               } Draw_LgtDf_Dir;

typedef struct { /* Materials Light Prop. Directive */
                 Dir_Common        dcom;  /* Common Directive Part */
                 GLenum      lmat_face,   /* Face Specification */
                             lmat_kind;   /* Kind of Properties */
                 GLfloat     lmat_prm[4]; /* Parameters */
               } Draw_MLPrp_Dir;


typedef union  Draw_Dir { /* Draw Elementary Directive Definition */
                 Draw_Segm_Dir   seg;     /* Segment Head */
                 Draw_Plot_Dir   tab;     /* Coordinates Table */
                 Draw_Text_Dir   txt;     /* String of text */
                 Draw_Circle_Dir circ;    /* Circle */
                 Draw_Sphere_Dir sphere;  /* Sphere */
                 Draw_Cylinder_Dir cyl;   /* Cylinder */
                 Draw_Disk_Dir   disk;    /* Disk or part of disk */
                 Draw_LAttr_Dir  linattr; /* Set Line Attribute*/
                 Draw_MAttr_Dir  mrkattr; /* Set Marker Attribute */
                 Draw_FAttr_Dir  filattr; /* Set Fill Attribute */
                 Draw_TAttr_Dir  txtattr; /* Set text Attribute */
                 Draw_Font_Dir   font;    /* Set a font */
                 Draw_Color_Dir  color;   /* Set a Color */
                 Draw_PPAttr_Dir ppattr;  /* Push/Pop current Attribute */
                 Draw_EPlane_Dir eplane;  /* Enable a new plot plane */
                 Draw_DPlane_Dir dplane;  /* disable current plot plane */
                 Draw_Boxref_Dir boxref;  /* Set a Box reference */
                 Draw_Popbxr_Dir popbxr;  /* Release a Box reference */
                 Draw_ExecSeg_Dir exeseg; /* Exec the specified segment */
                 Draw_PushMat_Dir tmat;   /* Push Transformation Matrix */
                 Draw_PopMat_Dir  popmat; /* Pop Transformation Matrix */
                 Draw_Blend_Dir   blend;  /* Blending Set */
                 Draw_LgtDf_Dir   light;  /* Light Define */
                 Draw_MLPrp_Dir   lmatp;  /* Material Light Properties */
               } Draw_Directive;


typedef struct { /* Draw Segment Cache Reference */
                 Draw_Ptr       ref_ref;  /* Pointer to the segment */
                 int            ref_idnt; /* Segment identifier Copy */
               } Draw_Cache_Ref;





/* Identifier Name String Definition */


typedef struct { Char l;                  /* Used length of the identifier */
                 char s[MAXIDSIZE];       /* Identifier string */
               } nameid;


typedef union  { struct { unsigned char ch0, ch1, ch2, ch3; } ct; /* 4 chars */
                 struct { unsigned short i0, i1; } it;            /* or 2 shorts */
                 int   i;                                         /* or one int */
                 float f;                                         /* or one float */
               } eqv_if;    /* Define an equivalent type for conversion  */


typedef enum   { car, entier, reel } le_type;


typedef struct { eqv_if   nb;             /* A Binary Number */
                 le_type typ;             /* ... or an ennumerated */
               } teqv_if;                 /* Define the generalized equ type */


typedef float color_tab[16][4];           /* Color table definition */






/***********************************************************************/
/**                                                                   **/
/**            V A R I A B L E S    D E F I N I T I O N S             **/
/**                                                                   **/
/***********************************************************************/

#  ifdef _DEF_GLOBAL
#    define extref
#  else
#    define extref extern
#  endif


extref  FILE * fmsg; /* Error message File */

extref  char *         draw_pic_title;    /* Picture title */
extref  int            draw_pic_emarg;    /* Picture margin Enable Flag */

/*********    Whole Plot Tree Pointer and Segment number recovery   **********/

extref  Draw_Ptr       draw_root,         /* Root of the plot */
                       draw_fsegm,        /* First Segment */
                       draw_lsegm,        /* Last segment */
                       draw_usrseg,       /* Current Saved User Segment */
                       draw_curseg,       /* Current Segment */
                       draw_fsysseg,      /* First System Segment */
                       draw_lsysseg,      /* Last System Segment */
                       draw_ftrmat,       /* First Transformation Ref. */
                       draw_ltrmat;       /* Last Transformation Ref. */

extref  int            draw_seg_count,    /* Segment Creator Count */
                       draw_trf_count,    /* Transformation Count */
                       draw_curr_pid,     /* Current Pick identifier */
                       draw_curr_detf,    /* Current Pick Detection Flag */
                       draw_curr_color,   /* Current color number */
                       draw_out_mode,     /* Current Output mode */
                       draw_lock_flag,    /* Lock Draw/Redraw Flag */
                       draw_mat_cnt;      /* Transformation Matrix Count */

extref  Draw_Font_Ptr  Draw_first_font,   /* Pointer to first font */
                       Draw_last_font,    /* Pointer to last font */
                       Draw_curr_font;    /* Pointer to current font */

extref  float          xy_scale,          /* Global Draw Display Scale */
                       efxy_scale,        /* 1/xy_scale */
                       sxy_scale,         /* Saved xy_scale (Output scale) */
                       vw_scale,          /* View of Printer Working Display Scale */
                       efvw_scale,        /* 1/vw_scale */
                       svw_scale,         /* Saved vw_scale (View scale) */
                       cv_scale,          /* Conversion from Printer to Screen Scale */
                       cx_pen,            /* Current Pen position for plotter simulation */
                       cy_pen,
                       cz_pen,
                       orgx,              /* Current Plot Origine */
                       orgy,
                       orgz,
                       org_orgx,          /* Default Plot Origine */
                       org_orgy,
                       org_orgz,
                       Draw_pic_xx,       /* MiniMaxi of the user Space */
                       Draw_pic_yy,
                       Draw_pic_zz,
                       Draw_pic_yx,       /* Cuurent Picture Y/X ration and total size */
                       Draw_pic_sx,
                       Draw_pic_sy,
                       Draw_Dist;         /* View Distance for perspective */

extref  int            Plot_Size,         /* Local Plot Size */
                       Plot_Index,        /* Local Plot Fill Index */
                       Plot_Flag;         /* Local Plot Large Move Flag */

extref  float     Plot_Tab[PLOT_TAB_LEN]; /* Local Plot table */



extref  Draw_Cache_Ref draw_sgtb[SEG_CACHE_SIZE], /* Cache of Segment Reference */
                       draw_trtb[TRF_CACHE_SIZE]; /* Cache of Transformation Reference */



/* Common buffer */

extref  char    * draw_dis_conid,  * draw_pap_conid,  * draw_col_name;

extref  char    *      ds_griena,  *      ds_gridis,  *    menutb[15];


extref  int               insize,            inread,          outsize,
                      server_flg,            status,             itry;

extref  int                essai,            b_ieee,           b_conv;

extref  int              p_wtype,           d_wtype,
                         p_categ,           d_categ,         bclearws;

extref  int              i_dummy,          bpicture,             ndot,
                       usr_segtb,            wtype1,          ips_pen,
                        pen_type,            d_ncol,           d_indx,
                        p_colflg,            p_ncol,           p_indx,
                        fac_size,           wstmask,
               default_echo_type,
                      state_size,         /* Non def. */
                          errind;         /* Definit */

extref  int            sys_segnb,         usr_segnb,    sys_segtb[20];

extref  int               d_stat,     d_color_flags,  d_one_page_flag,
                          p_stat,     p_color_flags,  p_one_page_flag;

extref  int               p_used,            w_indx;

extref  int          w_plt_state,         w_pens_ok,           e_font,
                         g_flags,         scur_draw,
                     scur_addopt,          scur_pan,       scur_color,
                    start_dialog,           nb_cell,
                        xup_cell,          yup_cell,
                       xlow_cell,         ylow_cell,        ncol_cell,
                       nrow_cell;

extref  int               b_stop,
                        p_pltflg,
                        d_pltflg,
                        b_panusr,
                       b_plotted,
                          b_grid,        /* Grid Flag Enable/Disable */
                     color_flags,
                         w_color,
                    w_complement,
                   one_page_flag,
                      cpen_state;

extref  int    col_tab[col_size*row_size];

extref  int    b_edit, b_usr, bstat,     /* boolean */
               size_menu, iseg, ii, jj, wp_st, wp_sho, msgpl,
               plt_wtype, perrind, pconid, punit,
               pnum_colors, pcolor_flag, pnum_indexes,
               user_d_stat, inpch, inpch1;

extref  int    minx_cadre, maxx_cadre, miny_cadre, maxy_cadre;

extref  int    pet_string, pet_choice,  pet_answerd, pet_position,
               pet_line,   pet_stroke,   pet_window,    pet_value,
               pet_pick;

extref  int    immediat;


extref  int    dummy_int;                 /* Dummy int used by insymbol. */
extref  float  dummy_flt;                 /* Dummy float used by insymbol. */




/*       Definition of Standard Draw Colors      */

#  ifdef _DEF_GLOBAL

  /* Default Color Table */
  color_tab draw_defcoltb = { { 1.0, 1.0, 1.0, 1.0 },     /* Color 0 = White   */
                              { 0.0, 0.0, 0.0, 1.0 },     /* Color 1 = Black   */
                              { 1.0, 0.0, 0.0, 1.0 },     /* Color 2 = Red     */
                              { 0.0, 0.0, 1.0, 1.0 },     /* Color 3 = Blue    */
                              { 0.0, 1.0, 0.0, 1.0 },     /* Color 4 = Green   */
                              { 1.0, 1.0, 0.0, 1.0 },     /* Color 5 = Yellow  */
                              { 0.0, 1.0, 1.0, 1.0 },     /* Color 6 = Cyan    */
                              { 1.0, 0.0, 1.0, 1.0 },     /* Color 7 = Magenta */
                              { 0.7, 0.7, 0.7, 1.0 },     /* Color 8 = W. Grey */
                              { 0.3, 0.3, 0.3, 1.0 },     /* Color 9 = B. Grey */
                              { 0.5, 0.0, 0.0, 1.0 },     /* Color A = B. Red  */
                              { 0.0, 0.0, 0.5, 1.0 },     /* Color B = B. Blue */
                              { 0.0, 0.5, 0.0, 1.0 },     /* Color C = B.Green */
                              { 0.5, 0.5, 0.0, 1.0 },     /* Color D = B.Yellow*/
                              { 0.0, 0.5, 0.5, 1.0 },     /* Color E = B. Cyan */
                              { 0.5, 0.0, 0.5, 1.0 }      /* Color F = B.Magenta*/
                            };

  color_tab   draw_srccoltb, draw_savsrcctb,
              draw_lprcoltb, draw_savlprctb;

#else

  extref color_tab   draw_defcoltb,
                     draw_srccoltb, draw_savsrcctb,
                     draw_lprcoltb, draw_savlprctb;

#endif


extref  float  twndx1, twndx2, twndy1, twndy2, lstox, lstoy,
               xg1, xg2, yg1, yg2, r, xysca, rv, rmin, rmax, orggx, orggy;





/*********    Screen Work Station Canvas definitions    **********/

extref  int    draw_print;                /* Flag for Hard Copy Printing */

extref  float  draw_wxmin, draw_wymin,    /* World window station */
               draw_wxmax, draw_wymax,
               draw_swxmi, draw_swymi,    /* World window station saved */
               draw_swxma, draw_swyma,
               draw_iwxmi, draw_iwymi,    /* World window station Initial (pic) */
               draw_iwxma, draw_iwyma;

extref  double draw_uxmin, draw_uxmax,    /* Minimaxi in x, y ... */
               draw_uymin, draw_uymax,    /* ... and z (cm). */
               draw_uzmin, draw_uzmax,
               draw_suxmi, draw_suxma,    /* and, all corresponding save values */
               draw_suymi, draw_suyma,
               draw_suzmi, draw_suzma;

extref  unt_ty d_unit;                    /* Kind of metric for the Screen. */

extref  int    d_id,                      /* Screen Display Flag Identifie */
               dr_rx,    dr_ry,           /* Screen Display size in raster. */
               dt_rx,    dt_ry,           /* (used) Window Display Size in raster. */
               dp_rx,    dp_ry,           /* Screen Window Display Position in raster. */
               dtr_rx,   dtr_ry,          /* (Required dt_rx, dt_ry) */
               dhs_rx,   dvs_ry,          /* Measured Scroll Bares Sizes */
               dsv_px,   dsv_py,          /* System ViewPort Display position in raster */
               dsv_sx,   dsv_sy,          /* System ViewPort Display size in raster */

               s_dt_rx,  s_dt_ry,         /* Saved dt_rx and dt_ry. */
               s_dsv_px, s_dsv_py,        /* Saved dsv_px and dsv_py. */
               s_dsv_sx, s_dsv_sy,        /* Saved dsv_sx and dsv_sy. */

               d_vpxp,   d_vpyp,          /* User ViewPort in raster */
               d_vpsx,   d_vpsy,
               s_d_vpxp, s_d_vpyp,        /* Saves User ViewPort in raster */
               s_d_vpsx, s_d_vpsy;

extref  float  d_width,  d_height,        /* Screen Display Size (in cm). */
               d_borders_x, d_borders_y,  /* Screen Window Display Position (in cm). */
               d_xscale, d_yscale,        /* Screen Window Display View Scales. */
               ds_rx,    ds_ry,           /* Screen Window Display Size. */
               d_cfx,    d_cfy,           /* World to Screen View Port Scales (pixel/cm) */
               d_dfx,    d_dfy,           /* World to Screen View Port Shift (cm) */
               d_Hscrol, d_Vscrol;        /* Bare Scroll Sizes in cm */

extref int     df_Hscr,  df_Vscr;         /* Scroll flag and saved ones */

extref  double dw_cwpx,  dw_cwpy,         /* Center Org. Coordinates (User Cm) */
               dw_cwsx,  dw_cwsy,         /* Half Size of Screen Word (User Cm) */
               dw_swpx,  dw_swpy,         /* Saved Org. Coord. Word (User Cm) */
               dw_swsx,  dw_swsy,         /* Saved Half Size of Screen Word (User Cm) */
               dw_cxmin, dw_cymin,        /* Screen Word Coordinates Minimaxi */
               dw_cxmax, dw_cymax,
               dw_sxmin, dw_symin,        /* Screen Saved Word Coordinates Minimaxi */
               dw_sxmax, dw_symax,
               dw_ixmin, dw_iymin,        /* Screen Saved Initial Word Coord. Minimaxi */
               dw_ixmax, dw_iymax,
               sdw_cwpx, sdw_cwpy,        /* To Save Last view from Zoom */
               sdw_cwsx, sdw_cwsy;

extref  float  d_ch_area_x1, d_ch_area_x2,  /* Screen Echo Arrea for choice input. */
               d_ch_area_y1, d_ch_area_y2,
               d_st_area_x1, d_st_area_x2,  /* Screen Echo Arrea for string input. */
               d_st_area_y1, d_st_area_y2,
               d_an_area_x1, d_an_area_x2,  /* Screen Echo Arrea for answerd input. */
               d_an_area_y1, d_an_area_y2,
               d_va_area_x1, d_va_area_x2,  /* Screen Echo Arrea for value input. */
               d_va_area_y1, d_va_area_y2;




/*********   Printer Work Station Canvas definitions    **********/

extref  unt_ty p_unit;                    /* Kind of metric for the Printer. */

extref  int    p_id,                      /* Printer Display Flag Identifie */
               pr_rx,    pr_ry,           /* Printer Display size in raster. */
               pt_rx,    pt_ry,           /* Printer Window Display Size in raster. */
               pp_rx,    pp_ry,           /* Printer Window Display Position in raster. */
               psv_px,   psv_py,          /* System ViewPort Printer Position in raster */
               psv_sx,   psv_sy,          /* System ViewPort Printer Size in raster */
               p_vpxp,   p_vpyp,          /* User ViewPort in raster */
               p_vpsx,   p_vpsy,
               s_p_vpxp, s_p_vpyp,        /* Saves User ViewPort in raster */
               s_p_vpsx, s_p_vpsy;

extref  float  p_width,  p_height,        /* Printer Display Size (in cm). */
               p_borders_x, p_borders_y,  /* Printer Window Display Margins. */
               p_xscale, p_yscale,        /* Printer Window Display View scales. */
               ps_rx,    ps_ry,           /* Printer Window Display Size. */
               pw_cwpx,  pw_cwpy,         /* Printer Center Org. Coordinates (User Cm) */
               pw_cwsx,  pw_cwsy,         /* Printer Window size (in Users Cm) */
               pw_cxmin, pw_cymin,        /* Printer Word Coordinates Minimaxi */
               pw_cxmax, pw_cymax,
               pw_sxmin, pw_symin,        /* Printer Saved Word Coordinates Minimaxi */
               pw_sxmax, pw_symax;

extref  float  p_ch_area_x1, p_ch_area_x2,
               p_ch_area_y1, p_ch_area_y2,
               p_st_area_x1, p_st_area_x2,
               p_st_area_y1, p_st_area_y2,
               p_an_area_x1, p_an_area_x2,
               p_an_area_y1, p_an_area_y2,
               p_va_area_x1, p_va_area_x2,
               p_va_area_y1, p_va_area_y2;



/*********    Working Display Canvas definitions    **********/

extref  unt_ty w_unit;                    /* Working Display Unit */

extref  int    w_stat,                    /* Draw Working State. */
               w_flag;                    /* Draw working Flag. */

extref  float  ws_rx,    ws_ry;           /* Working Display Size (cm) */


/*********     View Display Canvas definitions     **********/

extref  float  vs_rx, vs_ry;              /* View Display Size (cm) */



/*********      Other Draw definitions       **********/


extref  int    reqflg,                    /* Flag (1/0) to Enable/Disable Request */
               reqnxt,                    /* Flag (1/0) to Ena./Dis. the after dialog mode */
                                          /* In dialog mode reqflg = 0, reqnxt = 1 */
               draw_3D_init,              /* Flag for 3D Picture Init */
               draw_3D_flg,               /* Flag for 3D Picture use */
               draw_3D_fill_flg;          /* Flag for 3D Picture with fill area */


extref  float  emarginx, emarginy;        /* Picture Margin Size (cm) */



/*********     Draw <--> V Interface Definitions     **********/

extref  int    npoint,                    /* Number of point in nptab */
               cur_out_kind,              /* Current V DRAW Output type */
               cur_out_mode;              /* Current Output mode */


//extref  vIcon  cur_icon;                  /* Current icon to use */



extref  float  pen_speed;                 /* Plotter Pen Speed (for printer -> Plotter). */


extref  char   prc_name[512];             /* User Program Name */

extref  char   sv_title[512];

extref  int    sdrw_pen_cnt;              /* Pen table count for local PLOT */
extref  float  sdrw_pen_tab[128];         /* Pen table for local PLOT */

extref  int    sdrw_read_left;            /* Byte left count for pipe input */




/************************************************************************/
/**                                                                    **/
/**  P R O C E D U R E S / F U N C T I O N S    D E F I N I T I O N S  **/
/**                                                                    **/
/************************************************************************/

/****  All DRAW-LIB Connection management routines  ****/

void          Sdrw_Open_Gate(int arc, char **arv);
int           Sdrw_Read();
void          Sdrw_Write();
int           Sdrw_Read_Block( Char* tb, int dim );
void          Sdrw_Write_Block( Char* tb, int dim );
void          Sdrw_Close_Gate();  /* End of Client-Server relation for reverse mode */

int           Sdrw_Dialog_Request();
void          Sdrw_Put_Char( Char ch );
Char *        Sdrw_Put_Address( int n );
void          Sdrw_Put_Int( int iv );
void          Sdrw_Put_Int_Direct( int pos, int iv );
void          Sdrw_Put_Float( float fv );
void          Sdrw_Put_Code( int code );
void          Sdrw_Put_String( char * s, int l );
Char          Sdrw_Get_Char();
Char *        Sdrw_Get_Address( int n );
int           Sdrw_Get_Int();
float         Sdrw_Get_Float();
int           Sdrw_Get_String( char * s );
char *        Sdrw_Get_String_Tmp();
void          Sdrw_String_Free_Tmp( char * s );
int           Sdrw_Get_Code();
void          Sdrw_Anim_acq( int isgn );

void          Sdrw_Resume_User_Manager();  /* To start the user Manager */

void          Sdrw_read_lock();            /* To Lock and Unlock for critical section */
void          Sdrw_read_unlock();

void          Sdrw_Params_Setting();
void          Sdrw_Pre_Init();
void          Sdrw_Init( int argc, char ** argv );


void          Sdrw_Start_User_Pipe( void );  /* Start the User Pipe Dialog */
void          Sdrw_Resume_User_Pipe( void ); /* Resume the User Pipe Dialog */
void          Sdrw_Wait_For_Request( void ); /* To synchronous with standard */


/*        * * *     D R A W    R O U T I N E S     * * *        */

Draw_Ptr      Draw_Locate_Seg( int );
Draw_Ptr      Draw_Locate_Sys_Seg( int );
Draw_Ptr      Draw_New_Segment( int, int );
Draw_Ptr      Draw_New_Sys_Seg( int, int );
Draw_Ptr      Draw_New_Node( Draw_Dir_Types );
Draw_Font_Ptr Draw_Load_Font( int );

void          Draw_Ini_Sys_Seg();

void          Draw_Zero_Seg( Draw_Ptr );
void          Draw_Destroye( Draw_Ptr );
void          Draw_Draw_Clear();
Draw_Ptr      Draw_User_Append( Draw_Ptr );
void          Draw_Send_Points( int );

void          Draw_Gen_Clip( float, float, float, float, float, float );
void          Draw_Gen_Mplot( int, int, float * );
void          Draw_Gen_Text( float, float, float, float, int, char * );
void          Draw_Gen_Circle( float, float, float, float, float, float );
void          Draw_Gen_Sphere( float, float, float, float, int, int, int );
void          Draw_Gen_Cylinder( float*, int, int, int );
void          Draw_Gen_Disk( float*, int, int, int );
void          Draw__G_Surface( int nraw, int ncol, int flg, float* buf );
void          Draw_Gen_Surface( int, int, int );
void          Draw_Gen_Surface2( int, int, int, float, float, float, float );
void          Draw_Gen_Polyhedral( int, int, int );

void          Draw_Gen_Exec_Seg( int );

int           Draw_Set_Seg_Attr( int, int, int, int, float );

int           Draw_Gen_TMat( int );
Draw_Ptr      Draw_Locate_TMat( int id );

void          Draw_Gen_Lattr( int, float );
void          Draw_Gen_Mattr( int, float );
void          Draw_Gen_Fattr( int, int );
void          Draw_Gen_Tattr( int, int, int, float, float );
void          Draw_Gen_Font( int, int );
void          Draw_Gen_Color( float, float, float, float );
void          Draw_Gen_PP_Attr( int );
void          Draw_Gen_Box_Ref( int );
void          Draw_Gen_Eplane( float * );
void          Draw_Gen_BlendSet( int );
void          Draw_Gen_LightDef( int nb, int kind, int nprm, float* prm );
void          Draw_Gen_MatLight( int fcd, int kind, int nprm, float* prm );

void          Draw_Gen_Normal( float * q, int cod, int dim );

void          Draw_GPlots( void );
void          Draw_GPlot1( void );
void          Draw_GPlot( float, float, int );
void          Draw_GPlot3( float, float, float, int );
void          Draw_GPlot2D( Draw_Point, int );
void          Draw_GPlot3D( Draw_Point3, int );
void          Draw_GPlot_Rect( float, float, float, float );
Draw_Ptr      Draw_GPlot_Grid();

void          Draw_Get_Color_Def( int, float *, float *, float *, float * );
void          Draw_Set_Color_Def( int, float, float, float, float );

void          Draw_Fmsgupdate();
void          Draw_Error( char *msg, int* id );


#endif


