/*
 *		Copyright IBM Corporation 1989
 *
 *                      All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 *
 * University of Illinois at Urbana-Champaign
 * Department of Computer Science
 * 1304 W. Springfield Ave.
 * Urbana, IL	61801
 *
 * (C) Copyright 1987, 1988 by The University of Illinois Board of Trustees.
 * All rights reserved.
 *
 * Tool: X 11 Graphical Kernel System
 * Author: Gregory Scott Rogers
 * Author: Sung Hsien Ching Kelvin
 * Author: Yu Pan
 * 
 *
 *
 *
 * Version changed for Draw Library.
 * Author: Pierre Wolfers, 
 *         CNRS, Laboratoire de cristallographie,
 *         BP 166X
 *         F 38042 GRENOBLE CEDEX 9
 *
 * Draw_Font.h - vector fonts for DRAW servers.
 *
 */



#ifndef word

# define word short	/* MACHINE DEPENDENT */

#endif


typedef struct Font_Dsc *  Draw_Font_Ptr;     /* Define a pointer of font */

typedef word * wptr;                          /* Define a word pointer type */

typedef struct Font_Dsc { /* Font Descriptor */
                 Draw_Font_Ptr  fnt_next;     /* Link to the Next Loaded Font */
                 int            fnt_ident,    /* Font Integer Identifier */
                                fnt_gsize;    /* Graphic Table size */
                 char           fnt_name[64]; /* Font Name */
                 word           fnt_nmszx,    /* Nominal Char. Size (size 'm') */
                                fnt_nmszy,
                                fnt_top,      /* Displacment from y == 0 */
                                fnt_cap,
                                fnt_half,
                                fnt_base,
                                fnt_bottom;
                 int            fnt_idx[256]; /* Graphic data index for each char. */
#ifdef _MAKE_FONT
                 word           fnt_grph[_MAKE_FONT];
#else
                 word           fnt_grph[1];  /* Whole Graphic data pointer. */
#endif
               } Draw_Font_Dsc;



