(*

 **********************************************************************
 *                                                                    *
 *                                                                    *
 *                                                                    *
 *             D R A W   -   C L I E N T   L I B R A R Y              *
 *                                                                    *
 *               P A S C A L     E N V I R O N M E N T                *
 *                                                                    *
 *                       (Pascal Environment)                         *
 *                                                                    *
 *                                                                    *
 *                               by                                   *
 *                                                                    *
 *          Pierre Wolfers, Laboratoire de Cristallographie           *
 *                                                                    *
 *          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
 *                                                                    *
 *                     F 38042 GRENOBLE CEDEX 9                       *
 *                                                                    *
 *                           F R A N C E                              *
 *                                                                    *
 *                                                                    *
 *                                                                    *
 **********************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                  Global Public License (GPL)                        //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*)
(*
  [environment( 'DRAW_DEFS')]
*)
%pragma code_option c_code '#include <draw/draw_apientry.h>';
(*
module DRAW_DEFS;
*)

const
  raster = 0;
  centimeter = 1;



  {   *****   PopUp Menus Flags  ***** }

  Menu_Close =  0;
  Menu_Open  =  1;
  Menu_Skip  =  2;
  Menu_New   =  3;
  Menu_Entry =  4;
  Menu_Separ =  5;
  Menu_Fact  = 16;



  {   *****   Server Capability Flags  ***** }

  DrwSrv_Do_Input        =     1;
  DrwSrv_Do_3D           =     2;
  DrwSrv_Do_Animation    =     4;
  DrwSrv_Do_Blend_alpha  =     8;
  DrwSrv_Do_Lighting     =    16;

  DrwSrv_Do_User_Menu    =    64;

  DrwSrv_Enable_Light1   =   256;
  DrwSrv_Enable_Light2   =   512;
  DrwSrv_Enable_Light3   =  1024;
  DrwSrv_Enable_Light4   =  2048;


  {   *****   Blending Flags and Codes   ***** }

  PLOT_BLD_SOLID         =     0;
  PLOT_BLD_TRANSPARENT   =     1;

  PLTBLEND               =  4096;
  PLTBLEND_ZERO          =     0;
  PLTBLEND_ONE           =     1;
  PLTBLEND_DST_COLOR     =     2;
  PLTBLEND_SRC_COLOR     =     3;
  PLTBLEND_1_M_DST_COLOR =     4;
  PLTBLEND_1_M_SRC_COLOR =     5;
  PLTBLEND_SRC_ALPHA     =     6;
  PLTBLEND_1_M_SRC_ALPHA =     7;
  PLTBLEND_DST_ALPHA     =     8;
  PLTBLEND_1_M_DST_ALPHA =     9;
  PLTBLEND_SRC_ALPHA_SAT =    10;

  PLTBLEND_BENA          =  4096 +  256;
  PLTBLEND_BDIS          =  4096 +  512;
  PLTBLEND_DENA          =  4096 + 1024;
  PLTBLEND_DDIS          =  4096 + 2048;



  {   *****   Light/material_Properties Codes   ***** }

  LIGHT_POSITION         =     0;
  LIGHT_AMBIENT_COLOR    =     1;
  LIGHT_DIFFUSE_COLOR    =     2;
  LIGHT_SPECULAR_COLOR   =     3;
  LIGHT_SPOT_DIRECTION   =     4;
  LIGHT_SPOT_EXPONENT    =     5;
  LIGHT_SPOT_CUTOFF      =     6;
  LIGHT_CONSTANT_ATT     =     7;
  LIGHT_LINEAR_ATT       =     8;
  LIGHT_QUADRATIC_ATT    =     9;

  MAT_FRONT_FACE         =     0;
  MAT_FRONT_AND_BACK     =     1;
  MAT_BACK_FACE          =     2;

  MAT_AMBIENTE_DIFFUSE   =     0;
  MAT_AMBIENT_COLOR      =     1;
  MAT_DIFFUSE_COLOR      =     2;
  MAT_SPECULAR_COLOR     =     3;
  MAT_SHININESS          =     4;
  MAT_EMISSION_COLOR     =     5;


  {   *****   Plot  Flags  ***** }

  PLOT_LINE           =   1;      { Normal Line Out_Mode }
  PLOT_MARKER         =   2;      { Normal Marker Out_Mode }
  PLOT_FILL           =   3;      { Normal Fill Area Out_Mode }
  PLOT_POINTS         =   0;      { GL Conformance to GL_POINTS }
  PLOT_LINES          =  -1;      { GL Conformance to GL_LINES }
  PLOT_LINE_STRIP     =  -2;      { GL Conformance to GL_LINE_STRIP }
  PLOT_LINE_LOOP      =  -3;      { GL Conformance to GL_LINE_LOOP }
  PLOT_TRIANGLES      =  -4;      { GL Conformance to GL_TRIANGLE_STRIP }
  PLOT_TRIANGLE_STRIP =  -5;      { GL Conformance to GL_TRIANGLE_STRIP }
  PLOT_TRIANGLE_FAN   =  -6;      { GL Conformance to GL_TRIANGLE_FAN }
  PLOT_QUADS          =  -7;      { GL Conformance to GL_QUADS }
  PLOT_QUAD_STRIP     =  -8;      { GL Conformance to GL_QUAD_STRIP }
  PLOT_POLYGON        =  -9;      { GL Conformance to GL_POLYGON }

  PLTFLG_START        =   1;      { PLOT Block Start Flag }
  PLTFLG_END          =   2;      { PLOT Block End Flag }
  PLTFLG_ABS          =   4;      { PLOT Block Absolute Flag }
  PLTFLG_3D           =   8;      { PLOT Block 3D Flag }
  PLTFLG_NRM          =  16;      { PLOT Block Auto Generation of Normal Flag }
  PLTFLG_UNRM         = 128;      { PLOT Block Normal are given or each point in the data block }



  {   *****   Axis Flags   ***** }

  Axis_Log       =       1;       { Axis is in Log10 Coordinate }
  Axis_Left      =       2;       { Ticks and displayed value at left position ( else at right ) }
  Axis_VOther    =       4;       { Value are in other side (than ticks) }
  Axis_NFrs      =       8;       { Does not display the first Ticks }
  Axis_NFVl      =      16;       { Does not display the first Value }
  Axis_NLsT      =      32;       { Does not display the last Ticks }
  Axis_NLVl      =      64;       { Does not display the last Value }
  Axis_NZer      =     128;       { Does not display the Zero Ticks }
  Axis_NZVl      =     256;       { Does not display the Zero Value }
  Axis_Arrow     =     512;       { Put an arrow at the end of axis }
  Axis_ArroF     =    1024;       { Fill mode for Axis_Arrow }
  Axis_Tilte     =    2048;       { Axis character are tilted with ticks }
  Axis_VPath     =    4096;       { String Path (2 bits) for Ticks Value }
  Axis_Upath     =   16384;       { String Path (2 bits) for Axis Unit }
  Axis_SpLim     =   65536;       { Axis Limit auto-adaptation when set }
  Axis_VLeft     =  131072;       { Left Alignement for Unit String }
  Axis_VRight    =  262144;       { Right Alignement for Unit String }
  Axis_ULeft     =  524288;       { Left Alignement for Unit String }
  Axis_URight    = 1048576;       { Right Alignement for Unit String }
  Axis_UMiddle   = 2097152;       { Set Unit String at the Middle of Axis }


  {   *****   Axis Plot Directives and Flags for Draw_Plot   ***** }

  Axis_Plot_X    =     1;         { Plot an X axis }
  Axis_Plot_Y    =     2;         { Plot an Y axis }
  Axis_Plot_Z    =     3;         { Plot a  Z axis }
  Axis_PFlg_TVl  =     4;         { Ticks values and Unit String will be Displayed }
  Axis_PFlg_TPrm =     8;         { The ticks left and right sides are permutted }
  Axis_PFlg_TSym =    16;         { The Ticks must be symmetrized }
  Axis_PFlg_XEnd =    32;         { Plot Axis with a shift of x axis size }
  Axis_PFlg_YEnd =    64;         { Plot Axis with a shift of Y axis size }
  Axis_PFlg_ZEnd =   128;         { Plot Axis with a shift of Z axis size }
  Axis_PFlg_XPos =   256;         { Plot Axis at specified X shift }
  Axis_PFlg_YPos =   512;         { Plot Axis at specified Y shift }
  Axis_PFlg_ZPos =  1024;         { Plot Axis at specified Z shift }
  Axis_Pflg_SymU =  2048;         { Apply a mU (mirror u) to tick direction }
  Axis_Pflg_SymV =  4096;         { Apply a mV (mirror v) to tick direction }
  Axis_Pflg_SymW =  8192;         { Apply a mW (mirror w) to tick direction }
  Axis_Pflg_Rotv = 16384;         { Apply an additional rotation of 180 to value and unit strings }




type
 Dint   = cc__int;                { Define the Draw Integer to use }
 Dfloat = single;                 { Define the Draw Float to use }
 Dbool  = boolean;                { Define the Draw boolean to use }
 Dbyte  = byte;                   { Define a Flag byte }


 { unit_type = ( raster, centimeter );}   { Selected unit capacity }
  unit_type  = byte;              { Selected unit capacity }
  

  Dvalue = array[1..1] of Dfloat; { Unique parameter in an array }

  Dpoint = array[1..2] of Dfloat; { 2D coordinates }

  Dpoint3 = array[1..3] of Dfloat;{ 3D coordinates }

  Dcolor = array[1..4] of Dfloat; { Color with alpha }

  DMatrix = array[1..3,1..4] of Dfloat; { Transformation Matrix }

  Draw_Menu( dim, cap: byte ) = array[1..dim] of string( cap ); { Define the menu type }


var
  [external 'Draw_Srv_Name'] Draw_Server_NamTb: $wild_Pointer;
  [external 'Draw_Srv_NameLength'] Draw_Server_Namln: char;
  [external 'Draw_Srv_Ide']  Draw_Server_Ident: cc__int;
  [external 'Draw_Srv_Flg']  Draw_Server_Flags: cc__int;
  [external 'Draw_SrvMod']   Draw_Server_Mode : cc__int;
  [external 'Draw_AnmSSt']   Draw_Anim_State  : cc__int;



{******************************************************}
{******************DRAW$L1 ROUTINES********************}
{******************************************************}


procedure DRAW$END; external 'DRW_API( end )';
{ To end the DRAW session }


procedure DRAW$SET_MENU_SPC( cd: Dint; in_var name: [optional] string; id: Dint := -1 );
external 'Draw_Pas_Set_Menu_Spc';


function  DRAW$INIT( var    x,  y: Dfloat; var unit: unit_type;
                     in_var usrid: [optional] string ): Dint;
{ Start Graphic Server and get the X*Y plot size from the final
  work station driver.
  The resulting unit flag is true when the final work station
  has the metrix attribute, then x and y are in Cm.
  otherwise, x and y are in screen units.
  usrid is the optional user programme string identifier. }
external 'Draw_Pas_Init';



procedure DRAW$GET_SERVER_NAME( var s: string );
external 'Draw_Get_Server_Name';



function DRAW$PICTURE( in_var title:  string;    { Picture title }
                              px, py: Dfloat;    { Picture size in cm. }
                              bscale,            { Scale flag }
                              blimit: Dbool ): Dbool; { Margin/title flag }
{ Set the picture size to be px*py (in Cm.), and the picture title.
  If the flag blimit is set at true, then a margin is allocated around
  the picture and the title is displayed inside it else the title is
  ignored.
  If the bscale flag is set to true, then DRAW$PICTURE try to respect the
  picture size to be Dfloat Cm. If is is not possible (du to the Dfloat size of
  the final work station area, or for a not metrix work station) the flag is
  clear to false value on the return. In this case, or when the input value
  of bscale was false, the picture size is set to the maximum size possible
  in agreement with the work station area. }
external 'Draw_Pas_Picture';

function DRAW$PICTURE3( in_var title:  string;         { Picture title }
                               px, py, pz: Dfloat;     { Picture size in cm. }
                               bscale,                 { Scale flag }
                               blimit: Dbool ): Dbool; { Margin/title flag }
external 'Draw_Pas_Picture_3D';


procedure DRAW$PICTURE_SCALES( cd: Dint; var xscale, yscale: Dfloat );
external 'Draw_Picture_Scales';


procedure DRAW$PIC_VIEW( flags: Dbyte := 0 );  external 'Draw_Pic_View';


procedure DRAW$PIC_RESET( flags: Dbyte := 0 ); external 'Draw_Pic_Reset';


function  DRAW$TIME_ANIM( per: Dint ): Dint; external 'Draw_Time_Anim';


procedure DRAW$SET_STOP_ANIM( md: Dint ); external 'Draw_Set_Stop_Anim';


procedure DRAW$CLIPBOX( limits, modexyz: $wild_pointer := nil );
external 'draw_clipbox';


procedure DRAW$ORG( ox, oy: Dfloat; irel: Dint );
{*****************************************************************}
{                                                                 }
{       Origine pen change                                        }
{                                                                 }
{       call draw$org( ox, oy, irel )                             }
{                                                                 }
{       ox,oy is the vector to applied                            }
{       irel must be 0 for absolute origine change, >0 for        }
{       relative origine change and <0 from original origine.     }
{                                                                 }
{*****************************************************************}
external 'Draw_Org';



procedure DRAW$ORG3( ox, oy, oz: Dfloat; irel: Dint );
external 'Draw_Org3';



procedure DRAW$COLOR( n: Dint );
{*************************************************}
{                                                 }
{     To emulate calcomp pen change               }
{                                                 }
{     flush plot buffer before change.            }
{                                                 }
{*************************************************}
external 'Draw_Color_Index';

procedure DRAW$COLOR( r, v, b: Dfloat; a: Dfloat := 1.0 );
{*************************************************}
{                                                 }
{     To emulate calcomp pen change               }
{                                                 }
{     flush plot buffer before change.            }
{                                                 }
{*************************************************}
external 'Draw_Set_ColorA';


procedure DRAW$OUT_MODE( n: Dint );
{********************************************************************}
{                                                                    }
{     To select a line(1), a marker(2) or a fill area mode (3)       }
{                                                                    }
{     n = 1 => line                                                  }
{     n = 2 => marker                                                }
{     n = 3 => fill area                                             }
{                                                                    }
{********************************************************************}
external 'Draw_Out_Mode';


procedure DRAW$SEND_BLOCK( in_var vtb: array[sz: Dint] of Dfloat );
external 'Draw_Pas_Send_Block';


procedure DRAW$SEND_BLOCK( in_var vtb: array[sz: Dint] of Dpoint3 );
external 'Draw_Pas_Send_Block';


procedure DRAW$MPLOT( in_var   pt: array[sz: Dint] of Dfloat;
                              npt: Dint := 0;
                             flag: Dint := 3 );
external 'Draw_Pas_Mplot';


procedure DRAW$PLOT( x, y: Dfloat; ipen: Dbool );
{***********************************************}
{                                               }
{     To emulate calcomp plot with gks          }
{                                               }
{     call draw$plot( x, y, ipen )              }
{                                               }
{     x,y coordinate to go                      }
{     ipen := false  to go with pen up          }
{     ipen := true   to go with pen down        }
{                                               }
{***********************************************}
external 'Draw_Plot';


procedure DRAW$PLOT3( x, y, z: Dfloat; ipen: Dbool );
external 'Draw_Plot3';


procedure DRAW$RPLOT( dx, dy: Dfloat; ipen: Dbool );
{**********************************************}
{                                              }
{     Relative move of the pen                 }
{                                              }
{     call draw$rplot( dx, dy, ipen )          }
{                                              }
{     dx,dy is the vector to applied           }
{     ipen is the pen command                  }
{                                              }
{**********************************************}
external 'Draw_Rplot';


procedure DRAW$RPLOT3( dx, dy, dz: Dfloat; ipen: Dbool );
external 'Draw_Rplot3';


procedure DRAW$WHERE( var x, y: Dfloat );
{*********************************************************}
{                                                         }
{       Subroutine to give the current pen position       }
{                                                         }
{*********************************************************}
external 'DRW_API( where )';



procedure DRAW$WHERE3( var x, y, z: Dfloat );
external 'DRW_API( where3 )';



procedure DRAW$CIRCLE( xcentre, ycentre, rayon: Dfloat;
                       start_angle, end_angle: Dfloat := 0.0; prec: Dfloat := 1.0E-3; flg: Dint := 0 );
external 'Draw_Circle';


procedure DRAW$STRING( x, y, theta, high: Dfloat;
                       in_var        str: string; oflg: Dint := 0 );
{*******************************************}
{                                           }
{       Subroutine to plot a string.        }
{                                           }
{*******************************************}
external 'Draw_Pas_String';


procedure DRAW$VIEW( dist, om, th, nu : Dfloat := 0.0 );
external 'Draw_View';


procedure DRAW$SPHERE( xc, yc, zc, r: Dfloat; plg, plt: Dint; flg: Dint := 0 );
external 'Draw_Sphere';


procedure DRAW$CYLINDER( xb, yb, zb, th, ph, lg, rb, rt: Dfloat; px, pz: Dint; flg: Dint := 0 );
external 'Draw_Cylinder';


procedure DRAW$DISK( xc, yc, zc, th, ph, ri, re, sa, ea: Dfloat; pt, pr: Dint; flg: Dint := 0 );
external 'Draw_Disk';


procedure DRAW$SURFACE( in_var vtb: array[nraw: integer, ncol: integer] of DPoint3; oflg: Dint := 0 );
external 'Draw_Pas_Surface';


procedure DRAW$SURFACE( nraw, ncol, oflg: Dint := 0 );
external 'Draw_Pas_SurfaceA';


procedure DRAW$SURFACE2( in_var vtb: array[nraw: integer, ncol: integer] of Dfloat; xo, yo, xs, ys: Dfloat; oflg: Dint := 0 );
external 'Draw_Pas_Surface2';


procedure DRAW$SURFACE2( nraw, ncol, oflg: Dint := 0; xo, yo, xs, ys: Dfloat );
external 'Draw_Pas_Surface2A';


procedure DRAW$SURFACE( nraw, ncol: Dint; vtbp: $Wild_pointer; ofl: Dint );
external 'Draw_Surface';


procedure DRAW$POLYHEDRAL( in_var ftb: array[nfc: integer] of Dint;
                           in_var vtb: array[nvt: integer] of DPoint3; oflg: Dint := 0 );
external 'Draw_Pas_Polyhedral';


procedure DRAW$POLYHEDRAL( nfc, nvt: Dint; ftbp, vtbp: $Wild_pointer; ofl: Dint );
external 'Draw_Polyhedral';


procedure DRAW$DEFINE_COLOR( icol: Dint; r, g, b: Dfloat; a: Dfloat := 1.0 );
external 'Draw_Define_ColorA';


function DRAW$INQUIRE_COLOR( icol: Dint; var r, g, b: Dfloat; var a: [optional] Dfloat ): Dint;
external 'Draw_Inquire_Color';


procedure DRAW$LINE_ATTR( n: Dint; r: Dfloat );
{*************************************}
{                                     }
{     n is the line type              }
{     r is the line size.             }
{                                     }
{*************************************}
external 'Draw_Line_Attr';


procedure DRAW$MARKER_ATTR( n: Dint; r: Dfloat );
{*************************************}
{                                     }
{       n is the marker type          }
{       r is the marker size.         }
{                                     }
{*************************************}
external 'Draw_Marker_Attr';


procedure DRAW$FILL_ATTR( n1, n2: Dint );
{****************************************}
{                                        }
{     n1 is the fill int style           }
{     n2 is the fill style index         }
{                                        }
{****************************************}
external 'Draw_Fill_Attr';


procedure DRAW$TEXT_FONT( n: Dint; tp: Dint := 0 );
{*******************************************}
{                                           }
{     To give the font change               }
{                                           }
{*******************************************}
external 'Draw_Text_Font';


procedure DRAW$TEXT_ATTR( n1, n2, n3: Dint; re, rs: Dfloat );
{**************************************************}
{                                                  }
{     To give the font align and path.             }
{                                                  }
{**************************************************}
{                                                  }
{     n1 is the horizontal text alignment value    }
{     n2 is the vertical text alignment value      }
{     n3 is the path value                         }
{     re is the expension factor                   }
{     rs is the spacing factor                     }
{                                                  }
{**************************************************}
external 'Draw_Text_Attr';


function  DRAW$NEW_SEG( n: Dint := -1 ): Dint;
{*****************************************************************}
{                                                                 }
{     To change of segment                                        }
{     n is the segment identifier of the new opened segment.      }
{     flush plot buffer before change.                            }
{                                                                 }
{*****************************************************************}
external 'Draw_New_Seg';


procedure DRAW$SEG_END;
{******************************************}
{                                          }
{       To close an opened segment.        }
{                                          }
{******************************************}
external 'DRW_API( seg_end )';


procedure DRAW$DEL_SEG( n: Dint );
{********************************************************************}
{                                                                    }
{     To delete a given segment                                      }
{       n is the segment identifier of of the segment to delete.     }
{       flush plot buffer before gks change.                         }
{                                                                    }
{********************************************************************}
external 'Draw_Del_Seg';


function  DRAW$UPDATE_SEG( n: Dint; fapp: Dint := 0 ): Dint;
{*****************************************************************}
{                                                                 }
{     To change a segment to a possible existing one,             }
{     n is the segment identifier of the new opened segment.      }
{     flush plot buffer before change.                            }
{                                                                 }
{*****************************************************************}
external 'Draw_Update_Seg';


procedure  DRAW$INCLUDE_SEG( n: Dint );
{*****************************************************************}
{                                                                 }
{     To include a segment to a possible existing one,            }
{     n is the segment identifier of the segment to include.      }
{     flush plot buffer before change.                            }
{                                                                 }
{*****************************************************************}
external 'Draw_Include_Seg';


procedure DRAW$SEG_ATTR( seg_id, det, hli, vis: Dint;
                         prior:                 Dfloat );
external 'Draw_Seg_Attr';


procedure DRAW$SET_PICKID( pic_id: Dint );
external 'Draw_Set_Pickid';


procedure DRAW$DETECTABLE( det_flg: Dint );
external 'Draw_Detectable';


function  DRAW$SEG_INQUIRE: Dint;
external 'DRW_API( seg_inquire )';


function  DRAW$PUSH_MATRIX: integer;
external 'DRW_API( push_matrix )';

procedure DRAW$POP_MATRIX;
external 'DRW_API( pop_matrix )';


procedure DRAW$SEG_UNIT_TRANSF( iseg: Dint; update: Dint := 0 );
external 'Draw_Seg_Unit_Transf';
procedure DRAW$MAT_UNIT_TRANSF( imat: Dint; update: Dint := 0 );
external 'Draw_Mat_Unit_Transf';


procedure DRAW$TRANSF_SEG(  iseg: Dint;  tx,  ty,  px,  py, theta, scx, scy: Dfloat );
external 'Draw_Transf_Seg';
procedure DRAW$TRANSF_Mat(  imat: Dint;  tx,  ty,  px,  py, theta, scx, scy: Dfloat );
external 'Draw_Transf_Mat';

procedure DRAW$TRANSF_SEG3( iseg: Dint;  tx,  ty,  tz,  px,  py,  pz,
                                        ome, chi, psi, scx, scy, scz: Dfloat );
external 'Draw_Transf_Seg3';
procedure DRAW$TRANSF_MAT3( imat: Dint;  tx,  ty,  tz,  px,  py,  pz,
                                        ome, chi, psi, scx, scy, scz: Dfloat );
external 'Draw_Transf_Mat3';


procedure DRAW$MOVE_SEG(  iseg: Dint; tx, ty: Dfloat );
external 'Draw_Move_Seg';
procedure DRAW$MOVE_MAT(  imat: Dint; tx, ty: Dfloat );
external 'Draw_Move_Mat';

procedure DRAW$MOVE_SEG3( iseg: Dint; tx, ty, tz: Dfloat );
external 'Draw_Move_Seg3';
procedure DRAW$MOVE_MAT3( imat: Dint; tx, ty, tz: Dfloat );
external 'Draw_Move_Mat3';


procedure DRAW$ROTATE_SEG(  iseg: Dint; px, py, theta: Dfloat );
external 'Draw_Rotate_Seg';
procedure DRAW$ROTATE_MAT(  imat: Dint; px, py, theta: Dfloat );
external 'Draw_Rotate_Mat';

procedure DRAW$UROT_SEG3( iseg: Dint;  px,  py,  pz, th, ph, an: Dfloat );
external 'Draw_URot_Seg3';
procedure DRAW$UROT_MAT3( imat: Dint;  px,  py,  pz, th, ph, an: Dfloat );
external 'Draw_URot_Mat3';

procedure DRAW$ROTATE_SEG3( iseg: Dint;  px,  py,  pz, ome, chi, psi: Dfloat );
external 'Draw_Rotate_Seg3';
procedure DRAW$ROTATE_MAT3( imat: Dint;  px,  py,  pz, ome, chi, psi: Dfloat );
external 'Draw_Rotate_Mat3';


procedure DRAW$SCALE_SEG(  iseg: Dint;  px,  py, scx, scy: Dfloat );
external 'Draw_Scale_Seg';
procedure DRAW$SCALE_MAT(  imat: Dint;  px,  py, scx, scy: Dfloat );
external 'Draw_Scale_Mat';

procedure DRAW$SCALE_SEG3( iseg: Dint;  px,  py,  pz, scx, scy, scz: Dfloat );
external 'Draw_Scale_Seg3';
procedure DRAW$SCALE_MAT3( imat: Dint;  px,  py,  pz, scx, scy, scz: Dfloat );
external 'Draw_Scale_Mat3';

function  Draw$Get_Seg_Mat( iseg: Dint; var m: DMatrix ): Dint; external 'Draw_Get_Seg_Mat';
function  Draw$Put_Seg_Mat( iseg: Dint; in_var m: DMatrix ): Dint; external 'Draw_Put_Seg_Mat';
function  Draw$Get_Matrix( imat: Dint; var m: DMatrix ): Dint; external 'Draw_Get_Matrix';
function  Draw$Put_Matrix( imat: Dint; in_var m: DMatrix ): Dint; external 'Draw_Put_Matrix';

function DRAW$SEG_ORIENTATION( iseg: Dint; px, py, pz: Dfloat; interaction: boolean := false ): Dint; external 'Draw_Seg_Orient';
function DRAW$MAT_ORIENTATION( imat: Dint; px, py, pz: Dfloat; interaction: boolean := false ): Dint; external 'Draw_Mat_Orient';

procedure DRAW$MESSAGE( in_var str: string );
external 'Draw_Pas_Message';



{******************************************************}
{******************DRAW$L2 ROUTINES********************}
{******************************************************}

{***********************************************************************}
{                                                                       }
{       Procedure to get a choice from the current work station.        }
{                                                                       }
{***********************************************************************}
function DRAW$GET_CHOICE( in_var title: string;
                          in_var menu: array[dim: integer, cap: integer] of char;
                                  nsz: Dint := 0
                        ): Dint;
external 'Draw_Pas_Get_Arr_Choice';


function DRAW$GET_CHOICE( in_var title: string;
                          in_var  menu: array[dim: integer] of ^string;
                                   nsz: Dint := 0 ): Dint;
external 'Draw_Pas_Get_Str_Choice';


function DRAW$GET_CHOICE( in_var title: string;
                          in_var  menu: Draw_Menu; nsz: integer := 0 ): Dint;
external 'Draw_Pas_Get_M_Choice';



{***********************************************************************}
{                                                                       }
{       Procedure to select a file from the current work station.       }
{                                                                       }
{***********************************************************************}
function Draw$Select_File( in_var title: string;
                           in_var filtr: Draw_menu;
                           in_var defst: string;
                              var resul: string;
                              var flidx: integer;
                                  nwflg, nszfl: Dint := 0 ): Dint;
external 'Draw_Pas_Select_MFile';


function DRAW$SELECT_FILE( in_var title: string;
                           in_var filtr: array[dim: integer] of ^string;
                           in_var defst: string;
                              var resul: string;
                              var flidx: Dint;
                                  nwflg, nszfl: Dint := 0 ): Dint;
external 'Draw_Pas_Select_File';



{*****************************************************************************}
{                                                                             }
{       Procedure to get an answerd (yes/not ) from the current work station  }
{                                                                             }
{*****************************************************************************}
function DRAW$GET_ANSWERD( in_var title: string ): Dint;
external 'Draw_Pas_Get_Answerd';


{************************************************************************}
{                                                                        }
{       Procedure to get a position from the current work station.       }
{                                                                        }
{************************************************************************}
function DRAW$GET_POSITION( var xx, yy: Dfloat; in_epure: Dbool := true ): Dint;
external 'Draw_Get_Position';


{*********************************************************************}
{                                                                     }
{       Procedure to get a window from the current work station.      }
{                                                                     }
{*********************************************************************}
function DRAW$GET_WINDOW( var xx1, xx2, yy1, yy2: Dfloat ): Dint;
external 'DRW_API( get_window )';


{***********************************************************************}
{                                                                       }
{       Procedure to get a string from the current work station.        }
{                                                                       }
{***********************************************************************}
function DRAW$GET_STRING( in_var title, default: string;
                             var        value  : string ): Dint;
external 'Draw_Pas_Get_String';


{**************************************************************************}
{                                                                          }
{       Procedure to get a floating value from the current work station.   }
{                                                                          }
{**************************************************************************}
function DRAW$GET_VALUE( in_var title:   string;
                            var   val:   Dfloat;
                                lwlim, uplim: Dfloat ): Dint;
external 'Draw_Pas_Get_Value';


function DRAW$GET_CURVE( var    pt: array[capa: Dint] of Dfloat;
                         var  rdim: Dint;
                             bplot: Dbool;
                              stfl: Dbool := false ): Dint;
external 'Draw_Get_Line_Stroke';



{**************************************************************************}
{                                                                          }
{       Procedure to get a segment and id from the current work station.   }
{                                                                          }
{**************************************************************************}
function DRAW$SEG_PICK( var  seg_id, pick_id: Dint ): Dint;
external 'DRW_API( seg_pick )';



{******************************************************}
{******************DRAW$L3 ROUTINES********************}
{******************************************************}


function DRAW$DIALOG( flags: Dint := 0 ): Dint;
{ To display the picture and give mouse control for grid, zoom etc... }
external 'Draw_Dialog';

procedure DRAW$ALPHA_SET( flg: Dint ); external 'Draw_Alpha_Set';
procedure DRAW$LIGHT_ON_OFF( light, flg: Dint ); external 'Draw_Light_OnOff';

procedure DRAW$LIGHT_DEFINE( light, kind: Dint; in_var fparm: array[sz:Dint] of Dfloat );
external 'Draw_Light_Define';

procedure DRAW$LIGHT_DEFINE( light, kind: Dint; in_var fval: Dfloat; fvalsz: Dint := 1 );
external 'Draw_Light_Define';

procedure DRAW$MAT_LIGHT_PROP( face, kind: Dint; in_var fparm: array[sz:Dint] of Dfloat );
external 'Draw_Mat_Light_Prop';

procedure DRAW$MAT_LIGHT_PROP( face, kind: Dint; in_var fval: Dfloat; fvalsz: Dint := 1 );
external 'Draw_Mat_Light_Prop';

procedure DRAW$ZOOM;                 external 'DRW_API( zoom )';

procedure DRAW$SCALE;                external 'DRW_API( scale )';

procedure DRAW$RELOAD( flg: Dbool ); external 'Draw_Reload';

procedure DRAW$REFRESH;              external 'DRW_API( refresh )';

procedure DRAW$GRID( flg: Dbool );   external 'Draw_Grid';

procedure DRAW$PRINT;                external 'DRW_API( print )';




{*******************************************************************}
{                                                                   }
{      D R A W   $   C O M M O N  for  A X I S  M A N A G E R       }
{                                                                   }
{*******************************************************************}

function  Draw$New_Axis( in_var u_axis, v_axis: Dpoint3;
                             length, vinf, vsup: Dfloat; ntck, flags: Dint := 0 ): Dint;
external 'Draw_New_Axis';


function  Draw$New_Box( in_var org: Dpoint3; ix, iy, iz: Dint;
                        in_var dtb: array[sz: Dint] of Dint;
                               stb: $wild_pointer := nil; nf, sz1, sz2: Dint := 0 ): Dint;
external 'Draw_New_Box';


function  Draw$New_Box( in_var org: Dpoint3; ix, iy, iz: Dint;
                        in_var dtb: array[sz: Dint] of Dint;
                        in_var stb: array[nf: Dint] of Dfloat;
                               dtbsz, stbsz: Dint := 0 ): Dint;
external 'Draw_New_Box';


function Draw$Easy_Box_2D( ox, oy, sx, sy, mx1, mx2, my1, my2: Dfloat;
                           in_var ux, uy: [optional] string; ns: Dint := 0 ): Dint;
external 'Draw_Easy_Box_2D';


procedure Draw$Free_Box( ib: Dint; axflg: Dbool := false );
external 'Draw_Free_Box';


procedure DRAW$FREE_BOX_LIST;
external 'DRW_API( free_box_list )';



procedure Draw$Set_Axis_Value( ia, cd,  n: Dint; in_var p1, p2, p3, p4: [optional] Dfloat;
                                                 in_var p5, p6, p7:     [optional] Dint );
external 'Draw__Set_Axis_Value';

procedure Draw$Get_Axis_Value( ia, cd,  n: Dint; var p1, p2, p3, p4: [optional] Dfloat;
                                                 var p5, p6, p7:     [optional] Dint );
external 'Draw__Get_Axis_Value';

procedure Draw$Set_Axis_Ticks( ia, n, nt: Dint; in_var tfre: array[$sf:Dint] of Dint;
                                                in_var tknd: array[$sk:Dint] of Dint;
                                                in_var tsiz: array[$sl:Dint] of Dfloat );
external 'Draw_Set_Axis_Ticks';

function  Draw$Get_Axis_Ticks( ia, n, nt: Dint; var tfre: array[$sf:Dint] of Dint;
                                                var tknd: array[$sk:Dint] of Dint;
                                                var tsiz: array[$sl:Dint] of Dfloat ): Dint;
external 'Draw_Get_Axis_Ticks';

procedure Draw$Set_Axis_Unit( ia: Dint; in_var unit: string );
external 'Draw_Set_Axis_Unit';

function  Draw$Get_Axis_Unit( ia: Dint; var unit: string ): Dint;
external 'Draw_Get_Axis_Unit';

procedure Draw$Set_Axis_Flags( io, flg: Dint );
external 'Draw_Set_Axis_Flags';

function  Draw$Get_Axis_Flags( io: Dint ): Dint;
external 'Draw_Get_Axis_Flags';

function  Draw$Get_Box_Value( box, cd: Dint; var itb: array[sz: Dint] of Dint ): Dint;
external 'Draw_Get_Box_Value';

function  Draw$Get_Box_Value( box, cd: Dint; var ftb: array[sz: Dint] of Dfloat ): Dint;
external 'Draw_Get_Box_Value';

procedure Draw$Plot_Axis( ia: Dint; in_var org: Dpoint3; fvl: Dint );
external 'Draw_Plot_Axis';

procedure Draw$Plot_Box( ib: Dint );
external 'Draw_Plot_Box';


procedure Draw$Open_Box( ib: Dint );
external 'Draw_Open_Box';


procedure Draw$Close_Box;
external 'DRW_API( close_box )';


function  Draw$Conv_Box( tbox: Dbool; xd, yd, zd: Dfloat; var xr, yr, zr: Dfloat ): Dint;
external 'Draw_CV_Box';


procedure Draw$Axis_Inscale( mi, ma: Dfloat; n: Dint; var inf, sup, delta, ef: Dfloat );
external 'Draw_Axis_Inscale';


procedure Draw$Axis_Setvscale( inf, sup, delta, rsiz: Dfloat; var fsiz, eff, scale: Dfloat );
external 'Draw_Axis_Setvscale';


function  Draw$Axis_AutoScale( min, max, szp: Dfloat; ani, ana: Dint;
                               var inf, sup, del, fsz, sca, eff: Dfloat ): Dint;
external 'Draw_Axis_AutoScale';


procedure Draw$Axis_Viewscale( a_inf, a_sup, a_del: Dfloat;
                               var a_vinf, a_vsup, a_vdel, a_sc, a_sh: Dfloat );
external 'Draw_Axis_Viewscale';


(*
end.
*)
