/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                     (Multi-Language Support)                       *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */


/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                  DRAW  LIBRARY  BASIC  FUNCTIONS                    //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/

void DRW_API( end )();

void Draw__Init( float *x_paper, float *y_paper, Char *unit,
                 Char *usr_id, int usr_len );

Char Draw__Picture( char  *title, int len,     /* Title string */
                    float x_size,              /* Plot Surface Length */
                    float y_size,
                    float z_size,
                    Char   scale,              /* Scale flags */
                    Char margin                /* Margin/Title flag*/
                  );

int Draw_Time_Anim( int per );

void Draw_Send_Block( float* vtb );

void Draw_Out_Mode( int mode );

void Draw__Mplot( int dim, float * pt, int flg );

void Draw_Plot( float x, float y, Char pen );

void Draw_Plot3( float x, float y, float z, Char pen );

void Draw_Org( float ox, float oy, int irel );

void Draw_Org3( float ox, float oy, float oz, int irel );

void DRW_API( where )( float *x, float *y );

void DRW_API( where3 )( float *x, float *y, float *z );

void Draw_Rplot( float dx, float dy, Char pen );

void Draw_Rplot3( float dx, float dy, float dz, Char pen );

void Draw__String( float x, float y, float theta, float high,
                   char * str, int len, int flg );

void Draw_Circle( float x_c, float y_c, float r, float st_a, float nd_a, int flg );

void Draw_Sphere( float x_c, float y_c, float z_c, float r, int flg );




/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//               DRAW  LIBRARY  ATTRIBUTES  FUNCTIONS                  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


void Draw_Color( int color );

void Draw_Set_Color( float r, float v, float b );

void Draw_Define_Color( int icol, float r, float g, float b );

int Draw_Inquire_Color( int icol, float * r, float * g, float * b );

void Draw_Line_Attr( int n, float r );

void Draw_Marker_Attr( int n, float r );

void Draw_Fill_Attr( int n1, int n2 );

void Draw_Text_Font( int n, int tp );

void Draw_Text_Attr( int n1, int n2, int n3, float re, float rs );





/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                DRAW  LIBRARY  SEGMENT  FUNCTIONS                    //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


int DRW_API( new_seg )( int *n );

void DRW_API( seg_end )();

void DRW_API( del_seg )( int *n );

int DRW_API( update_seg )( int *n );

void DRW_API( include_seg )( int *n );

void DRW_API( seg_attr )( int *seg_id, int *det, int *hli, int *vis, float *prior );

void DRW_API( seg_picid )( int *pic_id );

int DRW_API( seg_inquire )();

void DRW_API( seg_unit_transf )( int *iseg );

void DRW_API( transf_seg )( int  *iseg, float  *tx, float    *ty,
                            float  *px, float  *py, float *theta,
                            float *scx, float *scy );

void DRW_API( transf_seg3 )( int *iseg, float  *tx, float  *ty, float  *tz,
                                        float  *px, float  *py, float  *pz,
                                        float *ome, float *chi, float *psi,
                                        float *scx, float *scy, float *scz );

void DRW_API( move_seg )( int *iseg, float *tx, float *ty );

void DRW_API( move_seg3 )( int *iseg, float *tx, float *ty, float *tz );

void DRW_API( rotate_seg )( int *iseg, float *px, float *py, float *theta );

void DRW_API( rotate_seg3 )( int *iseg, float  *px, float  *py, float  *pz,
                                        float *ome, float *chi, float *psi );

void DRW_API( scale_seg )( int *iseg, float *px, float *py, float *scx, float *scy );

void DRW_API( scale_seg3 )( int *iseg, float  *px, float  *py, float  *pz,
                                       float *scx, float *scy, float *scz );




/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                  DRAW  LIBRARY  INPUT  FUNCTIONS                    //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


void DRW_API( _message )( char * str, int *len );

int DRW_API( _get_choice )( int *len, char * menu[], int slen[] );

int DRW_API( _get_answerd )( char * question, int *len ):

int DRW_API( _get_string )( char * stit, int *ltit,
                            char * sdef, int *ldef,
                            char * sval, int *capa );

int DRW_API( _get_value )( char *stit, int *ltit, float *val, float *lw, float *up );

int DRW_API( _select_file )( char *   stit, int  *ltit,
                             char * fltr[], int fltl[], int  *flen,
                             int  *    fdx,
                             char *   sdef, int  *ldef,
                             char *   sval, int  *capa, int  *wflg );

int DRW_API( seg_pick )( int *seg_id, int *pick_id );

void DRW_API( _xy_display )( float * matrix, Char xcd, Char ycd,
                              char * xu, int xl, char * yu, int yl );

int Draw_Get_Position( float *xx, float *yy, Char in_epure );

int DRW_API( get_position )( float *xx, float *yy, Char *in_epure );

int DRW_API( get_window )( float *x1, float *x2, float *y1, float *y2 );

int Draw_Get_Line_Stroke( float pt[], int capa, int *size,
                          Char keep, Char f_stroke );

int DRW_API( get_curve )( float pt[], int *capa, int *size,
                          Char *keep, Char *f_stroke );





/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                  DRAW  LIBRARY  VIEW  FUNCTIONS                     //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


void Draw_Pic_View( Char flags );

void Draw_Pic_Reset( Char flags );

void DRW_API( clipbox )( float * limits, Char * md );

void Draw_View( float dist );

void Draw_Wplane3( float a, float b, float c, float d );

void Draw_Nplane3();

void Draw_Dialog();

void Draw_Zoom();

void Draw_Scale();

void Draw_Reload( Char flg );

void Draw_Refresh();

void Draw_Grid( Char flg );

void Draw_Print();

