/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*                      D R A W   -   C O D E S                       *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/**************************************/
/* DRAW Server Constantes definitions */
/**************************************/

#ifndef _DRAW_MSG_CTE
# define  DRAW_MSG_CTE             0


/* General definitions for exchange between client and server task */

# define  SERVER_NAME    "FLTK-GL_DRAW_SERVER V0.9 A"


/* Server Type Numeric Identifier { FLTK+GL = 7,
                                    Advanced Graphic function = 1,
                                    Version 1.5 (=1.5*10) }. */

# define  SERVER_IDENT   (7 + 256*(1 + 256*15))


/* This server provieded functionalities : 
        The User Input interraction management (1),
        the 3D directives                      (2),
        the Animation Directives               (4),
        the Blending/Alpha Directives          (8),
        the Light Support (4 ligths)          (16),
        No Extended Light Support (8 ligths)  (32),
        the User Menu Management              (64).
*/
# define SERVER_DO_INPUT          1
# define SERVER_DO_3D             2
# define SERVER_DO_ANIMATION      4
# define SERVER_DO_BLEND_ALPHA    8
# define SERVER_DO_LIGHTING      16

# define SERVER_DO_USER_MENUS    64

# define SERVER_ENA_LIGHT0      256
# define SERVER_ENA_LIGHT1      512
# define SERVER_ENA_LIGHT2     1024
# define SERVER_ENA_LIGHT3     2048

# define LIGHT_NUMBER             4

# define SERVER_ENA_LIGHT_MSK   (SERVER_ENA_LIGHT0*15)

# define SERVER_FUNCT       ( SERVER_DO_INPUT       | SERVER_DO_3D          |\
                              SERVER_DO_ANIMATION   | SERVER_DO_BLEND_ALPHA |\
                              SERVER_DO_LIGHTING    |\
                              SERVER_DO_USER_MENUS )

# define  MAXINT         2147483647
# define  RMAXINT      2147483647.0

  /* Size of point table for Draw_Plot */

# define  PLOT_TAB_LEN         4096*6  /* Set for 3D et 2D plot. */

  /* Size of Segment/transformation retrivial cache table table */
# define  SEG_CACHE_SIZE        128
# define  TRF_CACHE_SIZE        256

# define  ten                  10.0
# define  one                   1.0
# define  true                    1
# define  false                   0

# define  col_size               64
# define  row_size               64
# define  MAXIDSIZE              32
# define  MAXLINESZ             132


/* Exchange function code to adapt with the current system */

# if !defined( _WIN32) || defined(__CYGWIN__)
    /* All Unix Like + Cygwin on Windows */
#   ifdef __CYGWIN__
      /* Windows with the Cygwin Environment */
#     define _PIPE_NO_CNTFLOW 0
#     define _PIPE_NOBYPASS 0
#   endif
#   define BUF_SIZE  512
# else
#   /* Window System in WIN32 Environment */
#   define BUF_SIZE  512
# endif


/* DRAW Server codes */

# define  cd_continue           0

# define  cd_end                1
# define  cd_init               2
# define  cd_picture            3
# define  cd_pic_view           4
# define  cd_pic_reset          5
# define  cd_clipon             6
# define  cd_clipoff            7
# define  cd_org                8
# define  cd_color              9
# define  cd_view              10
# define  cd_wplane3           11
# define  cd_nplane3           12

# define  cd_picture_scales    14

# define  cd_tim_anim          15
# define  cd_anim_stop         16

# define  cd_exec_seg          20
# define  cd_out_mode          21

# define  cd_mplot             22
# define  cd_string            23
# define  cd_circle            24

# define  cd_sphere            25
# define  cd_cylinder          26
# define  cd_disk              27

# define  cd_surface           40
# define  cd_surface2          41

# define  cd_polyhedral        45

# define  cd_gen_tmat          50
# define  cd_init_trans_mat    51
# define  cd_move_mat          52
# define  cd_urotate_mat       53
# define  cd_rotate_mat        54
# define  cd_scale_mat         55
# define  cd_transform_mat     56
# define  cd_get_transf_mat    57
# define  cd_put_transf_mat    58

# define  cd_alpha_set         60
# define  cd_light_set         61
# define  cd_light_def         62
# define  cd_matp_light        63

# define  cd_define_color      72
# define  cd_inquire_color     73

# define  cd_line_attr         74
# define  cd_marker_attr       75
# define  cd_fill_area_attr    76
# define  cd_text_font         77
# define  cd_text_attr         78

# define  cd_new_seg           81
# define  cd_seg_end           82
# define  cd_del_seg           83
# define  cd_update_seg        84
# define  cd_seg_attr          85
# define  cd_seg_picid         86
# define  cd_seg_inquire       87

# define  cd_init_trans_seg    90
# define  cd_move_seg          91
# define  cd_urotate_seg       92
# define  cd_rotate_seg        93
# define  cd_scale_seg         94
# define  cd_transform_seg     95
# define  cd_get_transf_seg    96
# define  cd_put_transf_seg    97

# define  cd_message          101
# define  cd_get_choice       102
# define  cd_get_answerd      103
# define  cd_get_position     104
# define  cd_get_window       105
# define  cd_get_string       106
# define  cd_get_value        107
# define  cd_get_line         108
# define  cd_get_stroke       109
# define  cd_get_file         110
# define  cd_seg_pick         111
# define  cd_seg_pdetf        112

# define  cd_seg_orient       115
# define  cd_mat_orient       116

/* #  define  cd_rpmatrix         120 */

# define  cd_new_axis         151
# define  cd_new_box          152
# define  cd_free_box         153
# define  cd_free_all_box     154
# define  cd_set_values       155
# define  cd_get_values       156

# define  cd_box_info         157
# define  cd_easy_box         158

# define  cd_plot_axis        161
# define  cd_plot_box         162
# define  cd_open_box         163
# define  cd_close_box        164
# define  cd_box_to_cm        165
# define  cd_cm_to_box        166

# define  cd_dialog           201
# define  cd_zoom             202
# define  cd_scale            203
# define  cd_reload           204
# define  cd_refresh          205
# define  cd_grid             206
# define  cd_print            207


/* DRAW Server cd_mplot flag bits definitions */

/* Flag of cd_plot directive :
     cdf_ST           Start Point Block,
     cdf_ND           End Point Block,
     cdf_3D           Block of 3D point,
     cdf_AB           Block of matrix relative coordinates,
     cdf_NRM          Normal Vectors must be generated (Only active for 3D Triangle/quad/polygone),
     cdf_UNMR         Normal vectors are given by the user (when set cdf_NRM is disabled).
*/

# define  cdf_ST                1
# define  cdf_ND                2
# define  cdf_3D                4
# define  cdf_AB                8
# define  cdf_NRM              16
# define  cdf_UNRM            128

# define  cdf_3DMSK         (cdf_3D|cdf_NRM|cdf_UNRM)

# define  cdf_STND          (cdf_ST|cdf_ND)
# define  cdf_3DST          (cdf_3DMSK|cdf_ST)
# define  cdf_3DND          (cdf_3DMSK|cdf_ND)
# define  cdf_3DSTND        (cdf_3DMSK|cdf_ST|cdf_ND)

#endif
