/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                     (Multi-Language Support)                       *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */


void DRW_API( end )();



/*********************************************************************/
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*         Three kind of Procedure names :                           */
/*                                                                   */
/*       1/  API form (Directly Callable by Fortran)                 */
/*                all parameter are passed by reference.             */
/*                                                                   */
/*       2/  Draw_<name> form (C compatible form).                   */
/*                                                                   */
/*       3/  Draw__<name> form (Intermediary C compatible form).     */
/*                Used as intermediary between the dedicated         */
/*                language procedures for special parameter          */
/*                management.                                        */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*********************************************************************/



void Draw_Pic_View( Char flags )
{ /* To Set the "Time Of Fly Display mode */
  Sdrw_Put_Code( cd_pic_view );
  Sdrw_Put_Char( flags );
  Sdrw_Server_Request();
} /* Draw_Pic_View */


/*********************************************************************/

void Draw_Pic_Reset( Char flags )
{ /* To clear the "Time Of Fly" Display mode */
  Sdrw_Put_Code( cd_pic_reset );
  Sdrw_Put_Char( flags );
  Sdrw_Server_Request();
} /* Draw_Pic_Reset */


/*********************************************************************/

void DRW_API( clipbox )( float *limits, Char *md )
{ /* To set or clear a clipping box */
  int i;

  if (md)
  {
    Sdrw_Put_Code( cd_clipon );
    for (i = 0; i < 24; i++) if (limits) Sdrw_Put_Float( limits[i] );
                                    else Sdrw_Put_Float( 0.0 );
    for (i = 0; i <  3; i++) Sdrw_Put_Char( md[i] );
  }
  else
    Sdrw_Put_Code( cd_clipoff );
  Sdrw_Server_Request();
} /* draw_clipbox */



/*********************************************************************/

void Draw_View( float dist )
{ /* Set a distance of view for perspective */
  Sdrw_Put_Code( cd_view );
  Sdrw_Put_Float( dist );
  Sdrw_Server_Request();
} /* Draw_View */


/*********************************************************************/

int  Draw_Alpha_Set( int flg )
{
  Sdrw_Put_Code( cd_alpha_set );
  Sdrw_Put_Int( flg );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
}


/*********************************************************************/

int  Draw_Light_OnOff( int light, int flg )
{
  Sdrw_Put_Code( cd_light_set );
  Sdrw_Put_Int( light );
  Sdrw_Put_Int( flg );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
}


/*********************************************************************/

void Draw_Light_Define( int light, int knd, float* prm, int nprm )
{ /* Define the light(s) Characteristic */
  int i;

  Sdrw_Put_Code( cd_light_def );
  Sdrw_Put_Int( light );
  Sdrw_Put_Int( knd );
  if (nprm > 4) nprm = 4;
  for (i = 0; i < nprm; i++) Sdrw_Put_Float( prm[i] ); /* Light Parameter */
  Sdrw_Server_Request();
}


/*********************************************************************/

void Draw_Mat_Light_Prop( int face, int knd, float* prm, int nprm )
{ /* Define material properties for ligting */
  int i;

  Sdrw_Put_Code( cd_matp_light );
  Sdrw_Put_Int( face );
  Sdrw_Put_Int( knd );
  if (nprm > 4) nprm = 4;
  for (i = 0; i < nprm; i++) Sdrw_Put_Float( prm[i] );
  Sdrw_Server_Request();
}


/*********************************************************************/

void DRW_API( zoom )()
{ /* Performs a Zoom */
  Sdrw_Put_Code( cd_zoom );
  Sdrw_Server_Request();
  Sdrw_Connection_Release();  /* Wait for server exit */
} /* draw_zoom */



/*********************************************************************/

void DRW_API( scale )()
{ /* Performs a Scale Change */
  Sdrw_Put_Code( cd_scale );
  Sdrw_Server_Request();
} /* draw_scale */



/*********************************************************************/

void Draw_Reload( Char flg )
{ /* Perform a Reload Original image */
  Sdrw_Put_Code( cd_reload );
  Sdrw_Put_Char( flg );
  Sdrw_Server_Request();
} /* Draw_Reload */



/*********************************************************************/

void DRW_API( refresh )()
{ /* Perform a Refresh of the image */
  Sdrw_Put_Code( cd_refresh );
  Sdrw_Server_Request();
} /* draw_refresh */



/*********************************************************************/

void Draw_Grid( Char flg )
{ /* Perform a Set/Clear (for flg=1/0) the Grid */
  Sdrw_Put_Code( cd_grid );
  Sdrw_Put_Char( flg );
  Sdrw_Server_Request();
} /* Draw_Grid */



/*********************************************************************/

void DRW_API( print )()
{ /* Plot/Print Draw */
  Sdrw_Put_Code( cd_print );
  Sdrw_Server_Request();
} /* draw_print */



/****************************    E N D    ****************************/

