(*

**********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                P A S C A L (C P A S)   M O D U L E                 *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                    (Pascal Adaptation Support)                     *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
**********************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*)

%pragma code_option c_code '#include <draw/draw_apientry.h>';
module DRAW$PASCAL_CONTROL;


type
  Dfloat = single;
  Dint   = cc__int;
  Dbool  = boolean;



{*********************************************************************}


procedure Draw$$Set_Axis_Value( ia, cd, n: Dint; p1, p2, p3, p4, p5, p6, p7: $wild_pointer := nil );
external 'Draw__Set_Axis_Value';



function  Draw$$Get_Axis_Value( ia, cd, n: Dint; p1, p2, p3, p4, p5, p6, p7: $wild_pointer := nil ): Dint;
external 'Draw__Get_Axis_Value';


[global 'Draw_Set_Axis_Ticks']
procedure Draw$Set_Axis_Ticks( ia, n, k: Dint; in_var tfre: array[$sf:Dint] of Dint;
                                               in_var tknd: array[$sk:Dint] of Dint;
                                               in_var tsiz: array[$sl:Dint] of Dfloat );
var
  nv: record case boolean of
    true: ( niv: Dint);
    false:( npt: ^float);
  end;

begin
  if k > $sf then k := $sf;
  if k > $sk then k := $sk;
  if k > $sl then k := $sl;
  nv.niv := n;
  Draw$$Set_Axis_Value( ia, 1, k, nv.npt, tfre"address, tknd"address, tsiz"address );
end Draw$Set_Axis_Ticks;


[global 'Draw_Get_Axis_Ticks']
function  Draw$Get_Axis_Ticks( ia: Dint; var n: [optional] Dint; k: Dint;
                                               var tfre: array[$sf:Dint] of Dint;
                                               var tknd: array[$sk:Dint] of Dint;
                                               var tsiz: array[$sl:Dint] of Dfloat ): Dint;
var
  nv: record case boolean of
    true: ( niv: Dint);
    false:( npt: ^float);
  end;

begin
  if n > $sf then k := $sf;
  if n > $sk then k := $sk;
  if n > $sl then k := $sl;

  Draw$Get_Axis_Ticks :=
         Draw$$Get_Axis_Value( ia, 1, n, nv.npt, tfre"address, tknd"address, tsiz"address );
  if n"address <> nil then n := nv.niv;
end Draw$Get_Axis_Ticks;


[global 'Draw_Set_Axis_Unit']
procedure Draw$Set_Axis_Unit( ia: Dint; in_var unit: string );
begin
  Draw$$Set_Axis_Value( ia, 3, unit.length, unit.body"address );
end Draw$Set_Axis_Unit;


[global 'Draw_Get_Axis_Unit']
function  Draw$Get_Axis_Unit( ia: Dint; var unit: string ): Dint;
var
  dim: Dint;
begin
  dim := Draw$$Get_Axis_Value( ia, 3, unit.capacity - 1, unit.body"address );
  if dim >= unit.capacity then unit.length := unit.capacity - 1
                          else unit.length := dim;
  Draw$Get_Axis_Unit := dim
end Draw$Get_Axis_Unit;


[global 'Draw_Set_Axis_Flags']
procedure Draw$Set_Axis_Flags( ia, flg: Dint );

begin
  Draw$$Set_Axis_Value( ia, 0, flg )
end Draw$Set_Axis_Flags;


[global 'Draw_Get_Axis_Flags']
function  Draw$Get_Axis_Flags( ia: Dint ): Dint;
begin
  Draw$Get_Axis_Flags := Draw$$Get_Axis_Value( ia, 0, 0 )
end Draw$Get_Axis_Flags;


function  Draw$$Easy_Box_2D( ox, oy, sx, sy: Dfloat;
                             pmm, pux, puy: $wild_pointer; lx, ly, ns: Dint ): Dint;
external 'Draw__Easy_Box_2D';


[global 'Draw_Easy_Box_2D']
function Draw$Easy_Box_2D( ox, oy, sx, sy, mx1, mx2, my1, my2: Dfloat;
                           in_var ux, uy: [optional] string; ns: Dint := 0 ): Dint;
var
  mm: array[1..4] of Dfloat;
  px, py: $wild_pointer;
  lx, ly: Dint;

begin
  mm[1] := mx1; mm[2] := mx2; mm[3] := my1; mm[4] := my2;
  if ux"address <> nil then begin  px := ux.body"address; lx := ux.length  end
                       else begin  px := nil; lx := 0 end;
  if uy"address <> nil then begin  py := uy.body"address; ly := uy.length  end
                       else begin  py := nil; ly := 0 end;

  Draw$Easy_Box_2D := Draw$$Easy_Box_2D( ox, oy, sx, sy, mm"address, px, py, lx, ly, ns )
end Draw$Easy_Box_2D;


function  Draw$$Get_Box_Value( box, cd, n: Dint; ptb: $Wild_Pointer ): Dint;
external 'Draw__Get_Box_Value';

[global 'Draw_Get_Box_Value']
function  Draw$Get_Box_Value( box, cd: Dint; var itb: array[n: Dint] of Dint ): Dint;
begin
  Draw$Get_Box_Value := Draw$$Get_Box_Value( box, cd, n, itb"address )
end Draw$Get_Box_Value;


{*********************************************************************}



end.
