/*  P A S - P. WOLFERS SOFTWARE: V2.0-4 OF 15-OCT-2006 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 224 ) = {
 12,  12, 100, 114,  97, 119,  36, 109, 101, 115, 115,  97, 103, 101,  65,  65,
 47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111,
102, 116,  47, 102, 108, 116, 107,  95, 115, 101, 114, 118, 101, 114,  47,  68,
114,  97, 119,  95,  76, 105,  98, 114,  97, 114, 121,  47, 100, 114,  97, 119,
108, 105,  98,  95, 112,  97, 115,  95, 105, 110, 112, 117, 116,  46, 112,  97,
115,  15,  15, 100, 114,  97, 119,  36, 103, 101, 116,  95,  99, 104, 111, 105,
 99, 101,  15,  15, 100, 114,  97, 119,  36, 103, 101, 116,  95,  99, 104, 111,
105,  99, 101,  15,  15, 100, 114,  97, 119,  36, 103, 101, 116,  95,  99, 104,
111, 105,  99, 101,  16,  16, 100, 114,  97, 119,  36, 103, 101, 116,  95,  97,
110, 115, 119, 101, 114, 100,  15,  15, 100, 114,  97, 119,  36, 103, 101, 116,
 95, 115, 116, 114, 105, 110, 103,  16,  16, 100, 114,  97, 119,  36, 115, 101,
108, 101,  99, 116,  95, 102, 105, 108, 101,  16,  16, 100, 114,  97, 119,  36,
115, 101, 108, 101,  99, 116,  95, 102, 105, 108, 101,  14,  14, 100, 114,  97,
119,  36, 103, 101, 116,  95, 118,  97, 108, 117, 101,   0,   0,   0,   0,   0
};


/* Function/procedure prototypes. */
void DRW_API( _message )(V F_pt, SL *F_l);
SL DRW_API( _get_choice )(SL *F_len, V F_ptstb, V F_ptsln);
SL DRW_API( _get_answerd )(V F_pt, SL *F_len);
SL DRW_API( _get_string )(V F_pti, SL *F_lti, V F_pdf, SL *F_ldf, V F_pva, SL *F_cap)
;
SL DRW_API( _select_file )(V F_pti, SL *F_lti, V F_pfs, V F_pfl, SL *F_len, SL *
F_fdx, V F_pdf, SL *F_ldf, V F_res, SL *F_rec, SL *F_wf);
SL DRW_API( _get_value )(V F_pti, SL *F_lti, F *F_val, F *F_lw, F *F_up);


/* Procedure/Function : " draw_Message "  */
void Draw_Pas_Message(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=83; /* line # 83 */
  Rv0=((UB *)F_str)[1];
  DRW_API( _message )(F_str+2,&Rv0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Get_choice "  */
SL Draw_Pas_Get_Str_Choice(V F_title, V F_menu, SL F_dim, SL F_nsz){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+81;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=105; /* line # 105 */
  Ra.v[4]=F_title+2;
  Ra.sl[37]=((UB *)F_title)[1];
  if (F_dim>32) Rv0=32;
  else Rv0=F_dim;
  if (F_nsz>0&&F_nsz<Rv0) Rv0=F_nsz;
  Ra.sl[3]=110; /* line # 110 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Rv2=((V *)F_menu)[Rv1-1];
    Ra.v[Rv1+4]=Rv2+2;
    Ra.sl[Rv1+37]=((UB *)Rv2)[1];
    Rv1++;
  }
  Ra.sl[3]=116; /* line # 116 */
  Ret=DRW_API( _get_choice )(&Rv0, Ra.s+16,Ra.s+148);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_choice "  */
SL Draw_Pas_Get_Arr_Choice(V F_title, V F_menu, SL F_dim, SL F_cap, SL F_nsz){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+98;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=132; /* line # 132 */
  Ra.v[4]=F_title+2;
  Ra.sl[37]=((UB *)F_title)[1];
  if (F_dim>32) Rv0=32;
  else Rv0=F_dim;
  if (F_nsz>0&&F_nsz<Rv0) Rv0=F_nsz;
  Ra.sl[3]=137; /* line # 137 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Ra.v[Rv1+4]=(((C *)F_menu)+(Rv1-1)*F_cap+1);
    Ra.sl[Rv1+37]=(SL)((C *)F_menu)[(Rv1-1)*F_cap];
    Rv1++;
  }
  Ra.sl[3]=142; /* line # 142 */
  Ret=DRW_API( _get_choice )(&Rv0, Ra.s+16,Ra.s+148);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_choice "  */
SL Draw_Pas_Get_M_Choice(V F_title, V F_menu, SL F_nsz){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+115;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=156; /* line # 156 */
  Ra.v[4]=F_title+2;
  Ra.sl[37]=((UB *)F_title)[1];
  if (((UB *)F_menu)[0]>32) Rv0=32;
  else Rv0=((UB *)F_menu)[0];
  if (F_nsz>0&&F_nsz<Rv0) Rv0=F_nsz;
  Ra.sl[3]=161; /* line # 161 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Rv2=(((S *)F_menu)+(Rv1-1)*((SL)((UB *)F_menu)[1]+2)+2);
    Ra.v[Rv1+4]=Rv2+2;
    Ra.sl[Rv1+37]=((UB *)Rv2)[1];
    Rv1++;
  }
  Ra.sl[3]=167; /* line # 167 */
  Ret=DRW_API( _get_choice )(&Rv0, Ra.s+16,Ra.s+148);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_answerd "  */
SL Draw_Pas_Get_Answerd(V F_title){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+132;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=184; /* line # 184 */
  Rv0=((UB *)F_title)[1];
  Ret=DRW_API( _get_answerd )(F_title+2,&Rv0);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_string "  */
SL Draw_Pas_Get_String(V F_title, V F_defst, V F_resul){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+150;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=203; /* line # 203 */
  Rv0=((UB *)F_title)[1];
  Rv1=((UB *)F_defst)[1];
  Rv2=((UB *)F_resul)[0];
  ((UB *)F_resul)[1]=DRW_API( _get_string )(F_title+2,&Rv0, F_defst+2,&Rv1, F_resul+
2,&Rv2);
  Ra.sl[3]=209; /* line # 209 */
  Ret=((UB *)F_resul)[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Select_file "  */
SL Draw_Pas_Select_File(V F_title, V F_filtr, SL F_dim, V F_defst, V F_resul, SL
*F_flidx, SL F_nwflg, SL F_nszfl){
  /* Define the automatic variable space. */
  Blk( Ra, 272 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+167;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=238; /* line # 238 */
  if (F_dim>32) Rv0=32;
  else Rv0=F_dim;
  Rv1=((UB *)F_title)[1];
  Rv2=((UB *)F_resul)[0];
  Rv3=((UB *)F_defst)[1];
  Ra.sl[3]=243; /* line # 243 */
  if (F_nszfl>0&&F_nszfl<Rv0) Rv0=F_nszfl;
  Rv4=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Rv5=((V *)F_filtr)[Rv4-1];
    Ra.v[Rv4+3]=Rv5+2;
    Ra.sl[3]=248; /* line # 248 */
    Ra.sl[Rv4+35]=((UB *)Rv5)[1];
    Rv4++;
  }
  Rv6=(*F_flidx)-1;
  if (Rv6<0||Rv6>=Rv0) Rv6=0;
  Ra.sl[3]=253; /* line # 253 */
  ((UB *)F_resul)[1]=DRW_API( _select_file )(F_title+2,&Rv1, Ra.s+16,Ra.s+144,&Rv0,
  &Rv6, F_defst+2,&Rv3, F_resul+2,&Rv2, &F_nwflg);
  Ra.sl[3]=258; /* line # 258 */
  (*F_flidx)=Rv6+1;
  Ret=((UB *)F_resul)[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Select_file "  */
SL Draw_Pas_Select_MFile(V F_title, V F_filtr, V F_defst, V F_resul, SL *F_flidx
, SL F_nwflg, SL F_nszfl){
  /* Define the automatic variable space. */
  Blk( Ra, 272 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+185;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=278; /* line # 278 */
  if (((UB *)F_filtr)[0]>32) Rv0=32;
  else Rv0=((UB *)F_filtr)[0];
  Rv1=((UB *)F_title)[1];
  Rv2=((UB *)F_resul)[0];
  Rv3=((UB *)F_defst)[1];
  Ra.sl[3]=283; /* line # 283 */
  if (F_nszfl>0&&F_nszfl<Rv0) Rv0=F_nszfl;
  Rv4=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Rv5=(((S *)F_filtr)+(Rv4-1)*((SL)((UB *)F_filtr)[1]+2)+2);
    Ra.v[Rv4+3]=Rv5+2;
    Ra.sl[3]=288; /* line # 288 */
    Ra.sl[Rv4+35]=((UB *)Rv5)[1];
    Rv4++;
  }
  Rv6=(*F_flidx)-1;
  if (Rv6<0||Rv6>=Rv0) Rv6=0;
  Ra.sl[3]=293; /* line # 293 */
  ((UB *)F_resul)[1]=DRW_API( _select_file )(F_title+2,&Rv1, Ra.s+16,Ra.s+144,&Rv0,
  &Rv6, F_defst+2,&Rv3, F_resul+2,&Rv2, &F_nwflg);
  Ra.sl[3]=298; /* line # 298 */
  (*F_flidx)=Rv6+1;
  Ret=((UB *)F_resul)[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_value "  */
SL Draw_Pas_Get_Value(V F_title, F *F_val, F F_lwlim, F F_uplim){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  F Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+203;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=319; /* line # 319 */
  Rv0=((UB *)F_title)[1];
  Rv1=F_lwlim;
  Rv2=F_uplim;
  Ret=DRW_API( _get_value )(F_title+2,&Rv0, F_val,&Rv1, &Rv2);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
