(*

**********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                P A S C A L (C P A S)   M O D U L E                 *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                    (Pascal Adaptation Support)                     *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
**********************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*)

%pragma code_option c_code '#include <draw/draw_apientry.h>';
module DRAW$PASCAL_CONTROL;


const
  raster = 0;
  centimeter = 1;

  pi		 = (4.0*ARCTAN(1.0));
  fac_rad	 = (pi/180.0);

  max_menu   = 64;                        { 64 entries Max / menu }



type
  Dfloat = single;
  Dint   = cc__int;
  Dbool  = boolean;
  Dpoint3 = array[1..3] of Dfloat;



{*********************************************************************}

procedure DRAW__SET_MENU_SPC( cd, id: Dint; name: $wild_pointer; len: Dint );
external 'Draw__Set_Menu_Spc';


[global 'Draw_Pas_Set_Menu_Spc']
procedure DRAW$SET_MENU_SPC( cd: Dint; in_var name: [optional] string; id: Dint := -1 );
begin
  if name"address = nil then DRAW__SET_MENU_SPC( cd, id, nil, 0 )
                        else DRAW__SET_MENU_SPC( cd, id, name.body[1]"address, name.length );
end DRAW$SET_MENU_SPC;



{*********************************************************************}

procedure draw__init( var x_paper, y_paper: Dfloat;
                      var             unit:  byte;
                          pt: $wild_pointer; len: Dint );
external 'Draw__Init';


[global 'Draw_Pas_Init']
procedure DRAW$INIT( var x_p, y_p: Dfloat; var unit: byte;
                     in_var usrid: [optional] string );
var
  len: Dint;

begin
  if usrid"address = nil then
    draw__init( x_p, y_p, unit, nil, 0 )
  else
  begin
    len := usrid.length;
    draw__init( x_p, y_p, unit, usrid.body[1]"address, len )
  end
end Draw$Init;



[global 'Draw_Get_Server_Name']
procedure DRAW$GET_SERVER_NAME( var s: string );
type
  buf = array[1..255] of char;

var
  len: integer;
  [external 'Draw_Srv_Name'] cst: ^buf;
  [external 'Draw_Srv_NameLength'] nln: integer;

begin
  len := nln;
  if len > s.capacity then len := s.capacity;
  for i := 1 to len do s[i] := cst^[i];
  s.length := len
end DRAW$GET_SERVER_NAME;



{*********************************************************************}

function  draw__picture( pt: $wild_pointer; len: Dint;
                         x, y, z: Dfloat;
                         sca, marg: byte ): byte;
external 'Draw__Picture';


[global 'Draw_Pas_Picture']
function Draw$Picture( in_var title    : string;
                              x_s, y_s : Dfloat;
                              sca, marg: Dbool ): Dbool;
begin
  Draw$Picture := draw__picture( title.body"address, title.length,
                                 x_s, y_s, 0.0, ORD( sca ), ORD( marg ) ) = 1
end Draw$Picture;


[global 'Draw_Pas_Picture_3D']
function Draw$Picture_3D( in_var title    : string;
                            x_s, y_s, z_s : Dfloat;
                                 sca, marg: Dbool ): Dbool;
begin
  Draw$Picture_3D := draw__picture( title.body"address, title.length,
                                    x_s, y_s, z_s, ORD( sca ), ORD( marg ) ) = 1
end Draw$Picture_3D;



{*********************************************************************}

procedure draw_send_block( pt: $wild_pointer );
external 'Draw_Send_Block';

[global 'Draw_Pas_Send_Block']
procedure Draw_Send_Block( in_var pt: array[sz: Dint] of Dfloat );
begin
  draw_send_block( pt[1]"address )
end Draw_Send_Block;



{*********************************************************************}

procedure draw_mplot( dim: Dint; pt: $wild_pointer; flag: Dint );
external 'Draw_Mplot';

[global 'Draw_Pas_Mplot']
procedure Draw$Mplot( in_var   pt: array[sz: Dint] of Dfloat;
                              dim: Dint := 0;
                             flag: Dint := 3 );
type
  btn  = (b_00, b_01, b_3D, b_NV, b_04, b_05, b_06, b_07, b_08, b_09, b_10, b_11, b_12, b_13, b_14, b_15,
          b_16, b_17, b_18, b_19, b_20, b_21, b_22, b_23, b_24, b_25, b_26, b_27, b_28, b_29, b_30, b_31 );
  svty = set of btn;

var
  asz: integer;
  eqf: record case boolean of
         false:( iv: integer);
         true: ( sv: svty)
       end;

begin
  eqf.iv := flag;
  if b_3D in eqf.sv then asz := sz div 3     { 3D mode }
                    else asz := sz div 2;    { 2D mode }
  if b_NV in eqf.sv then asz := asz div 2;   { When the Normal Vectors are given by the user }
  if (dim > asz) or (dim <= 0) then dim := asz;
  draw_mplot( dim, pt[1]"address, flag )
end Draw$Mplot;



{*********************************************************************}

procedure draw__string( x, y, th, hgt: Dfloat;
                        s: $Wild_pointer; len, oflg: Dint );
external 'Draw__String';

[global 'Draw_Pas_String']
procedure Draw$String( x, y, th, hgt: Dfloat; in_var str: string; oflg: Dint := 0 );
begin
  draw__string( x, y, th, hgt, str.body"address, str.length, oflg )
end Draw$String;



{*********************************************************************}

procedure draw_surface( nraw, ncol, ofl: Dint; vtbp: $Wild_pointer );
external 'Draw_Surface';

[global 'Draw_Pas_Surface']
procedure Draw$Surface( in_var vtb: array[nraw: integer, ncol: integer] of DPoint3; oflg: Dint := 0 );
begin
  draw_surface( nraw, ncol, oflg, vtb[1]"address )
end Draw$Surface;


[global 'Draw_Pas_SurfaceA']
procedure Draw$Surface( nraw, ncol, oflg: Dint := 0 );
begin
  draw_surface( nraw, ncol, oflg, nil )
end Draw$Surface;





{*********************************************************************}

procedure draw_surface2( nraw, ncol, ofl: Dint; xo, yo, xs, ys: Dfloat; vtbp: $Wild_pointer );
external 'Draw_Surface2';

[global 'Draw_Pas_Surface2']
procedure Draw$Surface2( in_var vtb: array[nraw: integer, ncol: integer] of Dfloat; xo, yo, xs, ys: Dfloat; oflg: Dint := 0 );
begin
  draw_surface2( nraw, ncol, oflg, xo, yo, xs, ys, vtb[1]"address )
end Draw$Surface2;


[global 'Draw_Pas_Surface2A']
procedure Draw$Surface2( nraw, ncol, oflg: Dint := 0; xo, yo, xs, ys: Dfloat );
begin
  draw_surface2( nraw, ncol, oflg, xo, yo, xs, ys, nil )
end Draw$Surface2;





{*********************************************************************}

procedure draw_polyhedral( nfc, nvt, ofl: Dint; ftbp, vtbp: $Wild_pointer );
external 'Draw_Polyhedral';

[global 'Draw_Pas_Polyhedral']
procedure Draw$Polyhedral( in_var ftb: array[nfc: integer] of Dint;
                           in_var vtb: array[nvt: integer] of Dfloat; oflg: Dint := 0 );
begin
  draw_polyhedral( nfc, nvt, oflg, ftb[1]"address, vtb[1]"address )
end Draw$Polyhedral;




{*********************************************************************}



end.
