/*  P A S - P. WOLFERS SOFTWARE: V2.0-4 OF 15-OCT-2006 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 272 ) = {
 17,  17, 100, 114,  97, 119,  36, 115, 101, 116,  95, 109, 101, 110, 117,  95,
115, 112,  99,  67,  67,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101,
114, 115,  47,  83, 111, 102, 116,  47, 102, 108, 116, 107,  95, 115, 101, 114,
118, 101, 114,  47,  68, 114,  97, 119,  95,  76, 105,  98, 114,  97, 114, 121,
 47, 100, 114,  97, 119, 108, 105,  98,  95, 112,  97, 115,  95,  99, 111, 110,
116, 114, 111, 108,  46, 112,  97, 115,   9,   9, 100, 114,  97, 119,  36, 105,
110, 105, 116,  20,  20, 100, 114,  97, 119,  36, 103, 101, 116,  95, 115, 101,
114, 118, 101, 114,  95, 110,  97, 109, 101,  12,  12, 100, 114,  97, 119,  36,
112, 105,  99, 116, 117, 114, 101,  15,  15, 100, 114,  97, 119,  36, 112, 105,
 99, 116, 117, 114, 101,  95,  51, 100,  15,  15, 100, 114,  97, 119,  95, 115,
101, 110, 100,  95,  98, 108, 111,  99, 107,  10,  10, 100, 114,  97, 119,  36,
109, 112, 108, 111, 116,  11,  11, 100, 114,  97, 119,  36, 115, 116, 114, 105,
110, 103,  12,  12, 100, 114,  97, 119,  36, 115, 117, 114, 102,  97,  99, 101,
 12,  12, 100, 114,  97, 119,  36, 115, 117, 114, 102,  97,  99, 101,  13,  13,
100, 114,  97, 119,  36, 115, 117, 114, 102,  97,  99, 101,  50,  13,  13, 100,
114,  97, 119,  36, 115, 117, 114, 102,  97,  99, 101,  50,  15,  15, 100, 114,
 97, 119,  36, 112, 111, 108, 121, 104, 101, 100, 114,  97, 108,   0,   0,   0
};

/* Declaration of external variables. */
extern SL Draw_Srv_NameLength;
extern V Draw_Srv_Name;


/* Function/procedure prototypes. */
void Draw__Set_Menu_Spc(SL F_cd, SL F_id, V F_name, SL F_len);
void Draw__Init(F *F_x_paper, F *F_y_paper, UB *F_unit, V F_pt, SL F_len);
UB Draw__Picture(V F_pt, SL F_len, F F_x, F F_y, F F_z, UB F_sca, UB F_marg);
void Draw_Send_Block(V F_pt);
void Draw_Mplot(SL F_dim, V F_pt, SL F_flag);
void Draw__String(F F_x, F F_y, F F_th, F F_hgt, V F_s, SL F_len, SL F_oflg);
void Draw_Surface(SL F_nraw, SL F_ncol, SL F_ofl, V F_vtbp);
void Draw_Surface2(SL F_nraw, SL F_ncol, SL F_ofl, F F_xo, F F_yo, F F_xs, F F_ys
, V F_vtbp);
void Draw_Polyhedral(SL F_nfc, SL F_nvt, SL F_ofl, V F_ftbp, V F_vtbp);


/* Procedure/Function : " draw_Set_menu_spc "  */
void Draw_Pas_Set_Menu_Spc(SL F_cd, V F_name, SL F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=88; /* line # 88 */
  if (F_name==NULL) Draw__Set_Menu_Spc(F_cd, F_id,NULL,0);
  else Draw__Set_Menu_Spc(F_cd, F_id, (V)F_name+2,((UB *)F_name)[1]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Init "  */
void Draw_Pas_Init(F *F_x_p, F *F_y_p, UB *F_unit, V F_usrid){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+88;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=109; /* line # 109 */
  if (F_usrid==NULL) Draw__Init(F_x_p,F_y_p,F_unit,NULL,0);
  else {
    Rv0=((UB *)F_usrid)[1];
    Ra.sl[3]=114; /* line # 114 */
    Draw__Init(F_x_p,F_y_p,F_unit,(V)F_usrid+2,Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Get_server_name "  */
void Draw_Get_Server_Name(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+99;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=131; /* line # 131 */
  Rv0=Draw_Srv_NameLength;
  if (Rv0>((UB *)F_s)[0]) Rv0=((UB *)F_s)[0];
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)F_s)[Rv1+1]=((C *)Draw_Srv_Name)[Rv1-1];
    Rv1++;
  }
  ((UB *)F_s)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Picture "  */
UB Draw_Pas_Picture(V F_title, F F_x_s, F F_y_s, UB F_sca, UB F_marg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+121;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=152; /* line # 152 */
  Ret=Draw__Picture(F_title+2,((UB *)F_title)[1],F_x_s, F_y_s, (F)0.000000E-01,(
  SL)F_sca,(SL)F_marg)==1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Picture_3d "  */
UB Draw_Pas_Picture_3D(V F_title, F F_x_s, F F_y_s, F F_z_s, UB F_sca, UB F_marg)
{
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+135;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=162; /* line # 162 */
  Ret=Draw__Picture(F_title+2,((UB *)F_title)[1],F_x_s, F_y_s, F_z_s,(SL)F_sca,(
  SL)F_marg)==1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_send_block "  */
void Draw_Pas_Send_Block(V F_pt, SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+152;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=176; /* line # 176 */
  Draw_Send_Block((V)F_pt);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Mplot "  */
void Draw_Pas_Mplot(V F_pt, SL F_sz, SL F_dim, SL F_flag){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+169;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=203; /* line # 203 */
  Ra.sl[4]=F_flag;
  if (4&Ra.ul[4]) Rv0=F_sz/3;
  else Rv0=F_sz/2;
  if (8&Ra.ul[4]) Rv0=Rv0/2;
  if (F_dim>Rv0||F_dim<=0) F_dim=Rv0;
  Ra.sl[3]=208; /* line # 208 */
  Draw_Mplot(F_dim, (V)F_pt,F_flag);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_String "  */
void Draw_Pas_String(F F_x, F F_y, F F_th, F F_hgt, V F_str, SL F_oflg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+181;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=222; /* line # 222 */
  Draw__String(F_x, F_y, F_th, F_hgt, F_str+2,((UB *)F_str)[1],F_oflg);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Surface "  */
void Draw_Pas_Surface(V F_vtb, SL F_nraw, SL F_ncol, SL F_oflg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+194;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=235; /* line # 235 */
  Draw_Surface(F_nraw, F_ncol, F_oflg,(((S *)F_vtb)+0*(F_ncol*12+3&~3)));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Surface "  */
void Draw_Pas_SurfaceA(SL F_nraw, SL F_ncol, SL F_oflg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+208;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=242; /* line # 242 */
  Draw_Surface(F_nraw, F_ncol, F_oflg,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Surface2 "  */
void Draw_Pas_Surface2(V F_vtb, SL F_nraw, SL F_ncol, F F_xo, F F_yo, F F_xs, F F_ys
, SL F_oflg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+222;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=257; /* line # 257 */
  Draw_Surface2(F_nraw, F_ncol, F_oflg, F_xo, F_yo, F_xs, F_ys,(((S *)F_vtb)+0*(
  F_ncol*4+3&~3)));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Surface2 "  */
void Draw_Pas_Surface2A(SL F_nraw, SL F_ncol, SL F_oflg, F F_xo, F F_yo, F F_xs, 
F F_ys){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+237;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=264; /* line # 264 */
  Draw_Surface2(F_nraw, F_ncol, F_oflg, F_xo, F_yo, F_xs, F_ys,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Polyhedral "  */
void Draw_Pas_Polyhedral(V F_ftb, SL F_nfc, V F_vtb, SL F_nvt, SL F_oflg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+252;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=280; /* line # 280 */
  Draw_Polyhedral(F_nfc, F_nvt, F_oflg, (V)F_ftb,(V)F_vtb);
  PAS__curr_cntx=Ra.v[0];
}
