/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*              (Additional Control Graphic Directives)               *
*                     (Multi-Language Support)                       *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/



#define  _DRAWLIB_L4BASE_  0    /* Set the L4 Base Mode of L4 Declaration */

#include <draw/draw_common.h>
#include <draw/draw_l4env.h>    /* load the DRAW L4 Library environment */


extern int   Plt_Idx,           /* Filling index of Draw_plot point table */
             Plt_Cnt,           /* Vertex/Dot Plot Count */
             Plt_Lnk;           /* Link Flag for large Curve tracing */

extern float Plt_Tab[PLOT_TAB_LEN]; /* Draw_Plot table */



#define _LOGMAX_  5





/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//           Routines for local reference 2D/3D axis box               //
//                                                                     //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




int Draw_New_Axis( Draw_Point3 u_axis, Draw_Point3 v_axis,
                   float       length, float         vinf,
                   float         vsup, int           ntck, int          flags )
{ /* Create a New Axis Record and return its Identifier Number */
  int i;

  Sdrw_Put_Code( cd_new_axis );
  for (i = 0; i < 3; i++) Sdrw_Put_Float( u_axis[i] );
  for (i = 0; i < 3; i++) Sdrw_Put_Float( v_axis[i] );
  Sdrw_Put_Float( length );
  Sdrw_Put_Float( vinf );
  Sdrw_Put_Float( vsup );
  Sdrw_Put_Int( ntck );
  Sdrw_Put_Int( flags );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* Draw_New_Axis */


int DRW_API( new_axis )( Draw_Point3 u_axis, Draw_Point3 v_axis,
                         float      *length, float        *vinf,
                         float        *vsup, int          *ntck, int         *flags )
{
  return Draw_New_Axis( u_axis, v_axis, *length, *vinf, *vsup, *ntck, *flags );
} /* draw_new_axis */




int Draw_New_Box( Draw_Point3 org, int ix, int iy, int iz, int dtb[], int dsz,
                                                           float stb[], int nfz,
                                                           int dtbdim, int stbdim )
{
  int i;

  Sdrw_Put_Code( cd_new_box );
  for (i = 0; i < 3; i++) Sdrw_Put_Float( org[i] );
  Sdrw_Put_Int( ix );
  Sdrw_Put_Int( iy );
  Sdrw_Put_Int( iz );
  if ((dtbdim > 0) &&(dtbdim < dsz)) dsz = dtbdim;
  if ((stbdim > 0) &&(stbdim < nfz)) nfz = stbdim;
  Sdrw_Put_Int( dsz );
  for (i = 0; i < dsz; i++) Sdrw_Put_Int( dtb[i] );
  if ((nfz > 0)&&stb) {
    Sdrw_Put_Int( nfz );
    for (i = 0; i < dsz; i++) Sdrw_Put_Float( stb[i] );
  }
  else Sdrw_Put_Int( 0 );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* Draw_New_Box */


int DRW_API( new_box )( Draw_Point3 org, int *ix, int *iy, int *iz,
                        int dtb[], int* dsz, float stb[], int* nfz )
{
  Draw_New_Box( org, *ix, *iy, *iz, dtb, *dsz, stb, *nfz, 0, 0 );
}  /* draw_new_box */



int Draw__Easy_Box_2D( float ox, float oy, float sx, float sy, float* mm,
                       char* ux, char* uy, int  lux, int  luy, int    ns )
{
  int i;

  Sdrw_Put_Code( cd_easy_box );
  Sdrw_Put_Float( ox ); Sdrw_Put_Float( oy );
  Sdrw_Put_Float( sx ); Sdrw_Put_Float( sy );
  for (i = 0; i < 4; i++) Sdrw_Put_Float( mm[i] );
  Sdrw_Put_String( ux, lux ); Sdrw_Put_String( uy, luy );
  Sdrw_Put_Int( ns );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
}


int DRW_API( easy_box_2d )( float *ox, float *oy, float *sx, float *sy, float *mm,
                            char *ux, char *uy, int *lux, int *luy, int *ns )
{
  return Draw_Easy_Box_2D( *ox, *oy, *sx, *sy, mm, ux, uy, *lux, *luy, *ns );
}  /* easy_box_2d */




void Draw_Free_Box( int ib, Char axflg )
{
  int i;

  Sdrw_Put_Code( cd_free_box );
  Sdrw_Put_Int( ib );
  Sdrw_Put_Char( axflg );
  Sdrw_Server_Request();
} /* Draw_Free_Box */


void DRW_API( free_box ) ( int *ib, int *axflg )
{
  Draw_Free_Box( *ib, *axflg );
} /* draw_free_box */




void DRW_API( free_box_list ) ()
{
  Sdrw_Put_Code( cd_free_all_box );
  Sdrw_Server_Request();
} /* draw_free_box_list */




void Draw__Set_Axis_Value( int    ax,             /* Axis Identifier */
                           int    cd,             /* Operator Code */
                           int     n,             /* Length Driver Number */
                           float* p1, float* p2,  /* Pointer to the various parameters */
                           float* p3, float* p4,
                           int*   p5, int*   p6, int*   p7 )
{
  int i, k, i1, i2, ir;
  char*  str;
  int*   itb;
  int*   jtb;
  float* ftb;

  ir = 1;
  Sdrw_Put_Code( cd_set_values );
  Sdrw_Put_Int( ax );
  Sdrw_Put_Int( cd );
  switch (cd) {
    case 0: /* Change the Axis Flags */
      Sdrw_Put_Int( n );
    break;

    case 1: /* Number of ticks and Driven Table of ticks */
      Sdrw_Put_Int( (int) p1 );
      if (n <= 0) Sdrw_Put_Int( n );
      else {
        if (n > 4) n = 4; k = n;
        if (p2) k |= 16;
        if (p3) k |= 32;
        if (p4) k |= 64;
        Sdrw_Put_Int( k );
        for (i = 0; i < n; i++) {
          if (k&16) Sdrw_Put_Int( ((int*) p2)[i] );
          if (k&32) Sdrw_Put_Int( ((int*) p3)[i] );
          if (k&64) Sdrw_Put_Float( p4[i] );
        }
      }
    break;

    case 2: /* Tick Value String Attributs */
      if (!p1) n &= ~ 1;
      if (!p2) n &= ~ 2;
      if (!p3) n &= ~ 4;
      if (!p4) n &= ~ 8;
      if (!p5) n &= ~16;
      if (!p6) n &= ~32;
      if (!p7) n &= ~64;
      Sdrw_Put_Int( n );
      if (n& 1) Sdrw_Put_Float( *p1 );
      if (n& 2) Sdrw_Put_Float( *p2 );
      if (n& 4) Sdrw_Put_Float( *p3 );
      if (n& 8) Sdrw_Put_Float( *p4 );
      if (n&16)   Sdrw_Put_Int( *p5 );
      if (n&32)   Sdrw_Put_Int( *p6 );
      if (n&64)   Sdrw_Put_Int( *p7 );
    break;

    case 3: /* Unit String */
      if (p1) {
        if (n <= 0) n = strlen( (char*) p1 );
        Sdrw_Put_String( (char*) p1, n );
      }
    break;

    case 4: /* Unit String Attributs */
      if (!p1) n &= ~ 1;
      if (!p2) n &= ~ 2;
      if (!p3) n &= ~ 4;
      if (!p4) n &= ~ 8;
      if (!p5) n &= ~16;
      Sdrw_Put_Int( n );
      if (n& 1) Sdrw_Put_Float( *p1 );
      if (n& 2) Sdrw_Put_Float( *p2 );
      if (n& 4) Sdrw_Put_Float( *p3 );
      if (n& 8) Sdrw_Put_Float( *p4 );
      if (n&16)   Sdrw_Put_Int( *p5 );
    break;

    case 5: /* Axis Characteristic 1 */
      if (!p1) n &= ~ 1;
      if (!p2) n &= ~ 2;
      if (!p3) n &= ~ 4;
      Sdrw_Put_Int( n );
      if (n& 1) Sdrw_Put_Float( *p1 );
      if (n& 2) Sdrw_Put_Float( *p2 );
      if (n& 4) Sdrw_Put_Float( *p3 );
    break;

    default: ir = 0;
  }

  if (ir) Sdrw_Server_Request();  
} /* Draw_Set_Axis_Value */



void DRW_API( set_axis_value )( int*   ax, int*   cd, int*    n,
                                float* p1, float* p2, float* p3, float* p4,
                                int*   p5, int*   p6, int*   p7 )
{
  Draw__Set_Axis_Value( *ax, *cd, *n, p1, p2, p3, p4, p5, p6, p7 );
}



int  Draw__Get_Axis_Value( int    ax, int    cd, int     n,
                           float* p1, float* p2, float* p3, float *p4,
                           int*   p5, int*   p6, int*   p7 )
{
  int i, k, ir, i1, i2;
  float   fv;
  char*  str;

  if (n > 0) {
    Sdrw_Put_Code( cd_get_values );
    Sdrw_Put_Int( ax );
    Sdrw_Put_Int( cd );
    Sdrw_Server_Request();

    /* Now we set the user arguments as required */
    switch (cd) {
      case 0: /* Change the Axis Flags */
        ir = Sdrw_Get_Int();
      break;

      case 1: /* Number of ticks and Driven Table of ticks */
        ir = Sdrw_Get_Int();
        if (p1) *((int*)p1) = ir;
        if (n > 4) n = 4;
        for (i = 0; i < 4; i++) {
          i1 = Sdrw_Get_Int();
          i2 = Sdrw_Get_Int();
          fv = Sdrw_Get_Float();
          if (p2&&(i < n)) ((int*) p2)[i] = i1;
          if (p3&&(i < n)) ((int*) p3)[i] = i2;
          if (p4&&(i < n))         p4 [i] = fv;
        }
      break;

      case 2: /* Tick Value String Attributs */
        fv = Sdrw_Get_Float(); if ((n& 1)&&p1) *p1 = fv;
        fv = Sdrw_Get_Float(); if ((n& 2)&&p2) *p2 = fv;
        fv = Sdrw_Get_Float(); if ((n& 4)&&p3) *p3 = fv;
        fv = Sdrw_Get_Float(); if ((n& 8)&&p4) *p4 = fv;
        i1 =   Sdrw_Get_Int(); if ((n&16)&&p5) *p5 = i1;
        i1 =   Sdrw_Get_Int(); if ((n&32)&&p6) *p6 = i1;
        i1 =   Sdrw_Get_Int(); if ((n&64)&&p7) *p7 = i1;
        ir = 0;
      break;

      case 3: /* Unit String */
        if (p1) {
          k = Sdrw_Get_Char();
          if (k >= n) k = n - 1;
          for (i = 0; i < k; i++) ((char*) p1)[i] = Sdrw_Get_Char();
          ir = k;
        }
      break;

      case 4: /* Unit String Attributs */
        fv = Sdrw_Get_Float(); if ((n& 1)&&p1) *p1 = fv;
        fv = Sdrw_Get_Float(); if ((n& 2)&&p2) *p2 = fv;
        fv = Sdrw_Get_Float(); if ((n& 4)&&p3) *p3 = fv;
        fv = Sdrw_Get_Float(); if ((n& 8)&&p4) *p4 = fv;
        i1 =   Sdrw_Get_Int(); if ((n&16)&&p5) *p5 = i1;
        ir = 0;
      break;

      case 5: /* Axis Characteristic 1 */
        fv = Sdrw_Get_Float(); if ((n& 1)&&p1) *p1 = fv;
        fv = Sdrw_Get_Float(); if ((n& 2)&&p2) *p2 = fv;
        fv = Sdrw_Get_Float(); if ((n& 4)&&p3) *p3 = fv;
        ir = 0;
      break;

      case 6: /* Axis Characteristic 2 */
        fv = Sdrw_Get_Float(); if ((n& 1)&&p1) *p1 = fv;
        fv = Sdrw_Get_Float(); if ((n& 2)&&p2) *p2 = fv;
        fv = Sdrw_Get_Float(); if ((n& 4)&&p3) *p3 = fv;
        fv = Sdrw_Get_Float(); if ((n& 8)&&p4) *p4 = fv;
        i1 =   Sdrw_Get_Int(); if ((n&16)&&p5) *p5 = i1;
        i1 =   Sdrw_Get_Int(); if ((n&32)&&p6) *p6 = i1;
        ir = 0;
      break;

      default: ir = -1;
    }
  }
  return ir;  
}



int  DRW_API( get_axis_value )( int*   ax, int*   cd, int*    n,
                                float* p1, float* p2, float* p3, float* p4,
                                int*   p5, int*   p6, int*   p7 )
{
  return Draw__Get_Axis_Value( *ax, *cd, *n, p1, p2, p3, p4, p5, p6, p7 );
}




int  Draw__Get_Box_Value( int box, int cd, int n, void * tb )
{
  int n1, i, k, ir, i1, i2;
  float   fv;
  char*  str;

  if (n > 0) {
    Sdrw_Put_Code( cd_box_info );
    Sdrw_Put_Int( box );
    Sdrw_Put_Int( cd );
    Sdrw_Server_Request();
    n1 = Sdrw_Get_Int();

    /* Now we set the user arguments as required */
    if (n1 > 0)
    switch (cd) {
      case 0: /* Get Axis identifiers */
      case 2: /* Get Box Directive table */
        for (i = 0; i < n1; i++) ((int*)tb)[i] = Sdrw_Get_Int();
        return n1;
      break;

      case 3: /* Get Box Shift table */
        for (i = 0; i < n1; i++) ((float*)tb)[i] = Sdrw_Get_Float();
      break;

      default: n1 = -1;
    }
  }
  return n1;  
}



int  DRW_API( get_box_value )( int *box, int *cd, int *n, void * tb )
{
  return Draw__Get_Box_Value( *box, *cd, *n, tb );
}




void Draw_Plot_Axis( int ia, Draw_Point3 org, int fvl )
{ /* Plot the axis p, with origine at org,
     fvl is a boolean,
     When fvl is a bit set as this:
           1 = AX_VALU    - Ticks values and Unit String will be Displayed.
           2 = AX_TRVM    - The ticks left and right sides are permutted,
           4 = AX_TSYM    - The Ticks must be symmetrized.
     The value of p->axis_flag is a bit set as this :
           1 = AX_LOG     - Axis is in Log10 Coordinate,
           2 = AX_LEFT    - Ticks and displayed value at left position ( else at right ),
           4 = AX_NFRS    - Does not display the first Ticks,
           8 = AX_NFVL    - Does not display the first Value,
          16 = AX_NLST    - Does not display the last Ticks,
          32 = AX_NLVL    - Does not display the last Value,
          64 = AX_NZER    - Does not display the Zero Ticks,
         128 = AX_NZVL    - Does not display the Zero Value,
         256 = AX_ARRO    - Put an arrow at the end of axis,
  */
  int i;

  Sdrw_Put_Code( cd_plot_axis );
  Sdrw_Put_Int( ia );
  Sdrw_Put_Int( fvl );
  for (i = 0; i < 3; i++) Sdrw_Put_Float( org[i] );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Plot_Axis */


void DRW_API( plot_axis )( int *ia, Draw_Point3 org, int *fvl )
{
  Draw_Plot_Axis( *ia, org, *fvl );
}



void Draw_Plot_Box( int ib )
{
  Sdrw_Put_Code( cd_plot_box );
  Sdrw_Put_Int( ib );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
}


void DRW_API( plot_box ) ( int *ib )
{
  Draw_Plot_Box( *ib );
}




void Draw_Open_Box( int ib )
{ /* To select the specified box as the current box */
  Sdrw_Put_Code( cd_open_box );
  Sdrw_Put_Int( ib );
  Sdrw_Server_Request();
}


void DRW_API( open_box ) ( int *ib )
{
  Draw_Open_Box( *ib );
}




void DRW_API( close_box ) ()
{ /* To select the specified box as the current box */
  Sdrw_Put_Code( cd_close_box );
  Sdrw_Server_Request();
}



int  Draw_CV_Box( int flg, float xx, float yy, float zz, float* x, float* y, float* z )
{ /* convert coordinates between Cm and Box coordinates */
  int status;

  if (flg) Sdrw_Put_Code( cd_cm_to_box );
      else Sdrw_Put_Code( cd_box_to_cm );
  Sdrw_Put_Float( xx );
  Sdrw_Put_Float( yy );
  Sdrw_Put_Float( zz );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  if (status >= 0) {
    *x = Sdrw_Get_Float();
    *y = Sdrw_Get_Float();
    *z = Sdrw_Get_Float();
  }
  return status;
}



int  DRW_API( cv_box )( int* flg, float* xx, float* yy, float* zz, float *x, float *y, float *z )
{ /* Convert coordinates between Cm and Box coordinates */
  return Draw_CV_Box( *flg, *xx, *yy, *zz, x, y, z );
}
