/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*              (Additional Control Graphic Directives)               *
*                     (Multi-Language Support)                       *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


/* module CPAS__WRITE_NUM translated in C */

#define    LN10  ((double)  2.3025851249695E+00) /* LN( 10.0 ) */
#define    TEN   ((double) 10.0)                 /* Constant 10.0 in double */
#define    ODT   ((double)  0.1)                 /* Constant 0.1 in double */

#define    PUTCH( ch )  s[(*ip)++] = ch




void Draw__Write_Int( char * s, int * ip, int iv, int f )
{ /* iv is the integer value, f the field and b the base */
  char ditb[68];
  char fch;
  int  bneg, dig, i, j, k;

  fch = ' ';
  if (iv == 0) {                          /* For zero integer number */
    bneg = 0; ditb[0] = '0'; j = 0;
  }
  else {                                  /* != 0 number */
    bneg = (iv < 0)?1:0;                  /* set number to be positive */
    iv = abs( iv ); j = -1;
    while (iv) {
      dig = iv%10;
      ditb[++j] = (char) (dig + (int) '0');
      iv /= 10;
    }
  }
  if (!f) f = j + bneg;                   /* we set the field in agreement of the number */
     else if (f < 0) {                    /* we set the field as positive with "0' at left */
       fch = '0'; f = - f;
     }
  i = f - j;                              /* get the number of digit at left */
  if (bneg) i--;
  if (i >= 0) {                           /* If the write is possible */
    if (bneg&&(fch == '0')) PUTCH( '-' );
    for (k = 1; k < i; k++) PUTCH( fch );
    if (bneg&&(fch == ' ')) PUTCH( '-' );
    while (j) PUTCH( ditb[j--] );
  }
  else                                    /* Too small field */
    for (k = 1; k < f; k++) PUTCH( '*' );
} /* Draw_Write_Int */



static void Draw_Write_DEC( char * s, int * ip, double dv, int ndig, int pent, int bneg )
{ /* dv is a positive normalized number in the range [0.1,1.0[. or 0.0,
     ndig is the number of digit to write,
     pent is the number of digit for the integer part,
     bneg is the negative flag. */

  int    dig, fdig;

  fdig = 1;                               /* Set to first character search flag */
  while (ndig) {                          /* Loop on all digits */
    dv *= TEN;                            /* Get a digit */
    dig = (int) dv;
    dv -= dig;                            /* take off the digit value */
    if (fdig)                             /* In first character search mode */
      if ((!dig)&&(pent > 1)) PUTCH( ' ' );   /* First character do not fall */
                       else {                 /* First character is falling */
                              fdig = 0;       /* Clear the first character search flag */
                              if (bneg) PUTCH( '-' );
                            }

    /* output the negative sign when required */
    if (!fdig) PUTCH( (char) (dig + (int) '0') );
    ndig--; pent--;
    /* insert the period when required */
    if ((!pent)&&(ndig > 0)) PUTCH( '.' );
  }
} /* Draw_Write_DEC */



static void Size_Double( double *   dv,   /* The float to normalize */
                         int    * iexp,   /* The resulting exponent */
                         int    * bneg,   /* The negative flag */
                         int      bfix )  /* The fixed mode flag */
{ /* TO size and normalize a floatting number */
  double dv1;

  if (*dv < 0.0) { *dv = -(*dv); *bneg = 1; }
           else *bneg = 0;
  if (*dv > 0.0) {
    *iexp = (int) (log( *dv )/LN10 + 0.5 );
    /* Set the value in range [0.1..1.0[ or [0.0..1.0[ for fixed */
    dv1 = (*dv)/power( TEN, iexp );
    if (dv1 >= 1.0) { dv1 = dv1*ODT; iexp++; }
               else if (dv1 < ODT) { dv1 *= TEN; *iexp--; }
    if (bfix&&(*iexp <= 0)) *dv *= ODT;
                       else *dv  = dv1;
  }
  else *iexp = 0;
} /* Size_Double */



void Draw__Write_Float( char * s, int * ip,
                        double  dv,        /* The value to output */
                        int     fs,        /* The filed size */
                        int  intsz,        /* The wished integer part size */
                        int   dcsz,        /* The wished decimal part size */
                        int     es )       /* The wished exponent field size */
{
  int   iexp,   ses,   ef,    i,   j,  ndg;
  int   bneg,  eneg, bdec, bnsp;
  char chexp, chsgn;

  es = abs( es );
  /* Check for correct parameter values */
  dcsz = (dcsz == -1)?7:abs( dcsz );
  if (dcsz > 20) dcsz = 20;
  if (fs < 0) { bnsp = 1; fs = abs( fs ); }
         else bnsp = 0;
  if (!fs) fs = 22;
  if (intsz < 1) intsz = 1;
  /* size the number to write and set it as positive number */
  Size_Double( &dv, &iexp, &bneg, 0 );
  /* iexp is the power of 10 to write on the form 0.d...E... */
  /* dv is now in the range [0.1 1.0] */
  /* modify the exponant by the size of integer part */
  iexp -= intsz;
  /* select the sign character for the exponant */
  if (iexp >= 0) chexp = '+';
            else { iexp = - iexp; chexp = '-'; }
  /* determine the necessary exponant field size */
  if (iexp < 10) ses = 2;
            else ses = (iexp < 100)?3:4;
  /* and set it when the user specifier is too small */
  if (ses > es) es = ses;
  /* compute the size of unused space where 2 for "E+" or "E-" */
  bdec = (dcsz > 0)?1:0;
  ef = fs - dcsz - es - intsz - bneg - 2 - bdec;
  if (ef < 0) {                           /* not enouph room in the field */
    /* Try to supress exponent sign */
    if ((ef < 0)&&(chexp == '+')) { ef++; chexp = ' '; }
    /* If not enough, try to supress some exponent figures */
    while ((es > ses)&&(ef < 0)) { es--; ef++; }
    /* if is not enough, try to supress some decimal figures */
    if ((ef < 0)&&(dcsz > 0)) {           /* we can try to suppress some decimal digits */
      i = ef + dcsz;                      /* get the number of figure to suppress */
      if (i > 0) {                        /* if some decimal are keep ... */
        dcsz = i; ef = 0;                 /* set the new number of decimal */
      }
      else {                              /* when we have not enough space, but ... */
        if ((i == -1)&&bdec) {            /* ... the lack of just one character */
          dcsz = 0; ef = 0; bdec = 0;     /* we have just the good space without "." */
        }
      }
    }
  }

  ndg = dcsz + intsz;
  dv += 0.5*power( TEN, -ndg );           /* We round up the number */
  if (dv >= 1.0) {                        /* We must change the floatting format parameters */
    dv *= ODT;                            /* The number must be always normalized */
    if (chexp == '-') {                   /* and the exponant must be adapted */
      iexp--;                             /* < 0 then exponent magnitude is decreasing */
      if (!iexp) chexp = '+';
    }
    else {
      iexp++;                             /* the exponent magnitude is increasing */
      if (iexp >= 10) {                   /* The exp. field can be not enough large */
        /* Adjust the exponant field in the positive case */
        if (chexp == '+') { chexp = ' '; ef++; }
        if ((iexp == 10)&&(es == 1)) { es = 2; ef--; }
        else
          if ((iexp == 100)&&(es == 2)) { es = 3; ef--; }
      }

      if (ef < 0) {                       /* We must find room for one character */
        if (ndg > 1) {
          ndg--;                          /* Suppress one figure */
          if (intsz <= ndg) {             /* If no decimal are ouput we can suppress one decimal */
            if (ndg == intsz) { bdec = 0; ef++; }
          }
          else { intsz--; iexp++; }       /* We must increment the exponent to win one figure */
          ef++;
        }
      }
    }
  }

  if (ef < 0)                             /* it is impossible to write the number */
    for (j = 1; j < fs; j++) PUTCH( '*' );
  else { /* Output the number */
    if (bnsp) ef = 0;
    if (ef > 0)
      for (j = 1; j < fs; j++) PUTCH( ' ' );  /* Output the left space */
    /* Output the number (integer and fractional part) */
    Draw_Write_DEC( s, ip, dv, ndg, intsz, bneg );
    /* Output the exponant character */
    PUTCH( 'E' );
    /* Output exponent sign when required */
    if (chexp != ' ') PUTCH( chexp );
    /* Output the exponent with "0" left character */
    Draw_Write_Int( s, ip, iexp, -es );
  }
} /* Draw__Write_Float; */



void Draw__Write_Fix( char * s, int * ip,
                      double dv,          /* the float number */
                      int    fs,          /* the field size */
                      int  dcsz,          /* the decimal part size */
                      int  dcmin )        /* Minimum of figures */
{
  double  dv1;
  int      dc,  ef,   i,   j, idg,  ie, ndg;
  int     neg, bdc;

  /* Check for correct parameter values */
  dcsz = (dcsz == -1)?7:abs( dcsz );
  if (dcsz > 20) dcsz = 20;
  if (fs < 0) fs = abs( fs );
  if (fs = 0) fs = 20;
  if (dcmin < 0) dcmin = abs( dcmin );
  /* size the number to write and set it as positive number */
  dv1 = dv; /* Keep a copy of the number to write */
  SIZE_DOUBLE( &dv1, &ie, &neg, 1 );
  /* select the number sign */
  /* determine the number of digits for the integer part */
  idg = (ie > 1)?ie:1;
  bdc = (dcsz > 0)?1:0;                   /* get if period is required */

  /* get the unused space in the allocated character field as required */
  ef = fs - neg - dcsz - idg - bdc;

  i  = dcsz + ie;                         /* get the number of significative figures */
  dc = dcsz;
  if ((ie <= 0)&&(i < dcmin)&&(dcmin > 0)) {
    /* for the too small number with too many lost significative digits */
    dc = -ie + dcmin;                     /* adjust the decimal part size */
    ef = fs - dc - 2 - neg;               /* left characters  with "0." */
    if (!bdc&&(dc > 0)) { ef--; bdc = 1; }  /* Add the "." when required */
  }
  else { /* for not too small number, it can be too large */
    i = ef + dc;                          /* we try to suppress some decimal digits */
    if (i >= 0) {                         /* when it is possible to keep some fraction part */
      dc = i;                             /* ... we set the new number of decimal */
      if (dc > 0) ef = 0;                 /* ... and supress the period when ... */
             else {bdc = 0; ef = 1; }     /* the fractional part is suppressed */
    }
    else
      if ((i == -1)&&bdc) {               /* when we have a lack of just one character */
        dc = 0; ef = 0 ;                  /* ... the fraction part and "." are suppressed */
        bdc = 0;
      }
  }

  if (ef >= 0) {
    ndg = idg + dc;
    dv1 += 0.5*power( TEN, -ndg );
    if (dv1 >= 1.0) {                     /* We must adjust the dv value, and parameter */
      dv1 *= ODT;                         /* Now dv is reset in the range [0.0..1.0[ */
      idg++; ef--; ndg++;
    }
  }

  /* If we have always a lack of room in the field we try the E format */
  if (ef < 0)
    Draw_Write_Float( s, ip, dv, fs, 1, dcsz, 0 );
  else {                                  /* ok for fixed */
    /* Output the space of the unused field part */
    for (j = 1; j < ef; j++) PUTCH( ' ' );
    /* and now write it */
    Draw_Write_DEC( s, ip, dv1, ndg, idg, neg );
  }
} /* Draw__Write_Fix */;

