/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                     (Multi-Language Support)                       *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */




void DRW_API( _message )( char * str, int *len )
{ /* send a message to the Display */
  Sdrw_Put_Code( cd_message );
  Sdrw_Put_String( str, *len );
  Sdrw_Server_Request();
} /* draw__message */



/*********************************************************************/

int DRW_API( _get_choice )( int *len, char * menu[], int slen[] )
{ /* Perform a Menu Request */
  int i;

  Sdrw_Put_Code( cd_get_choice );
  Sdrw_Put_Int( *len );
  for (i = 0; i <= *len; i++)
    Sdrw_Put_String( menu[i], slen[i] );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* draw__get_choice */



/*********************************************************************/

int DRW_API( _get_answerd )( char * question, int *len )
{ /* Request for a Yes/Not Question */
  Sdrw_Put_Code( cd_get_answerd );
  Sdrw_Put_String( question, *len );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* draw__get_answerd */



/*********************************************************************/

int DRW_API( _get_string )( char * stit, int *ltit,
                            char * sdef, int *ldef,
                            char * sval, int *capa )
{ /* Get String from Keyboard */
  Sdrw_Put_Code( cd_get_string );
  Sdrw_Put_String( stit, *ltit );
  Sdrw_Put_String( sdef, *ldef );
  Sdrw_Put_Char( *capa );
  Sdrw_Server_Request();
  return Sdrw_Get_String( sval );
} /* draw__get_string */



/*********************************************************************/

int DRW_API( _get_value )( char *stit, int *ltit, float *val, float *lw, float *up )
{ /* Get A Numeric value (Radio Button) */
  int status;

  Sdrw_Put_Code( cd_get_value );
  Sdrw_Put_String( stit, *ltit );
  Sdrw_Put_Float( *val );
  Sdrw_Put_Float( *lw );
  Sdrw_Put_Float( *up );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *val = Sdrw_Get_Float();
  return status;
} /* draw__get_value */



/*********************************************************************/

int DRW_API( _select_file )( char *   stit, int  *ltit,
                             char * fltr[], int fltl[], int  *flen,
                             int  *    fdx,
                             char *   sdef, int  *ldef,
                             char *   sval, int  *capa, int  *wflg )
{ /* Get a File specification */
  int i;

  Sdrw_Put_Code( cd_get_file );
  Sdrw_Put_Char( *wflg );
  Sdrw_Put_Char( *flen );
  Sdrw_Put_String( stit, *ltit );
  for (i = 0; i < *flen; i++)
    Sdrw_Put_String( fltr[i], fltl[i] );
  Sdrw_Put_Char( *fdx );
  Sdrw_Put_String( sdef, *ldef );
  Sdrw_Put_Char( *capa );
  Sdrw_Server_Request();
  *fdx = Sdrw_Get_Char();
  return Sdrw_Get_String( sval );
} /* draw__select_file */




/*********************************************************************/

int DRW_API( seg_pick )( int *seg_id, int *pick_id )
{ /* request for "Clic" of a Segement */
  int status;

  Sdrw_Put_Code( cd_seg_pick );
  Sdrw_Put_Int( *seg_id );
  Sdrw_Put_Int( *pick_id );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *seg_id  = Sdrw_Get_Int();
  *pick_id = Sdrw_Get_Int();
  return status;
} /* draw_seg_pick */



/*********************************************************************/

int Draw_Get_Position( float *xx, float *yy, Char in_epure )
{ /* Request to get a Point coordinates */
  int status;

  Sdrw_Put_Code( cd_get_position );
  Sdrw_Put_Float( *xx );
  Sdrw_Put_Float( *yy );
  Sdrw_Put_Char( in_epure );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *xx = Sdrw_Get_Float();
  *yy = Sdrw_Get_Float();
  return status;
} /* Draw_Get_Position */


int DRW_API( get_position )( float *xx, float *yy, Char *in_epure )
{ /* Request to get a Point coordinates */
  return Draw_Get_Position( xx, yy, *in_epure );
} /* draw_get_position */



/*********************************************************************/

int DRW_API( get_window )( float *x1, float *x2, float *y1, float *y2 )
{ /* Get the Rectangle (Window) Coordinates */
  int status;

  Sdrw_Put_Code( cd_get_window );
  Sdrw_Put_Float( *x1 );
  Sdrw_Put_Float( *x2 );
  Sdrw_Put_Float( *y1 );
  Sdrw_Put_Float( *y2 );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *x1 = Sdrw_Get_Float();
  *x2 = Sdrw_Get_Float();
  *y1 = Sdrw_Get_Float();
  *y2 = Sdrw_Get_Float();
  return status;
} /* Draw_Get_Window */



/*********************************************************************/

int Draw_Get_Line_Stroke( float pt[], int capa, int *size,
                          Char keep, Char f_stroke )
{ /* Get Line (f_stroke=0)/ Stroke (f_stroke==1), Store the points in
     pt table and final size in *size, capa is the size in Dpoint of
     the array pt */
  int j, status, npt, rdim;

  Sdrw_Put_Code( f_stroke==0?cd_get_line:cd_get_stroke );
  Sdrw_Put_Int( abs( capa/2 ) ); /* Transmit the total capacity */
  Sdrw_Put_Char( keep );         /* Send the Graphic append flag */
  *size = 0;                     /* Init the Point count */
  do {
    Sdrw_Server_Request();       /* Send the partial Request */
    status = Sdrw_Get_Int();     /* Get status */
    rdim   = Sdrw_Get_Int();     /* Get the number of receive point */
    for (j = 0; j < rdim; j++) {
      *(pt++) = Sdrw_Get_Float();/* Store the x in the user memory */
      *(pt++) = Sdrw_Get_Float();/* Store the y in the user memory */
    }
    *size += rdim;               /* Update the collected number of point */
  if (status&1) break;
    Sdrw_Put_Code( cd_continue );
    Sdrw_Put_Char( 0 );          /* Continue in 2D mode */
  } while (1);
                                 /* status = 1=> Finish, status = -1 stop. */
  return status;
} /* Draw_Get_Line_Stroke */


int DRW_API( get_curve )( float pt[], int *capa, int *size,
                         Char *keep, Char *f_stroke )
{
  Draw_Get_Line_Stroke( pt, *capa, size, *keep, *f_stroke );
}


/****************************    E N D    ****************************/
