C
C**********************************************************************
C*                                                                    *
C*                                                                    *
C*                                                                    *
C*             D R A W   -   C L I E N T   L I B R A R Y              *
C*                                                                    *
C*                   F O R T R A N     M O D U L E                    *
C*                                                                    *
C*                 (Main Control Graphic Directives)                  *
C*                   (fortran Adaptation Support)                     *
C*                                                                    *
C*                                                                    *
C*                               by                                   *
C*                                                                    *
C*          Pierre Wolfers, Laboratoire de Cristallographie           *
C*                                                                    *
C*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
C*                                                                    *
C*                     F 38042 GRENOBLE CEDEX 9                       *
C*                                                                    *
C*                           F R A N C E                              *
C*                                                                    *
C*                                                                    *
C*                                                                    *
C**********************************************************************
C
C
C
C/////////////////////////////////////////////////////////////////////////
C//                                                                     //
C//                                                                     //
C// This license described in this file overrides all other licenses    //
C// that might be specified in other files for this library.            //
C//                                                                     //
C// This library is free software; you can redistribute it and/or       //
C// modify it under the terms of the GNU Lesser General Public          //
C// License as published by the Free Software Foundation; either        //
C// version 2.1 of the License, or (at your option) any later version.  //
C//                                                                     //
C// This library is distributed in the hope that it will be useful,     //
C// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
C// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
C// Library General Public License for more details.                    //
C//                                                                     //
C// You should have received a copy of the GNU Lesser General Public    //
C// License along with this library (see COPYING.LIB); if not, write to //
C// the Free Software Foundation :                                      //
C//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
C//                                                                     //
C/////////////////////////////////////////////////////////////////////////
C
C

	SUBROUTINE DRAW_MESSAGE( S )
	IMPLICIT NONE
	CHARACTER*(*) S

C	COMMON /STR/ STR, SRE, STB
C	CHARACTER*1 STR(255), SRE(255), STB(1024)

	EXTERNAL DRAW__MESSAGE

	INTEGER I, L

	L = LEN( S )
C	IF (L.GT.0) THEN
C	  DO I = 1, L
C	    STR(I) = S(I:I)
C	  END DO
C	ENDIF

	CALL DRAW__MESSAGE( S, L )

	RETURN
	END
C
C================================================================================
C
	INTEGER FUNCTION DRAW_GET_STRING( TITLE, DEFAULT, INSTR )
	IMPLICIT NONE
	CHARACTER*(*) TITLE, DEFAULT, INSTR

C	COMMON /STR/ STR, SRE, STB
C	CHARACTER*1 STR(255), SRE(255), STB(1024)

	EXTERNAL DRAW__GET_STRING
	INTEGER  DRAW__GET_STRING

	INTEGER I, LT, LD, LR, STATUS

	LT = LEN( TITLE )
C	IF (LT.GT.0) THEN
C	  DO I = 1, LT
C	    STR(I) = TITLE(I:I)
C	  END DO
C	ENDIF

	LD = LEN( DEFAULT )
C	IF (LD.GT.0) THEN
C	  DO I = 1, LT
C	    STB(I) = DEFAULT(I:I)
C	  END DO
C	ENDIF

C	STATUS = DRAW__GET_STRING( STR, LT, STB, LD, SRE, LR )
	STATUS = DRAW__GET_STRING( TITLE, LT, DEFAULT, LD, INSTR, LR )

C	IF (LR.GT.0) THEN
C	  DO I = 1, LR
C	    INSTR(I:I) = SRE(I)
C	  ENDDO
C	ENDIF

	DRAW_GET_STRING = STATUS
	RETURN
	END
C
C================================================================================
C
	INTEGER FUNCTION DRAW_GET_CHOICE( TITLE, MSG, N_CHOICES,
     1                                    INPUT_CHOICE )
	IMPLICIT NONE
	INTEGER       N_CHOICES, INPUT_CHOICE
	CHARACTER*(*) TITLE, MSG(N_CHOICES)

	CHARACTER*1 TBS(32,32)
	INTEGER     TBL(32)

	INTEGER  DRAW__GET_CHOICE
	EXTERNAL DRAW__GET_CHOICE

	INTEGER  I, J, STATUS
	

	TBL(1) = LEN( TITLE )
	IF (TBL(1).GT.0) THEN
	  DO I = 1, TBL(1)
	    TBS(I,1) = TITLE(I:I)
	  END DO
	ENDIF

	IF (N_CHOICES.GT.31) N_CHOICES = 31

	DO I = 1, N_CHOICES
	  TBL(I+1) = LEN( MSG(I) )
	  DO J = 1, TBL(I+1)
	    TBS(J,I+1) = MSG(I)(J:J)
	  ENDDO
	ENDDO

	STATUS = DRAW__GET_CHOICE( N_CHOICES, TBS, TBL )

	IF (STATUS .GT. 0) INPUT_CHOICE = STATUS
	DRAW_GET_CHOICE = STATUS
	RETURN
	END
C
C================================================================================
C
	INTEGER FUNCTION DRAW_GET_ANSWERD( TITLE, INPUT_CHOICE )
	IMPLICIT NONE
	CHARACTER*(*) TITLE
	INTEGER INPUT_CHOICE

	EXTERNAL DRAW__GET_ANSWERD
	INTEGER  DRAW__GET_ANSWERD

	INPUT_CHOICE = DRAW__GET_ANSWERD( TITLE, LEN( TITLE ) )
        DRAW_GET_ANSWERD = INPUT_CHOICE
	RETURN
	END
C
C================================================================================
C


	INTEGER FUNCTION DRAW_GET_VALUE( TITLE, VAL, LW, UP )
	IMPLICIT NONE
	CHARACTER*(*) TITLE
	REAL VAL, LW, UP

	EXTERNAL DRAW__GET_VALUE
	INTEGER  DRAW__GET_VALUE

	DRAW_GET_VALUE = DRAW__GET_VALUE( TITLE, LEN( TITLE ),
     1                                    VAL, LW, UP )

	RETURN
	END
C
C================================================================================
C

	INTEGER FUNCTION DRAW_SELECT_FILE( TIT, FLT, FLN, FDX,
     &	                                   SDF, LDF, SFL, CFL, WFL )
	IMPLICIT NONE
	CHARACTER*(*) TIT, FLT(32), SDF, SFL
	INTEGER FLN, FDX, LDF, CFL
	LOGICAL WFL

	CHARACTER*1 TBS(32,32)
	INTEGER     TBL(32)
	INTEGER     I, J

	EXTERNAL DRAW__SELECT_FILE
	INTEGER  DRAW__SELECT_FILE


	IF (FLN.GT.32) FLN = 32

	DO I = 1, FLN
	  TBL(I+1) = LEN( FLT(I) )
	  DO J = 1, TBL(I+1)
	    TBS(J,I+1) = FLT(I)(J:J)
	  ENDDO
	ENDDO

	DRAW_SELECT_FILE = DRAW__SELECT_FILE( TIT, LEN( TIT ),
     &                   TBS, TBL, FLN, SDF, LDF, SFL, CFL, WFL )

	RETURN
	END
C
C================================================================================
C
