/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                     (Multi-Language Support)                       *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */



void DRW_API( end )();


void DRW_API( pic_view )( Char *flags )
{ /* To Set the "Time Of Fly Display mode */
  Draw_Pic_View( *flags );
} /* draw_pic_view */


/*********************************************************************/

void DRW_API( pic_reset )( Char *flags )
{ /* To clear the "Time Of Fly" Display mode */
  Draw_Pic_Reset( *flags );
} /* draw_pic_reset */


/*********************************************************************/

void DRW_API( view )( float *dist )
{ /* Set a new origine for following Draw_Plot */
  Draw_View( *dist );
} /* draw_view */


/*********************************************************************/

void DRW_API( reload )( Char *flg )
{ /* Perform a Reload Original image */
  Draw_Reload( *flg );
} /* draw_reload */


/*********************************************************************/

void DRW_API( grid )( Char *flg )
{ /* Perform a Set/Clear (for flg=1/0) the Grid */
  Draw_Grid( *flg );
} /* draw_grid */



/*********************************************************************/

void DRW_API( alpha_set )( int *flg )
{
  Draw_Alpha_Set( *flg );
}


/*********************************************************************/

void DRW_API( light_onoff )( int *light, int *flg )
{
  Draw_Light_OnOff( *light, *flg );
}


/*********************************************************************/

void DRW_API( light_define )( int *light, int *knd, float *prm, int *nprm )
{ /* Define the light(s) Characteristic */
  Draw_Light_Define( *light, *knd, prm, *nprm );
}



/*********************************************************************/

void DRW_API( mat_light_prop )( int *face, int *knd, float *prm, int *psz )
{
  Draw_Mat_Light_Prop( *face, *knd, prm, *psz );
}





/****************************    E N D    ****************************/

