/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                     (Multi-Language Support)                       *
*                                                                    *
*                                                                    *
*                               by                                   *
*                                                                    *
*          Pierre Wolfers, Laboratoire de Cristallographie           *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */



/*********************************************************************/
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*         Three kind of Procedure names :                           */
/*                                                                   */
/*       1/  API form (Directly Callable by Fortran)                 */
/*                all parameter are passed by reference.             */
/*                                                                   */
/*       2/  Draw_<name> form (C compatible form).                   */
/*                                                                   */
/*       3/  Draw__<name> form (Intermediary C compatible form).     */
/*                Used as intermediary between the dedicated         */
/*                language procedures for special parameter          */
/*                management.                                        */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*********************************************************************/



void Draw_Color_Index( int color )
{ /* Set a color for following Drawing primitives */
  Sdrw_Put_Code( cd_color);
  Sdrw_Put_Float( - abs( color ) );
  Sdrw_Server_Request();
} /* Draw_Color */


/*********************************************************************/

void Draw_Set_Color( float r, float v, float b )
{ /* Set a color for following Drawing primitives */
  Sdrw_Put_Code( cd_color);
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( v );
  Sdrw_Put_Float( b );
  Sdrw_Server_Request();
} /* Draw_Set_Color */


/*********************************************************************/

void Draw_Set_ColorA( float r, float v, float b, float a )
{ /* Set a color for following Drawing primitives */
  Sdrw_Put_Code( cd_color);
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( v );
  Sdrw_Put_Float( b );
  Sdrw_Put_Float( a );
  Sdrw_Server_Request();
} /* Draw_Set_Color */


/*********************************************************************/

void Draw_Define_Color( int icol, float r, float g, float b )
{ /* Set the Icol# color definition (in RGB) */
  Sdrw_Put_Code( cd_define_color );
  Sdrw_Put_Int( icol );
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( g );
  Sdrw_Put_Float( b );
  Sdrw_Server_Request();
} /* Draw_Define_Color */



/*********************************************************************/

void Draw_Define_ColorA( int icol, float r, float g, float b, float a )
{ /* Set the Icol# color definition (in RGB) */
  Sdrw_Put_Code( cd_define_color );
  Sdrw_Put_Int( icol );
  Sdrw_Put_Float( r );
  Sdrw_Put_Float( g );
  Sdrw_Put_Float( b );
  Sdrw_Put_Float( a );
  Sdrw_Server_Request();
} /* Draw_Define_Color */



/*********************************************************************/

int Draw_Inquire_Color( int icol, float *r, float *g, float *b, float *a )
{ /* Get the Icol# color definition (in RGB) */
  int status;

  Sdrw_Put_Code( cd_inquire_color );
  Sdrw_Put_Int( icol );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *r = Sdrw_Get_Float();
  *g = Sdrw_Get_Float();
  *b = Sdrw_Get_Float();
  if (a) *a = Sdrw_Get_Float();
  return status;
} /* Draw_Inquire_Color */



/*********************************************************************/

void Draw_Line_Attr( int n, float r )
{ /* Set Line Attributs */
  Sdrw_Put_Code( cd_line_attr );
  Sdrw_Put_Int( n );
  Sdrw_Put_Float( r );
  Sdrw_Server_Request();
} /* Draw_Line_Attr */



/*********************************************************************/

void Draw_Marker_Attr( int n, float r )
{ /* set the Marker Attributs */
  Sdrw_Put_Code( cd_marker_attr );
  Sdrw_Put_Int( n );
  Sdrw_Put_Float( r );
  Sdrw_Server_Request();
} /* Draw_Marker_Attr */



/*********************************************************************/

void Draw_Fill_Attr( int n1, int n2 )
{ /* Set The Fill Area Attribute */
  Sdrw_Put_Code( cd_fill_area_attr );
  Sdrw_Put_Int( n1 );
  Sdrw_Put_Int( n2 );
  Sdrw_Server_Request();
} /* Draw_Fill_Attr */



/*********************************************************************/

void Draw_Text_Font( int n, int tp )
{ /* To select a specified Font */
  Sdrw_Put_Code( cd_text_font );
  Sdrw_Put_Int( n );
  Sdrw_Put_Int( tp );
  Sdrw_Server_Request();
} /* Draw_Text_Font */



/*********************************************************************/

void Draw_Text_Attr( int n1, int n2, int n3, float re, float rs )
{ /* Set text Attributs*/
  Sdrw_Put_Code( cd_text_attr );
  Sdrw_Put_Int( n1 );
  Sdrw_Put_Int( n2 );
  Sdrw_Put_Int( n3 );
  Sdrw_Put_Float( re );
  Sdrw_Put_Float( rs );
  Sdrw_Server_Request();
} /* Draw_Text_Attr */




/****************************    E N D    ****************************/

