C ************************************************************          
C ************************************************************
C ***                                                      ***
C ***                   STRUPLO'84                         ***
C ***                                                      ***
C ***             A FORTRAN PLOTPROGRAM                    ***
C ***                                                      ***
C ***             FOR CRYSTAL STRUCTURE                    ***
C ***                                                      ***
C ***                  ILLUSTRATIONS                       ***
C ***                                                      ***
C ***                                                      ***
C ***  AUTHOR: REINHARD X. FISCHER                         ***
C ***          INSTITUT FUER GEOWISSENSCHAFTEN DER         ***
C ***          UNIVERSITAET                                ***
C ***          SAARSTR. 21, D-6500 MAINZ                   ***
C ***                                                      ***
C ***  PRESENT ADDRESS :                                   ***
C ***          DEPT. GEOL. SCI.                            ***
C ***          UNIV. OF ILLINOIS                           ***
C ***          P.O. BOX 4348                               ***
C ***          CHICAGO, ILLINOIS 60680                     ***
C ***                                                      ***
C ************************************************************
C ************************************************************
C VERSION OCTOBER 1985 (1500 ATOMS, 200 POLYHEDRA)
C

	IMPLICIT INTEGER*4 (I-N), REAL*4 (A-H,O-Z)

      COMMON/PLOR/FXOR,FYOR
      COMMON/ALL/A,B,C,D,E,F,G,H,M,N,O,IO1,IO2,IO3,IO4,CR
      COMMON/ADD/NH(50,3),P(10),TIT(17),IS,BL
      COMMON/MODI/ID,PA1,PA2,AR1,AR2,OR1,OR2,RES,FAC
      DIMENSION CR(7),A(1500,4),B(24),C(90),D(40),E(48,3,4),F(900)
      INTEGER*4 G(20), H(84), M(70), N(1600), O(1524)

      INTEGER*4       ICODE,  IPEN
      CHARACTER*32    NFIL
	CHARACTER*80    LINE
	LOGICAL         LOG,  LOG2,  LOG3, FEND

	EXTERNAL PACK
	EXTERNAL UNPACK
	EXTERNAL READ_LINE
C
C *** MODIFICATIONS FOR DEC-10 ***
      INTEGER TTY

	TTY=5
      TTYO=6
	
      WRITE(TTYO,9876)
 9876 FORMAT(2X,'INPUT FILE NAME (A32) ?')
      READ(TTY,9877) NFIL
 9877 FORMAT(A32)
      OPEN(UNIT=IO1,STATUS='OLD',FILE=NFIL)
      OPEN(UNIT=IO2,STATUS='UNKNOWN',FILE='STRUPL.OUT')
C *** END OF MODIFICATIONS ***
C
      CALL SB_READ
      LOG2=H(45).EQ.0
      LOG3=C(29).LT.-10..OR.H(45).NE.2
C
C *** CALCULATE ORTHOGONAL MATRIX ***
C
      D(1)=SIN(C(26)*C(35))
      D(2)=SIN(C(27)*C(35))
      D(3)=SIN(C(28)*C(35))
      D(4)=COS(C(26)*C(35))
      D(5)=COS(C(27)*C(35))
      D(6)=COS(C(28)*C(35))
      D(7)=(D(4)*D(5)-D(6))/(D(1)*D(2))
      C(37)=C(23)*D(2)*SQRT(1.-D(7)*D(7))
      C(38)=-C(23)*D(2)*D(7)
      C(39)=C(24)*D(1)
      C(40)=C(23)*D(5)
      C(41)=C(24)*D(4)
      C(42)=C(25)
C
C *** CALCULATE INVERSE MATRIX ***
C
      C(48)=1./C(42)
      C(46)=1./C(40)
      C(43)=1./C(37)
      C(47)=-(C(41)*C(48))/C(40)
      C(44)=-(C(38)*C(43)*C(46))
      C(45)=-C(43)*(C(38)*C(47)+C(39)*C(48))
      IF (P(1).GT.-1E10) CALL VIEW
      IF (H(6).EQ.0) GOTO 1
C
C *** CALCULATE ROTATION MATRIX ***
C
      D(1)=COS(B(4)*C(35))
      D(2)=COS(B(5)*C(35))
      D(3)=COS(B(6)*C(35))
      D(4)=SIN(B(4)*C(35))
      D(5)=SIN(B(5)*C(35))
      D(6)=SIN(B(6)*C(35))
      B(4)=D(2)*D(3)
      B(7)=D(6)*D(2)
      B(10)=D(5)
      B(5)=-D(6)*D(1)-D(3)*D(5)*D(4)
      B(8)=D(3)*D(1)-D(6)*D(5)*D(4)
      B(11)=D(2)*D(4)
      B(6)=D(6)*D(4)-D(3)*D(5)*D(1)
      B(9)=-D(3)*D(4)-D(6)*D(5)*D(1)
      B(12)=D(2)*D(1)
    1 IF (.NOT.LOG2) GOTO 3
C
C *** CALCULATE RANGE FOR ATOMS OUTSIDE THE UNITCELL ***
C
      DO 2 I=1,24,3
    2 CALL CORTH  ! (C(I+48) , C(I+49) , C(I+50))
C   2 CALL CORTH(C(I+48) , C(I+49) , C(I+50))
      D(1)=C(56)*C(60)-C(57)*C(59)
      D(2)=C(57)*C(58)-C(55)*C(60)
      D(3)=C(55)*C(59)-C(56)*C(58)
      D(4)=C(53)*C(60)-C(54)*C(59)
      D(5)=C(54)*C(58)-C(52)*C(60)
      D(6)=C(52)*C(59)-C(53)*C(58)
      D(7)=C(53)*C(57)-C(54)*C(56)
      D(8)=C(54)*C(56)-C(52)*C(57)
      D(9)=C(52)*C(56)-C(53)*C(55)
      D(10)=SQRT(D(1)*D(1)+D(2)*D(2)+D(3)*D(3))
      D(11)=SQRT(D(4)*D(4)+D(5)*D(5)+D(6)*D(6))
      D(12)=SQRT(D(7)*D(7)+D(8)*D(8)+D(9)*D(9))
      C73=AMAX1(C(9)+C(10),C(17)+C(18))
      D(4)=ABS(C73*D(10)/(D(1)*C(37)+D(2)*C(38)+D(3)*C(40)))
      D(7)=ABS(C73*D(11)/(D(5)*C(39)+D(6)*C(41)))
      D(8)=ABS(C73*D(12)/(D(9)*C(42)))
      C(1)=-D(4)
      C(3)=-D(7)
      C(5)=-D(7)
      C(2)=D(4)+1.
      C(4)=D(7)+1.
      C(6)=D(8)+1.
      WRITE (IO2,1000) (C(J),J=1,6)
      GOTO 4
    3 WRITE (IO2,1013) (C(J),J=1,6)
    4 IF (H(44)-1) 7,5,7
C
C *** SET -X,-Y,-Z OPERATOR ***
C
    5 DO 6 I=1,H(5)
      L=I+H(5)
      DO 6 J=1,3
      DO 6 K=1,4
    6 E(L,J,K)=-E(I,J,K)
      H(5)=L
      WRITE (IO2,1014)
      GOTO 8
    7 WRITE (IO2,1015)
C
C *** PREPARE DO LOOP PARAMETERS ***
C
    8 DO 9 I=1,6
    9 O(I)=IFIX(C(I)-SIGN(1E-4,C(I))+10.)
C
C *** READ ATOMIC PARAMETERS ***
C
      DO 42 I=9,6000
      GOTO (10,18,19,21,20),H(9)
   10 K=0
   11	CALL READ_LINE( IO3, LINE, FEND )
	IF (FEND) GOTO 43
	WRITE(6,1888) LINE
	READ (LINE,1004) (N(J),J=1,80)
      IF (N(1).EQ.M( 1).AND.N(2).EQ.M( 1)) GOTO 11
      IF (N(1).EQ.M(41).AND.N(2).EQ.M(28)) GOTO 11
      IF (N(1).EQ.M(24).AND.N(2).EQ.M(34)) GOTO 11
      IF (N(1).EQ.M(27).AND.N(2).EQ.M(34)) GOTO 43
      IF (N(1).NE.M(21).OR. N(2).NE.M(40)) GOTO 13
      N(3)=M(1)
      N(4)=M(1)
      CALL READN
      DO 12 J=1,30
      IF (D(J).LT.-1E20) GOTO 11
      K=K+1
   12 F(K)=D(J)
      GOTO 11
   13 DO 14 J=19,44
   14 IF (N(1).EQ.M(J)) GOTO 15
      GOTO 11
   15 N(81)=N(1)
      N(82)=N(2)
      CALL READN
      N(3)=IFIX(D(1))
      DO 17 J=3,5
      IF (D(J).GT.15.) GOTO 16
      D(J-1)=D(J)
      GOTO 17
   16 K=IFIX((D(J)+5.)*0.1)
      D(J-1)=(D(J)-FLOAT(K*10))*F(K)
   17 CONTINUE
      N(1)=N(81)
      N(2)=N(82)
      GOTO 22
   18 CALL READ_LINE( IO3, LINE, FEND )
	IF (FEND) GOTO 43
	WRITE(6,1888) LINE
	READ (LINE,1002) (N(J),J=1,3) , (D(J),J=2,4)
      GOTO 22
   19 CALL READ_LINE( IO3, LINE, FEND )
	IF (FEND) GOTO 43
	WRITE(6,1888) LINE
	READ (LINE,1003) (N(J),J=1,3) , (D(J),J=2,4)
      GOTO 22
   20 CALL READ_LINE( IO3, LINE, FEND )
	IF (FEND) GOTO 43
	WRITE(6,1888) LINE
	READ (LINE,G) (N(J),J=1,3) , (D(J),J=2,4)
      GOTO 22
   21 CALL READ_LINE( IO3, LINE, FEND )
	IF (FEND) GOTO 43
	WRITE(6,1888) LINE
	READ (LINE,1004) (N(J),J=1,80)
      N1=N(1)
      N2=N(2)
      CALL READN
      N(1)=N1
      N(2)=N2
      N(3)=D(1)
   22 A(H(8)+1,1)=PACK(1)
C
C *** STORE ATOM NAME ***
C
      IF (H(24)) 25,25,23
   23 DO 24 J=1,H(24)
   24 IF (N(3) .EQ. H(J+24)) GOTO 26
   25 H(24)=H(24)+1
      H(H(24)+24)=N(3)
C
C *** GENERATE EQUIVALENT POSITIONS ***
C
   26 D(1)=A(H(8)+1,1)
      N(2)=H(8)
      DO 41 J=1,H(5)
      DO 40 K=1,3*H(4),3
      H(8)=H(8)+1
      A(H(8),1)=D(1)
      DO 27 L=1,3
   27 A(H(8),L+1)=E(J,L,1)+E(J,L,2)*D(2)+E(J,L,3)*D(3)+E(J,L,4)*D(4)+
     &B(K+L+11)
C
C *** REDUCE COORDINATES TO RANGE OF UNIT CELL ***
C
      DO 31 L=2,4
      IF (A(H(8),L)) 28,29,29
   28 A(H(8),L)=A(H(8),L)-AINT(A(H(8),L))+1.
   29 IF (A(H(8),L)-1.) 31,30,30
   30 A(H(8),L)=A(H(8),L)-AINT(A(H(8),L))
   31 CONTINUE
C
C *** CHECK SPECIAL POSITIONS ***
C
      IF (J.EQ.1 .OR. K.GT.1) GOTO 36
      DO 35 L=N(2),H(8)-1
      IF (ABS(A(L,2) - A(H(8),2))  -  0.001) 32,35,35
   32 IF (ABS(A(L,3) - A(H(8),3))  -  0.001) 33,35,35
   33 IF (ABS(A(L,4) - A(H(8),4))  -  0.001) 34,35,35
   34 H(8)=H(8)-1
      GOTO 41
   35 CONTINUE
C
C *** CHECK LIMITS FOR ALL ATOMS ***
C
   36 IF (A(H(8),2) .LT. C(1) .OR. A(H(8),2) .GT. C(2)) GOTO 37
      IF (A(H(8),3) .LT. C(3) .OR. A(H(8),3) .GT. C(4)) GOTO 37
      IF (A(H(8),4) .LT. C(5) .OR. A(H(8),4) .GT. C(6)) GOTO 37
      GOTO 38
   37 A(H(8),1)=SIGN(A(H(8),1),-1.)
      GOTO 40
C
C *** CHECK LIMITS FOR CIRCLES ***
C
   38 IF (LOG3) GOTO 40
      IF (A(H(8),2) .LT. C(29) .OR. A(H(8),2) .GT. C(30)) GOTO 39
      IF (A(H(8),3) .LT. C(31) .OR. A(H(8),3) .GT. C(32)) GOTO 39
      IF (A(H(8),4) .LT. C(33) .OR. A(H(8),4) .GT. C(34)) GOTO 39
      GOTO 40
   39 A(H(8),1)=FLOAT(IFIX(A(H(8),1)*0.1)*10+5)
   40 CONTINUE
   41 CONTINUE
   42 CONTINUE
C
C *** GENERATE ATOMS OUTSIDE THE UNIT CELL ***
C
   43 H(36)=H(8)
      DO 47 I=9,H(36)
      D(1)=ABS(IFIX(A(I,1)*0.1)*10)
      D(2)=A(I,2)
      D(3)=A(I,3)
      D(4)=A(I,4)
      DO 47 J=O(1),O(2)
      DO 47 K=O(3),O(4)
      DO 47 L=O(5),O(6)
      IF (J.EQ.10 .AND. K.EQ.10 .AND. L.EQ.10) GOTO 47
      H(8)=H(8)+1
      A(H(8),1)=D(1)
      A(H(8),2)=D(2)+FLOAT(J)-10.
      A(H(8),3)=D(3)+FLOAT(K)-10.
      A(H(8),4)=D(4)+FLOAT(L)-10.
C
C *** CHECK LIMITS ***
C
      IF (A(H(8),2) .LT. C(1) .OR. A(H(8),2) .GT. C(2)) GOTO 44
      IF (A(H(8),3) .LT. C(3) .OR. A(H(8),3) .GT. C(4)) GOTO 44
      IF (A(H(8),4) .LT. C(5) .OR. A(H(8),4) .GT. C(6)) GOTO 44
      GOTO 45
   44 H(8)=H(8)-1
      GOTO 47
C
C *** CHECK LIMITS FOR CIRCLES ***
C
   45 IF (LOG3) GOTO 47
      IF (A(H(8),2) .LT. C(29) .OR. A(H(8),2) .GT. C(30)) GOTO 46
      IF (A(H(8),3) .LT. C(31) .OR. A(H(8),3) .GT. C(32)) GOTO 46
      IF (A(H(8),4) .LT. C(33) .OR. A(H(8),4) .GT. C(34)) GOTO 46
      GOTO 47
   46 A(H(8),1)=FLOAT(IFIX(A(H(8),1)*0.1)*10+5)
   47 CONTINUE
      IF (H(11)-356) 54,54,48
C
C *** OMIT ATOMS ***
C
   48 I=356
   49 I=I+1
      IF (N(I+1)) 50,51,51
   50 N(1)=N(I)
      N(2)=-N(I+1)
      I=I+1
      GOTO 52
   51 N(1)=N(I)
      N(2)=N(I)
   52 DO 53 J=N(1),N(2)
   53 A(J,1)=-A(J,1)
      IF (I-H(11)) 49,54,54
C
C *** ADD ATOMS ***
C
   54 IF (H(2)) 57,57,55
   55 DO 56 I=156,H(10),4
      H(8)=H(8)+1
      A(H(8),1)=ABS(A(N(I),1))
      A(H(8),2)=A(N(I),2)+FLOAT(N(I+1))-5.
      A(H(8),3)=A(N(I),3)+FLOAT(N(I+2))-5.
   56 A(H(8),4)=A(N(I),4)+FLOAT(N(I+3))-5.
C
   57 D(7)=1E5
      D(9)=1E5
      D(8)=-1E5
      D(10)=-1E5
      WRITE (IO2,1009)
      WRITE (IO2,1007)
      DO 66 I=1,H(8)
      IF (I-9) 59,58,59
   58 WRITE (IO2,1010)
      WRITE (IO2,1007)
   59 IF (I-H(36)-1) 61,60,61
   60 WRITE (IO2,1011)
      WRITE (IO2,1007)
   61 II=I
      CALL UNPACK(II)
C
C *** CALCULATE ORTHOGONAL COORDINATES ***
C
      D(1)=A(I,2)
      D(2)=A(I,3)
      D(3)=A(I,4)
      CALL CORTH
C
C *** ROTATE COORDINATES ***
C
   62 A(I,2)=B(4)*D(4)+B(5)*D(5)+B(6)*D(6)
      A(I,3)=B(7)*D(4)+B(8)*D(5)+B(9)*D(6)
      A(I,4)=B(10)*D(4)+B(11)*D(5)+B(12)*D(6)
C
C *** FIND MINIMUM AND MAXIMUM FOR SCALE CALCULATION ***
C
   63 IF (A(I,1)) 65,65,64
   64 D(7)=AMIN1(D(7),A(I,2))
      D(8)=AMAX1(D(8),A(I,2))
      D(9)=AMIN1(D(9),A(I,3))
      D(10)=AMAX1(D(10),A(I,3))
C
      WRITE (IO2,1005) I,(G(J),J=1,3) , (D(J),J=1,3) , (A(I,J),J=2,4)
      GOTO 66
   65 WRITE (IO2,1006) I,(G(J),J=1,3) , (D(J),J=1,3) , (A(I,J),J=2,4)
   66 CONTINUE
      WRITE (IO2,1012)
      DO 67 I=1,80
   67 N(I)=-1
      B(10)=D(7)
      B(11)=D(8)
      B(12)=D(9)
      B(13)=D(10)
      IF (H(7)) 80,80,68
C
C *** STORE ATOM NUMBERS TO BE GRAPHED AS CIRCLES ***
C
C *** A) GIVEN AS INTEGERS ***
C
   68 I=456
      J=1
      L=0
   69 I=I+1
      IF (N(I)) 70,70,71
   70 J=J+1
      GOTO 78
   71 IF (N(I+1)) 74,74,72
   72 N(1)=N(I)
      N(2)=N(I)
      IF (N(I+1)+5000) 73,73,74
   73 J=J+1
      I=I+1
      GOTO 76
   74 IF (N(I+1)+5000) 72,72,75
   75 N(1)=N(I)
      N(2)=-N(I+1)
      I=I+1
   76 DO 77 K=N(1),N(2)
      A(K,1)=A(K,1)+J
      L=L+1
      IF (L.LT.3000) GOTO 77
      WRITE (IO2,1003)
      STOP
   77 O(L)=K
   78 IF (I-H(7)-456) 69,79,79
   79 H(7)=L
   80 IF (H(38)) 86,86,81
C
C *** B) GIVEN AS ATOM NAMES ***
C
   81 DO 85 I=9,H(8)
      IF (A(I,1)) 85,85,82
   82 N(1)=IFIX(A(I,1)*1E-1)
      N(2)=IFIX(A(I,1)*1E-3)
      IF (IFIX(A(I,1))-N(1)*10.NE.0) GOTO 85
      DO 83 J=557,H(38)+556
      N(3)=N(J)*1E-2
      IF (N(3)-N(2)) 83,84,83
   83 CONTINUE
      GOTO 85
   84 H(7)=H(7)+1
      O(H(7))=I
      A(I,1)=FLOAT(IFIX(A(I,1))+N(J)-N(3)*100)
   85 CONTINUE
   86 IF (IABS(H(7))+IABS(H(38))) 91,91,87
C
C *** SORT CIRCLES ***
C
   87 DO 90 I=1,H(7)-1
      K=0
      D(1)=A(O(I),4)
      DO 88 J=I+1,H(7)
      IF (D(1).GT.A(O(J),4)) GOTO 88
      D(1)=A(O(J),4)
      K=J
   88 CONTINUE
      IF (K) 90,90,89
   89 L=O(I)
      O(I)=O(K)
      O(K)=L
   90 CONTINUE
   91 DO 94 I=9,H(8)
      IF (H(39)+H(40).EQ.0) GOTO 94
C
C *** CALCULATE INTERATOMIC DISTANCES AND ANGLES ***
C
   92 J=I
      LOG=J.GT.H(36)
      IF (LOG.AND.LOG2) GOTO 95
      LOG=IABS(IFIX(A(I,1)*0.1)).EQ.IABS(IFIX(A(I-1,1)*0.1)).OR.LOG
      IF (LOG .AND. A(I,1).LE.0.) GOTO 94
      IF (LOG) GOTO 93
      CALL UNPACK(J)
      WRITE (IO2,1008) J,G(1),G(2),G(3)
   93 CALL ANDI(J,II,LOG)
C
C *** SEARCH POLYHEDRA ***
C
      IF (A(I,1).LE.0.) GOTO 94
      CALL SEARCH(J,II)
C
   94 CONTINUE
C
   95 IF (H(37)) 97,97,96
   96 CALL SB_WRITE
C
C *** CALCULATE SCALE PARAMETERS ***
C
   97 IF (H(42)+H(43)) 100,100,98
C
C *** PERSPECTIVE VIEW ***
C
   98 B(10)=1E5
      B(12)=1E5
      B(11)=-1E5
      B(13)=-1E5
      DO 99 I=1,H(8)
      B(1)=60./(60.-A(I,4))
      A(I,2)=A(I,2)*B(1)
      A(I,3)=A(I,3)*B(1)
      B(10)=AMIN1(B(10),A(I,2))
      B(11)=AMAX1(B(11),A(I,2))
      B(12)=AMIN1(B(12),A(I,3))
   99 B(13)=AMAX1(B(13),A(I,3))
C
  100 B(14)=ABS(B(10)-B(11))
      B(15)=ABS(B(12)-B(13))
      B(16)=B(14)*0.5
      B(17)=B(15)*0.5
      B(18)=(B(10)+B(11))*0.5
      B(19)=(B(12)+B(13))*0.5
      IF (H(46)) 109,109,101
C
C *** CALCULATE SCALE FACTOR ***
C
  101 C(75)=AMIN1(AR1/B(14),AR2/B(15))*FAC*0.9
      C(77)=AR1*0.5
      C(78)=AR2*0.5
C
C *** MOVE ORIGIN TO CENTER OF PLOT AND SCALE COORDINATES ***
C
      DO 107 I=1,H(8)
      A(I,2)=A(I,2)-B(18)
  107 A(I,3)=A(I,3)-B(19)
      IF (H(46)) 109,109,108
C
C *** START PLOT ***
C
  108 B10=(B(10)-B(18))*C(75)
      B11=(B(11)-B(18))*C(75)
      B12=(B(12)-B(19))*C(75)
      B13=(B(13)-B(19))*C(75)
      WRITE (IO2,1016) C(75),C(77),C(78),B10,B11,B12,B13
      CALL DRAW
C
C *** ORIGINAL LINES OF PROGRAM ***
C 109 CALL ENDPL(0)
C     CALL DONEPL
C
  109	CONTINUE
	CALL DRAW_DIALOG( 1, ISTATUS )
	IF (ISTATUS.NE.-10) CALL DRAW_END ! RETURN TO SYSTEM.
      STOP
 1888	FORMAT (1X,1A80)
 1000 FORMAT (///,1X,'DEFAULT RANGE FOR GENERATING ATOMS IS X:',F8.4,1X,
     &'TO',F7.4,/,39X,'Y:',F8.4,' TO',F7.4,/,39X,'Z:',F8.4,' TO',F7.4)
 1001 FORMAT (2A1,I2,5X,3F10.5)
 1002 FORMAT (2A1,I2,26X,3F10.6)
 1018 FORMAT (1X,'ONLY 3000 ATOMS CAN BE REPRESENTED AS CIRCLES, JOB IS
     &TERMINATED')
 1003 FORMAT (2A1,I2,3F10.6)
 1004 FORMAT (80A1)
 1005 FORMAT (1X,'(',I4,')',5X,2A1,I3,3F10.5,5X,3F10.5)
 1006 FORMAT (1X,'(',I4,')',5X,2A1,I3,3F10.5,5X,3F10.5,5X,'ATOM IS NOT G
     &RAPHED')
 1007 FORMAT (3X,'NO',7X,'ATOM',6X,'X/A',7X,'Y/B',7X,'Z/C',12X,'XO',8X,
     &'YO',9X,'ZO',/,'--------------------------------------------------
     &--------------------------------')
 1008 FORMAT (///,1X,'DISTANCES TO ATOM (',I4,')',1X,2A1,I2,//,3X,'NO',
     &5X,'NAME',10X,'DIST.'/,1X,'-----------------------------')
 1009 FORMAT (///,1X,'ORIGIN SPECIFICATION',//)
 1010 FORMAT (///,1X,'FRACTIONAL AND ORTHOGONAL COORDINATES OF ATOMS INS
     &IDE THE UNIT CELL',//)
 1011 FORMAT (///,1X,'FRACTIONAL AND ORTHOGONAL COORDINATES OF ATOMS OUT
     &SIDE THE UNIT CELL',//)
 1012 FORMAT ('1')
 1013 FORMAT (///,1X,'GIVEN RANGE FOR GENERATING ATOMS IS X:',F8.4,1X,
     &'TO',F7.4,/,37X,'Y:',F8.4,' TO',F7.4,/,37X,'Z:',F8.4,' TO',F7.4)
 1014 FORMAT (///,1X,'THE CRYSTAL STRUCTURE IS CENTROSYMMETRIC WITH CENT
     &RE IN THE ORIGIN')
 1015 FORMAT (///,1X,'THERE IS NO CENTRE IN THE ORIGIN OF THE CRYSTAL ST
     &RUCTURE')
 1016 FORMAT (///,1X,'AFTER SCALING WITH FAC=',F6.3,'AND MOVING THE ORIG
     &IN TO',2F6.2,' LEFT AND RIGHT LIMITS FOR THE COORDINATES ARE:',/,
     &'X=',F6.2,' TO ',F6.2,' AND UPPER AND LOWER LIMITS: Y=',F6.2,
     &' TO ',F6.2,///)
	END
C**************************************************************************
      BLOCK DATA

	IMPLICIT INTEGER*4 (I-N), REAL*4 (A-H,O-Z)

      COMMON/ALL/A,B,IO1,IO2,IO3,IO4,CR
      COMMON/ADD/NH(50,3),P(10),TIT(17),IS,BL
      COMMON/MODI/ID,P1,P2,A1,A2,O1,O2,RES,FAC
      DIMENSION A(7650)
      INTEGER*4 B(3278), CR(7), BL(1)

      DATA ID,P1,P2,A1,A2,O1,O2,RES,FAC/1,27.,18.,26.,16.,0.,0.,.03,1./

      DATA NH/1,49*0,3000,49*0,9,49*0/, P/10*-1E30/, IS/1/, BL/'    '/

      DATA A/439010.,439020.,439030.,439040.,439050.,439060.
     &,439070.,439080.,1493*0.,1.,2*0.,2*1.,0.,1.,1494*0.,1.,0.,1.,
     &0.,2*1.,1495*0.,1.,0.,3*1.,1495*0.,1.,3*0.,1.,3*0.,1.,12*0.,
     &6*-1E30,109.,20.,1.62,0.2,15.,3*0.,90.,20.,1.97,0.4,15.,
     &3*0.,3*10.,3*90.,6*-1.,1.745329E-02,57.29578,1.,0.,0.,1.,0.,
     &2*1.,0.,0.,1.,0.,1.,3*0.,1.,3*0.,1.,3*0.,3*1.,0.,1.,0.,1.,0.,5*1.,
     &21.05,29.75,1.,100.,40.,15.,10*1.,3.2,4.,
     &30*-1E30,154*0.,1.,191*0.,1.,191*0.,1.,967*0./
      DATA B/3*0,2*1,2*0,8,4,156,356,13*0,4403,8*0,1,4*0,3*1,2*0,1,0,
     &3*1,4*2,4*7,2*2,3,2,2*3,4,5,2*3,5,4,2*3,2*4,5,4,2*6,4,5,2*6,4,3*5,
     &' ','+','0','1','2','3','4','5','6','7','8','9','.','-',';',
     &',','(',')','P','I','F','C','B','A','R','D','E','G','H','J','K',
     &'L','M','N','O','Q','S','T','U','V','W','X','Y','Z','TI','CE','SY'
     &,'SP','FO','AD','OM','RO','TE','OC','CI','XY','BO','EN','PA','FI',
     &'MO','VI','SH',7*'  ',156*' ',300*0,1144*-1,1500*0,1,2,5,3,1,4,6,8
     &,7,2,5,3,2,5,3,1,4,6,8,7,4,6,8,7/
      DATA IO1,IO2,IO3,IO4/41,10,41,42/
      DATA CR/'(C) ','REIN','HARD',' X. ','FISC','HER ','1984'/
      END
C**************************************************************************
      SUBROUTINE DRAW

	IMPLICIT INTEGER*4 (I-N), REAL*4 (A-H,O-Z)

      COMMON/PLOR/FXOR,FYOR
      COMMON/ALL/A,B,C,D,E,F,G1,G2,R,G3,H,M,N,O,P,Q,
     *	IO1,IO2,IO3,IO4,CR
      COMMON/ADD/NH(50,3),PP(10),TIT(17),IS,BL
      COMMON/MODI/ID,PA1,PA2,AR1,AR2,OR1,OR2,RES,FAC
      DIMENSION A(1500,4),B(24),C(90),D(40),R(200,3)
      INTEGER E(11,2),F(6),G1(100),G2(100),G3(600),H(68),Z(28)
      INTEGER M(48),N(12,3),O(70),P(200,8),Q(1524)
	INTEGER*4 CR(7)


C************** VARIABLES FOR DRAW ****************

	INCLUDE '../draw_defs.for'


C**************************************************
      INTEGER ICODE, IPEN, NN2, NN3, DCUNIT, L
      LOGICAL LOG, BSCALE
	CHARACTER*68 TITLE
	EQUIVALENCE (TIT,TITLE)
      EQUIVALENCE (E(1,1),Z(1))
      NN2=1
      NN3=0

C************* INIT DRAW WORKSTATION ******************

	CALL DRAW_INIT( X_PAPER, Y_PAPER, DCUNIT, 'STRUPLO' )

	L = 60
	DO WHILE (L.GT.0.AND.TITLE(L:L).GT.' ')
	  L = L - 1
	END DO

	IF (L.GT.0) THEN
	  TITLE = TITLE(1:L)
	ELSE
	  TITLE = ' '
	  L = 1
	END IF

	BSCALE = DRAW_PICTURE( TITLE(1:L), PA1, PA2, .TRUE., .TRUE. )

	CALL DRAW_ORG( PA1/2.0, PA2/2.0, 0 )

C ************************************************************
C ***                                                      ***
C *** START MAIN ROUTINE FOR DRAWING CIRCLES AND POLYHEDRA ***
C ***                                                      ***
C ************************************************************
C
    3 H(1)=0
      H(2)=0
      D(23)=0.
      D(24)=0.
      IF (M(48)) 5,5,4
    4 CALL OUTLIN
      IF (M(34).NE.0) GOTO 5
      DO 100 I=1,M(37)-1
      DO 100 J=I+1,M(37)
      DD=SQRT((A(P(I,1),2)-A(P(J,1),2))**2+
     &        (A(P(I,1),3)-A(P(J,1),3))**2+
     &        (A(P(I,1),4)-A(P(J,1),4))**2)
      IF (DD.GT.4.) GOTO 100
      CALL DRAW_PLOT(A(P(I,1),2)*C(75),A(P(I,1),3)*C(75),NN3)
      CALL DRAW_PLOT(A(P(J,1),2)*C(75),A(P(J,1),3)*C(75),NN2)
  100 CONTINUE
    5 IF (H(1)-M(37)) 6,47,47
    6 IF (H(2)-M(7)) 7,8,8
    7 IF (A(P(H(1)+1,1),4)-A(Q(H(2)+1),4)) 48,48,8
C
C ***********************
C *** DRAW POLYHEDRON ***
C ***********************
C
    8 H(1)=H(1)+1
      IF (M(34).EQ.0) GOTO 5
      DO 9 I=1,28
    9 Z(I)=-1
      IF (P(H(1),7)) 10,10,11
   10 H(12)=9
      H(13)=12
      GOTO 12
   11 H(12)=1
      H(13)=8
   12 CALL OBSC
C
C *** CHECK OVERLAPS ***
C
C *** A) WITH OTHER POLYHEDRA ***
C
      H(4)=0
      H(5)=0
      B(6)=FLOAT(P(H(1),8))*1E-3
      IF (H(1)-1) 5,16,13
   13 DO 15 I=1,H(1)-1
      B(7)=FLOAT(P(I,8))*1E-3
      B(4)=A(P(I,1),2)
      B(5)=A(P(I,1),3)
      B(8)=SQRT((B(1)-B(4))**2+(B(2)-B(5))**2)
      IF (B(8)-B(6)-B(7)) 14,15,15
   14 H(4)=H(4)+1
      G1(H(4))=I
   15 CONTINUE
C
C *** B) WITH CIRCLES ***
C
   16 IF (H(2)) 20,20,17
   17 DO 19 I=1,H(2)
      B(4)=A(Q(I),2)
      B(5)=A(Q(I),3)
      B(7)=RAD(IFIX(A(Q(I),1)))
      B(8)=SQRT((B(1)-B(4))**2+(B(2)-B(5))**2)
      IF (B(8)-B(6)-B(7)) 18,19,19
   18 H(5)=H(5)+1
      G2(H(5))=I
   19 CONTINUE
C
C *** SEND LINE PARAMETERS TO INTER ***
C
   20 K=17
C
C *** COUNT LINES ***
C
      DO 21 I=1,10
      IF (E(I+1,1)) 22,22,21
   21 CONTINUE
      I=11
C
C *** SEND LINE PARAMETERS TO INTER AND CHECK OUTLINES ***
C
   22 H(10)=3
      DO 27 J=1,I
      B( 9)=A(E(J,1),2)
      B(10)=A(E(J,1),3)
      B(11)=A(E(J,2),2)
      B(12)=A(E(J,2),3)
      D(13)=B(1)
      D(14)=B(2)
      D(15)=0.5*(B( 9)+B(11))
      D(16)=0.5*(B(10)+B(12))
      D(21)=(D(13)-D(15))**2+(D(14)-D(16))**2
      DO 26 L=1,I
      IF (J-L) 23,26,23
   23 D(17)=A(E(L,1),2)
      D(18)=A(E(L,1),3)
      D(19)=A(E(L,2),2)
      D(20)=A(E(L,2),3)
      CALL INTLL
      IF (ABS(D(5)-0.5)-0.5) 24,24,26
   24 IF (D(6)) 26,25,25
   25 D(22)=(D(13)-D(1))**2+(D(14)-D(2))**2
      IF (D(22)-D(21)) 26,26,27
   26 CONTINUE
      K=K+1
      H(K)=J
   27 CALL INTER
      IF (M(41)) 36,28,28
C
C *** SHADE POLYHEDRON ***
C
   28 H(10)=1
      DO 35 I=1,6
      IF (F(I)) 36,36,29
   29 H(7)=N(F(I),1)
      H(8)=N(F(I),2)
      H(9)=N(F(I),3)
      D(25)=0.
      D(26)=0.
      IF (A(P(H(1),H(7)),4)-A(P(H(1),H(8)),4)) 30,30,31
   30 J=H(7)
      H(7)=H(8)
      H(8)=J
   31 IF (A(P(H(1),H(7)),4)-A(P(H(1),H(9)),4)) 32,32,33
   32 J=H(7)
      H(7)=H(9)
      H(9)=J
   33 D(27)=A(P(H(1),H(7)),2)
      D(28)=A(P(H(1),H(7)),3)
      D(29)=A(P(H(1),H(8)),2)
      D(30)=A(P(H(1),H(8)),3)
      D(31)=A(P(H(1),H(9)),2)
      D(32)=A(P(H(1),H(9)),3)
      D(33)=D(29)-D(27)
      D(34)=D(30)-D(28)
      D(35)=D(31)-D(27)
      D(36)=D(32)-D(28)
      JN=9
      STEP=0.1
      DO 600 II=1,IS
      IF (H(1).LT.NH(II,1) .OR. H(1).GT.NH(II,2)) GOTO 600
      JN=NH(II,3)
      STEP=1./FLOAT(JN+1)
      GOTO 601
  600 CONTINUE
  601 IF (JN.LE.0) GOTO 35
      DO 34 J=1,JN
      D(37)=J*STEP
      B( 9)=D(27)+D(37)*D(33)
      B(10)=D(28)+D(37)*D(34)
      B(11)=D(27)+D(37)*D(35)
      B(12)=D(28)+D(37)*D(36)
   34 CALL INTER
   35 CONTINUE
C
C *** SORT OUTLINES ***
C
   36 L=3
      P(H(1),2)=E(H(18),1)
      P(H(1),3)=E(H(18),2)
   37 DO 43 I=19,K
      IF (H(I)) 43,43,38
   38 IF (E(H(I),1)-P(H(1),L)) 40,39,40
   39 L=L+1
      P(H(1),L)=E(H(I),2)
      GOTO 42
   40 IF (E(H(I),2)-P(H(1),L)) 43,41,43
   41 L=L+1
      P(H(1),L)=E(H(I),1)
   42 H(I)=-1
      IF (L-7) 37,45,44
   43 CONTINUE
      P(H(1),L)=-1
      GOTO 45
   44 WRITE (IO2,1000)
      STOP
   45 IF (P(H(1),2)-P(H(1),L)) 85,46,85
   46 P(H(1),L)=-1
      GOTO 85
C
C ********************
C ***              ***
C *** DRAW CIRCLES ***
C ***              ***
C ********************
C
   47 IF (H(2).GE.M(7)) GOTO 85
   48 H(2)=H(2)+1
      B(1)=A(Q(H(2)),2)
      B(2)=A(Q(H(2)),3)
      B(3)=RAD(IFIX(A(Q(H(2)),1)))
      H(4)=0
      H(5)=0
      IF (M(34).EQ.0) GOTO 52
      IF (H(1)) 52,52,49
C
C *** CHECK OVERLAPS WITH POLYHEDRA ***
C
   49 DO 51 I=1,H(1)
      B( 8)=FLOAT(P(I,8))*0.01
      D(11)=A(P(I,1),2)
      D(12)=A(P(I,1),3)
      IF ((B(1)-D(11))**2+(B(2)-D(12))**2-B(3)-B(8)) 50,51,51
   50 H(4)=H(4)+1
      G1(H(4))=I
   51 CONTINUE
   52 IF (H(2)-1) 58,58,53
C
C *** CHECK OVERLAPS WITH OTHER CIRCLES ***
C
   53 DO 57 I=1,H(2)-1
      B(8)=RAD(IFIX(A(Q(I),1)))
      B(5)=A(Q(I),2)
      B(6)=A(Q(I),3)
      D(40)=SQRT((B(1)-B(5))**2+(B(2)-B(6))**2)
      IF (D(40)-B(3)-B(8)) 54,57,57
   54 IF (D(40)-1E-3) 55,55,56
   55 IF (D(40)+ABS(B(3)-B(8))-1E-3) 85,85,57
   56 H(5)=H(5)+1
      G2(H(5))=I
   57 CONTINUE
C
C *** SET STARTING POINT ***
C
   58 H(15)=2
      R(1,1)=B(1)
      R(1,2)=B(2)+B(3)
      R(1,3)=0.
      R(2,1)=R(1,1)
      R(2,2)=R(1,2)
      R(2,3)=360.
      IF (M(34).EQ.0) GOTO 69
      IF (H(4)) 69,69,59
C
C *** CALCULATE OVERLAPS WITH POLYHEDRA ***
C
   59 B(19)=B(1)
      B(20)=B(2)
      DO 68 I=1,H(4)
      LOG=.FALSE.
      H(16)=6
      DO 67 J=2,7
      IF (P(G1(I),J+1).GT.0) GOTO 60
      H(16)=J-1
      LOG=.TRUE.
   60 B( 9)=A(P(G1(I),J),2)
      B(10)=A(P(G1(I),J),3)
      H(13)=J-1
      H(14)=MOD(H(13),H(16))+2
      B(11)=A(P(G1(I),H(14)),2)
      B(12)=A(P(G1(I),H(14)),3)
      CALL INTCL
      IF (ABS(D(5)-0.5)-0.5) 61,61,63
   61 H(15)=H(15)+1
      R(H(15),1)=D(1)
      R(H(15),2)=D(2)
      D(25)=D(1)-B(1)
      D(26)=D(2)-B(2)
      R(H(15),3)=ACOS((D(26)/SQRT(D(25)*D(25)+D(26)*D(26))))*C(36)
      IF (D(25)) 62,62,63
   62 R(H(15),3)=360.-R(H(15),3)
   63 IF (ABS(D(6)-0.5)-0.5) 64,64,66
   64 H(15)=H(15)+1
      R(H(15),1)=D(3)
      R(H(15),2)=D(4)
      D(25)=D(3)-B(1)
      D(26)=D(4)-B(2)
      R(H(15),3)=ACOS((D(26)/SQRT(D(25)*D(25)+D(26)*D(26))))*C(36)
      IF (D(25)) 65,65,66
   65 R(H(15),3)=360.-R(H(15),3)
   66 IF (LOG) GOTO 68
   67 CONTINUE
   68 CONTINUE
   69 IF (H(5)) 75,75,70
C
C *** CALCULATE OVERLAPS WITH CIRCLES ***
C
   70 DO 74 I=1,H(5)
      B(5)=A(Q(G2(I)),2)
      B(6)=A(Q(G2(I)),3)
      B(8)=RAD(IFIX(A(Q(G2(I)),1)))
      CALL INTCC
      H(15)=H(15)+1
      R(H(15),1)=D(1)
      R(H(15),2)=D(2)
      D(25)=D(1)-B(1)
      D(26)=D(2)-B(2)
      R(H(15),3)=ACOS((D(26)/SQRT(D(25)*D(25)+D(26)*D(26))))*C(36)
      IF (D(25)) 71,71,72
   71 R(H(15),3)=360.-R(H(15),3)
   72 H(15)=H(15)+1
      R(H(15),1)=D(3)
      R(H(15),2)=D(4)
      D(25)=D(3)-B(1)
      D(26)=D(4)-B(2)
      R(H(15),3)=ACOS((D(26)/SQRT(D(25)*D(25)+D(26)*D(26))))*C(36)
      IF (D(25)) 73,73,74
   73 R(H(15),3)=360.-R(H(15),3)
   74 CONTINUE
C
C *** SORT INTERSECTIONS ***
C
   75 CALL SORT
C
C *** CHECK OBSCURING OF SEGMENTS ***
C
      DO 84 I=2,H(15)
      B(11)=R(I,3)-R(I-1,3)
      B(12)=R(I,3)-B(11)*0.5
      B(23)=B(3)*SIN(B(12)*C(35))+B(1)
      B(24)=B(3)*COS(B(12)*C(35))+B(2)
      IF (M(34).EQ.0) GOTO 78
      IF (H(4)) 78,78,76
   76 DO 77 J=1,H(4)
      H(3)=G1(J)
      CALL INOUT
      IF (H(17)) 84,84,77
   77 CONTINUE
   78 IF (H(5)) 81,81,79
   79 DO 80 J=1,H(5)
      IF (SQRT((B(23)-A(Q(G2(J)),2))**2+(B(24)-A(Q(G2(J)),3))**2)-
     &RAD(IFIX(A(Q(G2(J)),1)))) 84,84,80
   80 CONTINUE
C
C *** DRAW SEGMENT ***
C *** CIRCLES ARE DRAWN 3X WITH DO LOOP 83; REMOVE C AND ERASE 2. 81 ***
C
C  81 C(6)=B(3)-2.*RES
   81 C(6)=B(3)-RES
C     DO 83 J=1,3
      C(6)=C(6)+RES
      CALL DRAW_PLOT(R(I-1,1)*C(75),R(I-1,2)*C(75),NN3)
      H(24)=IFIX(B(11)*C(35)*C(6)/0.02)
      IF (H(24)-1) 84,84,82
   82 D(30)=B(11)/FLOAT(H(24))
      D(31)=R(I-1,3)
      DO 83 K=1,H(24)
      D(31)=D(31)+D(30)
      D(32)=B(3)*SIN(D(31)*C(35))+B(1)
      D(33)=B(3)*COS(D(31)*C(35))+B(2)
   83 CALL DRAW_PLOT(D(32)*C(75),D(33)*C(75),NN2)
   84 CONTINUE
   85 IF (H(1).LT.M(37).OR.H(2).LT.M(7)) GOTO 5
      RETURN
 1000 FORMAT (///,1X,'AN ERROR OCCURED IN DETERMINATION OF POLYHEDRAL OU
     &TLINES, THE JOB IS TERMINATED')
      END
C**************************************************************************
      SUBROUTINE DRAWL

	IMPLICIT INTEGER*4 (I-N), REAL*4 (A-H,O-Z)

      COMMON/ALL/A,B,C,D,E,F,G,IO1,IO2,IO3,IO4,CR
      DIMENSION CR(7),A(6000),B(24),C(90),D(40),E(1428)
      INTEGER*4 F(68),G(3278)
      INTEGER*4 NN2,NN3
C
      NN2=1
      NN3=0
      IF ((D(23)-B(9))**2+(D(24)-B(10))**2-1E-4) 2,2,1
    1 D(23)=B(9)
      D(24)=B(10)
      CALL DRAW_PLOT(D(23)*C(75),D(24)*C(75),NN3)
    2 IF (F(10)-1) 3,3,4
    3 CALL DRAW_PLOT(B(11)*C(75),B(12)*C(75),NN2)
C
C *** DELETE NEXT TWO LINES IF EVERY LINE SHOULD BE DRAWN ONLY ONCE ***
C
C     CALL DRAW_PLOT(D(23)*C(75),D(24)*C(75),2)
C     CALL DRAW_PLOT(B(11)*C(75),B(12)*C(75),2)
      GOTO 5
    4 D(10)=D(23)-B(12)
      D(11)=B(11)-D(24)
      D(12)=0.012/SQRT(D(10)*D(10)+D(11)*D(11))
      D(10)=D(10)*D(12)
      D(11)=D(11)*D(12)
      CALL DRAW_PLOT(B(11)*C(75),B(12)*C(75),NN2)
      CALL DRAW_PLOT((B(11)+D(10))*C(75),(B(12)+D(11))*C(75),NN2)
      CALL DRAW_PLOT((D(23)+D(10))*C(75),(D(24)+D(11))*C(75),NN2)
      CALL DRAW_PLOT((D(23)-D(10))*C(75),(D(24)-D(11))*C(75),NN2)
      CALL DRAW_PLOT((B(11)-D(10))*C(75),(B(12)-D(11))*C(75),NN2)
    5 D(23)=B(11)
      D(24)=B(12)
      RETURN
      END
C**************************************************************************
	SUBROUTINE READ_LINE( IO, BUFFER, FE )
	INTEGER IO
	CHARACTER*80 BUFFER
	LOGICAL FE

	INTEGER I

	READ(IO, 500, END=90) BUFFER
  500	FORMAT(1A80)

	DO I = 1, 80
	  IF (BUFFER(I:I).LT.' '.OR.BUFFER(I:I).GT.CHAR(126))
     &	 BUFFER(I:I) = ' '
	ENDDO
	FE = .FALSE.
	RETURN

   90	FE = .TRUE.
	RETURN
	END

C**************************************************************************
      SUBROUTINE SB_READ

	IMPLICIT INTEGER*4 (I-N), REAL*4 (A-H,O-Z)

      COMMON/ALL/A,B,C,D,E,F,G,H,M,N,O,IO1,IO2,IO3,IO4,CR
      COMMON/ADD/NH(50,3),PP(10),TIT(17),IS,BL
      COMMON/MODI/ID,PM,RES,FAC
      DIMENSION CR(7),A(1500,4),B(24),C(90),D(40),E(48,3,4),F(5,15,12)
      DIMENSION P(1524),PM(6)
      INTEGER*4 G(20)
      INTEGER*4 H(84),M(70),N(1600),O(1524)
      LOGICAL LOG,LOG2,LOG3
	CHARACTER*80 LINE

	LOGICAL FEND

      EQUIVALENCE (O(1),P(1))

      WRITE (IO2,1000)
      WRITE (IO2,1001) IO1
      WRITE (IO2,1013)

C
C *** READ ALL OPTIONS ***
C

	CALL READ_LINE( IO1, LINE, FEND )
	READ( LINE, 100 ) TIT

C     READ (IO1,100) TIT
  100 FORMAT (17A4)
      WRITE (IO2,103) TIT
	IF(TIT(17).NE.BL) WRITE(IO2,101)
  101	FORMAT(1X,'* !!! THE TITLE IS TRUNCATED TO 60 CHARACTERS !!!')
	DO 102 I=2,12
  102	TIT(I-1)=TIT(I)
	TIT(16)=BL
	TIT(17)=BL
  103 FORMAT (1X,'* ',16A4)
      IS=0
    1	CALL READ_LINE( IO1, LINE, FEND )
	READ( LINE, 1002 ) (N(I),I=1,78)

	WRITE(6,888) LINE
  888	FORMAT(1X,A80)

C   1 READ (IO1,1002) (N(I),I=1,78)
      WRITE (IO2,1003) (N(I),I=1,78)
      LOG3=.FALSE.
      DO 2 I=1,19
    2 IF (N(1).EQ.M(I+44)) GOTO (3,5,7,8,9,10,13,16,18,20,22,38,42,
     &46,47,65,66,68,70),I
      WRITE (IO2,1004) N(1),N(2)
      GOTO 1
C
C *** STORE TITLE ***
C
    3 DO 4 I=3,78
    4 N(I+76)=N(I)
      GOTO 1
C
C *** STORE LATTICE CONSTANTS ***
C
    5 CALL READN
      DO 6 I=1,6
    6 C(I+22)=D(I)
      GOTO 1
C
C *** STORE SYMMETRY OPERATORS ***
C
    7 CALL READS
      GOTO 1
C
C *** GENERATE SYMMETRY OPERATORS ***
C
    8 CALL SPGR
      GOTO 1
C
C *** STORE NUMBER OF ATOMS AND INPUT FORMAT ***
C
    9 H(1)=1
      CALL READN
      H(9)=D(1)
      GOTO 1
C
C *** STORE ADDED ATOMS ***
C
   10 CALL READN
C     DO 12 I=1,30
C ----DO Loop Begin - Modif P. Wolfers To compatibility with F77 -------------
      I = 1
  810	  IF (D(I)) 1,1,11
   11   H(10)=H(10)+1
C
        NOMA=2147483647
        IF (D(I).GT.NOMA) THEN
          D(I)=2147483000.
        ELSE
          IF (D(I).LT.-NOMA) THEN
	      D(I)=-2147483000.
          END IF
        END IF
C
   12   N(H(10))=IFIX(D(I))
	  I = I + 1
	IF (I.LE.30) GOTO 810
C ----DO Loop nd - - Modif P. Wolfers To compatibility with F77 -------------
      GOTO 1
C
C *** STORE OMITTED ATOMS ***
C
   13 CALL READN
      DO 15 I=1,30
      IF (D(I)+1E20) 1,1,14
   14 H(11)=H(11)+1
   15 N(H(11))=IFIX(D(I))
      GOTO 1
C
C *** STORE ROTATION ANGLES OR VIEW DIRECTION ***
C
   16 CALL READN
      H(6)=1
      DO 17 I=1,3
   17 B(I+3)=D(I)
      GOTO 1
C
C *** STORE TETRAHEDRA CONSTANTS ***
C
   18 CALL READN
      H(12)=1
      DO 19 I=1,8
   19 C(I+6)=D(I)
      GOTO 1
C
C *** STORE OCTAHEDRA CONSTANTS ***
C
   20 CALL READN
      H(13)=1
      DO 21 I=1,8
   21 C(I+14)=D(I)
      GOTO 1
C
C *** STORE CIRCLE NUMBERS ***
C
   22 CALL READN
      H(35)=H(35)+1
      C(H(35)+78)=D(1)
      I=2
      LOG=.FALSE.
      IF (D(35).GT.0.0) GOTO 35
   23 K=0
   24 I=I+1
      IF (I-78) 25,25,1
   25 IF (N(I).EQ.M(1)) GOTO 24
      DO 26 J=19,44
   26 IF (N(I).EQ.M(J)) GOTO 27
      IF (.NOT.LOG) GOTO 24
      WRITE (IO2,1012) N(I),H(35)
      STOP
   27 LOG=.TRUE.
      IF (N(I+1).NE.M(1)) GOTO 28
      L=45
      GOTO 31
   28 DO 29 L=19,44
   29 IF (N(I+1).EQ.M(L)) GOTO 30
      WRITE (IO2,1012) N(I+1),H(35)
      STOP
   30 IF (N(I+2).EQ.M(1)) GOTO 31
      WRITE (IO2,1015) N(I),N(I+1),N(I+2)
      STOP
   31 K=((J-19)*27+(L-18))*100+H(35)
      H(38)=H(38)+1
      IF (H(38).LT.44) GOTO 32
      WRITE (IO2,1016)
      STOP
   32 N(H(38)+556)=K
      I=I+1
      GOTO 23
C  34 DO 36 I=2,30
C ----DO Loop Begin - Modif P. Wolfers To compatibility with F77 -------------
   34 I = 2
  834 H(7)=H(7)+1
        IF (H(7).GE.100) THEN
          WRITE (IO2,1017)
          STOP
	  END IF
   35   IF (D(I)+1E10.LE.0.0) GOTO 37
   36   N(H(7)+456)=D(I)
        I = I + 1
      IF (I.LE.30) GOTO 834
C -----DO Loop End - - Modif P. Wolfers To compatibility with F77 ------------
      H(7)=H(7)+1
      IF (H(7).LT.100) GOTO 37
      WRITE (IO2,1017)
      STOP
   37 N(H(7)+456)=-10000*H(35)
      GOTO 1
C
C *** STORE XYZ-RANGE ***
C
   38 CALL READN
      DO 39 I=1,6
   39 C(I)=D(I)
      H(45)=1
      IF (D(7)+1E20) 1,1,40
   40 DO 41 I=7,12
   41 C(I+22)=D(I)
      H(45)=2
      GOTO 1
C
C *** INTERPRET AND STORE BONDLENGTH AND TOLERANCE ***
C
   42 CALL READN
      N(1)=D(1)
      N(2)=IABS(N(1))
      IF (N(2)) 45,45,43
   43 H(N(2)+13)=H(N(2)+13)+1
      F(N(2),H(N(2)+13),1)=SIGN(D(2),D(1))
      DO 44 I=3,12
      IF (D(I)) 1,1,44
   44 F(N(2),H(N(2)+13),I-1)=D(I)
      GOTO 1
   45 C(32)=D(2)
      C(33)=D(3)
      C(34)=D(4)
C
C *** THE END MARK HAS BEEN READ, RETURN TO MAIN ***
C
   46 WRITE (IO2,1013)
      WRITE (IO2,1014)
      RETURN
C
C *** STORE PLOT SPECIFICATIONS ***
C
   47 CALL READN
      DO 48 I=2,7
   48 IF (D(I).LT.-1E2) D(I)=-1.
      IF (D(1)-1E-2) 49,49,50
   49 H(46)=0
   50 FAC=D(1)
C
   51 IF (IFIX(D(2))) 53,52,53
   52 H(44)=0
   53 IF (IFIX(D(3))) 55,54,55
C
   54 H(48)=0
   55 IF (IFIX(D(4))) 57,56,57
C
   56 H(34)=0
   57 IF (IFIX(D(5))) 59,58,59
C
   58 H(39)=0
   59 IF (IFIX(D(6))) 61,60,61
C
   60 H(40)=0
   61 IF (IFIX(D(7))) 63,62,63
C
   62 H(46)=0
   63 IF (D(8)) 1,1,64
C
   64 C(89)=D(8)
      GOTO 1
   65 CALL READN
      IF (D(1).GT.0.) IO1=IFIX(D(1))
      IF (D(2).GT.0.) IO2=IFIX(D(2))
      IF (D(3).GT.0.) IO3=IFIX(D(3))
      IF (D(4).GT.0.) IO4=IFIX(D(4))
      GOTO 1
C
C *** STORE DEVICE AND SCALE PARAMETERS ***
C
   66 CALL READN
      ID=IFIX(D(1))
      DO 67 I=2,7
      IF (D(I).LT.-1E10) GOTO 1
   67 PM(I-1)=D(I)
      GOTO 1
C
C *** STORE VIEW DIRECTION
C
   68 CALL READN
      DO 69 I=1,6
   69 PP(I)=D(I)
      GOTO 1
C
C *** STORE DO LOOP PARAMETERS FOR SHADING  ***
C
   70 CALL READN
      I=1
      H(41)=IFIX(D(I))
   71 I=I+1
      IF (D(I).LT.-1E20) GOTO 11
      IF (D(I+1).GT.-1E20) GOTO 72
      LOG3=.TRUE.
      D(I+1)=-D(I+1)
   72 IS=IS+1
      NH(IS,1)=IFIX(D(I))
      NH(IS,3)=H(41)
      IF (D(I+1)) 73,74,74
   73 NH(IS,2)=-IFIX(D(I+1))
      I=I+1
      GOTO 71
   74 NH(IS,2)=NH(IS,1)
      IF (.NOT.LOG3) GOTO 71
      GOTO 1
C
 1000 FORMAT ('1')
 1001 FORMAT (1X,'***************************** INPUT CONTROL FROM UNIT'
     &,I2,' ****************************')
 1002 FORMAT (2A2,76A1)
 1003 FORMAT (1X,'* ',2A2,76A1,' *')
 1004 FORMAT (1X,'* ||| WARNING ||| THE LAST OPTION ',2A2,' IS IGNORED')
 1005 FORMAT (40A2)
 1006 FORMAT (1X,' ||| WARNING ||| THERE ARE TOO MANY CONSTRAINTS FOR BO
     &NDS')
 1007 FORMAT (20A4)
 1008 FORMAT (2A1,I2,5X,3F10.5)
 1009 FORMAT (2A1,I2,26X,3F10.6)
 1010 FORMAT (2A1,I2,3F10.6)
 1011 FORMAT (80A1)
 1012 FORMAT (1X,' ||| ERROR ||| THE CHARACTER ',A1,' IN OPTION CIRC NO.
     & ',I3,' IS ILLEGAL, THE JOB IS TERMINATED')
 1013 FORMAT (1X,'*',82X,'*')
 1014 FORMAT (1X,'******************************************************
     &******************************')
 1015 FORMAT (1X,3A1,' IS NOT A COMMON ATOM NAME, ONLY 2 LETTERS PER NAM
     &E ARE ACCEPTED, JOB IS TERMINATED')
 1016 FORMAT (1X,'ONLY 44 SPECIFICATIONS ARE ACCEPTED DEFINED IN OPTION
     &CIRC, USE ATOM NUMBERS INSTEAD OF ATOM NAMES AND TRY AGAIN,',/,
     &'JOB IS TERMINATED')
 1017 FORMAT (1X,'THESE ARE TOO MANY CIRCLE SPECIFICATIONS, USE ATOM NA
     &MES INSTEAD OF NUMBERS AND TRY AGAIN',/,
     &'JOB IS TERMINATED')
      END
C**************************************************************************
      SUBROUTINE READN

	IMPLICIT INTEGER*4 (I-N), REAL*4 (A-H,O-Z)

      COMMON/ALL/A,B,C,D,E,F,G,IO1,IO2,IO3,IO4,CR
      DIMENSION CR(7),A(6114),B(40),C(1496)
      INTEGER D(84),E(70),F(1600),G(1524)
      LOGICAL PNT,II

      DO 1 I=3,80
    1 IF (F(I).EQ.E(16)) F(I)=E(13)
      DO 2 I=1,30
    2 B(I)=-1E30
      F(1)=2
      F(2)=0
      B(35)=1.
    3 B(31)=0.
      B(32)=10.
      B(33)=1.
      D(26)=0
      PNT=.FALSE.
      II=.FALSE.
    4 F(1)=F(1)+1
      IF (F(1)-76) 5,5,13
    5 IF (II) GOTO 6
      IF (F(F(1)).EQ.E(1).OR.F(F(1)).EQ.E(2)) GOTO 4
      II=.TRUE.
    6 DO 7 J=3,14
    7 IF (F(F(1)).EQ.E(J)) GOTO 9
      IF (F(F(1)).EQ.E(1)) GOTO 8
      B(35)=-1.
      GOTO 3
    8 F(2)=F(2)+1
      B(F(2))=B(31)*B(33)
      GOTO 3
    9 IF (J-13) 10,11,12
   10 B(34)=1.*J-3.
      IF (PNT) D(26)=D(26)+1
      B(31)=B(31)*B(32)+B(34)/10**D(26)
      GOTO 4
   11 PNT=.TRUE.
      B(32)=1.
      GOTO 4
   12 B(33)=-1.
      GOTO 4
   13 RETURN
      END
C**************************************************************************
      SUBROUTINE READS

	IMPLICIT INTEGER*4 (I-N), REAL*4 (A-H,O-Z)

      COMMON/ALL/A,B,C,D,E,F,G,H,IO1,IO2,IO3,IO4,CR
      DIMENSION CR(7),A(6114),B(40),C(48,3,4),D(920)
      INTEGER E(84),F(70),G(1600),H(1524)
      LOGICAL II
      G(1)=2
      E(5)=E(5)+1
      G(2)=1
      II=.FALSE.
    1 B(1)=1.
    2 G(1)=G(1)+1
      IF (G(1)-78) 3,3,12
    3 IF (G(G(1)).EQ.F(1).OR.G(G(1)).EQ.F(2)) GOTO 2
      IF (G(G(1)).NE.F(16)) GOTO 4
      G(2)=G(2)+1
      GOTO 2
    4 IF (G(G(1)).NE.F(15)) GOTO 5
      E(5)=E(5)+1
      G(2)=1
      GOTO 2
    5 IF (G(G(1)).NE.F(14)) GOTO 6
      B(1)=-1.
      GOTO 2
    6 DO 7 J=4,9
    7 IF (G(G(1)).EQ.F(J)) GOTO 9
      IF (II) WRITE (6,1000)
      DO 8 J=42,44
    8 IF (G(G(1)).EQ.F(J)) GOTO 11
      WRITE (6,1000)
    9 IF (II) GOTO 10
      II=.TRUE.
      B(2)=1.*J-3.
      G(1)=G(1)+2
      GOTO 6
   10 C(E(5),G(2),1)=B(2)/(1.*J-3.)
      II=.FALSE.
      GOTO 2
   11 C(E(5),G(2),J-40)=1.*B(1)
      GOTO 1
   12 RETURN
 1000 FORMAT (1X,'UNKNOWN SYMBOL')
 1001 FORMAT (1X,12F6.2)
      END
C**************************************************************************


                    
