%pragma trace 1;
program Draw_Calibration( input, output );

%include 'PASENV:draw_defs.pas' {, list_on};

const
  { In Pixel/cm. Assume 15" (inch) corresponding to resx = 1024 }
  Def_Pixel_Scale = 1024.0*SQRT( 2 )/(15.0*2.54);

  { Set default for a Postscript/PDF (ADDOBE TradMark) printer }
  Def_PICA_VAL    = 2.54/72.0; { in cm }

var
       bstatus,          bok:         Dbool;
                        unit:     unit_type;

       x_paper,      y_paper,
       d_width,     d_height,
  d_xwp, d_ywp, d_xws, d_yws,
       p_width,     p_height,
  p_xwp, p_ywp, p_xws, p_yws,
  x_sca, y_sca, c_sca, xysca,
     xx,    yy,    vx,    vy:        Dfloat;

  d_xre, d_yre, p_xre, p_yre,
     ix,    iy, status, iret:          Dint;

         sline, d_com, d_nam,
         d_sav, p_com, p_nam: string( 255 );

  filtre:            array[1..1] of ^string;



procedure DRAW_INQUIRE_2V( in_var title: string; var xx, yy: Dfloat );
var
  sdef, sval, smsg: [static] string( 64 );
  status: Dint;

begin
  WRITEV( sdef, xx:10:2, ' ', yy:10:2 );
  repeat
    sval := sdef;
    status := DRAW$GET_STRING( title, sdef, sval );
    if status <= 0 then begin  DRAW$END; PASCAL_EXIT( 2 )  end;
    READV( sval, xx, yy );
    WRITEV( smsg, 'The read values was (', xx:10:2, ', ', yy:10:2, '). That is Correct?' );
    status := DRAW$GET_ANSWERD( smsg )
  until status = 1
end DRAW_INQUIRE_2V;



procedure DRAW_INQUIRE_2V( in_var title: string; var xx, yy: Dint );
var
  sdef, sval, smsg: [static] string( 64 );
  status: Dint;

begin
  WRITEV( sdef, xx:10, ' ', yy:10 );
  repeat
    sval := sdef;
    status := DRAW$GET_STRING( title, sdef, sval );
    if status <= 0 then begin  DRAW$END; PASCAL_EXIT( 2 )  end;
    READV( sval, xx, yy );
    WRITEV( smsg, 'The read values was (', xx:10, ', ', yy:10, '). That is Correct?' );
    status := DRAW$GET_ANSWERD( smsg )
  until status = 1
end DRAW_INQUIRE_2V;


procedure DRAW_SET_SETUP(        wid, hig,                   { Width and Height of surface in cm }
                                 xwp, ywp, xws, yws: Dfloat; { The Window View Port in cm }
                                 nst, nca, nco,              { Station Number, Category, Color }
                                 xre, yre: Dint;             { Resolution (in pixels) }
                          in_var com, nam: string );         { Comment and file name }
var
  fset: text;

begin
  { Create the Setting File }
  REWRITE( fset, nam );

  WRITELN( fset, '!' );
  WRITELN( fset, '! *** Display Setting Generated by DRAW Calibration Program ***' );
  WRITELN( fset, '!' );
  if com.length > 0 then
  begin
    WRITELN( fset, '! * * ', com, ' * *' );
    WRITELN( fset, '!' )
  end;
  WRITELN( fset, 'WS_TYPE       = ', nst:12, '; ! WorkStation code value (0 for Graphic Screen)' );
  WRITELN( fset, 'WS_CATEG      = ', nca:12, '; ! Input+Output Draw Station.' );
  WRITELN( fset, 'COLOR_FLAGS   = ', nco:12, '; ! DRAW_COLORS setting.' );
  WRITELN( fset, 'WS_WIDTH      = ', wid:12:6, '; ! Screen Width in cm.' );
  WRITELN( fset, 'WS_HIGHT      = ', hig:12:6, '; ! Auto adjustment or Real Screen Height.' );
  WRITELN( fset, 'WS_RESOLUTION = ', xre:5, ', ', yre:5, '; ! Screen resolution.' );
  WRITELN( fset, 'WS_BORDERS    = ', xwp:5:1, ', ', ywp:5:1, ';' );
  WRITELN( fset, 'WS_SIZES      = ', xws:5:1, ', ', yws:5:1, ';' );
  WRITELN( fset, '!' );
  WRITELN( fset, '! Kind of interaction.' );
  WRITELN( fset, '!' );
  WRITELN( fset, '!' );
  WRITELN( fset, 'IMMEDIATE_ACTION = 1;' );
  WRITELN( fset, '!' );
  WRITELN( fset, '!' );
  WRITELN( fset, '!' );
  WRITELN( fset, '!         Red  Green  Blue' );
  WRITELN( fset, '!         ***  *****  ****' );
  WRITELN( fset, '!' );
  WRITELN( fset, 'COLOR_0 = 1.00, 1.00, 1.00;     ! WHITE' );
  WRITELN( fset, 'COLOR_1 = 0.00, 0.00, 0.00;     ! BLACK' );
  WRITELN( fset, 'COLOR_2 = 1.00, 0.00, 0.00;     ! RED' );
  WRITELN( fset, 'COLOR_3 = 0.00, 0.00, 1.00;     ! BLUE' );
  WRITELN( fset, 'COLOR_4 = 0.00, 1.00, 0.00;     ! GREEN' );
  WRITELN( fset, 'COLOR_5 = 1.00, 1.00, 0.00;     ! YELLOW' );
  WRITELN( fset, 'COLOR_6 = 0.00, 1.00, 1.00;     ! CYAN' );
  WRITELN( fset, 'COLOR_7 = 1.00, 0.00, 1.00;     ! MAGENTA' );
  WRITELN( fset, '!' );
  WRITELN( fset, '!WS_TITLE     = ''NOUVEAU TITRE''' );
  WRITELN( fset, '!' );

  CLOSE( fset );
end DRAW_SET_SETUP;



procedure DRAW_BEGIN;
var
  Server_On: [static] Dbool := false;

begin
  if Server_On then DRAW$END
               else Server_On := true;
  DRAW$INIT( x_paper, y_paper, unit, 'Draw Metric' );
  DRAW$PICTURE( '', x_paper, y_paper, false, false );
  DRAW$PIC_VIEW( 0 );
  xx := x_paper/2.0; yy := y_paper/2.0;            { Get the Display Canvas Centre coordinates }
  DRAW$ORG( xx, yy, 0 );                           { Origine at centre }
  DRAW$COLOR( 1 );                                 { Color is Black }
  DRAW$TEXT_FONT( 3, 1 );                          { Set a Nice Font }
  DRAW$TEXT_ATTR( 3, 4, 1, 1.0, 0.0 );             { Text is centered on x and y }
  DRAW$LINE_ATTR( 1, 1.0 )                         { Continue Line with thickness of 1.0 }
end DRAW_BEGIN;


{
  GL_POINTS,         /*  0  for  GL Codes */
  GL_LINES,          /* -1 */
  GL_LINE_STRIP,     /* -2, Use by draw_out 1 */
  GL_LINE_LOOP,      /* -3 */
  GL_TRIANGLES,      /* -4 */
  GL_TRIANGLE_STRIP, /* -5 */
  GL_TRIANGLE_FAN,   /* -6 */
  GL_QUADS,          /* -7 */
  GL_QUAD_STRIP,     /* -8 */
  GL_POLYGON         /* -9, Use by draw_out 3 */
}



begin { Draw_Calibration }

  { Initialize the File Setting filtre }
  new( filtre[1], 14 ); filtre[1]^ := '*.draw_setting';



  {****************************************************}
  {     SUPPRESS ANY PREVIOUS DRAW SETTING SYSTEM      }
  {****************************************************}

  d_sav.length := 0;
  iret := GET_LOGICAL( d_sav, 'DRAW_DISPLAY_SETTING' );    { Save the Present Screen Setting reference }

  SET_LOGICAL( 'DRAW_DISPLAY_SETTING', '', 1 );    { Clear the previously defined Settings access }
  SET_LOGICAL( 'DRAW_PRINTER_SETTING', '', 1 );

  { Initialize the Screen to get the Screen Resolution }

  DRAW_BEGIN;                                      { Initial start of the Draw Server }

  if d_sav.length > 0 then
    if DRAW$GET_ANSWERD( 'Do you Want Create the Screen Setting File ?' ) <> 1 then
    begin
      SET_LOGICAL( 'DRAW_DISPLAY_SETTING', d_sav, 1 );
      goto ET_PRINTER
    end;

  d_xre := 1024; d_yre := 768;
  DRAW_INQUIRE_2V( 'Please Enter the Known Resolution of your Screen', d_xre, d_yre );

  { Speculate that d_xre = 1024 corresponding to 15"/2**(1/2) }
  d_width  := d_xre/Def_Pixel_Scale; 
  d_height := d_yre/Def_Pixel_Scale; 

  d_xwp := TRUNC(  d_width*0.05 ); d_xws := ROUND(  d_width*0.90 );
  d_ywp := TRUNC( d_height*0.05 ); d_yws := ROUND( d_height*0.90 );
  d_nam := './tmp_display.draw_setting';

  DRAW_SET_SETUP(  d_width, d_height,              { Width and Height of surface in cm }
                   d_xwp, d_ywp, d_xws, d_yws,     { The Window View Port in cm }
                   1, 3, 1,                        { Station Number 1, Category (IN+OUT=3), Color=Yes }
                   d_xre, d_yre, '', d_nam );      { Resolution (in pixels) and setting file name. }

  { Set the temporary Setup File as Active for the DRAW_SERVER }
  SET_LOGICAL( 'DRAW_DISPLAY_SETTING', d_nam, 1 );
  DRAW_BEGIN;                                      { Restart the DRAW_SERVER }

  DRAW$MEssage( 'Increase the Window as possible to get its accurate sizes, and clic anywhere inside' );
  status := DRAW$GET_POSITION( vx, vy );

  { Plot the Reticle }
  DRAW$COLOR( 0.4, 0.4, 0.6 );
  DRAW$LINE_ATTR( 1, 2.0 );
  DRAW$OUT_MODE( 1 );
  xx := xx*0.99999; yy := yy*0.99999;
  DRAW$PLOT( -0.95*xx, -0.75*yy, false );
  DRAW$PLOT(      -xx, -0.80*yy,  true );
  DRAW$PLOT( -0.95*xx, -0.85*yy,  true );
  DRAW$PLOT(      -xx, -0.80*yy, false );
  DRAW$PLOT(       xx, -0.80*yy,  true );
  DRAW$PLOT(  0.95*xx, -0.85*yy, false );
  DRAW$PLOT(       xx, -0.80*yy,  true );
  DRAW$PLOT(  0.95*xx, -0.75*yy,  true );

  DRAW$PLOT(  0.75*xx, -0.95*yy, false );
  DRAW$PLOT(  0.80*xx,      -yy,  true );
  DRAW$PLOT(  0.85*xx, -0.95*yy,  true );
  DRAW$PLOT(  0.80*xx,      -yy, false );
  DRAW$PLOT(  0.80*xx,       yy,  true );
  DRAW$PLOT(  0.85*xx,  0.95*yy, false );
  DRAW$PLOT(  0.80*xx,       yy,  true );
  DRAW$PLOT(  0.75*xx,  0.95*yy,  true );
  DRAW$PLOT(      0.0,      0.0, false );

  DRAW$COLOR( 3 );                                 { Write in Blue }
  WRITEV( sline, 'Temporary Canvas Size = (', x_paper:8:2, ' * ', y_paper:8:2, ') cm^2.' );
  DRAW$STRING( -xx*0.1, yy*0.80, 0.0, 0.7, sline );

  WRITEV( sline, 'Picture Size = (', vx:8:2, ' * ', vy:8:2, ') pixel^2.' );
  DRAW$STRING( -xx*0.1, yy*0.60, 0.0, 0.7, sline );
  DRAW$STRING( -xx*0.1, yy*0.30, 0.0, 0.7, 'You Must Measure the real Dimensions of the external' );
  DRAW$STRING( -xx*0.1, yy*0.15, 0.0, 0.7, 'frame (The Blue Grey Arrow Line Lengths)' );

  DRAW$COLOR( 1 );

  xx := x_paper; yy := y_paper;
  DRAW_INQUIRE_2V( 'Please, Enter the Measured Size (X and after Y) in cm of the canvas rectangle.', xx, yy );

  { Code for Draw_Picture_Scales :
     0 => xy_scale, cv_scale, # Scales Lpt/User and Scr/Lpt,
     1 => d_xscale, d_yscale, # Screen(Scr) Scales for x and y in Pixel/cm,
     2 => p_xscale, p_yscale, # Printer(Lpt) Scales for x and y in Pixel/cm,
    -1 =>    dt_rx,    dt_ry, # Size of Screen Canvas in pixels,
    -2 =>    pt_rx,    pt_ry, # Size of Printer Canvas in pixels with border,
    -3 =>    ds_rx,    ds_ry, # Size of Screen Canvas in Cm with border,
    -4 =>    ps_rx,    ps_ry, # Size of printer Canvas in Cm,
    -5 =>  d_wight,  d_hight, # Size of Screen in Cm,
    -6 =>  p_wight,  p_hight  # Size of Printer in Cm. }

  DRAW$PICTURE_SCALES(  0, xysca, c_sca );         { Get The actual DRAW Scale user/surface and CV on Screen }
  DRAW$PICTURE_SCALES(  1,    vx,    vy );         { Get The actual DRAW X and y Scales in pixel/(Pseudo-Cm) }

  vx := vx*xysca*c_sca;                            { Take in account the real user scales }
  vy := vy*xysca*c_sca;

  d_width  := d_xre*xx/(x_paper*vx);               { Now, we deduce the size of screen in real Cm. }
  d_height := d_yre*yy/(y_paper*vx);

  d_xwp := TRUNC(  d_width )*0.1;                  { Compute the default DRAW Window Position }
  d_ywp := TRUNC( d_height )*0.1;
  d_xws := ROUND(  d_width*0.8 );                  { Compute the default DRAW Window Size }
  d_yws := ROUND( d_height*0.8 );


  DRAW_INQUIRE_2V( 'Please, Enter the Favourite Initial Sizes of the DRAW Window.', d_xws, d_yws );
  DRAW_INQUIRE_2V( 'Enter the Favourite Initial Position of the DRAW Window.', d_xwp, d_ywp );

  iret := DRAW$GET_STRING( 'If you want insert a screen setup comment, Enter it now', '', d_com );
  if iret <= 0 then d_com.length := 0;

  status := DRAW$SELECT_FILE( 'Screen Display Setup Filename', filtre, 'display.draw_setting', d_nam, iret, 1 );
  if status <= 0 then goto ET_END;

  DRAW_SET_SETUP(  d_width, d_height,              { Width and Height of surface in cm }
                   d_xwp, d_ywp, d_xws, d_yws,     { The Window View Port in cm }
                   1, 3, 1,                        { Station Number 1, Category (IN+OUT=3), Color=Yes }
                   d_xre, d_yre, d_com, d_nam );   { Resolution (in pixels) and setting file name. }

  SET_LOGICAL( 'DRAW_DISPLAY_SETTING', d_nam, 1 ); { Set on this new Display }
  DRAW$MESSAGE( 'Now we Restart the DRAW Server to Use the New DRAW_DISPLAY_SETTING' );

  DRAW_BEGIN;                                      { Restart the Server with the new Display Setting }

  DRAW$COLOR( 3 );                                 { Write in Blue }
  DRAW$STRING( 0.0, yy*0.8, 0.0, 0.6, 'Warning: The Position of window is not' );
  DRAW$STRING( 0.0, yy*0.7, 0.0, 0.6, '         always take in account' );

  DRAW$STRING( 0.0, yy*0.4, 0.0, 0.6, 'You can verify your setup with' );
  DRAW$STRING( 0.0, yy*0.3, 0.0, 0.6, ' the Grid (in View menu)' );
  DRAW$STRING( 0.0, yy*0.1, 0.0, 0.6, 'To Continue on a Printer Setup' );
  DRAW$STRING( 0.0, yy*0.0, 0.0, 0.6, 'select Resume (in File Menu)' );
  DRAW$STRING( 0.0,-yy*0.2, 0.0, 0.6, 'To Continue stop select the exit' );
  DRAW$STRING( 0.0,-yy*0.3, 0.0, 0.6, '(File menu or exit cross)' );

  DRAW$COLOR( 1 );                                 { Return to Black }

  iret := DRAW$DIALOG( 1 );                        { You Can test it }
  if iret < 0 then goto ET_END;

ET_PRINTER:

  { Pass to printer setup file }
  { Default to A4 Postscript Printer }
  p_width  := 21.0;
  p_height := 29.7;

  DRAW_INQUIRE_2V( 'Please, Enter the Paper Size (Default is for A4 sheet).', p_width, p_height );

  p_xre    := TRUNC( p_width /Def_PICA_VAL );
  p_yre    := TRUNC( p_height/Def_PICA_VAL );

  ix := p_xre; iy := p_yre;

  DRAW$MESSAGE( 'You Don''t change the following value if you have a PDF/Postscript Printer' );
  DRAW_INQUIRE_2V( 'The resolutions (or paper unit for PostSrcipt) is.', p_xre, p_yre );

  if (ix = p_xre) and (iy = p_yre) then { PostScript Mode }
  begin
    p_width  := p_xre*Def_PICA_VAL;
    p_height := p_yre*Def_PICA_VAL
  end;

  p_xwp :=           1.0; p_ywp :=            1.0;
  DRAW_INQUIRE_2V( 'Please, Enter the requested Page Margin size (in cm).', p_xwp, p_ywp );
  p_xws := p_width - 2.0*p_xwp; p_yws := p_height - 2.0*p_ywp;

  iret := DRAW$GET_STRING( 'If you want insert a printer setup comment, Enter it now', '', p_com );
  if iret <= 0 then d_com.length := 0;

  status := DRAW$SELECT_FILE( 'Printer Setup Filename', filtre, 'printer.draw_setting', p_nam, iret, 1 );
  if status <= 0 then goto ET_END;

  DRAW_SET_SETUP(  p_width, p_height,              { Width and Height of surface in cm }
                   p_xwp, p_ywp, p_xws, p_yws,     { The Window View Port in cm }
                   2, 2, 1,                        { Station Number 2 (Landscape), Category (OUT=2), Color=Yes }
                   p_xre, p_yre, p_com, p_nam );   { Resolution (in pixels) and setting file name. }

  SET_LOGICAL( 'DRAW_PRINTER_SETTING', p_nam, 1 ); { Set on this Printer Setup }
  DRAW$MESSAGE( 'Now we Restart the DRAW Server to Use the New DRAW_PRINTER_SETTING' );

  DRAW_BEGIN;                                      { Restart the Server with the new Display Setting }

  DRAW$COLOR( 3 );                                 { Write in Blue }
  DRAW$STRING( 0.0, yy*0.5, 0.0, 0.7, 'You can verify your printer setup' );
  DRAW$STRING( 0.0, yy*0.4, 0.0, 0.7, 'with the Grid entry (in View menu)' );
  DRAW$STRING( 0.0, yy*0.2, 0.0, 0.7, 'To Create PDF/PS or EPS File use' );
  DRAW$STRING( 0.0, yy*0.1, 0.0, 0.7, 'Save entry (in File Menu)' );

  DRAW$STRING( 0.0,-yy*0.1, 0.0, 0.7, 'To Continue stop select the exit' );
  DRAW$STRING( 0.0,-yy*0.2, 0.0, 0.7, 'or Resume (File menu or exit cross)' );

  DRAW$COLOR( 1 );                                 { Return to Black }

  iret := DRAW$DIALOG( 1 );                        { You Can test it }

ET_END:

  DRAW$END;                                        { End of Process }
  WRITELN( ' End of Draw Calibration.' )
end Draw_Calibration.
