(*
[inherit (   'LIB:BASIC_ENV_STR',       { string manager }
             'LIB:BASIC_ENV_TXF',       { text file manager }
             'LIB:BASIC_ENV_LST'),      { list file manager }
 environment('LIB:BASIC_ENV_SRC')]      { create the environment file }

module BASIC_ENV_SRC( input,output );   { use input and output }
*)

{ basic environment for source input operation }

{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*            - - -  Source Read  Manager Library  - - -                 *
*                                                                       *
*           - - -   version 2.0-A  -- 31/08/2016   - - -                *
*                                                                       *
*                       For C-Pascal  3.1-B3                            *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Institut Louis Neel                                   *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}



%include      'pasenv:cpas_b__lst_env'; { We use the Listing environment and ... }
%include      'pasenv:cpas_b__err_env'; { ... the Error message environment. }


const
  src_ch_tab           =      CHR( 9 ); { This character is the TAB character here set as *8 column skip (ASCII TAB) }
  src_ch_eof           =      CHR( 4 ); { This character code is used as end_of_source code (EOF ~ ASCII EOT) }
  src_ch_prv           =      CHR( 2 ); { This character code is used as previous text recovery (ASCII STX) }
  src_ch_eoln          =      CHR( 1 ); { This character code is used as end of line code (EOLN ~ ASCII SOH) }
  src_ch_null          =      CHR( 0 ); { This character code is used as a character to ignore (ASCII NUL) }

  src_maxerrline       =             8; { Maximum repported error by line }


type

  { Source state mode flags definitions }
  src_flagty = (src_blist,              { List on if present }
                src_bmacroex,           { Set for macro expansion listing memory }
                src_bphys,              { Set physical output if present }
                src_bterminal,          { Set if prompt is wanted }
                src_stdin,              { Flag for the console mode (the Pascal file is input) }
                src_becho,              { Set echo mode if present }
                src_echerr,             { Set error echo on control terminal }
                src_delete,             { Set if delete on close in required }
                src_toolong,            { Set if present line is too long }
                src_commentflg,         { Set if only spaces or comments found in line }
                src_eolcomment,         { Set for eoln => end of comment }
                src_eoln,               { Set if end of line seen in data mode }
                src_eofrc,              { Set if end of file reached (at end of last line) }
                src_eof,                { Eof seen if set,
                                          (but the last line can be no finished) }
                src_fopen,              { Set when the Source file is opened }

                { *** The next bits can be set by the user application *** }
                src_macro,              { Set if macro file }
                src_autoret,            { Flag for auto return to the parent source (with clos current one) }
                src_autonfree,          { when src_autonfree set, do not free the terminated source }
                src_autopch,            { Flag for SRC_INCHAR to return the last current character }

                src_linemode,           { Set when the data mode is required. When it is set,
                                          each EOLN is tranmit by SRC_INSCHAR as CHR( 1 ) in place of space ' '. }
                src_listbyline,         { Set this bit induces that the current source line is output when
                                          the EOLN is reached but not given by SRC_INCHAR }
                src_userflg1,           { User flag 1, 2, 3 and 4 }
                src_userflg2,
                src_userflg3,
                src_userflg4
               );

  src_comty = ( src_pascomment,         { Pascal comment handling }
                src_plicomment,         { PL/1 and C comment handling }
                src_adacomment,         { Ada comment handling }
                src_lispcomment,        { Lisp comment handling }
                src_nocomment);         { Comment support disable }

  src_flagw    =     set of src_flagty; { Flag word for source }

  src_ptr      =          ^src_context; { Source context pointer definition }



  { * Define the User CallBack function to manage the EOLN and EOF for Macro stream }
  src_callback = ^function(                     { User call back function to call on EOLN/EOF }
                            obj: $wild_pointer  { Pointer to the user macro symbol object }
                          ): str_ptr;           { This function must return a new macro text or nil }


  src_context = record                  { Source context definition }
    src_next,                           { Link to next source }
    src_previous:              src_ptr; { Previous source in command sequence }
    src_wchpt,                          { Word pointer in src_cmdline }
    src_chidx,                          { Character pointer in src_cmdline }
    src_insnb,                          { Source instruction count }
    src_level,                          { Source level for listing }
    src_lstmxlev,                       { Maximum source listing level }
    src_errnb,                          { Number of error in the current line }
    src_linenbr,                        { Line number in this file }
    src_frspos,                         { First valid column to use }
    src_lstpos:                integer; { Last valid column to use }
    src_prvchar,                        { Previous valid character }
    src_curchar,                        { Current valid character }
    src_fchcd,
    src_schcd:                    char; { First and second character code }
    src_coltb: array[1..src_maxerrline] of
                           error_entry; { Column table error entry }
    src_flags:               src_flagw; { Source status flag set }
    src_commentty:           src_comty; { Mode for comment handling }
    src_cmdline:               str_ptr; { Commande line }
    case boolean of
      true:
        (                               { * for real source (not macro mode) * }
          src_prompt:          str_ptr; { Prompt to use if terminal file }
          src_promptf,                  { Prompt file if not output (note: With PASCAL-II, the files are also pointers) }
          src_file:               text  { Text file to use, if not input }
        );
      false:                            { * For macro source file * }
        (
          src_usrcb:      src_callback; { Call back user routine }
          src_mobject:   $wild_pointer; { Pointer to a user macro specific object ... }
          src_macidx:          integer  { Macro index for macro listing generation }
        )
  end;


[external]
var
  def_prompt:                  str_ptr; { Default prompt }

  src_openerr,                          { Source open error code as set by SRC_OPEN_FILE }
  src_maxerror,                         { Maximum number of error before compiler stop }
  src_lstinsnb:                integer; { Last instruction number }

  src_control,                          { Current source file pointer }
  src_cont_base,                        { Basis source file pointer }

  src_hde:                     src_ptr; { Used source list header }

  src_listing:                 lst_ptr; { Listing and error source file pointer }




{**********************************************************}
{**********    SRC ENTRY POINTS DEFINITIONS     ***********}
{**********************************************************}


procedure SRC_FREE( var p: src_ptr );
external;



procedure SRC_CLOSE( var     p:        src_ptr; { Pointer of the Source file to close }
                         bfree: boolean:= true  { When false the Source file structure is preserved }
                   );
external;



function  SRC_FILE_OPEN( in_var   fspc:                 string; { File specification }
                                  bdel: boolean     :=   false; { When true the source file will be deleted on close time }
                                  srcp: src_ptr     :=     nil  { Source file structure pointer (to use a preallocated one) }
                       ): src_ptr;
{ Open a real source file (not a memory macro file) :
  p        Is the pointer of a previous source context that can be re-used
           when it is opened, it will be closed before to open the new source file.
  fspc     Is the file specification (with absolute or relative path), When fspc
           is a zero-length string the source file will be the standard input file.
  bdel     If it is true, the new source file will be deleted on the close time.
  
  On any open error, SRC_OPEN_FILE return nil and src_openerr is the Open File error code,
  else (on open file Success) src_open allocate the source context if p = nil 
  and close a previously opened file. SRC_OPEN_FILE return the pointer of the new source file context.
}
external;



procedure SRC_NEW_SOURCE( in_var  fspc:                 string; { File specification of the new source }
                                  binc: boolean     :=    true; { True: Include the source file, False: new source replace the old one }
                                  bdel: boolean     :=   false  { Delete the new source on the close time }
                       );
{ Open a NEW real source file with automatic link with the presently opened (and selected) source.
  binc      Is true, the new source file is opened as an included file and an
            automatic return is to the previous source is done on the EOF of the new source.
            If binc is false, the previous source is closed and the new one is readden as
            the continuation of the previous one.
  bdel      If true, the new dource file will be deleted on its close time.
}
external;



procedure SRC_SET_MACRO_CB( function CALL_BACK( mp: $wild_pointer ): str_ptr );
external;



procedure SRC_DEL_MACRO_CB;
external;



function SRC_MACRO_OPEN( mtxt:                 str_ptr; { First Macro text pointer }
                         ucbf: src_callback     := nil; { User call back function for macro process }
                         uobj: $wild_pointer    := nil; { User remated macro obeject pointer }
                         fact: boolean  :=        true; { To activate as sub-source of previous source }
                         srcp: src_ptr  :=         nil  { Source file structure pointer (to use a preallocated one) }
                       ): src_ptr;
{ Open a macro source file :
  p is the pointer of the newsource context, txt is the initial source
  line, p1 and p2 are some user free pointer that can be used to specify
  some dat to the user procedure VSR_NEXTSTRING. These pointer are
  respectively stored in the record fields src_mptr_1 and src_mptr_2.
}
external;


procedure SRC_ACTIVE_SOURCE( srcp: src_ptr );
{ Procedure to link and activate the source file (or macro) p^
  as the current source file with an automatic return to The
  previous one when an src_eof character is read by SRC_INSCHAR.
}
external;



function  SRC_RETURN( bfree: boolean ): char;
{
}
external;




{******************************************************}
{*********    error managment procedures  *************}
{******************************************************}


procedure SRC_ERROR(    modnam: error_mdnam;
                        number:     integer;
                      severity: error_sev );
{ to set an error in src processing }
{ must be called for all source errors }
external;


procedure SRC_OUT_MAC_ERROR( procedure OUT_MAC_LINE( var f: text; btt: boolean ) );
{ procedure to output all error messages }
{ For any macro error management }
external;






{******************************************************}
{*******   input line managment procedures  ***********}
{******************************************************}


procedure SRC_GET_INPUTLINE( var f: text; var pstr: str_ptr );
{ Get a line from the specified file }
external;


procedure SRC_PUT_PROMPT( pstr: str_ptr );
{ Generate a string output on the prompt file }
external;


procedure SRC_END_OF_LINE;
{ procedure to output a line with all appropriate  error messages }
{ to called by src_inchar }
external;


function SRC_INCHAR: char;
{ can be used for real (terminal or other device) file text }
{ to get one character from input }
external;


function SRC_NEXT_CHAR: char;
{ can be used to inspect the next character without change the current one }
external;


function SRC_SEARCH_CHAR: char;
{ can be used to look for a following no space character without
  change the current one, until the end of line }
external;



{********************************************************}
{*********    Common initialization routines    *********}
{********************************************************}

procedure SRC_SET_FLAGS( flg: src_flagw; fclr: boolean := false );
external;



procedure SRC_INIT( in_var def_prt, def_src: string );
{ common command source initialization routine }
{ must be called after lst_txf_st_init procedure(s).
  this call open the default listing file as current listing,
  here we assume that this current file is the output error message file.
}
external;



(*
end.
*)

