{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*           * * *   S t a n d a r d   L i b r a r y   * * *             *
*                                                                       *
*                                                                       *
*               ---  Logical Name Manager Routines ---                  *
*                                                                       *
*               ---  Version 3.2-A1 -- 31/10/2017  ---                  *
*       by :                                                            *
*                                                                       *
*             P. Wolfers                                                *
*                 C.N.R.S.                                              *
*                 Institut Neel                                         *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
%pragma trace 0; { Always here: called by PAS__ERROR to do not loop }
module CPAS__LOGICALS;



%include 'PASSRC:cpas__ccdef.pas'{, list_on};




[external 'PAS__ERROR'] procedure ERROR( nerr: integer ); external;



[global 'PAS__GET_ENV_ARRAY']
function PAS__GET_ENV( var ptr: cc__char_ptr; in_var src: string ): integer;
var
  ie:          integer;
  bf:   [static] bufty;
  ch:             char;

begin
  for i := 1 to src.length do
  begin
    ch := src[i];
    if (ch >= 'a') and (ch <= 'z') then ch := CHR( ORD( ch ) - inmin );
    bf[i] := ch
  end;
  bf[src.length+1] := char( 0 );
  ptr := CC__GETENV( bf"address );
  if ptr = nil then ie := -1                    { No translation - Do not find the logical name }
  else
  begin
    ie := 0;
    while ptr^[ie+1] <> char( 0 ) do ie := ie + 1
  end;
  PAS__GET_ENV := ie
end PAS__GET_ENV;



[global 'PAS__GETENV']
function PAS$$GETENV( var trg: string; in_var src: string ): integer;
var
  pt:     cc__char_ptr;
  ie, i:       integer;
  ch:             char;

begin
  ie := PAS__GET_ENV( pt, src );
  if ie <= 0 then
    trg.length := 0                             { No translation - do not find the logical name }
  else
  begin
    i := 1;
    loop
      ch := pt^[i];
    exit if ch = char( 0 ) or i > trg.capacity;
      trg.body[i] := ch;
      i := i + 1
    end;
    if i > trg.capacity then ie := -2
                        else ie :=  0;
    trg.length := i - 1;
  end;
  PAS$$GETENV := ie
end PAS$$GETENV;



function SET_ENV( log, val: buf_ptr; sz1, sz2, ovr: integer ): integer;
var
  ptr: buf_ptr;
  len: integer;
  c:      char;

begin
  if sz1 > 0 then
  begin
    len := sz1 + 1;                             { Compute the "<log>=<val>NUL" string size }
    if sz2 > 0 then len := len + sz2 + 1;
    ptr := MEM$$ALLOC( len );
    for i := 0 to sz1-1 do                      { Force logical Name to be in MAJOR csae }
    begin
      c := log^[i];
      if (c >= 'a') and (c <= 'z') then c := CHR( ORD( c ) - inmin );
      ptr^[i] := c;
    end;
    ptr^[sz1] := CHR( 0 );
    if sz2 > 0 then
    begin                                       { Create a new Environment Variable }
      if ovr = 0 then                           { Does not overwrite }
        if CC__GETENV( ptr ) <> nil then
        begin  MEM$$FREE( ptr ); return 0  end;
      len := sz1;
      ptr^[len] := '='; len := len + 1;
      for i := 0 to sz2-1 do
      begin
        ptr^[len] := val^[i]; len := len + 1
      end;
      ptr^[len] := CHR( 0 )
    end;
    return CC__PUTENV( ptr );
  end
end SET_ENV;



[global 'PAS__SET_ENV_ARRAY']
function PAS__SET_ENV( in_var log: string;
                       in_var val: array[dim: integer] of char; sz, ovr: integer ): integer;
var
  ie:          integer;
  bf:   [static] bufty;
  ch:             char;

begin
  ie := 0;
  if (sz < 0) or (sz > dim) then sz := dim;
  if sz <= 0 then
    SET_ENV( log.body"address, nil, log.length, 0, 1 )
  else
    ie := SET_ENV( log.body"address, val"address, log.length, sz, ovr );
  PAS__SET_ENV := ie
end PAS__SET_ENV;



[global 'PAS__SETENV']
function PAS$$SETENV( in_var log, val: string; ovr: integer ): integer;
type
  bufty = packed array[1..256] of char;
  relty = packed array[1..1024] of char;
  ptr   = ^relty;

var
  p:       ^relty;
  lg,  vl: bufty;
  ierr:    integer;
  ch:      char;

begin
  ierr := 0;
  if val.length <= 0 then
    SET_ENV( log.body"address, nil, log.length, 0, 1 )
  else
    ierr := SET_ENV( log.body"address, val.body"address,
                     log.length, val.length, ovr );
  PAS$$SETENV := ierr
end PAS$$SETENV;




[global 'PAS__GETPHYSIC']
function GET_PHYSIC_FSPC( var trg: string; in_var spc: string ): integer;
var
  err: integer;

  {***********************************************************************}



  function GET_PHY_FSPC( in_var  fsp: string;
                                irep: integer;
                            var ierr: integer ): string;
  const
    sep = ':/]\';

  var
    c1, c2,
    llog, len, dnam:   integer;
    tmp, src:           string;

  begin
    if irep <= 10 then                  { Check for Circular definitions }
    begin
      src  := fsp;                      { Copy the string }
      len  := src.length;               { Save the Source Length }
      llog := INDEX( src, ':' );        { Extract the "Device Name" }
      { When no ":" the whole can be a logical }
      if llog > 0 then                  { When a device is specified ... }
        src.length := llog - 1          { ... simule SUBSTR( src, 1, llog ) }
      else
        llog := src.length;             { We try to get the whole of fspc }
      ierr := GET_LOGICAL( tmp, src );  { GET logical translation, if it exist }
      src.length := len;                { Restore the source length }
      if ierr <> 0 then tmp.length := 0;{ Ignore too long translation }
      if ierr = -1 then ierr := 0;      { Ignore Not Found Error }
      if tmp.length = 0 then            { If we have no translation ... }
        GET_PHY_FSPC := src             { ... Return the original string }
      else
      begin { We have got a Logical Translation }
        c1 := INDEX( sep, src[llog+1] );
        c2 := INDEX( sep, tmp[tmp.length] );
        if (c1 > 0) or (c2 > 0) then
        begin { The logical was a logical file device specification }
          { Compute the length of the trailing file specification }
          if c1 = c2 then llog := llog + 1; { same directory separator to elliminate }
          len := src.length - llog;
          if function.capacity < tmp.length + len then ierr := -2;
          if len > 0 then src := tmp !! substr( src, llog + 1 )
                     else src := tmp
        end
        else src := tmp;

        { Try a Recursive call on success }
        if ierr = 0 then { If no error try to translate sub-logicals }
          GET_PHY_FSPC := GET_PHY_FSPC( src, irep + 1, ierr )
        else
          GET_PHY_FSPC := src
      end
    end
    else ierr := -100 { Circular definitions Error }
  end GET_PHY_FSPC;

{***********************************************************************}



begin { GET_PHYSIC_FSPC }
  trg := GET_PHY_FSPC( spc, 1, err );
  GET_PHYSIC_FSPC := err
end GET_PHYSIC_FSPC;



end CPAS__LOGICALS.


