{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*           * * *   S t a n d a r d   L i b r a r y   * * *             *
*                                                                       *
*                                                                       *
*          ---  Look for a file in a specified Path list  ---           *
*                                                                       *
*               ---  Version 3.1-B5 -- 31/07/2019 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 www.pierre.wolfers.fr                                 *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
%pragma trace 0;
module CPAS__PATH_SEARCH;

var
  [global 'PAS_PATH_SEARCH_INDEX'] Search_Path_Index: integer := 0;

[global 'PAS__PATH_SEARCH']
function SEARCH_IN_PATH( in_var path:  string;  { The path list (list of directories path) }
                         in_var fspc:  string;  { The name of file to search }
                         dsep:    char := '/'   { The directories separator (typicaly '/' or '\') }
                       ): string;
{ Routine to search the file specified file (fspc), in the path (path arg.).
  On sucess, the complete file specification is returned (else a null string).
  dsep is the directory sperator (typicaly '\' for windows and '/' for Linux,
  Unix and Mac-OS-X. The Path list element separator must be ',' because it is
  a natural choice and also because the semicolon ':' can be used to design a
  devicePath.
  Note: A file without read access is equivalent to a none existing file.
}
const
  lsep = ',';

var
  ib, ie, n:   integer;
  dir, nam:     string;
  fnd:         boolean;

begin
  ib  :=     1;
  n   :=     1;
  fnd := false;
  while not fnd and (ib <> 0) do                { Loop on all PATH entries }
  begin
    ie := INDEX( path, lsep, n ); n := n + 1;
    if ie = 0 then                              { When we take the last path entry ... }
    begin
      dir := SUBSTR( path, ib ); ib := 0        { ... we get it ... }
    end
    else
    begin
      dir := SUBSTR( path, ib, ie - ib );       { ... else we get the current entry ... }
      ib := ie + 1                              { ... without the semicolon separator. }
    end;
    if (dir[dir.length] <> dsep) and            { We complete the current entry with ... }
       (dir[dir.length] <> ':') then            { ... a directory separator if it is not present. }
    begin
      dir.length := dir.length + 1;
      dir[dir.length] := dsep
    end;
    nam := dir||fspc;                           { Build a possible complete setup file specification }
    fnd := FILE_ACCESS_CHECK( nam, 4 {read} )   { Test it as existing with free access to read }
  end;                                          { End of search loop }

  if fnd then begin  Search_Path_Index := n - 1; SEARCH_IN_PATH := dir  end
         else begin  Search_Path_Index := 0; SEARCH_IN_PATH := ''  end
end SEARCH_IN_PATH;



end CPAS__PATH_SEARCH.
